/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util;

import kd.bos.algo.util.Tuple2;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.flex.FlexBDValueCondition;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class AssgrpUtil {
    private static final Log log = LogFactory.getLog(AssgrpUtil.class);

    private AssgrpUtil() {
    }

    public static boolean checkAssgrpValueByName(String assgrpName, String importProp, Object propValue) {
        Tuple2<String, QFilter> assgrpSourceAndFilter = AssgrpUtil.getAssgrpSourceAndFilterByName(assgrpName);
        if (assgrpSourceAndFilter == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u6838\u7b97\u7ef4\u5ea6\u3010%s\u3011\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5", (String)"AssgrpUtil_0", (String)"fi-gl-common", (Object[])new Object[0]), assgrpName));
        }
        QFilter assgrpFilter = (QFilter)assgrpSourceAndFilter.t2;
        if (assgrpFilter == null) {
            return true;
        }
        if (StringUtils.isNotBlank((CharSequence)importProp) && propValue != null) {
            QFilter filter = new QFilter(importProp, "=", propValue);
            assgrpFilter.and(filter);
        }
        return QueryServiceHelper.exists((String)((String)assgrpSourceAndFilter.t1), (QFilter[])new QFilter[]{assgrpFilter});
    }

    public static boolean checkAssgrpValueByFlexFieldAndSourceId(String flexField, Object sourceId) {
        Tuple2<String, QFilter> assgrpSourceAndFilter = AssgrpUtil.getAssgrpSourceAndFilterByFlexField(flexField);
        if (assgrpSourceAndFilter == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u5b57\u6bb5\u5b57\u6bb5\u540d\u4e3a\u3010%s\u3011\u7684\u6838\u7b97\u7ef4\u5ea6\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5", (String)"AssgrpUtil_1", (String)"fi-gl-common", (Object[])new Object[0]), flexField));
        }
        QFilter assgrpFilter = (QFilter)assgrpSourceAndFilter.t2;
        if (assgrpFilter == null) {
            return true;
        }
        if (sourceId != null) {
            QFilter idFilter = new QFilter("id", "=", sourceId);
            assgrpFilter.and(idFilter);
        }
        return QueryServiceHelper.exists((String)((String)assgrpSourceAndFilter.t1), (QFilter[])new QFilter[]{assgrpFilter});
    }

    private static Tuple2<String, QFilter> getAssgrpSourceAndFilterByName(String assgrpName) {
        QFilter nameFilter = new QFilter("name", "=", (Object)assgrpName);
        DynamicObject assgrp = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_asstacttype", (String)"filtercondition_tag, valuesource.number", (QFilter[])new QFilter[]{nameFilter});
        if (assgrp == null) {
            log.error("\u6839\u636e\u6838\u7b97\u7ef4\u5ea6\u540d\u79f0\u3010" + assgrpName + "\u3011\u67e5\u4e0d\u5230\u5bf9\u5e94\u7684\u6838\u7b97\u7ef4\u5ea6\u6570\u636e\uff0c\u4ee3\u7801\u4f4d\u7f6e\uff1akd.fi.gl.util.AssgrpUtil.getAssgrpSourceAndFilterByName");
            return null;
        }
        String filterConditionJson = assgrp.getString("filtercondition_tag");
        QFilter filter = AssgrpUtil.transformJsonToFilter(filterConditionJson);
        return new Tuple2((Object)assgrp.getString("valuesource.number"), (Object)filter);
    }

    private static Tuple2<String, QFilter> getAssgrpSourceAndFilterByFlexField(String flexField) {
        QFilter flexFieldFilter = new QFilter("flexfield", "=", (Object)flexField);
        DynamicObject assgrp = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_asstacttype", (String)"filtercondition_tag, valuesource.number", (QFilter[])new QFilter[]{flexFieldFilter});
        if (assgrp == null) {
            log.error("\u6839\u636e\u6838\u7b97\u7ef4\u5ea6\u5b57\u6bb5\u540d\u3010" + flexField + "\u3011\u67e5\u4e0d\u5230\u5bf9\u5e94\u7684\u6838\u7b97\u7ef4\u5ea6\u6570\u636e\uff0c\u4ee3\u7801\u4f4d\u7f6e\uff1akd.fi.gl.util.AssgrpUtil.getAssgrpSourceAndFilterByFlexField");
            return null;
        }
        String filterConditionJson = assgrp.getString("filtercondition_tag");
        QFilter filter = AssgrpUtil.transformJsonToFilter(filterConditionJson);
        return new Tuple2((Object)assgrp.getString("valuesource.number"), (Object)filter);
    }

    private static QFilter transformJsonToFilter(String filterConditionJson) {
        if (StringUtils.isBlank((CharSequence)filterConditionJson)) {
            return null;
        }
        FlexBDValueCondition flexBdValueCondition = (FlexBDValueCondition)SerializationUtils.fromJsonString((String)filterConditionJson, FlexBDValueCondition.class);
        FilterCondition filterCondition = flexBdValueCondition.getFilterCondition();
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"bd_asstacttype");
        FilterBuilder builder = new FilterBuilder(mainEntityType, filterCondition);
        builder.buildFilter();
        return builder.getQFilter();
    }
}

