/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util;

import com.google.common.collect.Lists;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.basedataref.BaseDataRefenceKey;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.gl.vo.NameHistoryVO;

public class BaseDataUtil {
    private static final String SQL_READSAMETABLEOBJECTTYPES = "select fid from t_meta_mainentityinfo where ftablename = ? and fpkfieldname = ?  ";
    private static final String SQL_READOBJECTTYPEREF = "select t1.FObjectTypeId, t1.FTableName, t1.FFieldName, t3.FDBRoute, t4.ftablename as fmaintable, t1.fassttypeid, t1.FSqlLoadIdByTime  from t_meta_objecttyperef t1 inner join t_meta_entitydesign t2 on (t1.FObjectTypeId = t2.FNumber) left join t_meta_bizapp t3 on (t2.fbizappid = t3.fid) left join t_meta_mainentityinfo t4 on (t1.FObjectTypeId = t4.fid) ";
    private static final String SQL_READFLEXTYPEREF = "select t0.fformid, t1.fflexfield, t1.fassistanttype from t_bas_flex t0 inner join t_bas_flex_property t1 on (t0.fid = t1.fid) where t1.fvaluesource in (%s) ";

    public static List<BaseDataRefenceKey> getAllRefKeys(BasedataEntityType baseEntityType) {
        ArrayList<BaseDataRefenceKey> list = new ArrayList<BaseDataRefenceKey>();
        List<String> bdEntityNumbers = BaseDataUtil.loadSameTableObjectTypes(baseEntityType);
        if (bdEntityNumbers.isEmpty()) {
            return list;
        }
        list.addAll(BaseDataUtil.loadObjectTypeRefs(baseEntityType, bdEntityNumbers));
        return list;
    }

    private static List<BaseDataRefenceKey> loadObjectTypeRefs(final BasedataEntityType baseEntityType, List<String> refBDTypeNames) {
        ArrayList<String> strParams = new ArrayList<String>(16);
        Object[] selectParams = new SqlParameter[refBDTypeNames.size()];
        for (int i = 0; i < refBDTypeNames.size(); ++i) {
            selectParams[i] = new SqlParameter("FRefObjectTypeId" + String.valueOf(i), 12, (Object)refBDTypeNames.get(i));
            strParams.add("?");
        }
        String sql = SQL_READOBJECTTYPEREF;
        if (strParams.size() == 1) {
            sql = sql + "where t1.FRefObjectTypeId = ? ";
        } else {
            sql = sql + "where t1.FRefObjectTypeId in (%s)";
            sql = String.format(sql, StringUtils.join((Object[])strParams.toArray(), (String)","));
        }
        return (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])selectParams, (ResultSetHandler)new ResultSetHandler<List<BaseDataRefenceKey>>(){

            public List<BaseDataRefenceKey> handle(ResultSet rs) throws SQLException {
                ArrayList<BaseDataRefenceKey> refs = new ArrayList<BaseDataRefenceKey>();
                while (rs.next()) {
                    String tableName = rs.getString("FTableName");
                    String refAsstType = rs.getString("FAsstTypeId");
                    if (!StringUtils.isNotBlank((CharSequence)tableName)) continue;
                    BaseDataRefenceKey ref = BaseDataRefenceKey.create((BasedataEntityType)baseEntityType, null);
                    ref.setRefDBRouteKey(rs.getString("FDBRoute"));
                    ref.setRefEntityKey(rs.getString("FObjectTypeId"));
                    ref.setRefMainTable(rs.getString("FMainTable"));
                    ref.setRefTable(tableName);
                    ref.setRefCol(rs.getString("FFieldName"));
                    ref.setSqlLoadIdByTime(rs.getString("FSqlLoadIdByTime"));
                    refs.add(ref);
                }
                return refs;
            }
        });
    }

    private static List<BaseDataRefenceKey> loadFlexTypeRefs(final BasedataEntityType baseEntityType, List<String> refBDTypeNames) {
        ArrayList<String> strParams = new ArrayList<String>(16);
        Object[] selectParams = new SqlParameter[refBDTypeNames.size()];
        for (int i = 0; i < refBDTypeNames.size(); ++i) {
            selectParams[i] = new SqlParameter("FValueSource" + String.valueOf(i), 12, (Object)refBDTypeNames.get(i));
            strParams.add("?");
        }
        String sql = String.format(SQL_READFLEXTYPEREF, StringUtils.join((Object[])strParams.toArray(), (String)","));
        try {
            List bdrList = (List)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])selectParams, (ResultSetHandler)new ResultSetHandler<List<BaseDataRefenceKey>>(){

                public List<BaseDataRefenceKey> handle(ResultSet rs) throws SQLException {
                    ArrayList<BaseDataRefenceKey> refs = new ArrayList<BaseDataRefenceKey>();
                    while (rs.next()) {
                        BaseDataRefenceKey ref = BaseDataRefenceKey.create((BasedataEntityType)baseEntityType, null);
                        ref.setRefEntityKey(rs.getString("fformid"));
                        ref.setRefCol("FValue");
                        ref.setRefFlexProperty(true);
                        ref.setRefFlexField(rs.getString("FFlexField"));
                        if (!StringUtils.isNotBlank((CharSequence)ref.getRefFlexField())) continue;
                        refs.add(ref);
                    }
                    return refs;
                }
            });
            Object[] ids = new String[bdrList.size()];
            int i = 0;
            for (BaseDataRefenceKey baseDataRefenceKey : bdrList) {
                ids[i++] = baseDataRefenceKey.getRefEntityKey();
            }
            String inStr = StringUtils.join((Object[])ids, (String)"','");
            String sql1 = String.format("select fid, ftablename from t_meta_mainentityinfo where fid in ('%s')", inStr);
            Map refs = (Map)DB.query((DBRoute)DBRoute.meta, (String)sql1, (ResultSetHandler)new ResultSetHandler<Map<String, String>>(){

                public Map<String, String> handle(ResultSet rs) throws SQLException {
                    HashMap<String, String> refs = new HashMap<String, String>(16);
                    while (rs.next()) {
                        refs.put(rs.getString(1), rs.getString(2));
                    }
                    return refs;
                }
            });
            for (BaseDataRefenceKey ref : bdrList) {
                String tab = (String)refs.get(ref.getRefEntityKey());
                ref.setRefTable(tab + "_bd");
            }
            return bdrList;
        }
        catch (Exception exp) {
            return new ArrayList<BaseDataRefenceKey>(0);
        }
    }

    private static List<String> loadSameTableObjectTypes(BasedataEntityType baseEntityType) {
        if (StringUtils.isBlank((CharSequence)baseEntityType.getAlias()) || baseEntityType.getPrimaryKey() == null || StringUtils.isBlank((CharSequence)baseEntityType.getPrimaryKey().getAlias())) {
            return new ArrayList<String>();
        }
        Object[] selectParams = new SqlParameter[]{new SqlParameter("FTableName", 12, (Object)String.valueOf(baseEntityType.getAlias().toLowerCase())), new SqlParameter("FPkFieldName", 12, (Object)String.valueOf(baseEntityType.getPrimaryKey().getAlias().toLowerCase()))};
        return (List)DB.query((DBRoute)DBRoute.meta, (String)SQL_READSAMETABLEOBJECTTYPES, (Object[])selectParams, (ResultSetHandler)new ResultSetHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws SQLException {
                ArrayList<String> entityNumbers = new ArrayList<String>(16);
                while (rs.next()) {
                    entityNumbers.add(rs.getString("FId"));
                }
                return entityNumbers;
            }
        });
    }

    public static boolean containsProp(Control control, String property) {
        if (!(control instanceof BasedataEdit)) {
            return false;
        }
        return BaseDataUtil.containsProp(((BasedataEdit)control).getProperty(), property);
    }

    public static boolean containsProp(IDataEntityProperty entityProperty, String property) {
        if (!(entityProperty instanceof BasedataProp)) {
            return false;
        }
        return BaseDataUtil.containsProp(((BasedataProp)entityProperty).getComplexType(), property);
    }

    public static boolean containsProp(IDataEntityType entityType, String property) {
        if (!(entityType instanceof BasedataEntityType)) {
            return false;
        }
        return ((BasedataEntityType)entityType).findProperty(property) != null;
    }

    public static void queryBaseDataByDate(Collection<NameHistoryVO> nameHistoryVOList) {
        for (NameHistoryVO nameHistoryVO : nameHistoryVOList) {
            QFilter idFilter = new QFilter("id", "in", nameHistoryVO.getAssIdSet());
            DynamicObjectCollection dynamicObjects = BaseDataServiceHelper.queryBaseDataByDate((String)nameHistoryVO.getEntityId(), (Long)nameHistoryVO.getOrgId(), (QFilter)idFilter, (String)nameHistoryVO.getSelectFields(), (Date)nameHistoryVO.getNameCtrlDate());
            if (CollectionUtils.isEmpty((Collection)dynamicObjects)) continue;
            dynamicObjects.stream().forEach(x -> nameHistoryVO.addAssIdMap(x.getLong("id"), x.getString("name")));
        }
        HashMap oriFlexValueMap = new HashMap(8);
        HashMap flexEmptyValueMap = new HashMap(8);
        HashMap flexSelectedPropMap = new HashMap(8);
        nameHistoryVOList.stream().forEach(x -> {
            flexSelectedPropMap.put(x.getEntityId(), x.getSelectFields());
            HashSet<Long> idSet = (HashSet<Long>)flexEmptyValueMap.get(x.getEntityId());
            if (Objects.isNull(idSet)) {
                idSet = new HashSet<Long>(32);
                flexEmptyValueMap.put(x.getEntityId(), idSet);
            }
            for (Map.Entry<Long, String> entry : x.getAssIdNameMap().entrySet()) {
                if (!StringUtils.isEmpty((CharSequence)entry.getValue())) continue;
                idSet.add(entry.getKey());
            }
        });
        for (Map.Entry entry : flexEmptyValueMap.entrySet()) {
            if (((Set)entry.getValue()).isEmpty()) continue;
            String selectedFields = (String)flexSelectedPropMap.get(entry.getKey());
            HashMap valueToName = new HashMap(32);
            ArrayList idList = new ArrayList((Collection)entry.getValue());
            Lists.partition(idList, (int)999).forEach(ids -> {
                QFilter idFilter = new QFilter("id", "in", ids);
                try (DataSet entitys = QueryServiceHelper.queryDataSet((String)BaseDataUtil.class.getName(), (String)((String)entry.getKey()), (String)selectedFields, (QFilter[])idFilter.toArray(), null);){
                    for (Row row : entitys) {
                        Long id = row.getLong(0);
                        String name = row.getString(1);
                        valueToName.put(id, name);
                    }
                }
            });
            if (valueToName.isEmpty()) continue;
            oriFlexValueMap.put(entry.getKey(), valueToName);
        }
        if (oriFlexValueMap.isEmpty()) {
            return;
        }
        nameHistoryVOList.stream().forEach(x -> {
            HashSet<Long> idSet = new HashSet<Long>(x.getAssIdSet());
            Map<Long, String> assIdNameMap = x.getAssIdNameMap();
            idSet.forEach(id -> {
                if (StringUtils.isEmpty((CharSequence)((CharSequence)assIdNameMap.get(id)))) {
                    assIdNameMap.put((Long)id, (String)((Map)oriFlexValueMap.get(x.getEntityId())).get(id));
                }
            });
        });
    }
}

