/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.apache.commons.collections4.CollectionUtils;

public class BatchProcessPipe<E> {
    private final int batchSize;
    private final Producer<E> producer;
    private final Consumer<List<E>> consumer;
    private final List<E> buffer;

    public BatchProcessPipe(Producer<E> producer, Consumer<List<E>> consumer, int batchSize) {
        this.producer = producer;
        this.consumer = consumer;
        this.batchSize = batchSize;
        this.buffer = new ArrayList(batchSize);
    }

    public void run() {
        while (this.producer.hasNext()) {
            List<E> currentBatch = this.producer.nextBatch();
            while (CollectionUtils.isNotEmpty(currentBatch)) {
                int endIndex = this.batchSize - this.buffer.size();
                if (endIndex > currentBatch.size()) {
                    endIndex = currentBatch.size();
                }
                this.buffer.addAll(currentBatch.subList(0, endIndex));
                if (this.buffer.size() >= this.batchSize) {
                    this.consumer.accept(new ArrayList<E>(this.buffer));
                    this.buffer.clear();
                }
                currentBatch = currentBatch.subList(endIndex, currentBatch.size());
            }
        }
        if (!this.buffer.isEmpty()) {
            this.consumer.accept(this.buffer);
        }
    }

    public static interface Producer<T> {
        public List<T> nextBatch();

        public boolean hasNext();
    }
}

