/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;

public class BiTreeNode<T, DT extends Serializable>
implements Serializable {
    public static final String PROP_LEVEL = "_level";
    private static final long serialVersionUID = 1L;
    private T id;
    private T parentId;
    private BiTreeNode<T, DT> parent;
    private List<BiTreeNode<T, DT>> child = new ArrayList<BiTreeNode<T, DT>>(2);
    private DT data;
    private Map<String, Object> exProps = new HashMap<String, Object>(2);

    public BiTreeNode() {
    }

    public BiTreeNode(T id, DT data) {
        this.id = id;
        this.data = data;
    }

    public BiTreeNode getParent() {
        return this.parent;
    }

    public List<BiTreeNode<T, DT>> getChild() {
        return this.child;
    }

    public T getId() {
        return this.id;
    }

    public void setId(T id) {
        this.id = id;
    }

    public T getParentId() {
        return this.parentId;
    }

    public void setParentId(T parentId) {
        this.parentId = parentId;
    }

    public void setParent(BiTreeNode<T, DT> parent) {
        if (Objects.nonNull(this.parent)) {
            this.disconnectParent();
        }
        if (Objects.nonNull(parent)) {
            this.parent = parent;
            this.parentId = parent.getId();
            List<BiTreeNode<T, DT>> childOfParent = parent.getChild();
            if (childOfParent.stream().noneMatch(x -> Objects.equals(this.id, x.getId()))) {
                childOfParent.add(this);
            }
        }
    }

    public void disconnectParent() {
        List<BiTreeNode<T, DT>> childOfParent = this.parent.getChild();
        childOfParent.removeIf(x -> Objects.equals(this.id, x.getId()));
        this.parent = null;
        this.parentId = null;
    }

    public BiTreeNode<T, DT> getRootNode() {
        BiTreeNode curNode = this;
        int times = 0;
        while (Objects.nonNull(curNode.getParent()) && times < 10000) {
            curNode = curNode.getParent();
        }
        if (Objects.isNull(curNode.getParent())) {
            return curNode;
        }
        throw new IllegalStateException("failed to find root node, invalid tree.");
    }

    public void preTravel(Consumer<BiTreeNode<T, DT>> consumer) {
        BiTreeNode.preTravel(this, consumer);
    }

    public static <T, DT extends Serializable> void preTravel(BiTreeNode<T, DT> node, Consumer<BiTreeNode<T, DT>> consumer) {
        consumer.accept(node);
        ArrayList<BiTreeNode<T, DT>> childClone = new ArrayList<BiTreeNode<T, DT>>(node.getChild());
        for (BiTreeNode biTreeNode : childClone) {
            BiTreeNode.preTravel(biTreeNode, consumer);
        }
    }

    public <V> Collection<V> collect(Function<BiTreeNode<T, DT>, V> converter) {
        ArrayList values = new ArrayList(8);
        BiTreeNode.preTravel(this, converter, values);
        return values;
    }

    public <V> List<V> collectOnAncestors(Function<BiTreeNode<T, DT>, V> converter) {
        ArrayList<V> ancestors = new ArrayList<V>(8);
        int maxCycle = 1000000;
        BiTreeNode nodePointer = this;
        int cycle = 0;
        while (null != nodePointer.getParent()) {
            if (cycle++ > maxCycle) {
                throw new IllegalStateException("excel max recursive cycle, maybe tree building is wrong. ");
            }
            nodePointer = nodePointer.getParent();
            ancestors.add(converter.apply(nodePointer));
        }
        return ancestors;
    }

    public static <T, DT extends Serializable, V> void preTravel(BiTreeNode<T, DT> node, Function<BiTreeNode<T, DT>, V> converter, List<V> results) {
        results.add(converter.apply(node));
        ArrayList<BiTreeNode<T, DT>> childClone = new ArrayList<BiTreeNode<T, DT>>(node.getChild());
        for (BiTreeNode biTreeNode : childClone) {
            BiTreeNode.preTravel(biTreeNode, converter, results);
        }
    }

    public void postTravel(Consumer<BiTreeNode> consumer) {
        BiTreeNode.postTravel(this, consumer);
    }

    public static void postTravel(BiTreeNode node, Consumer<BiTreeNode> consumer) {
        ArrayList childClone = new ArrayList(node.getChild());
        for (BiTreeNode biTreeNode : childClone) {
            BiTreeNode.postTravel(biTreeNode, consumer);
        }
        consumer.accept(node);
    }

    public void deepFirstTravel(Consumer<BiTreeNode> nodeConsumer) {
        int maxLevel;
        ListMultimap<Integer, BiTreeNode> levelNodeMap = this.tagNodeWithLevel(null);
        int level = maxLevel = ((Integer)Collections.max(levelNodeMap.keySet())).intValue();
        while (level > 0) {
            List nodes = levelNodeMap.get((Object)level--);
            nodes.forEach(x -> nodeConsumer.accept((BiTreeNode)x));
        }
    }

    public ListMultimap<Integer, ? extends BiTreeNode> tagNodeWithLevel(Consumer<BiTreeNode> consumer) {
        LinkedListMultimap levelNodeMap = LinkedListMultimap.create();
        BiTreeNode current = this;
        this.preTravel(x -> {
            if (Objects.equals(current, x)) {
                x.setPropValue(PROP_LEVEL, 1);
            } else {
                x.setPropValue(PROP_LEVEL, (Integer)x.getParent().getPropValue(PROP_LEVEL) + 1);
            }
            int curLevel = (Integer)x.getPropValue(PROP_LEVEL);
            levelNodeMap.put((Object)curLevel, x);
            if (Objects.nonNull(consumer)) {
                consumer.accept((BiTreeNode)x);
            }
        });
        return levelNodeMap;
    }

    public void setPropValue(String prop, Object value) {
        this.exProps.put(prop, value);
    }

    public Object getPropValue(String prop) {
        return this.exProps.get(prop);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BiTreeNode other = (BiTreeNode)obj;
        if (!Objects.equals(this.id, other.id)) {
            return false;
        }
        return Objects.equals(this.parentId, other.parentId);
    }

    public DT getData() {
        return this.data;
    }

    public void setData(DT data) {
        this.data = data;
    }

    public String showFormatTree(String splitStr) {
        return this.showFormatTree(splitStr, null);
    }

    public String showFormatTree(String splitStr, Function<BiTreeNode, String> nodeToStringSupplier) {
        HashMap nodeLevel = new HashMap(8);
        StringBuilder logStr = new StringBuilder();
        this.preTravel(x -> {
            int curLevel = 1;
            if (Objects.nonNull(x.getParent()) && Objects.nonNull(nodeLevel.get(x.getParentId()))) {
                curLevel = (Integer)nodeLevel.get(x.getParentId()) + 1;
            }
            nodeLevel.put(x.getId(), curLevel);
            logStr.append(splitStr);
            for (int i = 1; i < curLevel; ++i) {
                logStr.append("    ");
            }
            if (nodeToStringSupplier == null) {
                logStr.append(x.getId()).append("[").append(x.toString()).append("]");
            } else {
                logStr.append(x.getId()).append("[").append((String)nodeToStringSupplier.apply((BiTreeNode)x)).append("]");
            }
        });
        return logStr.toString();
    }

    public static <T, DT extends Serializable> Map<T, BiTreeNode<T, DT>> toMap(BiTreeNode<T, DT> node) {
        HashMap idMap = new HashMap(8);
        node.preTravel(x -> idMap.put(x.getId(), x));
        return idMap;
    }

    public String toString() {
        return "BiTreeNode{id=" + this.id + ", parentId=" + this.parentId + ", data=" + this.data + '}';
    }
}

