/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bd.cache.CacheModule;
import kd.fi.bd.cache.cacheservice.IDataLocalCache;

public class CarryPeriodUtil {
    private static final String CACHE_KEY = "fi.gl.balcarryperiod";
    private static final String BALCARRYPERIOD = "gl_balcarryperiod";

    private static String buildKey(long orgId, long booktypeId) {
        return "fi.gl.balcarryperiod-" + orgId + "-" + booktypeId;
    }

    public static void saveCarryPeriod(long orgId, long booktypeId, long periodId) {
        QFilter[] filter;
        String key = CarryPeriodUtil.buildKey(orgId, booktypeId);
        List periodIds = (List)CarryPeriodUtil.getLocalCache().get(key, List.class);
        if (periodIds != null) {
            CarryPeriodUtil.getLocalCache().remove(key);
        }
        if (!QueryServiceHelper.exists((String)BALCARRYPERIOD, (QFilter[])(filter = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("booktype", "=", (Object)booktypeId), new QFilter("period", "=", (Object)periodId)}))) {
            DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)BALCARRYPERIOD);
            obj.set("org", (Object)orgId);
            obj.set("booktype", (Object)booktypeId);
            obj.set("period", (Object)periodId);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
        }
    }

    public static synchronized List<Long> loadCarryPeriod(long orgId, long bookTypeId) {
        String key = CarryPeriodUtil.buildKey(orgId, bookTypeId);
        List<Long> periodIds = (List<Long>)CarryPeriodUtil.getLocalCache().get(key, List.class);
        if (periodIds == null) {
            periodIds = CarryPeriodUtil.loadPeriodFromDbb(orgId, bookTypeId);
            CarryPeriodUtil.getLocalCache().put(key, periodIds);
            return periodIds;
        }
        return periodIds;
    }

    private static List<Long> loadPeriodFromDbb(long orgId, long bookTypeId) {
        ArrayList<Long> list = new ArrayList<Long>();
        QFilter forgId = new QFilter("org", "=", (Object)orgId);
        QFilter fbtId = new QFilter("booktype", "=", (Object)bookTypeId);
        DataSet rows = QueryServiceHelper.queryDataSet((String)"CarryPeriodUtil#loadCarryPeriod", (String)BALCARRYPERIOD, (String)"period", (QFilter[])new QFilter[]{forgId, fbtId}, null);
        for (Row row : rows) {
            list.add(row.getLong("period"));
        }
        return list;
    }

    private static IDataLocalCache getLocalCache() {
        return IDataLocalCache.getCache((CacheModule)CacheModule.carryperiod, (int)60);
    }
}

