/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.fi.bd.service.balance.VoucherQueryUtils;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.util.CashFlowItemHelperNew;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.MutexRequireHelper;
import kd.fi.gl.util.SystemParamHelper;
import kd.fi.gl.util.cashflow.CashFlowSumHelper;
import kd.fi.gl.util.cashflow.FilterContext;
import org.apache.commons.lang3.tuple.Pair;

public class CashFlowDesignateHelper {
    public static final int DEFAULT_VOUCHERBATCH_SIZE = 200;
    private static final Log logger = LogFactory.getLog(CashFlowDesignateHelper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pair<Boolean, Boolean> designateV1In(QFilter qfilter, Long itemId, Long assgrpId, Set<Long> voucherIds, Map<Long, Long> entryidItemIdMap, Map<Long, DataSet> deductInfos, FilterContext filterContext, Map<Long, DynamicObject> cfItemMap) {
        if (DebugTrace.enable()) {
            logger.info("[T_preset]designateV1In itemId:{} assgrpId:{}, vchIds.size: {}, entryidItemIdMap.size: {}, qfilter: {}", new Object[]{itemId, assgrpId, voucherIds.size(), null == entryidItemIdMap ? "null" : Integer.valueOf(entryidItemIdMap.size()), CashFlowDesignateHelper.filterToString(qfilter)});
        }
        long designateStart = System.currentTimeMillis();
        if (null == itemId && null == entryidItemIdMap) {
            throw new KDBizException("itemId & entryidItemIdMap is null");
        }
        CashFlowDesignateHelper.checkParam(qfilter, filterContext);
        HashSet<String> bookIds = new HashSet<String>(10);
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(voucherIds.size());
        ArrayList<Object[]> vchParams = new ArrayList<Object[]>(voucherIds.size());
        ArrayList<Object[]> entryParams = new ArrayList<Object[]>(voucherIds.size());
        HashSet<Long> vchIds = new HashSet<Long>(voucherIds.size());
        HashMap<Long, Map<Long, BigDecimal>> dataMap = new HashMap<Long, Map<Long, BigDecimal>>(voucherIds.size());
        HashMap<Long, Map<Long, Long>> itemMap = new HashMap<Long, Map<Long, Long>>(voucherIds.size());
        Set<Long> unCashAccIds = CashFlowDesignateHelper.getCashAccIds(false, filterContext);
        qfilter.and(new QFilter("entries.account", "in", unCashAccIds));
        qfilter.and(new QFilter("mainstatus", "in", Arrays.asList("3", "2", "1")));
        boolean hasAuditVchs = false;
        boolean hasDesignate = false;
        long orgId = filterContext.getOrgId();
        long bookTypeId = filterContext.getBookTypeId();
        String opertion = "designate";
        Set<Long> lockIds = MutexRequireHelper.batchRequire("gl_voucher", voucherIds, opertion);
        if (voucherIds.size() != lockIds.size()) {
            MutexRequireHelper.batchRelease("gl_voucher", lockIds, opertion);
            return Pair.of((Object)hasDesignate, (Object)hasAuditVchs);
        }
        Map<Long, BigDecimal> vEntryDeducts = null;
        String selectedFields = "id,period,billstatus,entries.id,entries.maincfitem,entries.maincfamount,entries.creditlocal,entries.debitlocal";
        try (DataSet ds = CashFlowDesignateHelper.getInitDataSetV1(qfilter, selectedFields, "id");){
            if (ds.hasNext()) {
                HashMap<Long, BigDecimal> amtMap = new HashMap<Long, BigDecimal>(16);
                HashMap<Long, Long> itemIDMap = new HashMap<Long, Long>(16);
                long voucherId = 0L;
                for (Row row : ds) {
                    BigDecimal designAmt;
                    Long entryItemId;
                    if (!GLUtil.isCurrentVoucherAllowModifyCF(orgId, bookTypeId, row.getLong("period"), row.getString("billstatus"))) {
                        hasAuditVchs = true;
                        continue;
                    }
                    Long vid = row.getLong("id");
                    if (voucherId != 0L && vid != voucherId) {
                        amtMap = new HashMap(16);
                        itemIDMap = new HashMap(16);
                        if (dataMap.size() > 200) {
                            CashFlowItemHelperNew.batchCalVoucherStatus(dataMap, itemMap, "1", bookIds, paramList, vchParams, entryParams, vchIds, cfItemMap, assgrpId);
                            dataMap.clear();
                            itemMap.clear();
                            hasDesignate = true;
                        }
                    }
                    if (voucherId == 0L || vid != voucherId) {
                        vEntryDeducts = CashFlowSumHelper.tranVchDataSetToMap(deductInfos.get(vid));
                        voucherId = vid;
                    }
                    Long entryId = row.getLong("entries.id");
                    Long itemIdParam = itemId;
                    if (itemIdParam == null && (itemIdParam = entryidItemIdMap.get(entryId)) == null) {
                        throw new KDBizException("itemId is null, entryId: " + entryId);
                    }
                    DynamicObject cfItem = CashFlowItemHelperNew.getCfItem(cfItemMap, itemIdParam);
                    if (cfItem == null) {
                        logger.error("[T_preset]item is null, itemId:{} entryId:{}", (Object)itemIdParam, (Object)entryId);
                        continue;
                    }
                    dataMap.put(voucherId, amtMap);
                    itemMap.put(voucherId, itemIDMap);
                    itemIDMap.put(entryId, itemIdParam);
                    BigDecimal dc = BigDecimal.ONE;
                    if ("o".equals(cfItem.getString("direction"))) {
                        dc = dc.negate();
                    }
                    if ((entryItemId = row.getLong("entries.maincfitem")) != 0L) {
                        DynamicObject cfItem1 = CashFlowItemHelperNew.getCfItem(cfItemMap, entryItemId);
                        BigDecimal dc1 = BigDecimal.ONE;
                        if (cfItem1 != null && "o".equals(cfItem1.getString("direction"))) {
                            dc1 = dc1.negate();
                        }
                        amtMap.put(entryId, row.getBigDecimal("entries.maincfamount").multiply(dc1).multiply(dc));
                        continue;
                    }
                    if (vEntryDeducts == null || (designAmt = vEntryDeducts.get(entryId)) == null || designAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                    amtMap.put(entryId, designAmt.multiply(dc));
                }
                if (dataMap.size() > 0) {
                    hasDesignate = true;
                    CashFlowItemHelperNew.batchCalVoucherStatus(dataMap, itemMap, "1", bookIds, paramList, vchParams, entryParams, vchIds, cfItemMap, assgrpId);
                }
            }
            CashFlowItemHelperNew.saveData(paramList, vchParams, entryParams, vchIds);
        }
        finally {
            MutexRequireHelper.batchRelease("gl_voucher", lockIds, opertion);
            if (!bookIds.isEmpty()) {
                CashFlowItemHelperNew.calBal(bookIds);
            }
        }
        long designateEnd = System.currentTimeMillis();
        logger.info("[T_preset]designateV1_cost: {} ms, itemId:{} assgrpId:{}, qfilter: {}", new Object[]{designateEnd - designateStart, itemId, assgrpId, CashFlowDesignateHelper.filterToString(qfilter)});
        return Pair.of((Object)hasDesignate, (Object)hasAuditVchs);
    }

    private static Set<Long> getCashAccIds(boolean isCash, FilterContext filterContext) {
        AccountBookInfo book = filterContext.getBook();
        HashSet<Long> accountIdSet = new HashSet<Long>(8);
        CashFlowDesignateHelper.getAcctAllVersion(filterContext, book, isCash, accountIdSet, "T_BD_ACCOUNT_U");
        CashFlowDesignateHelper.getAcctAllVersion(filterContext, book, isCash, accountIdSet, "T_BD_ACCOUNTUSEREG");
        SqlBuilder shareAccSql = new SqlBuilder();
        if (book.isBudget()) {
            shareAccSql.append("SELECT distinct(c.fid) id FROM T_BD_ACCOUNT AS c INNER JOIN T_bd_accounttype AS ct ON c.faccounttypeid = ct.fid WHERE ct.faccounttype not in ('A','B','C') and ", new Object[0]);
        } else {
            shareAccSql.append("SELECT distinct(c.fid) id FROM T_BD_ACCOUNT AS c WHERE ", new Object[0]);
        }
        CashFlowDesignateHelper.appendCashCondition(shareAccSql, isCash);
        CashFlowDesignateHelper.appendPeriodCondition(shareAccSql, filterContext);
        shareAccSql.append(" AND c.fctrlstrategy = '5' ", new Object[0]);
        shareAccSql.append(" AND c.faccounttableid = ? ", new Object[]{book.getAccountTableId()});
        try (DataSet dataSet = DB.queryDataSet((String)CashFlowDesignateHelper.class.getName(), (DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)shareAccSql);){
            for (Row row : dataSet) {
                accountIdSet.add(row.getLong("id"));
            }
        }
        if (DebugTrace.enable()) {
            logger.info("[T_preset]getCashAccIds, isCash:{}, orgId:{}, PeriodId:{}, PeriodIds:{}, accountIdSet:{}", new Object[]{isCash, book.getOrgId(), filterContext.getPeriodId(), filterContext.getPeriodIds(), accountIdSet});
        }
        return accountIdSet;
    }

    private static void getAcctAllVersion(FilterContext filterContext, AccountBookInfo book, boolean isCash, Set<Long> accountIdSet, String table) {
        SqlBuilder commonAccSql = new SqlBuilder();
        if (book.isBudget()) {
            commonAccSql.append("SELECT distinct(u.fdataid) id FROM ", new Object[0]);
            commonAccSql.append(table + " AS u ", new Object[0]);
            commonAccSql.append("INNER JOIN T_BD_ACCOUNT AS c ON u.fdataid = c.fid INNER JOIN T_bd_accounttype AS ct ON c.faccounttypeid = ct.fid WHERE ct.faccounttype not in ('A','B','C') and ", new Object[0]);
        } else {
            commonAccSql.append("SELECT distinct(u.fdataid) id FROM ", new Object[0]);
            commonAccSql.append(table + " AS u ", new Object[0]);
            commonAccSql.append("INNER JOIN T_BD_ACCOUNT AS c ON u.fdataid = c.fid WHERE ", new Object[0]);
        }
        CashFlowDesignateHelper.appendCashCondition(commonAccSql, isCash);
        CashFlowDesignateHelper.appendPeriodCondition(commonAccSql, filterContext);
        commonAccSql.append(" AND u.fuseorgid = ? ", new Object[]{book.getOrgId()});
        commonAccSql.append(" AND c.faccounttableid = ? ", new Object[]{book.getAccountTableId()});
        try (DataSet dataSet = DB.queryDataSet((String)CashFlowDesignateHelper.class.getName(), (DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)commonAccSql);){
            for (Row row : dataSet) {
                accountIdSet.add(row.getLong("id"));
            }
        }
    }

    private static void appendPeriodCondition(SqlBuilder sqlBuilder, FilterContext filterContext) {
        sqlBuilder.append(" and c.fstartdate < ? ", new Object[]{filterContext.getEndDate()});
        sqlBuilder.append(" and c.fenddate >= ? ", new Object[]{filterContext.getStartDate()});
    }

    private static void appendCashCondition(SqlBuilder sqlBuilder, boolean isCash) {
        if (isCash) {
            sqlBuilder.append(" (c.fiscash = '1' or c.fisbank = '1' or c.fiscashequivalent = '1' )", new Object[0]);
        } else {
            sqlBuilder.append(" (c.fiscash != '1' and c.fisbank != '1' and c.fiscashequivalent != '1' )", new Object[0]);
        }
    }

    private static DataSet getInitDataSetV1(QFilter qFilter, String selectFields, String orders) {
        DataSet ds = VoucherQueryUtils.queryDataSet((String)selectFields, (QFilter[])qFilter.toArray(), (String)orders, (int)-1);
        return ds;
    }

    private static void checkParam(QFilter qFilter, FilterContext filterContext) {
        long orgId = filterContext.getOrgId();
        boolean modifyHisCf = SystemParamHelper.getBooleanParam("mdifyhiscfitem", orgId, false);
        if (!modifyHisCf) {
            AccountBookInfo book = filterContext.getBook();
            qFilter.and(new QFilter("period", ">=", (Object)book.getCurPeriodId()));
        }
    }

    private static String filterToString(QFilter qfilter) {
        QFilter[] qFilters = qfilter.recombine();
        StringBuilder sb = new StringBuilder(16);
        for (QFilter qf : qFilters) {
            String qfs = qf.toString();
            if (qfs.length() > 100) {
                String substring = qfs.substring(0, 100);
                sb.append(substring);
            } else {
                sb.append(qfs);
            }
            sb.append(';');
        }
        return sb.toString();
    }
}

