/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.datatype.BigDecimalType;

public class DataSetUtils {
    private DataSetUtils() {
    }

    public static DataSet gainSumDataSet(DataSet ds, String[] groupBy, String[] sumBy) {
        String[] sel = new String[groupBy.length + sumBy.length];
        System.arraycopy(groupBy, 0, sel, 0, groupBy.length);
        System.arraycopy(sumBy, 0, sel, groupBy.length, sumBy.length);
        GroupbyDataSet groupbyDataSet = ds.select(sel).groupBy(groupBy);
        for (String sum : sumBy) {
            groupbyDataSet.sum(sum);
        }
        return groupbyDataSet.finish();
    }

    public static DataSet gainSumDataSet(DataSet ds) {
        Field[] fields = ds.getRowMeta().getFields();
        ArrayList<String> groups = new ArrayList<String>(fields.length);
        ArrayList<String> sums = new ArrayList<String>(fields.length);
        for (Field field : fields) {
            String name = field.getName().toLowerCase();
            if (field.getDataType() instanceof BigDecimalType) {
                sums.add(name);
                continue;
            }
            groups.add(name);
        }
        return DataSetUtils.gainSumDataSet(ds, groups.toArray(new String[0]), sums.toArray(new String[0]));
    }

    public static List<String> getFields(DataSet ds) {
        Field[] fields = ds.getRowMeta().getFields();
        ArrayList<String> fieldlst = new ArrayList<String>(16);
        for (Field field : fields) {
            String name = field.getName().toLowerCase();
            fieldlst.add(name);
        }
        return fieldlst;
    }
}

