/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.util.GLPeriodEnd;

public class GLAdjustExchangeRateUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Long> getLocalAdjustExCurId(Long orgId, long currencyID) {
        HashSet<Long> result = new HashSet<Long>();
        String accCurSelect = "currencyentry.currency currency";
        QFilter forgid = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)orgId);
        QFilter fischangecurrency = new QFilter("ischangecurrency", "=", (Object)"1");
        QFilter notBasecurrency = new QFilter("currencyentry.currency", "!=", (Object)currencyID);
        QFilter[] filter = new QFilter[]{forgid, fischangecurrency, notBasecurrency};
        try (DataSet currDataSet = QueryServiceHelper.queryDataSet((String)"gl.AdjustExchangeRateEdit.setCurrency", (String)"bd_accountview", (String)accCurSelect, (QFilter[])filter, null);){
            for (Row row : currDataSet) {
                long currencyid = row.getLong("currency");
                result.add(currencyid);
            }
        }
        return result;
    }

    public static Map<Long, GLPeriodEnd.AdjExchRateLatest> getAdjustExchange(long exRateTableId, long targetCurrencyId, Date availTime) {
        HashMap<Long, GLPeriodEnd.AdjExchRateLatest> result = new HashMap<Long, GLPeriodEnd.AdjExchRateLatest>();
        QFilter ftargetcur = new QFilter("cur", "=", (Object)targetCurrencyId);
        QFilter fexchtable = new QFilter("exctable", "=", (Object)exRateTableId);
        QFilter effTime = new QFilter("effectdate", "<=", (Object)availTime);
        QFilter quoteprice = new QFilter("foreignexcid", "=", (Object)"2");
        QFilter[] filters2 = new QFilter[]{ftargetcur, fexchtable, quoteprice, effTime};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"gl.adjustexchangerate.exrate", (String)"bd_exrate_tree", (String)"exctable,orgcur.id cyid,orgcur.number cynumber, orgcur.name cyname,cur,convertmode,exctype,effectdate,excval", (QFilter[])filters2, null);){
            for (Row row : dataSet) {
                long cyID = row.getLong("cyid");
                String cyNumber = row.getString("cynumber");
                String cyName = row.getString("cyname");
                String type = row.getString("exctype");
                String cm = row.getString("convertmode");
                Date effectdate = row.getDate("effectdate");
                BigDecimal rate = row.getBigDecimal("excval");
                GLPeriodEnd.AdjExchRateLatest lex = new GLPeriodEnd.AdjExchRateLatest(cyID, cyNumber, cyName, type, cm, rate, new BigDecimal(0), effectdate);
                GLPeriodEnd.AdjExchRateLatest adjRex = (GLPeriodEnd.AdjExchRateLatest)result.get(cyID);
                if (!GLAdjustExchangeRateUtil.isEffcetdate(effectdate, cm, adjRex)) continue;
                result.put(cyID, lex);
            }
        }
        return result;
    }

    private static boolean isEffcetdate(Date effectdate, String cm, GLPeriodEnd.AdjExchRateLatest adjRex) {
        if (null == adjRex) {
            return true;
        }
        Date date = adjRex.getEffectdate();
        if (date.before(effectdate)) {
            return true;
        }
        return date.equals(effectdate) && cm.equals("1");
    }

    public static DynamicObject getAdjustExchangeRateInfo(Object id) {
        return BusinessDataServiceHelper.loadSingle((Object)id, (String)"gl_adjustexchangerate");
    }

    public static Map<String, Map<Long, GLPeriodEnd.AdjExchRateLatest>> fetchInitData(long orgId, long bookstypeId) {
        HashMap<String, Map<Long, GLPeriodEnd.AdjExchRateLatest>> map = new HashMap<String, Map<Long, GLPeriodEnd.AdjExchRateLatest>>();
        Map<Long, GLPeriodEnd.AdjExchRateLatest> adjExchRate = GLAdjustExchangeRateUtil.getAdjExchRate(orgId, bookstypeId);
        map.put("adjExchRate", adjExchRate);
        return map;
    }

    public static DynamicObject getBook(Object bookId) {
        return BusinessDataServiceHelper.loadSingle((Object)bookId, (String)"gl_accountbook");
    }

    public static Map<Long, GLPeriodEnd.AdjExchRateLatest> getAdjExchRate(long orgId, long bookstypeId) {
        AccountBookInfo book = AccSysUtil.getBookFromAccSys(orgId, bookstypeId);
        long curPeriodID = book.getCurPeriodId();
        long localCurrencyID = book.getBaseCurrencyId();
        long localTableID = book.getExrateTableId();
        DynamicObject curPeriod = BusinessDataServiceHelper.loadSingleFromCache((Object)curPeriodID, (String)"bd_period");
        Date prdEnd = curPeriod.getDate("enddate");
        return GLAdjustExchangeRateUtil.getAdjustExchange(localTableID, localCurrencyID, prdEnd);
    }

    public static DataSet getAccountParam(String string, Long id) {
        QFilter q = new QFilter("id", "=", (Object)id);
        return QueryServiceHelper.queryDataSet((String)"gl.adjustexchangerate.getBw", (String)"bd_account", (String)string, (QFilter[])new QFilter[]{q}, null);
    }

    public static DynamicObject getAccountParam(Long id) {
        return BusinessDataServiceHelper.loadSingle((Object)id, (String)"bd_accountview");
    }
}

