/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.sequence.SequenceReader;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.gl.util.QFBuilder;

public class ImrVoucherUtil {
    private static final Log logger = LogFactory.getLog((String)ImrVoucherUtil.class.getTypeName());
    private static final String GL_ISOMERISMRELATION = "gl_isomerismrelation";
    private static final String INSERTSQL = "insert into t_gl_isomerismrelation (fid,fvoucherid,fsourcesystemid,fextsystemvchid,fextsystemvchno) values (?,?,?,?,?);";

    public static void deleteIsomerismRelation(Set<Long> voucherIds) {
        try (TXHandle h = TX.required((String)"deleteIsomerismRelation");){
            try {
                DeleteServiceHelper.delete((String)GL_ISOMERISMRELATION, (QFilter[])new QFBuilder("voucherid", "in", voucherIds).toArray());
            }
            catch (Throwable e) {
                h.markRollback();
                logger.error("deleteIsomerismRelation error, failedVids: {}", voucherIds, (Object)e);
                throw e;
            }
        }
    }

    public static void insertIsomerismRelation(OperateOption operateOption, DynamicObject[] dataEntities) {
        boolean insertIsomerismRelation = Boolean.parseBoolean(operateOption.getVariableValue("insertIsomerismRelation", Boolean.FALSE.toString()));
        if (!insertIsomerismRelation) {
            return;
        }
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        DynamicObject dataEntity = dataEntities[0];
        DynamicProperty sourcesystemIdProp = dataEntity.getDynamicObjectType().getProperty("sourcesystem_id");
        DynamicProperty extsystemvchidProp = dataEntity.getDynamicObjectType().getProperty("extsystemvchid");
        DynamicProperty extsystemvchnoProp = dataEntity.getDynamicObjectType().getProperty("extsystemvchno");
        if (sourcesystemIdProp == null || extsystemvchnoProp == null || extsystemvchidProp == null) {
            return;
        }
        ArrayList<DynamicObject> needDealDys = new ArrayList<DynamicObject>(dataEntities.length);
        for (DynamicObject o : dataEntities) {
            String sourceType = o.get("sourcetype").toString();
            if (!"8".equals(sourceType)) continue;
            needDealDys.add(o);
        }
        if (needDealDys.isEmpty()) {
            return;
        }
        Set<Long> hashRecordVchIds = ImrVoucherUtil.getHashRecordVchIds(needDealDys);
        needDealDys.clear();
        for (DynamicObject o : dataEntities) {
            String sourceType = o.get("sourcetype").toString();
            if (!"8".equals(sourceType) || hashRecordVchIds.contains(o.getLong("id"))) continue;
            needDealDys.add(o);
        }
        if (!needDealDys.isEmpty()) {
            ArrayList<Object[]> paramList = new ArrayList<Object[]>(1000);
            SequenceReader sReader = new SequenceReader(new DBRoute("gl"));
            int count = needDealDys.size();
            Iterator iDItr = Arrays.stream(sReader.getSequences((Object[])new Long[count], "T_GL_ISOMERISMRELATION", count)).iterator();
            int i = 0;
            for (DynamicObject o : needDealDys) {
                String extsystemvchid = o.getString("extsystemvchid");
                long sourcesystemId = o.getLong("sourcesystem_id");
                if (StringUtils.isNotEmpty((CharSequence)extsystemvchid) && 0L != sourcesystemId) {
                    paramList.add(new Object[]{iDItr.next(), o.getLong("id"), sourcesystemIdProp.getValueFast((Object)o), extsystemvchidProp.getValueFast((Object)o), extsystemvchnoProp.getValueFast((Object)o)});
                    ++i;
                }
                if (i <= 0 || i % 1000 != 0) continue;
                ImrVoucherUtil.insertIsomerismRelation(paramList);
                paramList.clear();
            }
            if (!paramList.isEmpty()) {
                ImrVoucherUtil.insertIsomerismRelation(paramList);
            }
        }
    }

    private static Set<Long> getHashRecordVchIds(List<DynamicObject> needDealDys) {
        HashSet<Long> hashRecordVchIds = new HashSet<Long>(needDealDys.size());
        HashSet<Long> voucherIds = new HashSet<Long>(needDealDys.size());
        for (DynamicObject dataEntitie : needDealDys) {
            voucherIds.add(dataEntitie.getLong("id"));
        }
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"getHashRecordVchIds", (String)GL_ISOMERISMRELATION, (String)"voucherid", (QFilter[])new QFBuilder("voucherid", "in", voucherIds).toArray(), null);){
            for (Row row : ds) {
                hashRecordVchIds.add(row.getLong("voucherid"));
            }
        }
        return hashRecordVchIds;
    }

    private static void insertIsomerismRelation(List<Object[]> paramList) {
        try (TXHandle h = TX.required((String)"insertIsomerismRelation");){
            try {
                DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)INSERTSQL, paramList);
            }
            catch (Throwable e) {
                h.markRollback();
                logger.error("insertIsomerismRelation error, destVid: {}", paramList.get(0)[0], (Object)e);
                throw e;
            }
        }
    }

    public static String getUrl(Long voucherId) {
        String url = "";
        DynamicObject relation = QueryServiceHelper.queryOne((String)GL_ISOMERISMRELATION, (String)"extsystemvchid,sourcesystem.ipaddress ipaddress,sourcesystem.transmissionfield transmissionfield", (QFilter[])new QFilter("voucherid", "=", (Object)voucherId).toArray());
        if (relation != null) {
            url = relation.getString("ipaddress") + "&" + relation.getString("transmissionfield") + "=" + relation.getString("extsystemvchid");
        }
        return url;
    }

    public static boolean existsRelation(Long voucherId) {
        return QueryServiceHelper.exists((String)GL_ISOMERISMRELATION, (QFilter[])new QFilter("voucherid", "=", (Object)voucherId).toArray());
    }
}

