/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.bd.service.balance.VoucherQueryUtils;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.comassist.model.ComAssistTable;
import kd.fi.gl.exception.GLErrorCode;
import kd.fi.gl.model.schema.VoucherSchema;
import kd.fi.gl.report.CurType;
import kd.fi.gl.report.QueryParamRpt;
import org.apache.commons.collections4.list.UnmodifiableList;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Triple;

public class LimitSizeVchQueryUtils {
    private static final VoucherSchema VOUCHER = VoucherSchema.instance;
    private static final Log LOGGER = LogFactory.getLog(LimitSizeVchQueryUtils.class);
    static final int FILTER_LEN_LIMIT = 500;
    static final Map<String, String> VCH_2_BAL = new HashMap<String, String>(4){
        {
            this.put("org", "org");
            this.put("booktype", "booktype");
            this.put("period", "period");
            this.put("entries.account", "account");
            this.put("entries.currency", "currency");
            this.put("entries.measureunit", "measureunit");
        }
    };
    static final Map<String, String> BAL_2_VCH = VCH_2_BAL.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
    static final List<String> ALL_VCH_DIM_AND_ORDER = Arrays.asList(LimitSizeVchQueryUtils.VOUCHER.org.toFullName(), LimitSizeVchQueryUtils.VOUCHER.bookType.toFullName(), LimitSizeVchQueryUtils.VOUCHER.currency.toFullName(), LimitSizeVchQueryUtils.VOUCHER.unit.toFullName(), LimitSizeVchQueryUtils.VOUCHER.period.toFullName());
    static final List<String> ALL_BAL_DIM_AND_ORDER = ALL_VCH_DIM_AND_ORDER.stream().map(VCH_2_BAL::get).collect(Collectors.toList());

    public static Tuple<DataSet, Integer> query(QueryParamRpt qpRpt, String selectFields, QFilter[] filters, int top) {
        List<QFilter> filterList = LimitSizeVchQueryUtils.addFeatureFilter(qpRpt, filters);
        QFilter[] originalFilters = filterList.toArray(new QFilter[0]);
        if (DebugTrace.enable()) {
            LOGGER.info("original filters: " + LimitSizeVchQueryUtils.formatFilterAsString(Arrays.stream(originalFilters)));
        }
        List<QFilter> vchFilters = Arrays.stream(VoucherQueryUtils.enhanceFilters((QFilter[])originalFilters, (boolean)true)).collect(Collectors.toList());
        if (DebugTrace.enable()) {
            LOGGER.info("after enhance: " + LimitSizeVchQueryUtils.formatFilterAsString(vchFilters.stream()));
        }
        Triple<Boolean, List<QFilter>, List<QFilter>> balAndExtVchFilters = LimitSizeVchQueryUtils.tryTransferToBalAndExtVchFilters(vchFilters);
        Boolean existCustomFilter = (Boolean)balAndExtVchFilters.getLeft();
        List balDimFilters = (List)balAndExtVchFilters.getMiddle();
        List extraFilters = (List)balAndExtVchFilters.getRight();
        if (DebugTrace.enable()) {
            LOGGER.info("parsed balance filter: " + LimitSizeVchQueryUtils.formatFilterAsString(balDimFilters.stream()));
            LOGGER.info("extra voucher filter: " + LimitSizeVchQueryUtils.formatFilterAsString(extraFilters.stream()));
        }
        OrderByHelper helper = new OrderByHelper(balDimFilters);
        UnmodifiableList<String> balGroupAndOrderBy = helper.balGroupAndOrderBy;
        UnmodifiableList<String> vchGroupAndOrderBy = helper.vchGroupAndOrderBy;
        if (existCustomFilter.booleanValue()) {
            DataSet vchDs = VoucherQueryUtils.queryDataSet((String)selectFields, (QFilter[])originalFilters, (String)String.join((CharSequence)", ", vchGroupAndOrderBy), (int)top);
            int count = vchDs.copy().count(vchDs.getRowMeta().getFields()[0].getAlias(), false);
            return new Tuple((Object)vchDs, (Object)count);
        }
        String[] params = LimitSizeVchQueryUtils.getParamForCountQuery(balDimFilters, balGroupAndOrderBy);
        String sql = String.format("select sum(fcount) count, %s from t_gl_balance where %s group by %s order by %s", params[0], params[1], params[2], params[3]);
        return (Tuple)DB.query((DBRoute)new DBRoute("fi"), (String)sql, (ResultSetHandler)new BalGrpCountRSH(balGroupAndOrderBy, vchGroupAndOrderBy, top, selectFields, extraFilters));
    }

    static List<QFilter> addFeatureFilter(QueryParamRpt qpRpt, QFilter[] filters) {
        List<QFilter> filterList = Arrays.stream(filters).collect(Collectors.toList());
        if (qpRpt.getCurType() == CurType.ALL) {
            filterList.add(LimitSizeVchQueryUtils.VOUCHER.currency.toFilter("!=", (Object)-1));
        }
        if (qpRpt.isShowSumQty()) {
            filterList.add(LimitSizeVchQueryUtils.VOUCHER.unit.toFilter("!=", (Object)-1));
        }
        return filterList;
    }

    static long extractValue(ResultSet rs, String fieldName) {
        try {
            return rs.getLong(fieldName);
        }
        catch (SQLException e) {
            LOGGER.error((Throwable)e);
            throw new KDBizException(GLErrorCode.SYS_ERR, new Object[0]);
        }
    }

    static Triple<Boolean, List<QFilter>, List<QFilter>> tryTransferToBalAndExtVchFilters(List<QFilter> vchFilters) {
        ArrayList<QFilter> vchExtFilters = new ArrayList<QFilter>();
        ArrayList<QFilter> balFilters = new ArrayList<QFilter>();
        Set vchComAssistKeys = ComAssistTable.getMaxCommonAssistKeys().stream().map(k -> "entries." + k).collect(Collectors.toSet());
        boolean existCustomFilter = false;
        block17: for (QFilter filter : vchFilters) {
            String property;
            switch (property = filter.getProperty()) {
                case "entries.eorg": 
                case "entries.eperiod": {
                    continue block17;
                }
                case "org": 
                case "booktype": 
                case "period": 
                case "entries.measureunit": 
                case "entries.currency": {
                    balFilters.add(new QFilter(VCH_2_BAL.get(property), filter.getCP(), filter.getValue()));
                    continue block17;
                }
                case "entries.account": {
                    balFilters.add(LimitSizeVchQueryUtils.convertAcctF(filter));
                    vchExtFilters.add(filter);
                    continue block17;
                }
                case "billstatus": {
                    vchExtFilters.add(filter);
                    continue block17;
                }
            }
            if (vchComAssistKeys.contains(property)) {
                balFilters.add(new QFilter(property.split("\\.")[1], filter.getCP(), filter.getValue()));
                continue;
            }
            existCustomFilter = true;
        }
        return Triple.of((Object)existCustomFilter, balFilters, vchExtFilters);
    }

    static DataSet doExtVoucherQuery(String selectFields, QFilter[] extVchFilters, String orderBy, int top, Map<String, Set<Long>> balDimValues) {
        LinkedList<QFilter> vchExtFilters = new LinkedList<QFilter>();
        balDimValues.forEach((balField, ids) -> vchExtFilters.add(new QFilter(BAL_2_VCH.getOrDefault(balField, "entries." + balField), "in", ids)));
        vchExtFilters.addAll(Arrays.asList(extVchFilters));
        LOGGER.info("do extra voucher query: " + LimitSizeVchQueryUtils.formatFilterAsString(vchExtFilters.stream()));
        return VoucherQueryUtils.queryDataSet((String)selectFields, (QFilter[])vchExtFilters.toArray(new QFilter[0]), (String)orderBy, (int)top);
    }

    static QFilter convertAcctF(QFilter vchAcctF) {
        QFilter idF = new QFilter("id", vchAcctF.getCP(), vchAcctF.getValue());
        List mids = BusinessDataServiceHelper.loadFromCache((String)"bd_accountview", (String)"masterid", (QFilter[])idF.toArray()).values().stream().map(acct -> acct.getLong("masterid")).collect(Collectors.toList());
        return new QFilter("account", "in", mids);
    }

    static String[] getParamForCountQuery(List<QFilter> filtersForBalance, UnmodifiableList<String> balOrderBy) {
        MainEntityType balanceEntityType = MetadataServiceHelper.getDataEntityType((String)"gl_balance");
        LinkedList<QFilter> emptyFilters = new LinkedList<QFilter>();
        for (QFilter filter : filtersForBalance) {
            if (filter.toString().contains("()")) {
                emptyFilters.add(filter);
                LOGGER.warn("caught empty filter " + filter);
            }
            String dbFieldName = balanceEntityType.getProperty(filter.getProperty()).getAlias();
            filter.__setProperty(dbFieldName);
        }
        if (!emptyFilters.isEmpty()) {
            filtersForBalance.removeAll(emptyFilters);
            filtersForBalance.add(QFilter.of((String)"1!=1", (Object[])new Object[0]));
        }
        String filter = filtersForBalance.stream().map(QFilter::toString).collect(Collectors.joining(" and "));
        String groupBy = balOrderBy.stream().map(arg_0 -> ((MainEntityType)balanceEntityType).getProperty(arg_0)).map(DynamicProperty::getAlias).collect(Collectors.joining(", "));
        String select = balOrderBy.stream().map(key -> balanceEntityType.getProperty(key).getAlias() + " " + key).collect(Collectors.joining(", "));
        String balSqlOrderBy = String.join((CharSequence)", ", balOrderBy);
        return new String[]{select, filter, groupBy, balSqlOrderBy};
    }

    static String formatFilterAsString(Stream<QFilter> filterStream) {
        return StringUtils.join((Iterable)filterStream.map(x -> {
            if (null == x) {
                return "null";
            }
            String fullString = x.toString();
            return fullString.length() <= 500 ? fullString : fullString.substring(0, 500) + String.format("--ignore %s chars -- ", fullString.length() - 500);
        }).collect(Collectors.toList()), (String)" | ");
    }

    static class OrderByHelper {
        protected final UnmodifiableList<String> balGroupAndOrderBy;
        protected final UnmodifiableList<String> vchGroupAndOrderBy;

        OrderByHelper(List<QFilter> balDimFilters) {
            HashSet existedBalDim = new HashSet();
            balDimFilters.forEach(dimFilter -> existedBalDim.add(dimFilter.getProperty()));
            List existedBalOrderBy = ALL_BAL_DIM_AND_ORDER.stream().filter(existedBalDim::contains).collect(Collectors.toList());
            List vchOrderBy = existedBalOrderBy.stream().map(BAL_2_VCH::get).collect(Collectors.toList());
            int insertIndex = existedBalOrderBy.indexOf("org") + 1;
            List<String> maxCommonAssistKeys = ComAssistTable.getMaxCommonAssistKeys();
            for (int i = maxCommonAssistKeys.size() - 1; i >= 0; --i) {
                String comAssistKey = maxCommonAssistKeys.get(i);
                existedBalOrderBy.add(insertIndex, comAssistKey);
                vchOrderBy.add(insertIndex, "entries." + comAssistKey);
            }
            this.balGroupAndOrderBy = new UnmodifiableList(existedBalOrderBy);
            this.vchGroupAndOrderBy = new UnmodifiableList(vchOrderBy);
        }
    }

    static class BalGrpCountRSH
    implements ResultSetHandler<Tuple<DataSet, Integer>> {
        final UnmodifiableList<String> balGroupAndOrderBy;
        final UnmodifiableList<String> vchGroupAndOrderBy;
        final int top;
        final String selectFields;
        final List<QFilter> extraFilters;

        BalGrpCountRSH(UnmodifiableList<String> balGroupAndOrderBy, UnmodifiableList<String> vchGroupAndOrderBy, int top, String selectFields, List<QFilter> extraFilters) {
            this.balGroupAndOrderBy = balGroupAndOrderBy;
            this.vchGroupAndOrderBy = vchGroupAndOrderBy;
            this.top = top;
            this.selectFields = selectFields;
            this.extraFilters = extraFilters;
        }

        public Tuple<DataSet, Integer> handle(ResultSet resultSet) throws Exception {
            Triple<Boolean, Tuple<Integer, Integer>, Tuple<Map<String, Set<Long>>, Map<String, Set<Long>>>> rs = this.parseBalRS(resultSet);
            int count = (Integer)((Tuple)rs.getMiddle()).item1;
            int preCount = (Integer)((Tuple)rs.getMiddle()).item2;
            Map inLimitValues = (Map)((Tuple)rs.getRight()).item1;
            Map onLimitValues = (Map)((Tuple)rs.getRight()).item2;
            boolean containOtherDim = (Boolean)rs.getLeft();
            if (count < this.top) {
                DataSet allSize = LimitSizeVchQueryUtils.doExtVoucherQuery(this.selectFields, this.extraFilters.toArray(new QFilter[0]), null, this.top, inLimitValues);
                return new Tuple((Object)allSize, (Object)count);
            }
            String orderByInSql = null;
            if (containOtherDim) {
                orderByInSql = String.join((CharSequence)", ", this.vchGroupAndOrderBy);
            }
            DataSet inSize = LimitSizeVchQueryUtils.doExtVoucherQuery(this.selectFields, this.extraFilters.toArray(new QFilter[0]), orderByInSql, preCount, inLimitValues);
            DataSet leavedSize = LimitSizeVchQueryUtils.doExtVoucherQuery(this.selectFields, this.extraFilters.toArray(new QFilter[0]), null, this.top - preCount, onLimitValues);
            DataSet vchDS = inSize.union(leavedSize);
            return new Tuple((Object)vchDS, (Object)this.top);
        }

        Triple<Boolean, Tuple<Integer, Integer>, Tuple<Map<String, Set<Long>>, Map<String, Set<Long>>>> parseBalRS(ResultSet resultSet) throws Exception {
            HashMap inLimitValues = new HashMap();
            HashMap onLimitValues = new HashMap();
            this.balGroupAndOrderBy.forEach(field -> {
                inLimitValues.put(field, new HashSet());
                onLimitValues.put(field, new HashSet());
            });
            int count = 0;
            int preCount = 0;
            boolean collectedEnoughData = false;
            boolean containOtherDim = false;
            while (resultSet.next()) {
                if (!collectedEnoughData) {
                    preCount = count;
                    if ((count += resultSet.getInt("count")) < this.top) {
                        for (String field2 : this.balGroupAndOrderBy) {
                            ((Set)inLimitValues.get(field2)).add(resultSet.getLong(field2));
                        }
                        continue;
                    }
                    collectedEnoughData = true;
                    for (String field2 : this.balGroupAndOrderBy) {
                        ((Set)onLimitValues.get(field2)).add(resultSet.getLong(field2));
                    }
                    continue;
                }
                containOtherDim = this.balGroupAndOrderBy.stream().allMatch(field -> ((Set)inLimitValues.get(field)).contains(LimitSizeVchQueryUtils.extractValue(resultSet, field)));
                if (!containOtherDim) continue;
            }
            if (DebugTrace.enable()) {
                LOGGER.info(String.format("count %s, preCount %s, collectedEnoughData %s, containOtherDim %s", count, preCount, collectedEnoughData, containOtherDim));
            }
            return Triple.of((Object)containOtherDim, (Object)new Tuple((Object)count, (Object)preCount), (Object)new Tuple(inLimitValues, onLimitValues));
        }
    }
}

