/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util;

import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicComplexProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.control.FieldAp;

public class MetaUtils {
    public static FieldAp buildTextFieldAp(String key, LocaleString displayName, boolean isFireUpdEvt, boolean isMustInput) {
        FieldAp fieldAp = MetaUtils.buildFieldAp(key, displayName, isFireUpdEvt);
        TextField textField = new TextField();
        textField.setMustInput(isMustInput);
        textField.setId(key);
        textField.setKey(key);
        fieldAp.setField((Field)textField);
        return fieldAp;
    }

    public static FieldAp buildBaseDateFieldAp(String key, LocaleString displayName, String entityId, String bizOrgField, boolean isFireUpdEvt, boolean isMustInput) {
        FieldAp fieldAp = MetaUtils.buildFieldAp(key, displayName, isFireUpdEvt);
        BasedataField basedataField = new BasedataField();
        basedataField.setMustInput(isMustInput);
        basedataField.setId(key);
        basedataField.setKey(key);
        basedataField.setBaseEntityId(entityId);
        basedataField.setOrgFieldId(bizOrgField);
        fieldAp.setField((Field)basedataField);
        return fieldAp;
    }

    public static void registerBaseDataProp(MainEntityType entityType, String key, String entityId, String bizOrgField) {
        BasedataProp basedataProp = new BasedataProp();
        basedataProp.setOrgProp(bizOrgField);
        basedataProp.setOrgProp("org");
        basedataProp.setDbIgnore(true);
        basedataProp.setName(key);
        basedataProp.setBaseEntityId(entityId);
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
        basedataProp.setComplexType((IDataEntityType)dataEntityType);
        String refKey = key + "_id";
        DynamicSimpleProperty refIDProp = basedataProp.createRefIDProp();
        refIDProp.setName(refKey);
        refIDProp.setDbIgnore(true);
        basedataProp.setRefIdProp((IDataEntityProperty)refIDProp);
        basedataProp.setRefIdPropName(refKey);
        entityType.registerComplexProperty((DynamicComplexProperty)basedataProp);
        entityType.addProperty((DynamicProperty)refIDProp);
    }

    public static void registerTextProp(MainEntityType entityType, String key) {
        TextProp textProp = new TextProp();
        textProp.setName(key);
        textProp.setDbIgnore(true);
        entityType.registerSimpleProperty((DynamicSimpleProperty)textProp);
    }

    public static Control createControl(Class<? extends Control> controlType, String key, IFormView view) {
        try {
            Control control = controlType.newInstance();
            control.setKey(key);
            control.setView(view);
            return control;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    private static FieldAp buildFieldAp(String key, LocaleString displayName, boolean isFireUpdEvt) {
        FieldAp fieldAp = new FieldAp();
        fieldAp.setId(key);
        fieldAp.setKey(key);
        fieldAp.setName(displayName);
        fieldAp.setFireUpdEvt(isFireUpdEvt);
        return fieldAp;
    }

    public static void registerIDataEntityProperty(IDataEntityProperty property, DynamicObjectType type) {
        if (property == null || type == null) {
            return;
        }
        try {
            if (property instanceof DynamicSimpleProperty) {
                DynamicSimpleProperty simpleProperty = (DynamicSimpleProperty)property.clone();
                type.registerSimpleProperty(simpleProperty);
            } else if (property instanceof DynamicComplexProperty) {
                DynamicComplexProperty complexProperty = (DynamicComplexProperty)property.clone();
                type.registerComplexProperty(complexProperty);
                if (complexProperty instanceof BasedataProp) {
                    BasedataProp basedataProp = (BasedataProp)complexProperty;
                    IDataEntityProperty refIdProp = basedataProp.getRefIdProp();
                    type.registerSimpleProperty((DynamicSimpleProperty)refIdProp);
                }
            }
        }
        catch (CloneNotSupportedException e) {
            throw new KDException((Throwable)e, new ErrorCode("VOUCHER_REFLIST_ERROR", ResManager.loadKDString((String)"\u7c7b\u578b\u514b\u9686\u5931\u8d25", (String)"VoucherRefListDataProvider_0", (String)"fi-gl-formplugin", (Object[])new Object[0])), new Object[0]);
        }
    }
}

