/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.bd.util.BillParamUtil;
import kd.fi.gl.exception.GLErrorCode;

public class MultiIndexTreeCache<T> {
    private static final Log LOG = LogFactory.getLog(MultiIndexTreeCache.class);
    public static final String NULL_DEFAULT_VALUE = "-1";
    private final String key;
    private final int maxCapacity;
    private int factorSize = -1;
    private Object[] sampleFactors = null;
    private Map<Object, ?> _holders = new HashMap(10);
    private int size = 0;

    public MultiIndexTreeCache(String key, int maxCapacity) {
        this.key = key;
        this.maxCapacity = maxCapacity;
    }

    public void clearAll() {
        this._holders.clear();
        this.size = 0;
    }

    public void addData(T data, Object ... routeFactors) {
        int i;
        if (this.size > this.maxCapacity) {
            LOG.info("===clear cache on MultiIndexTreeCache: {}", (Object)data.getClass().getName());
            this.clearAll();
        }
        if (null == data) {
            throw new KDBizException(GLErrorCode.BIZ_ERR, new Object[0]);
        }
        for (int j = 0; j < routeFactors.length; ++j) {
            if (null != routeFactors[j]) continue;
            routeFactors[j] = NULL_DEFAULT_VALUE;
        }
        Map nextIndex = this._holders;
        for (i = 0; i < routeFactors.length - 1; ++i) {
            if (!nextIndex.containsKey(routeFactors[i])) {
                nextIndex.put(routeFactors[i], new HashMap(2));
            }
            nextIndex = (Map)nextIndex.get(routeFactors[i]);
        }
        Object previousValue = nextIndex.put((Object)routeFactors[i], data);
        if (null != previousValue) {
            LOG.error("override one exists value:" + previousValue.toString() + ", route params:" + Arrays.stream(routeFactors).map(x -> String.valueOf(x)).collect(Collectors.toList()));
            throw new KDBizException(GLErrorCode.BIZ_ERR, new Object[0]);
        }
        if (this.size == 0) {
            this.sampleFactors = routeFactors;
            this.factorSize = this.sampleFactors.length;
            LOG.info("{} key: {} sample factors: {}", new Object[]{this, this.key, routeFactors});
        }
        ++this.size;
    }

    public T retrieval(Object ... routeFactors) {
        if (null != this.sampleFactors && routeFactors.length != this.factorSize) {
            LOG.error("{} key: {} - inconsistent factor size, it should be {}, sample factors as: {}, but: {}", new Object[]{this, this.key, this.factorSize, this.sampleFactors, routeFactors});
            if (BillParamUtil.getBooleanValue((String)"83bfebc8000017ac", (String)"fi.gl.report.assistbalance.multitreecache.validate.enable", (boolean)true)) {
                throw new KDBizException(GLErrorCode.BIZ_ERR, new Object[]{"inconsistent factor size"});
            }
        }
        for (int j = 0; j < routeFactors.length; ++j) {
            if (null != routeFactors[j]) continue;
            routeFactors[j] = NULL_DEFAULT_VALUE;
        }
        Object nextIndex = this._holders.get(routeFactors[0]);
        for (int i = 1; i < routeFactors.length; ++i) {
            if (null == nextIndex) {
                return null;
            }
            if (i >= routeFactors.length - 1) {
                return (T)((Map)nextIndex).get(routeFactors[i]);
            }
            nextIndex = ((Map)nextIndex).get(routeFactors[i]);
        }
        return (T)nextIndex;
    }

    public int getSize() {
        return this.size;
    }
}

