/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util;

import java.math.BigDecimal;
import java.math.RoundingMode;

public class QuantityAmountCalculator {
    public static boolean consistencyCheck(BigDecimal quantity, int quantityPrecision, BigDecimal price, int pricePrecision, BigDecimal amount, int amountPrecision, boolean abs) {
        if (quantity == null || price == null || amount == null) {
            return true;
        }
        if (quantity.signum() == 0 && price.signum() == 0) {
            return true;
        }
        BigDecimal multiply = price.multiply(quantity).setScale(amountPrecision, RoundingMode.HALF_UP);
        if (multiply.signum() == 0) {
            return amount.signum() == 0;
        }
        if (amount.signum() == 0) {
            return false;
        }
        if (abs) {
            return multiply.abs().compareTo(amount.abs()) == 0 || amount.divide(quantity, pricePrecision, RoundingMode.HALF_UP).abs().compareTo(price.abs()) == 0 || amount.divide(price, quantityPrecision, RoundingMode.HALF_UP).abs().compareTo(quantity.abs()) == 0;
        }
        return multiply.compareTo(amount) == 0 || amount.divide(quantity, pricePrecision, RoundingMode.HALF_UP).compareTo(price) == 0 || amount.divide(price, quantityPrecision, RoundingMode.HALF_UP).compareTo(quantity) == 0;
    }
}

