/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.service.balance.AppHelper;
import kd.fi.bd.util.BillParamUtil;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.util.threads.Consumer;
import kd.fi.gl.util.threads.Producer;

public class VoucherEntryInitProducer
extends Producer {
    private static final Log LOG = LogFactory.getLog(VoucherEntryInitProducer.class);

    public VoucherEntryInitProducer(BlockingQueue<Callable> sharedQueue, String taskIdentifier, AtomicBoolean isAbort) {
        super(sharedQueue, taskIdentifier, isAbort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        block27: {
            logPrefix = "producer for " + this.taskIdentifier;
            this.startTick = System.currentTimeMillis();
            voucherIdCursor = BillParamUtil.getLongValue((String)"83bfebc8000017ac", (String)"fi.gl.voucher.entryredundant.initstartid", (long)-1L);
            cycle = 0;
            try {
                while (true) lbl-1000:
                // 5 sources

                {
                    keyOfForceCancel = String.format("fi.gl.batchprocess.%s.iscancel", new Object[]{this.taskIdentifier});
                    VoucherEntryInitProducer.LOG.info(logPrefix + ", force cancel property key:" + keyOfForceCancel);
                    isForceCancel = Boolean.parseBoolean(AppHelper.getSystemProperty((String)keyOfForceCancel, (String)"false"));
                    if (isForceCancel) {
                        VoucherEntryInitProducer.LOG.error(logPrefix + "producer: ABORT on force cancel");
                        this.isAllTaskProduced.getAndSet(true);
                        break block27;
                    }
                    pullIdBatchSize = BillParamUtil.getIntegerValue((String)"83bfebc8000017ac", (String)"fi.gl.voucher.entryredundant.batchidcnt", (int)100000);
                    taskIdBatchSize = BillParamUtil.getIntegerValue((String)"83bfebc8000017ac", (String)"fi.gl.voucher.entryredundant.taskidcnt", (int)10000);
                    entryDs = QueryServiceHelper.queryDataSet((String)(Producer.class + ".fullBatchUpdate"), (String)"gl_voucher", (String)"id,org,period", (QFilter[])new QFilter("id", ">", (Object)voucherIdCursor).toArray(), (String)"id", (int)pullIdBatchSize);
                    var10_10 = null;
                    try {
                        ++cycle;
                        if (!entryDs.hasNext()) {
                            VoucherEntryInitProducer.LOG.info(logPrefix + "producer: end, cost:" + (System.currentTimeMillis() - this.startTick));
                            this.isAllTaskProduced.getAndSet(true);
                            return;
                        }
                        if (DebugTrace.enable()) {
                            VoucherEntryInitProducer.LOG.info(logPrefix + "producer: batch:" + cycle);
                        }
                        params = new HashMap<Long, VoucherUpdateParam>(taskIdBatchSize);
                        while (entryDs.hasNext()) {
                            row = entryDs.next();
                            vid = row.getLong("id");
                            params.put(vid, new VoucherUpdateParam(vid, row.getLong("org"), row.getLong("period")));
                            if (vid > voucherIdCursor) {
                                voucherIdCursor = vid;
                            }
                            if (params.size() < taskIdBatchSize || params.isEmpty()) continue;
                            curTaskIndex = this.produceTaskCnt.incrementAndGet();
                            voucherUpdateParams = new ArrayList<VoucherUpdateParam>(params.values());
                            newTask = new VoucherEntryUpdateTask(voucherUpdateParams, curTaskIndex, this.consumer, this, this.taskIdentifier);
                            params.clear();
                            while (!this.taskQueue.offer(newTask)) {
                                Thread.sleep(2000L);
                            }
                            if (!DebugTrace.enable()) continue;
                            VoucherEntryInitProducer.LOG.info(String.format(logPrefix + "producer: generate task index: %s with %s in cycle: %s, voucher id cursor: %s", new Object[]{this.produceTaskCnt.get(), voucherUpdateParams.size(), cycle, voucherIdCursor}));
                        }
                        if (params.isEmpty()) ** GOTO lbl-1000
                        curTaskIndex = this.produceTaskCnt.incrementAndGet();
                        voucherUpdateParams = new ArrayList<VoucherUpdateParam>(params.values());
                        while (!this.taskQueue.offer(new VoucherEntryUpdateTask(voucherUpdateParams, curTaskIndex, this.consumer, this, this.taskIdentifier))) {
                            Thread.sleep(2000L);
                        }
                        if (!DebugTrace.enable()) ** GOTO lbl-1000
                        VoucherEntryInitProducer.LOG.info(String.format(logPrefix + "producer: generate task index: %s with %s in cycle: %s, voucher id cursor: %s", new Object[]{this.produceTaskCnt.get(), params.size(), cycle, voucherIdCursor}));
                    }
                    catch (Throwable var11_14) {
                        var10_10 = var11_14;
                        throw var11_14;
                    }
                    finally {
                        if (entryDs == null) continue;
                        if (var10_10 != null) {
                            try {
                                entryDs.close();
                            }
                            catch (Throwable var11_12) {
                                var10_10.addSuppressed(var11_12);
                            }
                            continue;
                        }
                        entryDs.close();
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                VoucherEntryInitProducer.LOG.error(logPrefix + "producer: ABORT on error:" + e.getMessage(), (Throwable)e);
                break block27;
            }
            finally {
                VoucherEntryInitProducer.LOG.info(logPrefix + "producer keep alive during: " + (System.currentTimeMillis() - this.startTick));
            }
            ** GOTO lbl-1000
        }
    }

    private static int batchUpdateEntry(Collection<VoucherUpdateParam> params) {
        if (!CollectionUtils.isEmpty(params)) {
            int[] updateRowCnts = DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)"update t_gl_voucherentry set forgid = ? , fperiodid = ? where fid = ? ", params.stream().map(x -> x.build()).collect(Collectors.toList()));
            return Arrays.stream(updateRowCnts).sum();
        }
        return 0;
    }

    public static class VoucherUpdateParam {
        private long voucherId;
        private long orgId;
        private long periodId;

        public VoucherUpdateParam(long voucherId, long orgId, long periodId) {
            this.voucherId = voucherId;
            this.orgId = orgId;
            this.periodId = periodId;
        }

        public Object[] build() {
            return new Object[]{this.orgId, this.periodId, this.voucherId};
        }

        public long getVoucherId() {
            return this.voucherId;
        }
    }

    public static class VoucherEntryUpdateTask
    implements Callable {
        private final Collection<VoucherUpdateParam> batchUpdateParams;
        private final Consumer consumer;
        private final Producer producer;
        private final String taskIdentifier;
        private final int curTaskIndex;

        public VoucherEntryUpdateTask(Collection<VoucherUpdateParam> batchUpdateParams, int curTaskIndex, Consumer consumer, Producer producer, String taskIdentifier) {
            this.batchUpdateParams = batchUpdateParams;
            this.consumer = consumer;
            this.producer = producer;
            this.taskIdentifier = taskIdentifier;
            this.curTaskIndex = curTaskIndex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object call() throws Exception {
            boolean isFullSuccess;
            long taskTick;
            String logPrefix;
            block24: {
                boolean isFullSuccess2;
                Object var5_4;
                logPrefix = "VoucherEntryUpdateTask_" + this.taskIdentifier;
                taskTick = System.currentTimeMillis();
                try {
                    boolean isForceCancel = BillParamUtil.getBooleanValue((String)"83bfebc8000017ac", (String)"fi.gl.voucher.entryredundant.iscancel", (boolean)false);
                    if (isForceCancel) {
                        LOG.error(logPrefix + "consumer,ABORT on force cancel");
                        this.consumer.getIsAbort().getAndSet(true);
                    }
                    if (!this.consumer.getIsAbort().get()) break block24;
                    LOG.info(logPrefix + "consumer,worker aborted.");
                    var5_4 = null;
                    boolean bl = isFullSuccess2 = !this.consumer.getIsAbort().get() && this.curTaskIndex == this.producer.getProduceTaskCnt().get();
                }
                catch (Throwable throwable) {
                    boolean isFullSuccess3;
                    boolean bl = isFullSuccess3 = !this.consumer.getIsAbort().get() && this.curTaskIndex == this.producer.getProduceTaskCnt().get();
                    if (this.consumer.getIsAbort().get() || isFullSuccess3) {
                        if (DebugTrace.enable()) {
                            LOG.info(logPrefix + "consumer, all tasks are processed or is abort, close thread pool, cost:" + (System.currentTimeMillis() - this.producer.getStartTick()));
                            LOG.info(logPrefix + String.format("consumer,SUMMARY: submitted task: %s, consumed task: %s, is Abort:%s", this.consumer.getSubmittedTaskCnt().get(), this.consumer.getConsumedTaskCnt().get(), this.consumer.getIsAbort().get()));
                        }
                        this.consumer.getFinishLatch().countDown();
                    }
                    throw throwable;
                }
                if (this.consumer.getIsAbort().get() || isFullSuccess2) {
                    if (DebugTrace.enable()) {
                        LOG.info(logPrefix + "consumer, all tasks are processed or is abort, close thread pool, cost:" + (System.currentTimeMillis() - this.producer.getStartTick()));
                        LOG.info(logPrefix + String.format("consumer,SUMMARY: submitted task: %s, consumed task: %s, is Abort:%s", this.consumer.getSubmittedTaskCnt().get(), this.consumer.getConsumedTaskCnt().get(), this.consumer.getIsAbort().get()));
                    }
                    this.consumer.getFinishLatch().countDown();
                }
                return var5_4;
            }
            try (TXHandle tx = TX.requiresNew();){
                try {
                    int updateRowsCnt = VoucherEntryInitProducer.batchUpdateEntry(this.batchUpdateParams);
                    this.consumer.getTotalHandleItemCnt().getAndAdd(updateRowsCnt);
                    LOG.info(logPrefix + String.format("consumer,worker task index: %s, update voucher size: %s, update entry rows: %s, cost: %s.", this.curTaskIndex, this.batchUpdateParams.size(), updateRowsCnt, System.currentTimeMillis() - taskTick));
                    this.batchUpdateParams.clear();
                }
                catch (Exception e) {
                    tx.markRollback();
                    this.consumer.getIsAbort().getAndSet(true);
                    LOG.error(logPrefix + String.format("consumer,worker update voucher size: %s, failed on : %s", this.batchUpdateParams.size(), e.getMessage()), (Throwable)e);
                }
            }
            boolean bl = isFullSuccess = !this.consumer.getIsAbort().get() && this.curTaskIndex == this.producer.getProduceTaskCnt().get();
            if (this.consumer.getIsAbort().get() || isFullSuccess) {
                if (DebugTrace.enable()) {
                    LOG.info(logPrefix + "consumer, all tasks are processed or is abort, close thread pool, cost:" + (System.currentTimeMillis() - this.producer.getStartTick()));
                    LOG.info(logPrefix + String.format("consumer,SUMMARY: submitted task: %s, consumed task: %s, is Abort:%s", this.consumer.getSubmittedTaskCnt().get(), this.consumer.getConsumedTaskCnt().get(), this.consumer.getIsAbort().get()));
                }
                this.consumer.getFinishLatch().countDown();
            }
            return null;
        }
    }
}

