/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util.replace;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.Flushable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import kd.bos.entity.flex.FlexProperty;
import kd.bos.ext.fi.flex.FlexFilterUtil;
import kd.bos.ext.fi.gl.flexplugin.FilterInfo;
import kd.bos.ext.fi.gl.flexplugin.SourceType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.bd.util.BDUtil;
import kd.fi.bd.util.collector.ExtCollectors;
import kd.fi.bd.util.filter.QFilterBuilder;
import kd.fi.gl.business.vo.voucher.IVoucherEntry;
import kd.fi.gl.constant.GLField;
import kd.fi.gl.enums.basedata.AssistValueType;
import kd.fi.gl.flex.FlexValueJson;
import kd.fi.gl.util.FlexUtils;
import kd.fi.gl.util.MasterBaseDataUtils;

public class AssgrpBatchReplacer<T extends IVoucherEntry>
implements Flushable {
    private final BiFunction<T, String, Object> defaultValueSetter;
    private final boolean reloadMasterId;
    protected final List<ReplaceTask> pendingTaskList;
    private final Set<T> changedEntryList;
    private final String assgrpKey;
    protected boolean filterPermission = false;
    private long orgId;
    private long bookTypeId;
    protected static final int batchCnt = 999;

    public AssgrpBatchReplacer(boolean reloadMasterId, String assgrpKey) {
        this(reloadMasterId, assgrpKey, null);
    }

    public AssgrpBatchReplacer(boolean reloadMasterId, String assgrpKey, BiFunction<T, String, Object> defaultValueSetter) {
        this.reloadMasterId = reloadMasterId;
        this.assgrpKey = assgrpKey;
        this.defaultValueSetter = defaultValueSetter;
        this.pendingTaskList = new ArrayList<ReplaceTask>(10);
        this.changedEntryList = new LinkedHashSet<T>(10);
    }

    public void setFilterPermission(long orgId, long bookTypeId) {
        this.filterPermission = true;
        this.orgId = orgId;
        this.bookTypeId = bookTypeId;
    }

    public void addReplace(T replaceObject, List<String> targetFlexFields, String flexValueJson) {
        this.addReplace(replaceObject, targetFlexFields, flexValueJson, null);
    }

    public void addReplace(T replaceObject, List<String> targetFlexFields, String flexValueJson, Long assgrpId) {
        Map<String, Object> flexValueMap = new FlexValueJson(flexValueJson).getValueMap();
        this.pendingTaskList.add(new ReplaceTask(this, replaceObject, flexValueMap, targetFlexFields, assgrpId));
        this.checkSize();
    }

    private void checkSize() {
        if (this.pendingTaskList.size() >= 999) {
            this.flush();
        }
    }

    @Override
    public void flush() {
        if (this.pendingTaskList.isEmpty()) {
            return;
        }
        this._flush();
        this.pendingTaskList.clear();
    }

    protected void _flush() {
        Map<ReplaceTask, Map> replaceTaskResultMap = this.pendingTaskList.stream().collect(Collectors.toMap(task -> task, ReplaceTask::correctByFlexFieldsAndDefaultValue));
        if (this.filterPermission) {
            Map<Map<String, Object>, Map<String, Object>> correctedMap = this.correctAssgrpByPermission(new HashSet<Map<String, Object>>(replaceTaskResultMap.values()));
            replaceTaskResultMap.replaceAll((t, v) -> (Map)correctedMap.get(replaceTaskResultMap.get(t)));
        }
        Set popedReplaceTasks = BDUtil.popFromMap(replaceTaskResultMap, e -> ((ReplaceTask)e.getKey()).assgrpId != null && ((Map)e.getValue()).equals(((ReplaceTask)e.getKey()).flexValueMap)).keySet();
        popedReplaceTasks.forEach(task -> ((ReplaceTask)task).voucherEntry.set(GLField.id_(this.assgrpKey), ((ReplaceTask)task).assgrpId));
        if (replaceTaskResultMap.isEmpty()) {
            return;
        }
        Map<Map<String, Object>, Long> targetIdMap = FlexUtils.batchSaveFlexData(replaceTaskResultMap.values(), this.reloadMasterId);
        for (Map.Entry<ReplaceTask, Map> replaceTaskMapEntry : replaceTaskResultMap.entrySet()) {
            IVoucherEntry voucherEntry = replaceTaskMapEntry.getKey().voucherEntry;
            this.changedEntryList.add(voucherEntry);
            voucherEntry.set(GLField.id_(this.assgrpKey), targetIdMap.getOrDefault(replaceTaskMapEntry.getValue(), 0L));
        }
    }

    private Map<Map<String, Object>, Map<String, Object>> correctAssgrpByPermission(Set<Map<String, Object>> assgrpCol) {
        Multimap flexValuesMap = (Multimap)assgrpCol.stream().distinct().flatMap(assgrp -> assgrp.entrySet().stream()).collect(ExtCollectors.toMultiap(Map.Entry::getKey, Map.Entry::getValue));
        HashMultimap permissionFlexValuesMap = HashMultimap.create((Multimap)flexValuesMap);
        flexValuesMap.asMap().forEach((arg_0, arg_1) -> this.lambda$correctAssgrpByPermission$6((Multimap)permissionFlexValuesMap, arg_0, arg_1));
        return assgrpCol.stream().collect(Collectors.toMap(assgrp -> assgrp, arg_0 -> AssgrpBatchReplacer.lambda$correctAssgrpByPermission$9((Multimap)permissionFlexValuesMap, arg_0), (o, n) -> n));
    }

    public Set<T> finish() {
        this.flush();
        return this.changedEntryList;
    }

    private static /* synthetic */ Map lambda$correctAssgrpByPermission$9(Multimap permissionFlexValuesMap, Map assgrp) {
        HashMap result = new HashMap(assgrp);
        result.keySet().removeIf(flexfield -> !permissionFlexValuesMap.containsEntry(flexfield, assgrp.get(flexfield)));
        return result;
    }

    private /* synthetic */ void lambda$correctAssgrpByPermission$6(Multimap permissionFlexValuesMap, String flexField, Collection values) {
        QFilter baseDataFilter;
        FlexProperty flexProperty = FlexUtils.getFlexProperty(flexField);
        if (AssistValueType.isManualTxt(flexProperty.getValueType())) {
            return;
        }
        String valueSource = flexProperty.getValueSource();
        if (FlexFilterUtil.isBankAccount((String)valueSource)) {
            FilterInfo bankQFilter = FlexFilterUtil.getBankQFilter((long)this.orgId, (long)this.bookTypeId, (String)valueSource, (SourceType)SourceType.bill, Collections.emptyList(), Collections.emptyList());
            baseDataFilter = Optional.ofNullable(bankQFilter).map(FilterInfo::getFilter).orElse(null);
        } else {
            baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)valueSource, (Long)this.orgId);
        }
        if (baseDataFilter == null) {
            return;
        }
        String masterIdField = MasterBaseDataUtils.getMasterIdField(valueSource);
        QFilterBuilder qFilterBuilder = QFilterBuilder.create((String)masterIdField, (String)"in", (Object)values).add(baseDataFilter);
        Set validMasterIds = QueryServiceHelper.query((String)valueSource, (String)masterIdField, (QFilter[])qFilterBuilder.toArray(new QFilter[0])).stream().map(dyn -> dyn.get(masterIdField)).collect(Collectors.toSet());
        if (values.size() != validMasterIds.size()) {
            permissionFlexValuesMap.removeAll((Object)flexField);
            permissionFlexValuesMap.putAll((Object)flexField, validMasterIds);
        }
    }

    private static class ReplaceTask {
        private final T voucherEntry;
        private final Map<String, Object> flexValueMap;
        private final Long assgrpId;
        private final List<String> targetFlexFields;
        final /* synthetic */ AssgrpBatchReplacer this$0;

        public ReplaceTask(T voucherEntry, Map<String, Object> flexValueMap, List<String> targetFlexFields, Long assgrpId) {
            this.this$0 = var1_1;
            this.voucherEntry = voucherEntry;
            this.flexValueMap = flexValueMap;
            this.targetFlexFields = targetFlexFields;
            this.assgrpId = assgrpId;
        }

        public Map<String, Object> correctByFlexFieldsAndDefaultValue() {
            HashMap<String, Object> result = new HashMap<String, Object>(this.flexValueMap);
            result.keySet().removeIf(flexField -> !this.targetFlexFields.contains(flexField));
            if (this.this$0.defaultValueSetter == null) {
                return result;
            }
            for (String targetFlexField : this.targetFlexFields) {
                Object valueBuf;
                if (result.containsKey(targetFlexField) || (valueBuf = this.this$0.defaultValueSetter.apply(this.voucherEntry, targetFlexField)) == null) continue;
                result.put(targetFlexField, valueBuf);
            }
            return result;
        }
    }
}

