/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util.threads;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.bd.service.balance.AppHelper;
import kd.fi.gl.util.threads.Producer;

public class Consumer
implements Runnable {
    private static final Log LOG = LogFactory.getLog(Consumer.class);
    private final BlockingQueue<Callable> taskQueue;
    private final String taskIdentifier;
    private final int threadParallelism;
    private final CountDownLatch finishLatch;
    private Producer producer;
    private final AtomicBoolean isAllSubmitted = new AtomicBoolean(false);
    private AtomicInteger submittedTaskCnt = new AtomicInteger(0);
    private final AtomicBoolean isAbort;
    private AtomicInteger consumedTaskCnt = new AtomicInteger(0);
    private AtomicLong totalHandleItemCnt = new AtomicLong(0L);

    public AtomicLong getTotalHandleItemCnt() {
        return this.totalHandleItemCnt;
    }

    public Consumer(BlockingQueue<Callable> sharedQueue, String taskIdentifier, int threadParallelism, Producer producer, AtomicBoolean isAbort) {
        this.taskQueue = sharedQueue;
        this.taskIdentifier = taskIdentifier;
        this.threadParallelism = threadParallelism;
        this.producer = producer;
        this.finishLatch = new CountDownLatch(1);
        this.isAbort = isAbort;
        if (producer.getIsAbort() != this.isAbort) {
            throw new IllegalStateException("tha variable isAbort must be in the same on producer and consumer.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        String logPrefix = this.taskIdentifier;
        String keyOfForceCancel = String.format("fi.gl.batchprocess.%s.iscancel", this.taskIdentifier);
        LOG.info(logPrefix + ", force cancel property key:" + keyOfForceCancel);
        long startConsumeTick = System.currentTimeMillis();
        try {
            while (!this.isAbort.get()) {
                Callable headTask;
                block13: {
                    block14: {
                        if (this.submittedTaskCnt.get() - this.consumedTaskCnt.get() >= this.threadParallelism * 2) {
                            Thread.sleep(1000L);
                            continue;
                        }
                        boolean hadProducerStop = this.producer.isAllTaskProduced().get();
                        headTask = this.taskQueue.poll(1L, TimeUnit.SECONDS);
                        if (null != headTask) break block13;
                        if (!hadProducerStop) continue;
                        this.isAllSubmitted.getAndSet(true);
                        if (this.consumedTaskCnt.get() != this.producer.getProduceTaskCnt().get()) break block14;
                        LOG.info(logPrefix + "consumer, all task had been submitted:" + this.submittedTaskCnt.get());
                        return;
                    }
                    Thread.sleep(1000L);
                    continue;
                }
                boolean isForceCancel = Boolean.parseBoolean(AppHelper.getSystemProperty((String)keyOfForceCancel, (String)"false"));
                if (isForceCancel) {
                    LOG.error(logPrefix + "consumer, ABORT on force cancel");
                    return;
                }
                ThreadService.execute(() -> {
                    boolean isFullSuccess;
                    int curTaskIndex;
                    long oneTaskTick = System.currentTimeMillis();
                    try {
                        headTask.call();
                        curTaskIndex = this.consumedTaskCnt.incrementAndGet();
                    }
                    catch (Exception e) {
                        boolean isFullSuccess2;
                        int curTaskIndex2;
                        try {
                            this.isAbort.getAndSet(true);
                            LOG.error(logPrefix + "failed on: " + e.getMessage(), (Throwable)e);
                            curTaskIndex2 = this.consumedTaskCnt.incrementAndGet();
                        }
                        catch (Throwable throwable) {
                            boolean isFullSuccess3;
                            int curTaskIndex3 = this.consumedTaskCnt.incrementAndGet();
                            LOG.info(logPrefix + "consumer, task " + curTaskIndex3 + " consumed, cost:" + (System.currentTimeMillis() - oneTaskTick));
                            boolean bl = isFullSuccess3 = !this.isAbort.get() && this.producer.isAllTaskProduced().get() && curTaskIndex3 == this.producer.getProduceTaskCnt().get();
                            if (this.isAbort.get() || isFullSuccess3) {
                                LOG.info(logPrefix + String.format("consumer, all tasks are processed successfully: %s, subitem processed: %s, cost: %s", !this.isAbort.get(), this.totalHandleItemCnt.get(), System.currentTimeMillis() - startConsumeTick));
                                this.finishLatch.countDown();
                            }
                            throw throwable;
                        }
                        LOG.info(logPrefix + "consumer, task " + curTaskIndex2 + " consumed, cost:" + (System.currentTimeMillis() - oneTaskTick));
                        boolean bl = isFullSuccess2 = !this.isAbort.get() && this.producer.isAllTaskProduced().get() && curTaskIndex2 == this.producer.getProduceTaskCnt().get();
                        if (this.isAbort.get() || isFullSuccess2) {
                            LOG.info(logPrefix + String.format("consumer, all tasks are processed successfully: %s, subitem processed: %s, cost: %s", !this.isAbort.get(), this.totalHandleItemCnt.get(), System.currentTimeMillis() - startConsumeTick));
                            this.finishLatch.countDown();
                        }
                    }
                    LOG.info(logPrefix + "consumer, task " + curTaskIndex + " consumed, cost:" + (System.currentTimeMillis() - oneTaskTick));
                    boolean bl = isFullSuccess = !this.isAbort.get() && this.producer.isAllTaskProduced().get() && curTaskIndex == this.producer.getProduceTaskCnt().get();
                    if (this.isAbort.get() || isFullSuccess) {
                        LOG.info(logPrefix + String.format("consumer, all tasks are processed successfully: %s, subitem processed: %s, cost: %s", !this.isAbort.get(), this.totalHandleItemCnt.get(), System.currentTimeMillis() - startConsumeTick));
                        this.finishLatch.countDown();
                    }
                }, (TaskType)TaskType.GL_BATCH_PROCESS_PRODUCER_CONSUMER);
                this.submittedTaskCnt.getAndIncrement();
            }
            return;
            catch (Exception e) {
                LOG.error(logPrefix + "consumer,ABNORMAL ABORT, produce task: " + this.producer.getProduceTaskCnt().get() + ", consumed task: " + this.consumedTaskCnt.get());
                return;
            }
        }
        catch (Exception e) {
            LOG.error(logPrefix + "consumer, give up all tasks on " + e.getMessage(), (Throwable)e);
            return;
        }
        finally {
            LOG.info(logPrefix + "consumer_exit, cost:" + (System.currentTimeMillis() - startConsumeTick));
            this.finishLatch.countDown();
        }
    }

    public CountDownLatch getFinishLatch() {
        return this.finishLatch;
    }

    public AtomicInteger getConsumedTaskCnt() {
        return this.consumedTaskCnt;
    }

    public AtomicBoolean getIsAbort() {
        return this.isAbort;
    }

    public AtomicBoolean getIsAllSubmitted() {
        return this.isAllSubmitted;
    }

    public AtomicInteger getSubmittedTaskCnt() {
        return this.submittedTaskCnt;
    }
}

