/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util.voucher.check;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.OperationContext;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.mvc.SessionManager;
import kd.bos.util.CollectionUtils;
import kd.fi.gl.util.threads.Consumer;
import kd.fi.gl.util.voucher.check.VoucherEntryCheckProducer;

public class VoucherCheckExecutor
implements ProgresssListener {
    private final String pageId;

    public VoucherCheckExecutor(String pageId) {
        this.pageId = pageId;
    }

    public void execute() {
        ArrayBlockingQueue<Callable> taskQueue = new ArrayBlockingQueue<Callable>(40);
        AtomicBoolean isAbort = new AtomicBoolean(false);
        String taskIdentifier = "checkVoucher-" + RequestContext.getOrCreate().getTraceId();
        VoucherEntryCheckProducer producer = new VoucherEntryCheckProducer(taskQueue, taskIdentifier, isAbort, this.pageId);
        Consumer consumer = new Consumer(taskQueue, taskIdentifier, 1, producer, isAbort);
        producer.setConsumer(consumer);
        ThreadService.execute((Runnable)producer, (TaskType)TaskType.GL_CHECK_VOUCHER_PRODUCER, null, (OperationContext)OperationContext.get());
        ThreadService.execute((Runnable)consumer, (TaskType)TaskType.GL_CHECK_VOUCHER_CONSUMER, null, (OperationContext)OperationContext.get());
    }

    public void onProgress(ProgressEvent progressEvent) {
        List<CacheValue> errorDatas;
        progressEvent.setProgress(50);
        String progress = VoucherCheckCacheManager.getProgress(this.pageId);
        progressEvent.setText(progress);
        if (VoucherCheckCacheManager.isSuccess(this.pageId).booleanValue()) {
            progressEvent.setProgress(100);
            VoucherCheckCacheManager.setSuccess(this.pageId, Boolean.FALSE);
        }
        if (CollectionUtils.isNotEmpty(errorDatas = VoucherCheckCacheManager.getAndClearErrorDatas(this.pageId))) {
            AbstractFormDataModel model = (AbstractFormDataModel)SessionManager.getCurrent().getView(this.pageId).getModel();
            TableValueSetter valueSetter = new TableValueSetter(new String[]{"voucherid", "errortype"});
            errorDatas.forEach(data -> valueSetter.addRow(new Object[]{((CacheValue)data).entryId, ((CacheValue)data).errorInfo}));
            model.batchCreateNewEntryRow("entryentity1", valueSetter);
        }
    }

    protected static class CacheValue
    implements Serializable {
        private static final long serialVersionUID = -1L;
        private Long entryId;
        private String errorInfo;

        public CacheValue() {
        }

        public CacheValue(Long entryId, String errorInfo) {
            this.entryId = entryId;
            this.errorInfo = errorInfo;
        }

        public Long getEntryId() {
            return this.entryId;
        }

        public String getErrorInfo() {
            return this.errorInfo;
        }
    }

    public static class VoucherCheckCacheManager {
        private static final String DATA_PREFIX = "VoucherChecker$ErrorData$";
        private static final String PROGRESS_PREFIX = "VoucherChecker$Progress$";
        private static final String FLAG_PREFIX = "VoucherChecker$Success$";

        public static void setSuccess(String pageId, Boolean flag) {
            VoucherCheckCacheManager.getCache().put(FLAG_PREFIX + pageId, (Object)flag.toString());
        }

        public static Boolean isSuccess(String pageId) {
            String flag = (String)VoucherCheckCacheManager.getCache().get(FLAG_PREFIX + pageId);
            return flag == null ? Boolean.FALSE : Boolean.parseBoolean(flag);
        }

        public static void addErrorData(String pageId, CacheValue ... cacheValue) {
            VoucherCheckCacheManager.getCache().addList(DATA_PREFIX + pageId, (String[])Arrays.stream(cacheValue).map(SerializationUtils::toJsonString).toArray(String[]::new));
        }

        public static List<CacheValue> getAndClearErrorDatas(String pageId) {
            String[] list = VoucherCheckCacheManager.getCache().getList(DATA_PREFIX + pageId);
            VoucherCheckCacheManager.getCache().remove(DATA_PREFIX + pageId);
            return Arrays.stream(list).map(v -> (CacheValue)SerializationUtils.fromJsonString((String)v, CacheValue.class)).collect(Collectors.toList());
        }

        public static void setProgress(String pageId, String val) {
            VoucherCheckCacheManager.getCache().put(PROGRESS_PREFIX + pageId, (Object)val);
        }

        public static String getProgress(String pageId) {
            return (String)VoucherCheckCacheManager.getCache().get(PROGRESS_PREFIX + pageId);
        }

        private static DistributeSessionlessCache getCache() {
            return CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(CacheKeyUtil.getAcctId() + "VoucherCheckCacheManager");
        }
    }
}

