/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util.voucher.check;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.flex.FlexProperty;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.fi.gl.flex.FlexValueJson;
import kd.fi.gl.util.FlexUtils;
import kd.fi.gl.util.QFBuilder;
import kd.fi.gl.util.voucher.check.VoucherCheckExecutor;
import kd.fi.gl.util.voucher.check.VoucherEntryCheckProducer;

public enum VoucherCheckType {
    JUST_FOR_DB(1, "just for db.", new QueryConsumer()),
    ASSGRP_NOT_MATCH_ACCOUNT(2, "nonexistent assist item from account", new MatchConsumer()),
    ASSIST_NOT_USE_MASTERID(4, "one of the assist value doesn't store by masterid.", new MasterIdConsumer());

    private final int value;
    private final String description;
    private final Consumer<VoucherEntryCheckProducer.CheckTask> consumer;
    private static final Log LOG;

    private VoucherCheckType(int value, String description, Consumer<VoucherEntryCheckProducer.CheckTask> consumer) {
        this.value = value;
        this.description = description;
        this.consumer = consumer;
    }

    public String getDescription() {
        return this.description;
    }

    public Consumer<VoucherEntryCheckProducer.CheckTask> getConsumer() {
        return this.consumer;
    }

    public int getValue() {
        return this.value;
    }

    public static List<VoucherCheckType> getCheckTypes(int value) {
        Preconditions.checkArgument(((value & 1) == 1 ? 1 : 0) != 0, (Object)"value must contain 0b1");
        return Arrays.stream(VoucherCheckType.values()).filter(type -> (type.value | value) == value).collect(Collectors.toList());
    }

    static {
        LOG = LogFactory.getLog(VoucherCheckType.class);
    }

    private static class MasterIdConsumer
    implements Consumer<VoucherEntryCheckProducer.CheckTask> {
        private MasterIdConsumer() {
        }

        @Override
        public void accept(VoucherEntryCheckProducer.CheckTask checkTask) {
            HashMultimap flex2Values = HashMultimap.create();
            checkTask.checkContext.getAssgrpId2Flex2Value().rowMap().values().stream().flatMap(x -> x.entrySet().stream()).forEach(arg_0 -> MasterIdConsumer.lambda$accept$1((Multimap)flex2Values, arg_0));
            HashSet illegalHgids = new HashSet(32);
            Map<String, String> flex2ValueSource = FlexUtils.batchGetFlexProperty(flex2Values.keySet().toArray(new String[0])).values().stream().filter(prop -> !prop.getValueType().equals("3")).collect(Collectors.toMap(FlexProperty::getFlexField, FlexProperty::getValueSource));
            flex2Values.asMap().forEach((flex, values) -> {
                if (StringUtils.isEmpty((String)((String)flex2ValueSource.get(flex))) || EntityMetadataCache.getDataEntityType((String)((String)flex2ValueSource.get(flex))).findProperty("masterid") == null) {
                    return;
                }
                QFBuilder qfBuilder = new QFBuilder().add(QFilter.of((String)"id != masterid", (Object[])new Object[0])).add("id", "in", values);
                Set illegalValues = BusinessDataServiceHelper.loadFromCache((String)((String)flex2ValueSource.get(flex)), (String)"id", (QFilter[])qfBuilder.toArray()).values().stream().map(v -> v.get("id")).collect(Collectors.toSet());
                if (CollectionUtils.isNotEmpty(illegalValues)) {
                    checkTask.checkContext.getAssgrpId2Flex2Value().rowMap().forEach((assgrpId, valueMap) -> {
                        if (illegalValues.contains(valueMap.get(flex))) {
                            illegalHgids.add(assgrpId);
                        }
                    });
                }
            });
            if (!illegalHgids.isEmpty()) {
                VoucherCheckExecutor.CacheValue[] cacheValues = (VoucherCheckExecutor.CacheValue[])checkTask.entryParams.stream().filter(entry -> illegalHgids.contains(entry.getAssgrpId())).map(param -> new VoucherCheckExecutor.CacheValue(param.getEntryId(), ASSIST_NOT_USE_MASTERID.getDescription())).toArray(VoucherCheckExecutor.CacheValue[]::new);
                VoucherCheckExecutor.VoucherCheckCacheManager.addErrorData(checkTask.pageId, cacheValues);
            }
        }

        private static /* synthetic */ void lambda$accept$1(Multimap flex2Values, Map.Entry e) {
            flex2Values.put(e.getKey(), e.getValue());
        }
    }

    private static class MatchConsumer
    implements Consumer<VoucherEntryCheckProducer.CheckTask> {
        private MatchConsumer() {
        }

        @Override
        public void accept(VoucherEntryCheckProducer.CheckTask checkTask) {
            HashMultimap account2Flexs = HashMultimap.create();
            checkTask.checkContext.getAccountId2Dyn().values().forEach(arg_0 -> MatchConsumer.lambda$accept$1((Multimap)account2Flexs, arg_0));
            HashMultimap hgid2Flexs = HashMultimap.create();
            checkTask.checkContext.getAssgrpId2Flex2Value().rowMap().entrySet().stream().collect(Collectors.toMap(e -> (Long)e.getKey(), e -> ((Map)e.getValue()).keySet())).forEach((arg_0, arg_1) -> ((Multimap)hgid2Flexs).putAll(arg_0, arg_1));
            checkTask.entryParams.forEach(arg_0 -> MatchConsumer.lambda$accept$5((Multimap)account2Flexs, (Multimap)hgid2Flexs, checkTask, arg_0));
        }

        private static /* synthetic */ void lambda$accept$5(Multimap account2Flexs, Multimap hgid2Flexs, VoucherEntryCheckProducer.CheckTask checkTask, VoucherEntryCheckProducer.EntryParam entryParam) {
            Collection legalFlexs = account2Flexs.get((Object)entryParam.getAccountId());
            Collection actualFlexs = hgid2Flexs.get((Object)entryParam.getAssgrpId());
            if (actualFlexs.stream().anyMatch(flex -> !legalFlexs.contains(flex))) {
                LOG.warn("{} detects a wrong entry, entryid:{}, task index:{}, wrong description:{}", new Object[]{checkTask.logPrefix, entryParam.getEntryId(), checkTask.curTaskIndex, ASSGRP_NOT_MATCH_ACCOUNT.getDescription()});
                VoucherCheckExecutor.VoucherCheckCacheManager.addErrorData(checkTask.pageId, new VoucherCheckExecutor.CacheValue(entryParam.getEntryId(), ASSGRP_NOT_MATCH_ACCOUNT.getDescription()));
            }
        }

        private static /* synthetic */ void lambda$accept$1(Multimap account2Flexs, DynamicObject accDyn) {
            account2Flexs.putAll((Object)accDyn.getLong("id"), (Iterable)accDyn.getDynamicObjectCollection("checkitementry").stream().map(row -> row.getString("asstactitem.flexfield")).collect(Collectors.toSet()));
        }
    }

    private static class QueryConsumer
    implements Consumer<VoucherEntryCheckProducer.CheckTask> {
        private QueryConsumer() {
        }

        @Override
        public void accept(VoucherEntryCheckProducer.CheckTask checkTask) {
            Set accountIds = checkTask.entryParams.stream().map(VoucherEntryCheckProducer.EntryParam::getAccountId).collect(Collectors.toSet());
            Map accountId2Dyn = BusinessDataServiceHelper.loadFromCache((String)"bd_accountview", (String)"checkitementry, checkitementry.asstactitem, checkitementry.asstactitem.flexfield", (QFilter[])new QFilter[]{new QFilter("id", "in", accountIds)});
            checkTask.checkContext.setAccountId2Dyn(accountId2Dyn);
            HashBasedTable assgrpId2Flex2Value = HashBasedTable.create();
            Set assgrpIds = checkTask.entryParams.stream().map(VoucherEntryCheckProducer.EntryParam::getAssgrpId).collect(Collectors.toSet());
            BusinessDataServiceHelper.loadFromCache((String)"gl_assist", (String)"assvals", (QFilter[])new QFilter[]{new QFilter("id", "in", assgrpIds)}).forEach((arg_0, arg_1) -> QueryConsumer.lambda$accept$1((Table)assgrpId2Flex2Value, arg_0, arg_1));
            checkTask.checkContext.setAssgrpId2Flex2Value((Table<Long, String, Object>)assgrpId2Flex2Value);
        }

        private static /* synthetic */ void lambda$accept$1(Table assgrpId2Flex2Value, Object hgid, DynamicObject dyn) {
            new FlexValueJson(dyn.getString("assvals")).getValueMap().forEach((flex, value) -> assgrpId2Flex2Value.put((Object)((Long)hgid), flex, value));
        }
    }
}

