/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.carryover.genentry;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.bd.rate.IRateCalculator;
import kd.fi.bd.rate.RateServiceHelper;
import kd.fi.gl.autotrans.FinalProcessAssgrp;
import kd.fi.gl.balancecarryover.AssistDifferentMsgContext;
import kd.fi.gl.balancecarryover.BalanceCarryOverContext;
import kd.fi.gl.common.VoucherEntryInfo;
import kd.fi.gl.common.VoucherInfo;
import kd.fi.gl.finalprocess.info.AmountInfo;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.voucher.carryover.genentry.IEntryGenerator;
import kd.fi.gl.voucher.carryover.utils.BalanceCarryOverUtils;
import kd.fi.gl.voucher.carryover.utils.CarryOverCacheManager;

public class CarryOverEntryGeneratorImpl
implements IEntryGenerator {
    protected AmountInfo amountInfo;
    protected BalanceCarryOverContext carryOverContext;
    protected DynamicObject transInAccountDyn;
    protected DynamicObject transOutAccountDyn;
    protected IRateCalculator rateCalculator;

    @Override
    public void generateEntry(VoucherInfo voucherInfo) {
        this.generateTransOutEntry(voucherInfo);
        this.generateTransInEntry(voucherInfo);
    }

    @Override
    public IEntryGenerator build(Map<String, Object> paramMap) {
        this.carryOverContext = (BalanceCarryOverContext)paramMap.get("carryOverContext");
        this.amountInfo = CarryOverCacheManager.getAmountInfo(this.carryOverContext.getBalanceId());
        this.rateCalculator = this.getRateCalculator();
        this.initAccounts();
        return this;
    }

    protected void initAccounts() {
        long org = this.carryOverContext.getOrgId();
        long accMasterId = this.carryOverContext.getAccountMasterId();
        long startPeriod = this.carryOverContext.getPeriodId();
        long searchPeriodId = this.carryOverContext.getSearchPeriodId();
        this.transInAccountDyn = CarryOverCacheManager.getAccount(org, accMasterId, searchPeriodId);
        this.transOutAccountDyn = CarryOverCacheManager.getAccount(org, accMasterId, startPeriod);
    }

    protected void generateTransOutEntry(VoucherInfo voucherInfo) {
        VoucherEntryInfo newEntry = voucherInfo.createNewEntry();
        newEntry.setDesc(voucherInfo.getDesc());
        this.amountInfo.setAccountId(this.transOutAccountDyn.getLong("id"));
        this.fillExpireDate(newEntry, this.transOutAccountDyn);
        this.amountInfo.negate();
        if (this.amountInfo.getOriAmount().compareTo(BigDecimal.ZERO) > 0) {
            this.amountInfo.switchDcAndNegate();
        }
        newEntry.loadAmountInfo(this.amountInfo, this.rateCalculator);
    }

    private void generateTransInEntry(VoucherInfo voucherInfo) {
        VoucherEntryInfo newEntry = voucherInfo.createNewEntry();
        newEntry.setDesc(voucherInfo.getDesc());
        this.amountInfo.setAccountId(this.transInAccountDyn.getLong("id"));
        this.fillExpireDate(newEntry, this.transInAccountDyn);
        this.amountInfo.setAssgrpId(this.generateTransInAssgrp());
        this.amountInfo.negate();
        newEntry.loadAmountInfo(this.amountInfo, this.rateCalculator);
    }

    private void fillExpireDate(VoucherEntryInfo newEntry, DynamicObject accountDyn) {
        if (GLUtil.isAccheckAcct(accountDyn)) {
            newEntry.setExpireDate(BalanceCarryOverUtils.getEndDate(this.carryOverContext.getSearchPeriodId()));
        }
    }

    private Long generateTransInAssgrp() {
        Long oldAssgrpId = this.amountInfo.getAssgrpId();
        AssistDifferentMsgContext differentFlexs = this.carryOverContext.getAssistDifferentMsg();
        JSONObject jsonObject = oldAssgrpId == 0L ? new JSONObject() : JSONObject.parseObject((String)CarryOverCacheManager.getAssvals(oldAssgrpId));
        Stream.of(differentFlexs.getAddMustInputAssists(), differentFlexs.getTreeBaseAddLeaf()).flatMap(Collection::stream).forEach(flex -> jsonObject.put(flex, CarryOverCacheManager.getDefaultVal(flex)));
        differentFlexs.getDeleteAssists().forEach(arg_0 -> ((JSONObject)jsonObject).remove(arg_0));
        Set<Long> hgs = FinalProcessAssgrp.create(jsonObject.toJSONString()).getHgIds();
        return hgs.isEmpty() ? Long.valueOf(0L) : hgs.toArray(new Long[0])[0];
    }

    @Override
    public IRateCalculator getRateCalculator() {
        return RateServiceHelper.getRateType((long)this.carryOverContext.getCurrencyId(), (long)this.carryOverContext.getLocalCurrencyId(), (Date)BalanceCarryOverUtils.getEndDate(this.carryOverContext.getSearchPeriodId())).getRateCalculator();
    }
}

