/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.count;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.fi.gl.common.Tuple;
import kd.fi.gl.voucher.count.VoucherCount;
import kd.fi.gl.voucher.count.VoucherCountHelper;

public class VoucherCountUpgradeEngine
implements Callable<Tuple<Boolean, String>> {
    private static final Log logger = LogFactory.getLog(VoucherCountUpgradeEngine.class);
    private static final String Insert_VoucherCount = "insert into T_GL_VOUCHERCOUNT (fid,forgid,fbooktypeid,fperiodid,fbookeddate,fbillstatus,fischeck,fispost,fsourcetype,fmainstatus,fsuppstatus,fvouchercount,fentrycount) Values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final int Insert_Batch_Size = 999;
    private Boolean isSuccess = Boolean.TRUE;
    private long org;
    private long booktype;
    private long period;
    private boolean isDeleteOld;

    public VoucherCountUpgradeEngine(long org, long booktype, long period, boolean isDeleteOld) {
        this.org = org;
        this.booktype = booktype;
        this.period = period;
        this.isDeleteOld = isDeleteOld;
    }

    @Override
    public Tuple<Boolean, String> call() {
        this.doUpgrade();
        return new Tuple<Boolean, String>(this.isSuccess, StringUtils.join((Object[])new Long[]{this.org, this.booktype, this.period}, (String)"_"));
    }

    private void doUpgrade() {
        try (TXHandle tx = TX.requiresNew();){
            try {
                logger.info("VoucherCountUpgradeEngine data : " + StringUtils.join((Object[])new Long[]{this.org, this.booktype, this.period}, (String)"_"));
                if (this.isDeleteOld) {
                    this.deleteOldData(this.org, this.booktype, this.period);
                }
                Map<VoucherCount, Tuple<Integer, Integer>> map = VoucherCountHelper.queryVoucherForCount(this.org, this.booktype, this.period);
                ArrayList<Object[]> dataList = new ArrayList<Object[]>(8);
                List<Object> ids = new ArrayList(999);
                for (Map.Entry<VoucherCount, Tuple<Integer, Integer>> entry : map.entrySet()) {
                    VoucherCount count;
                    if (CollectionUtils.isEmpty(ids)) {
                        ids = Arrays.stream(DB.genLongIds((String)"t_gl_vouchercount", (int)999)).boxed().collect(Collectors.toList());
                    }
                    if ((count = entry.getKey()).getOrg() == null || count.getBooktype() == null || count.getPeriod() == null || count.getBookedDate() == null) continue;
                    Tuple<Integer, Integer> value = entry.getValue();
                    dataList.add(new Object[]{ids.remove(0), count.getOrg(), count.getBooktype(), count.getPeriod(), count.getBookedDate(), count.getBillSatus(), count.getIsCheck(), count.getIsPost(), count.getSourceType(), count.getMainStatus(), count.getSuppStatus(), value.item1, value.item2});
                    if (dataList.size() <= 999) continue;
                    DB.executeBatch((DBRoute)new DBRoute("fi"), (String)Insert_VoucherCount, dataList);
                    dataList.clear();
                }
                if (!CollectionUtils.isEmpty(dataList)) {
                    DB.executeBatch((DBRoute)new DBRoute("fi"), (String)Insert_VoucherCount, dataList);
                    dataList.clear();
                }
            }
            catch (Exception e) {
                this.isSuccess = Boolean.FALSE;
                logger.error("voucher_count_upgrade_failed on " + e.getMessage(), (Throwable)e);
                tx.markRollback();
            }
        }
    }

    private void deleteOldData(long org, long booktype, long period) {
        SqlBuilder builder = new SqlBuilder();
        builder.append(" delete from T_GL_VOUCHERCOUNT where ", new Object[0]);
        builder.append(" forgid = " + org, new Object[0]);
        builder.append(" and fbooktypeid = " + booktype, new Object[0]);
        builder.append(" and fperiodid = " + period, new Object[0]);
        DB.execute((DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)builder);
        builder = new SqlBuilder();
        builder.append(" delete from T_GL_VOUCHERCOUNT_LOG where ", new Object[0]);
        builder.append(" forgid = " + org, new Object[0]);
        builder.append(" and fbooktypeid = " + booktype, new Object[0]);
        builder.append(" and fperiodid = " + period, new Object[0]);
        builder.append(" and fcalculated = '0'", new Object[0]);
        DB.execute((DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)builder);
    }
}

