/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.dimquery;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.bd.model.schema.basedata.AccountSchema;
import kd.fi.bd.service.balance.VoucherQueryUtils;
import kd.fi.gl.model.schema.VoucherSchema;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.voucher.dimquery.AbstractDimVchQuery;
import kd.fi.gl.voucher.dimquery.vdf.VDFFactory;
import kd.fi.gl.voucher.dimquery.vdf.VchDimFilterService;

public abstract class SLDimVchQuery<R>
extends AbstractDimVchQuery<R> {
    protected static final VoucherSchema VOUCHER = VoucherSchema.instance;
    protected static final AccountSchema ACCOUNT = new AccountSchema();
    private static final Log LOGGER = LogFactory.getLog(SLDimVchQuery.class);
    protected static final String COUNT = "count";

    public SLDimVchQuery(VchDimFilterService.VDFContext context) {
        super(context);
    }

    @Override
    protected DataSet doBalDimSummaryQuery(List<QFilter> balDimFilters, List<String> balQueryDims) {
        String[] params = this.getParamForCountQuery(balDimFilters, balQueryDims);
        String sql = String.format("select sum(fcount) count, %s from t_gl_balance where %s group by %s order by %s", params[0], params[1], params[2], params[3]);
        LOGGER.info("balSumSql: " + sql);
        return (DataSet)DB.query((DBRoute)new DBRoute("fi"), (String)sql, rs -> Algo.create((String)"DimVchQueryHelper#doCountQuery").createDataSet(rs).copy());
    }

    String[] getParamForCountQuery(List<QFilter> filtersForBalance, List<String> balDimProps) {
        MainEntityType balanceEntityType = MetadataServiceHelper.getDataEntityType((String)"gl_balance");
        LinkedList<QFilter> emptyFilters = new LinkedList<QFilter>();
        for (QFilter filter : filtersForBalance) {
            if (filter.toString().contains("()")) {
                emptyFilters.add(filter);
                LOGGER.warn("caught empty filter " + filter);
            }
            String dbFieldName = balanceEntityType.getProperty(filter.getProperty()).getAlias();
            filter.__setProperty(dbFieldName);
        }
        if (!emptyFilters.isEmpty()) {
            filtersForBalance.removeAll(emptyFilters);
            filtersForBalance.add(QFilter.of((String)"1!=1", (Object[])new Object[0]));
        }
        String filter = filtersForBalance.stream().map(QFilter::toString).collect(Collectors.joining(" and "));
        String groupBy = balDimProps.stream().map(arg_0 -> ((MainEntityType)balanceEntityType).getProperty(arg_0)).map(DynamicProperty::getAlias).collect(Collectors.joining(", "));
        String select = balDimProps.stream().map(key -> balanceEntityType.getProperty(key).getAlias() + " " + key).collect(Collectors.joining(", "));
        String balSqlOrderBy = String.join((CharSequence)", ", balDimProps);
        return new String[]{select, filter, groupBy, balSqlOrderBy};
    }

    protected DataSet doExtVoucherQuery(String selectFields, QFilter[] extVchFilters, String orderBy, int top, Map<String, Set<Long>> balDimValues) {
        LinkedList<QFilter> vchExtFilters = new LinkedList<QFilter>();
        balDimValues.forEach((balField, ids) -> vchExtFilters.add(VDFFactory.getVDFServiceByBalDim(balField).getVchDimFilter(this.getContext(), (Set<Long>)ids)));
        vchExtFilters.addAll(Arrays.asList(extVchFilters));
        LOGGER.info("do extra voucher query: " + GLUtil.formatFilterAsString(vchExtFilters.stream()));
        return VoucherQueryUtils.queryDataSet((String)selectFields, (QFilter[])vchExtFilters.toArray(new QFilter[0]), (String)orderBy, (int)top);
    }
}

