/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.relation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.ext.fi.ai.v2.fah.dto.BillToVchRelationDto;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.business.GLServiceFactory;
import kd.fi.gl.enums.VoucherRelationTypeEnum;
import kd.fi.gl.interfaces.service.dap.IDAPService;
import kd.fi.gl.interfaces.service.voucher.rel.IVoucherRelationService;
import kd.fi.gl.voucher.relation.VchRelation;
import kd.fi.gl.voucher.relation.VchRelationId;

public class VoucherRelationHelper {
    private static final String NUMBER = "number";
    private static final String BILLNO = "billno";
    private static final String CREATOR = "creator";

    private VoucherRelationHelper() {
    }

    protected static IVoucherRelationService getService() {
        return GLServiceFactory.getService(IVoucherRelationService.class);
    }

    private static IDAPService getDAPService() {
        return GLServiceFactory.getService(IDAPService.class);
    }

    public static List<VchRelationId> getVoucherRelationIds(long vchId) {
        DynamicObject vchDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)vchId, (String)"gl_voucher", (String)String.join((CharSequence)",", "sourcetype", "isreverse", "hasreverse"));
        if (vchDyn == null) {
            return Collections.emptyList();
        }
        String srcType = vchDyn.getString("sourcetype");
        List<VchRelationId> vchRelations = null;
        switch (srcType) {
            case "4": {
                vchRelations = VoucherRelationHelper.getDapRelations(vchId);
                break;
            }
            case "6": 
            case "2": 
            case "1": 
            case "5": {
                vchRelations = VoucherRelationHelper.getEndingProcessRelation(vchId);
                break;
            }
            case "a": 
            case "b": {
                vchRelations = VoucherRelationHelper.getVoucherRefRelation(vchId);
                break;
            }
        }
        if (vchDyn.getBoolean("hasreverse") || vchDyn.getBoolean("isreverse")) {
            if (vchRelations == null || vchRelations.isEmpty()) {
                vchRelations = VoucherRelationHelper.getVoucherReverseRelation(vchId);
            } else {
                vchRelations.addAll(VoucherRelationHelper.getVoucherReverseRelation(vchId));
            }
        }
        if (vchRelations == null) {
            return Collections.emptyList();
        }
        return vchRelations;
    }

    private static List<VchRelationId> getEndingProcessRelation(long vchId) {
        QFilter qFilter = new QFilter("targentity", "=", (Object)vchId);
        Collection relationDyns = BusinessDataServiceHelper.loadFromCache((String)"gl_voucherrelation", (QFilter[])qFilter.toArray()).values();
        if (relationDyns.isEmpty()) {
            return Collections.emptyList();
        }
        DynamicObject relationDyn = (DynamicObject)relationDyns.iterator().next();
        String relationType = relationDyn.getString("type");
        VoucherRelationTypeEnum typeEnum = VoucherRelationTypeEnum.getTypeByValue(relationType);
        if (typeEnum == null) {
            return Collections.emptyList();
        }
        List<Long> srcIdList = relationDyns.stream().map(x -> x.getLong("srcentity")).collect(Collectors.toList());
        return VoucherRelationHelper.buildVchRelationIdNoVoucher(typeEnum.getEntityId(), srcIdList);
    }

    private static List<VchRelationId> getVoucherReverseRelation(long vchId) {
        long srcVchId = vchId;
        QFilter tarVchFilter = new QFilter("targentity", "=", (Object)vchId);
        DynamicObject relationDyn = BusinessDataServiceHelper.loadSingleFromCache((String)"gl_reverserelation", (QFilter[])tarVchFilter.toArray());
        if (relationDyn != null) {
            srcVchId = relationDyn.getLong("srcentity");
        }
        QFilter srcVchFilter = new QFilter("srcentity", "=", (Object)srcVchId);
        DynamicObjectCollection relationDynColl = QueryServiceHelper.query((String)"gl_reverserelation", (String)"targentity", (QFilter[])srcVchFilter.toArray());
        List<Long> relationVchIdList = relationDynColl.stream().map(x -> x.getLong("targentity")).collect(Collectors.toList());
        relationVchIdList.add(srcVchId);
        relationVchIdList.remove(vchId);
        return VoucherRelationHelper.buildVchRelationIdNoVoucher("gl_voucher", relationVchIdList);
    }

    public static List<VchRelationId> getVoucherRefRelation(long vchId) {
        QFilter qFilter = new QFilter("destvoucherid", "=", (Object)vchId);
        DynamicObjectCollection relationDynColl = QueryServiceHelper.query((String)"gl_voucher_relation", (String)"srcvoucherid", (QFilter[])qFilter.toArray());
        if (relationDynColl.isEmpty()) {
            return Collections.emptyList();
        }
        DynamicObject relationDyn = (DynamicObject)relationDynColl.iterator().next();
        if (relationDyn == null) {
            return Collections.emptyList();
        }
        long srcVoucherId = relationDyn.getLong("srcvoucherid");
        List<VchRelationId> vchRelations = VoucherRelationHelper.buildVchRelationIdNoVoucher("gl_voucher", Collections.singletonList(srcVoucherId));
        vchRelations.addAll(VoucherRelationHelper.getDapRelations(srcVoucherId));
        vchRelations.forEach(x -> x.setDirectRelationBill(false));
        return vchRelations;
    }

    private static List<VchRelationId> buildVchRelationIdNoVoucher(String entityId, Collection<Long> billIds) {
        return billIds.stream().map(x -> VoucherRelationHelper.buildVchRelationId(entityId, x, false)).collect(Collectors.toList());
    }

    private static List<VchRelationId> buildVchRelationIdList(String entityId, Collection<Long> billIds, Map<Long, Set<Long>> billIdVchIdMap, boolean directRelationBill) {
        return billIds.stream().map(x -> {
            VchRelationId vchRelationId = VoucherRelationHelper.buildVchRelationId(entityId, x, directRelationBill);
            if (billIdVchIdMap != null) {
                vchRelationId.setVchIdSet((Set)billIdVchIdMap.get(x));
            }
            return vchRelationId;
        }).collect(Collectors.toList());
    }

    private static VchRelationId buildVchRelationId(String entityId, long billId, boolean directRelationBill) {
        VchRelationId vchRelationId = new VchRelationId();
        vchRelationId.setEntityId(entityId);
        vchRelationId.setBillId(billId);
        vchRelationId.setDirectRelationBill(directRelationBill);
        return vchRelationId;
    }

    private static List<VchRelationId> getDapRelations(long vchId) {
        Map<String, Set<Long>> directRelationBillMap = VoucherRelationHelper.getService().findDAPRelatedBills(vchId);
        if (directRelationBillMap.isEmpty()) {
            return Collections.emptyList();
        }
        Set<String> directRelationBillTypeSet = directRelationBillMap.keySet();
        Map<String, Set<Long>> sourceRelationBillMap = VoucherRelationHelper.getDirectBillSourceRelationBill(directRelationBillMap);
        Map<String, Set<Long>> targetRelationBillMap = VoucherRelationHelper.getDirectBillTargetRelationBill(directRelationBillMap);
        Set directRelationBillIds = directRelationBillMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        Set<Long> sourceRelationBillIdSet = sourceRelationBillMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        Set targetRelationBillIdSet = targetRelationBillMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        sourceRelationBillIdSet.addAll(targetRelationBillIdSet);
        sourceRelationBillIdSet.removeAll(directRelationBillIds);
        Map<String, Map<Long, Set<Long>>> billRelationVoucherMap = VoucherRelationHelper.getBillRelationVoucher(sourceRelationBillMap.size() + targetRelationBillMap.size(), sourceRelationBillIdSet);
        VoucherRelationHelper.mergeMap(targetRelationBillMap, directRelationBillMap);
        VoucherRelationHelper.mergeMap(targetRelationBillMap, sourceRelationBillMap);
        int billCount = directRelationBillIds.size() + sourceRelationBillIdSet.size();
        ArrayList<VchRelationId> vchRelationIds = new ArrayList<VchRelationId>(billCount);
        for (Map.Entry<String, Set<Long>> entry : targetRelationBillMap.entrySet()) {
            String entityId = entry.getKey();
            boolean directRelationBill = directRelationBillTypeSet.contains(entityId);
            vchRelationIds.addAll(VoucherRelationHelper.buildVchRelationIdList(entityId, (Collection<Long>)entry.getValue(), billRelationVoucherMap.get(entityId), directRelationBill));
        }
        return vchRelationIds;
    }

    public static Map<String, HashSet<Long>> getDirectRelationBill(long vchId) {
        HashSet<Long> vchIds = new HashSet<Long>(1);
        vchIds.add(vchId);
        BillToVchRelationDto voucherRelations = VoucherRelationHelper.getDAPService().getBillToVchRelationDtoByVchIDSet(vchIds);
        LinkedHashMap<String, HashSet<Long>> billTypeToBillIdsMap = new LinkedHashMap<String, HashSet<Long>>(8);
        voucherRelations.forEach(x -> {
            String billType = x.getBillType();
            billTypeToBillIdsMap.computeIfAbsent(billType, k -> new HashSet(8)).add(x.getBillId());
        });
        return billTypeToBillIdsMap;
    }

    private static Map<String, Set<Long>> getDirectBillSourceRelationBill(Map<String, Set<Long>> directSrcRelationBillMap) {
        return VoucherRelationHelper.getService().findBOTPSourceBills(directSrcRelationBillMap);
    }

    private static Map<String, Set<Long>> getDirectBillTargetRelationBill(Map<String, Set<Long>> directSrcRelationBillMap) {
        Map<String, Set<Long>> relationBillMap = VoucherRelationHelper.getService().findBOTPTargetBills(directSrcRelationBillMap);
        ArrayList<Map.Entry<String, Set<Long>>> entryList = new ArrayList<Map.Entry<String, Set<Long>>>(relationBillMap.entrySet());
        ListIterator iterator = entryList.listIterator(relationBillMap.size());
        relationBillMap.clear();
        while (iterator.hasPrevious()) {
            Map.Entry previous = (Map.Entry)iterator.previous();
            relationBillMap.put((String)previous.getKey(), (Set<Long>)previous.getValue());
        }
        return relationBillMap;
    }

    private static Map<String, Map<Long, Set<Long>>> getBillRelationVoucher(int typeSize, Set<Long> relationBillIdSet) {
        return VoucherRelationHelper.getService().findDAPRelatedVouchers(relationBillIdSet);
    }

    private static void mergeMap(Map<String, Set<Long>> resultMap, Map<String, Set<Long>> map) {
        for (Map.Entry<String, Set<Long>> entry : map.entrySet()) {
            resultMap.compute(entry.getKey(), (k, v) -> {
                if (v == null) {
                    v = new HashSet((Collection)entry.getValue());
                } else {
                    v.addAll((Collection)entry.getValue());
                }
                return v;
            });
        }
    }

    public static List<VchRelation> fillRelationBillInfo(List<VchRelationId> vchRelationIdList, String entityId) {
        Predicate<Long> idExists = x -> x != null && x != 0L;
        Set<Long> billIdSet = vchRelationIdList.stream().map(VchRelationId::getBillId).filter(idExists).collect(Collectors.toSet());
        Set<Long> allVchIdSet = vchRelationIdList.stream().filter(x -> x.getVchIdSet() != null).flatMap(x -> x.getVchIdSet().stream()).filter(idExists).collect(Collectors.toSet());
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
        String billNoField = VoucherRelationHelper.getBillNoField(dataEntityType);
        String creatorField = VoucherRelationHelper.getCreatorField(dataEntityType);
        Map<Object, DynamicObject> billDynMap = VoucherRelationHelper.batchLoadBillDyn(entityId, billIdSet, billNoField, creatorField);
        Map<Object, DynamicObject> vchDynMap = VoucherRelationHelper.batchLoadBillDyn("gl_voucher", allVchIdSet, BILLNO, null);
        return vchRelationIdList.stream().map(x -> {
            VchRelation vchRelation = new VchRelation();
            vchRelation.setEntityId(x.getEntityId());
            vchRelation.setBillId(x.getBillId());
            vchRelation.setDirectRelationBill(x.getDirectRelationBill());
            Set<Long> vchIdSet = x.getVchIdSet();
            vchRelation.setVchIdSet(vchIdSet);
            DynamicObject billDyn = (DynamicObject)billDynMap.get(x.getBillId());
            if (billDyn != null) {
                if (StringUtils.isNotBlank((CharSequence)billNoField)) {
                    vchRelation.setBillNo(billDyn.getString(billNoField));
                }
                if (StringUtils.isNotBlank((CharSequence)creatorField)) {
                    vchRelation.setCreatorId(billDyn.getLong(creatorField + ".id"));
                }
            }
            if (vchIdSet != null && !vchIdSet.isEmpty()) {
                String vchNo = vchIdSet.stream().map(vchDynMap::get).filter(Objects::nonNull).map(y -> y.getString(BILLNO)).collect(Collectors.joining("\u3001"));
                vchRelation.setVchBillNo(vchNo);
            }
            return vchRelation;
        }).collect(Collectors.toList());
    }

    private static String getBillNoField(MainEntityType dataEntityType) {
        String numberField = null;
        if (dataEntityType instanceof BillEntityType) {
            numberField = ((BillEntityType)dataEntityType).getBillNo();
        }
        if (StringUtils.isBlank(numberField)) {
            if (dataEntityType.getAllFields().containsKey(BILLNO)) {
                numberField = BILLNO;
            } else if (dataEntityType.getAllFields().containsKey(NUMBER)) {
                numberField = NUMBER;
            }
        }
        return numberField;
    }

    private static String getCreatorField(MainEntityType dataEntityType) {
        return dataEntityType.getAllFields().containsKey(CREATOR) ? CREATOR : null;
    }

    private static Map<Object, DynamicObject> batchLoadBillDyn(String entityId, Collection<Long> pkValues, String numField, String creatorField) {
        if (pkValues.isEmpty()) {
            return Collections.emptyMap();
        }
        HashSet<String> fieldSet = new HashSet<String>(3);
        fieldSet.add("id");
        if (StringUtils.isNotBlank((CharSequence)numField)) {
            fieldSet.add(numField);
        }
        if (StringUtils.isNotBlank((CharSequence)creatorField)) {
            fieldSet.add(creatorField);
        }
        QFilter qFilter = new QFilter("id", "in", pkValues);
        return BusinessDataServiceHelper.loadFromCache((String)entityId, (String)String.join((CharSequence)",", fieldSet.toArray(new String[0])), (QFilter[])qFilter.toArray());
    }
}

