/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.util;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.PkSnapshotSet;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.xdb.hint.HintCondition;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.fi.bd.util.BDUtil;
import kd.fi.gl.accountref.utils.BalanceTransferUtils;
import kd.fi.gl.cache.ThreadCacheKey;
import kd.fi.gl.enums.AccountBalanceLogOperationEnum;
import kd.fi.gl.reciprocal.ReciprocalUtils;
import kd.fi.gl.util.ContextUtil;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.voucher.VoucherHintBuilder;

public class VoucherUtils {
    private static final String ID = "id";
    private static final String ACCCURRENTFIELD = "voucherentry, status";
    private static final String VOUCHERENTRY = "voucherentry";
    private static final String VOUCHERID = "voucherid";
    private static final String ACCTKEY = "acct-localcache-key";
    private static final String CFITEMKEY = "cfitem-localcache-key";
    public static final String DELIDS = "delId";
    public static final String UNMODIFYIDS = "unmodifyids";
    public static final String SUBMIT_RECIRSET = "submit_reciprocalrecord";

    public static DynamicObject getCFitem(long orgId, long cfItemId) {
        if (cfItemId == 0L) {
            return null;
        }
        HashMap<Long, Map<Long, DynamicObject>> map = (HashMap<Long, Map<Long, DynamicObject>>)ThreadCache.get((Object)CFITEMKEY);
        DynamicObject cfitem = null;
        if (map == null) {
            map = new HashMap<Long, Map<Long, DynamicObject>>();
            Map<Long, DynamicObject> cfmap = VoucherUtils.getCFMap(orgId);
            cfitem = cfmap.get(cfItemId);
            map.put(orgId, cfmap);
            ThreadCache.put((Object)CFITEMKEY, map);
        } else if (map.get(orgId) == null) {
            Map<Long, DynamicObject> cfmap = VoucherUtils.getCFMap(orgId);
            map.put(orgId, cfmap);
            cfitem = cfmap.get(cfItemId);
        } else {
            cfitem = (DynamicObject)((Map)map.get(orgId)).get(cfItemId);
        }
        return cfitem;
    }

    private static Map<Long, DynamicObject> getCFMap(long orgId) {
        QFilter filter = BaseDataServiceHelper.getBaseDataFilter((String)"gl_cashflowitem", (Long)orgId);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObject[] cfs = BusinessDataServiceHelper.load((String)"gl_cashflowitem", (String)"id,enable,isleaf,notice,direction,isdealactivity,isassist,assistentry.asstypeid,assistentry.isrequire,direction,isprefit,type", (QFilter[])filters);
        HashMap<Long, DynamicObject> result = new HashMap<Long, DynamicObject>(cfs.length);
        for (DynamicObject dyn : cfs) {
            result.put(dyn.getLong(ID), dyn);
        }
        return result;
    }

    public static DynamicObject getAcct(long acctId) {
        HashMap<Long, DynamicObject> acctCache = (HashMap<Long, DynamicObject>)ThreadCache.get((Object)ACCTKEY);
        if (acctCache == null) {
            DynamicObject acct = BusinessDataServiceHelper.loadSingleFromCache((Object)acctId, (String)"bd_accountview", (String)"checkitementry.asstactitem,checkitementry.isrequire,currencyentry.currency");
            acctCache = new HashMap<Long, DynamicObject>();
            acctCache.put(acctId, acct);
            ThreadCache.put((Object)ACCTKEY, acctCache);
            return acct;
        }
        if (acctCache.containsKey(acctId)) {
            return (DynamicObject)acctCache.get(acctId);
        }
        DynamicObject acct = BusinessDataServiceHelper.loadSingleFromCache((Object)acctId, (String)"bd_accountview", (String)"checkitementry.asstactitem,checkitementry.isrequire,currencyentry.currency");
        acctCache.put(acctId, acct);
        return acct;
    }

    @Deprecated
    public static void addReverseRelation(DynamicObject voucher) {
        if (!QueryServiceHelper.exists((String)"gl_reverserelation", (QFilter[])new QFilter("targentity", "=", voucher.get(ID)).toArray())) {
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"gl_reverserelation");
            DynamicObject re = new DynamicObject((DynamicObjectType)dt);
            re.set("srcentity", (Object)voucher.getLong("sourcebill"));
            re.set("targentity", voucher.get(ID));
            re.set("iseffective", (Object)true);
            SaveServiceHelper.save((IDataEntityType)dt, (Object[])new DynamicObject[]{re});
        }
    }

    @Deprecated
    public static void deleteReverseRelation(DynamicObject voucher) {
        QFilter f1 = new QFilter("targentity", "=", voucher.get(ID));
        QFilter f2 = new QFilter("srcentity", "=", (Object)voucher.getLong("sourcebill"));
        DeleteServiceHelper.delete((String)"gl_reverserelation", (QFilter[])new QFilter[]{f1, f2});
    }

    @Deprecated
    public static void dealReverseRelation(DynamicObject voucher, boolean isCancel) {
        QFilter f3;
        QFilter f2;
        QFilter f1 = new QFilter("targentity", "=", voucher.get(ID));
        DynamicObject[] rs = BusinessDataServiceHelper.load((String)"gl_reverserelation", (String)"id,iseffective", (QFilter[])new QFilter[]{f1, f2 = new QFilter("srcentity", "=", (Object)voucher.getLong("sourcebill")), f3 = new QFilter("iseffective", "=", (Object)(isCancel ? "1" : "0"))}, null);
        if (rs.length > 0) {
            DynamicObject o = rs[0];
            o.set("iseffective", (Object)(isCancel ? "0" : "1"));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{o});
        }
    }

    public static boolean isBlankLine(DynamicObject entry) {
        Object acct = entry.get("account");
        if (acct == null) {
            BigDecimal creditLoc = entry.getBigDecimal("creditlocal");
            BigDecimal debitLoc = entry.getBigDecimal("debitlocal");
            BigDecimal quantity = entry.getBigDecimal("quantity");
            if (creditLoc.signum() == 0 && debitLoc.signum() == 0 && quantity.signum() == 0) {
                return true;
            }
        }
        return false;
    }

    @Deprecated
    public static void updateReverseRelation(Object id, boolean hasreverse) {
        DB.execute((DBRoute)DBRoute.of((String)"gl"), (String)"update t_gl_voucher set fhasreverse = ? where fid = ?", (Object[])new Object[]{hasreverse ? "1" : "0", id});
    }

    public static void dealVoucherRelation(Long id, Long period, boolean isCancel) {
        Object[] ds;
        QFilter f1 = new QFilter("targentity", "=", (Object)id);
        QFilter f2 = new QFilter("period", "=", (Object)period);
        QFilter f3 = new QFilter("iseffective", "=", (Object)Character.valueOf(isCancel ? (char)'1' : '0'));
        for (DynamicObject dynamicObject : ds = BusinessDataServiceHelper.load((String)"gl_voucherrelation", (String)"id,iseffective", (QFilter[])new QFilter[]{f1, f2, f3})) {
            dynamicObject.set("iseffective", (Object)(isCancel ? 0 : 1));
        }
        if (ds.length > 0) {
            SaveServiceHelper.save((IDataEntityType)ds[0].getDynamicObjectType(), (Object[])ds);
        }
    }

    public static boolean isEarlierCurPeriod(DynamicObject v) {
        DynamicObject book = v.getDynamicObject("book");
        DynamicObject currPeriod = BusinessDataServiceHelper.loadSingleFromCache((Object)book.getPkValue(), (String)"gl_accountbook", (String)"curperiod").getDynamicObject("curperiod");
        DynamicObject period = v.getDynamicObject("period");
        long currPeriodId = currPeriod.getLong(ID);
        long periodId = period.getLong(ID);
        return periodId < currPeriodId;
    }

    public static ICodeRuleService getCodeRuleService() {
        ICodeRuleService codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        return codeRuleService;
    }

    public static Set<String> getExistNumbers(List<String> nums, Set<Long> ids, String key) {
        String[] keys = key.split("-");
        QFilter orgF = new QFilter("org", "=", (Object)Long.valueOf(keys[0]));
        QFilter booktypeF = new QFilter("booktype", "=", (Object)Long.valueOf(keys[1]));
        QFilter vtF = new QFilter("vouchertype.masterid", "=", (Object)Long.valueOf(keys[2]));
        QFilter periodF = new QFilter("period", "=", (Object)Long.valueOf(keys[3]));
        ArrayList<String> list = new ArrayList<String>();
        list.add("B");
        list.add("C");
        QFilter stateF = new QFilter("billstatus", "in", list);
        if (null != nums) {
            stateF = stateF.and(new QFilter("billno", "in", nums));
        }
        DataSet sameNumberDS = QueryServiceHelper.queryDataSet((String)VoucherUtils.class.getName(), (String)"gl_voucher", (String)"id,billno", (QFilter[])new QFilter[]{orgF, booktypeF, periodF, stateF, vtF}, null);
        HashSet<String> duplicateIdNumbers = new HashSet<String>(8);
        while (sameNumberDS.hasNext()) {
            Row row = sameNumberDS.next();
            if (!CollectionUtils.isEmpty(ids) && ids.contains(row.getLong(ID))) continue;
            duplicateIdNumbers.add(row.getString("billno"));
        }
        return duplicateIdNumbers;
    }

    public static Map<Long, String> getStatusFromDB(ExtendedDataEntity[] dataEntities) {
        HashMap<Long, String> statusMap = new HashMap<Long, String>(dataEntities.length);
        Map<Long, Map<String, Object>> result = VoucherUtils.getVchInfoFromDB(dataEntities);
        result.entrySet().forEach(x -> statusMap.put((Long)x.getKey(), (String)((Map)x.getValue()).get("billstatus")));
        return statusMap;
    }

    public static Map<Long, Map<String, Object>> getVchInfoFromDB(ExtendedDataEntity[] dataEntities) {
        Map<Long, DynamicObject> voucherId2Dyn = Arrays.stream(dataEntities).map(ExtendedDataEntity::getDataEntity).filter(dyn -> dyn.getDataEntityState().getFromDatabase()).collect(Collectors.toMap(voucherDyn -> voucherDyn.getLong(ID), voucherDyn -> voucherDyn, (original, conflict) -> original));
        HashMap<Long, Map<String, Object>> statusMap = new HashMap<Long, Map<String, Object>>(dataEntities.length);
        if (!voucherId2Dyn.isEmpty()) {
            QFilter fid = new QFilter(ID, "in", voucherId2Dyn.keySet());
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"VoucherUtils.getStatusFromDB", (String)"gl_voucher", (String)String.join((CharSequence)",", ID, "billstatus", "ischeck", "ispost", "period"), (QFilter[])new QFilter[]{fid}, null);){
                for (Row row : ds) {
                    Long vchId = row.getLong(ID);
                    Map map = statusMap.computeIfAbsent(vchId, k -> new HashMap());
                    map.put("billstatus", row.getString("billstatus"));
                    map.put("period", row.getString("period"));
                    DynamicObject vchDyn = voucherId2Dyn.get(vchId);
                    if (vchDyn.containsProperty("ischeck")) {
                        vchDyn.set("ischeck", (Object)row.getString("ischeck"));
                    }
                    if (!vchDyn.containsProperty("ispost")) continue;
                    vchDyn.set("ispost", (Object)row.getBoolean("ispost"));
                }
            }
        }
        return statusMap;
    }

    public static boolean isDateEqual(Date date1, Date date2) {
        if (null == date1 && null == date2) {
            return true;
        }
        if (null == date1) {
            return false;
        }
        if (null == date2) {
            return false;
        }
        return date1.compareTo(date2) == 0;
    }

    public static Map<Long, String> getReciRecord(List<Long> voucherId) {
        HashMap<Long, String> reciMap = new HashMap<Long, String>(16);
        QFilter fvchId = new QFilter(VOUCHERID, "in", voucherId);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"VoucherUtils.getReciRecord", (String)"gl_acccurrent", (String)ACCCURRENTFIELD, (QFilter[])new QFilter[]{fvchId}, null);){
            for (Row row : ds) {
                reciMap.put(row.getLong(VOUCHERENTRY), row.getString("status"));
            }
        }
        return reciMap;
    }

    public static void deleteReciprocalRecord(DynamicObject[] vchDys) {
        ArrayList<Long> list = new ArrayList<Long>();
        for (DynamicObject vch : vchDys) {
            if (vch.getString("billstatus").equals("A")) continue;
            list.add(vch.getLong(ID));
        }
        HashSet<Long> currentAccount = new HashSet<Long>(list.size());
        QFilter filter = new QFilter(VOUCHERID, "in", list);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)VoucherUtils.class.getName(), (String)"gl_acccurrent", (String)"account.masterid", (QFilter[])filter.toArray(), null).distinct();){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                currentAccount.add(row.getLong("account.masterid"));
            }
        }
        if (currentAccount.size() > 0) {
            ThreadCache.put((Object)ThreadCacheKey.buildAccAccountKey(), currentAccount);
        }
        if (!list.isEmpty()) {
            QFilter fentryId = new QFilter(VOUCHERID, "in", list);
            DeleteServiceHelper.delete((String)"gl_acccurrent", (QFilter[])new QFilter[]{fentryId});
        }
    }

    public static Set<Long> isReciprocal(List<Long> ids) {
        HashSet<Long> idset = new HashSet<Long>();
        if (!ids.isEmpty()) {
            QFilter fentryId = new QFilter(VOUCHERID, "in", ids);
            QFilter fstatus = new QFilter("status", "!=", (Object)"0");
            QFilter endDateF = new QFilter("uneffectivedate", "=", (Object)BalanceTransferUtils.getEndDate());
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryReciprocal", (String)"gl_acccurrent", (String)VOUCHERID, (QFilter[])new QFilter[]{fentryId, fstatus, endDateF}, null);){
                for (Row row : ds) {
                    idset.add(row.getLong(VOUCHERID));
                }
            }
        }
        return idset;
    }

    public static void doWriteOffByBizNum(Set<Long> writeOffVchIds) {
        Tuple<Map<Long, Long>, Set<Long>> entryOppRelations = VoucherUtils.getEntryAndOppRecordMap(writeOffVchIds);
        Map vchEntryAndBizNumRecordMap = (Map)entryOppRelations.item1;
        Set oppRecordIds = (Set)entryOppRelations.item2;
        if (vchEntryAndBizNumRecordMap.isEmpty()) {
            return;
        }
        Map<Long, Long> recordAndOppRecordMap = VoucherUtils.getRecordAndOppRecordMap(vchEntryAndBizNumRecordMap, writeOffVchIds);
        Set<Long> oppWriteOffVchIds = VoucherUtils.getOppRecordVchIds(oppRecordIds);
        if (oppWriteOffVchIds.isEmpty()) {
            return;
        }
        HashSet<Long> vchIds = new HashSet<Long>(8);
        vchIds.addAll(writeOffVchIds);
        vchIds.addAll(oppWriteOffVchIds);
        ReciprocalUtils.doWriteOff(new ArrayList<Long>(vchIds), recordAndOppRecordMap);
    }

    private static Set<Long> getOppRecordVchIds(Set<Long> oppRecordIds) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter(ID, "in", oppRecordIds));
        filters.add(new QFilter("status", "!=", (Object)"2"));
        HashSet<Long> oppWriteOffVchIds = new HashSet<Long>();
        try (DataSet dSet = QueryServiceHelper.queryDataSet((String)"VoucherUtils.doWriteOffByBizNum", (String)"gl_acccurrent", (String)VOUCHERID, (QFilter[])filters.toArray(new QFilter[0]), null);){
            for (Row row : dSet) {
                oppWriteOffVchIds.add(row.getLong(VOUCHERID));
            }
        }
        return oppWriteOffVchIds;
    }

    private static Map<Long, Long> getRecordAndOppRecordMap(Map<Long, Long> vchEntryAndBizNumRecordMap, Set<Long> writeOffVchIds) {
        HashMap<Long, Long> recordAndOppRecordMap = new HashMap<Long, Long>();
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter(VOUCHERID, "in", writeOffVchIds));
        filters.add(new QFilter(VOUCHERENTRY, "in", vchEntryAndBizNumRecordMap.keySet()));
        filters.add(new QFilter("status", "!=", (Object)"2"));
        try (DataSet dSet = QueryServiceHelper.queryDataSet((String)"VoucherUtils.doWriteOffByBizNum", (String)"gl_acccurrent", (String)"id, voucherentry", (QFilter[])filters.toArray(new QFilter[0]), null);){
            for (Row row : dSet) {
                Long recordId = row.getLong(ID);
                Long vchEntryId = row.getLong(VOUCHERENTRY);
                Long oppRecordId = vchEntryAndBizNumRecordMap.get(vchEntryId);
                if (oppRecordId == null) continue;
                recordAndOppRecordMap.put(recordId, oppRecordId);
            }
        }
        return recordAndOppRecordMap;
    }

    private static Tuple<Map<Long, Long>, Set<Long>> getEntryAndOppRecordMap(Set<Long> writeOffVchIds) {
        HashMap<Long, Long> vchEntryAndBizNumRecordMap = new HashMap<Long, Long>(8);
        HashSet<Long> oppRecordIds = new HashSet<Long>(8);
        if (writeOffVchIds.size() != 0) {
            try (ShardingHintContext ignored = ShardingHintContext.createAndSet((String)"t_gl_voucher", (HintCondition[])new HintCondition[]{new HintCondition("fid", FilterType.in_range, writeOffVchIds)}).prepareShardingIndex();){
                SqlBuilder sqlBuilder = new SqlBuilder();
                sqlBuilder.append("select fentryid,fbiznumrecordid from t_gl_voucherentry where", new Object[0]);
                sqlBuilder.appendIn("fid", writeOffVchIds.toArray());
                sqlBuilder.append("and fbiznumrecordid <> 0", new Object[0]);
                try (DataSet ds = DB.queryDataSet((String)"VoucherUtils.getEntryAndOppRecordMap", (DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)sqlBuilder);){
                    for (Row row : ds) {
                        long bizNumRecordId = row.getLong(1);
                        vchEntryAndBizNumRecordMap.put(row.getLong(0), bizNumRecordId);
                        oppRecordIds.add(bizNumRecordId);
                    }
                }
            }
        }
        return Tuple.create(vchEntryAndBizNumRecordMap, oppRecordIds);
    }

    public static void updateVerifyLog(DynamicObject[] entities) {
        String sourceBillType;
        HashMap<String, List> offsetMap = new HashMap<String, List>();
        for (DynamicObject vch : entities) {
            if (!"9".equals(vch.getString("sourcetype"))) continue;
            Long sourceBillId = vch.getLong("sourcebill");
            sourceBillType = vch.getString("sourcebilltype_id");
            List srcBillList = offsetMap.computeIfAbsent(sourceBillType, v -> new ArrayList());
            srcBillList.add(sourceBillId);
        }
        long userId = ContextUtil.getUserId();
        Date now = new Date();
        for (Map.Entry offsetEntry : offsetMap.entrySet()) {
            sourceBillType = (String)offsetEntry.getKey();
            List srcList = (List)offsetEntry.getValue();
            QFilter idFilter = new QFilter(ID, "in", (Object)srcList);
            Map srcBillMap = BusinessDataServiceHelper.loadFromCache((String)sourceBillType, (String)"id,offsetvoucherid,modifier,modifytime", (QFilter[])idFilter.toArray());
            for (Map.Entry srcBillEntry : srcBillMap.entrySet()) {
                DynamicObject srcBill = (DynamicObject)srcBillEntry.getValue();
                srcBill.set("offsetvoucherid", (Object)0L);
                srcBill.set("modifier", (Object)userId);
                srcBill.set("modifytime", (Object)now);
            }
            SaveServiceHelper.save((DynamicObject[])srcBillMap.values().toArray(new DynamicObject[0]));
        }
    }

    public static Date getEndDate() {
        try {
            SimpleDateFormat dt = new SimpleDateFormat("yyyy-MM-dd");
            return dt.parse("2999-12-31");
        }
        catch (ParseException e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e5\u671f\u89e3\u6790\u5f02\u5e38\u3002", (String)"VoucherUtils_0", (String)"fi-gl-common", (Object[])new Object[0]));
        }
    }

    public static void fillUser(DynamicObject voucherDyn, OperateOption option) {
        if (voucherDyn.get("creator") == null) {
            voucherDyn.set("creator", (Object)VoucherUtils.loadCurUser(voucherDyn));
        }
        if ("a".equals(voucherDyn.getString("sourcetype"))) {
            return;
        }
        if (!voucherDyn.getDataEntityState().getFromDatabase() && "8".equals(voucherDyn.getString("sourcetype")) || option.containsVariable("isdap")) {
            voucherDyn.set("submitter", (Object)voucherDyn.getDynamicObject("creator"));
        } else {
            voucherDyn.set("submitter", (Object)VoucherUtils.loadCurUser(voucherDyn));
        }
    }

    private static DynamicObject loadCurUser(DynamicObject voucherDyn) {
        return (DynamicObject)ThreadCache.get((Object)"curUserDyn", () -> {
            DynamicObjectType userDT = GLUtil.getDTByPropName(voucherDyn, "creator");
            return BusinessDataServiceHelper.loadSingleFromCache((Object)ContextUtil.getUserId(), (DynamicObjectType)userDT);
        });
    }

    public static String getEntryDc(DynamicObject voucherEntryRow) {
        boolean creditNonZero;
        boolean debitNonZero;
        boolean bl = debitNonZero = voucherEntryRow.getBigDecimal("debitori").signum() != 0 || voucherEntryRow.getBigDecimal("debitlocal").signum() != 0;
        if (debitNonZero) {
            return "1";
        }
        boolean bl2 = creditNonZero = voucherEntryRow.getBigDecimal("creditori").signum() != 0 || voucherEntryRow.getBigDecimal("creditlocal").signum() != 0;
        if (creditNonZero) {
            return "-1";
        }
        String originalDC = voucherEntryRow.getString("entrydc");
        if (StringUtils.isBlank((CharSequence)originalDC)) {
            return "-1";
        }
        return originalDC;
    }

    public static Set<Long> hasSubmittedVchId(List<Long> ids) {
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"VoucherUtils.hasSubmittedVchId", (String)"gl_balance_log", (String)"voucherid,operation", (QFilter[])new QFilter[]{new QFilter(VOUCHERID, "in", ids)}, null);
        HashSet<Long> result = new HashSet<Long>(10);
        HashSet<Long> deleteVoucherIds = new HashSet<Long>(10);
        for (Row row : dataSet) {
            Long voucherId = row.getLong(0);
            result.add(voucherId);
            if (!AccountBalanceLogOperationEnum.isDelete(row.getString(1))) continue;
            deleteVoucherIds.add(voucherId);
        }
        result.removeAll(deleteVoucherIds);
        return result;
    }

    public static Set<Long> getAccountIdSetByVoucherIds(Collection<Long> voucherIds) {
        if (CollectionUtils.isEmpty(voucherIds)) {
            return Collections.emptySet();
        }
        HashSet<Long> result = new HashSet<Long>(32);
        SqlBuilder sqlBuilder = new SqlBuilder().append("select distinct faccountid from t_gl_voucherentry where ", new Object[0]).appendIn("fid", voucherIds.toArray());
        try (ShardingHintContext pkHint = VoucherHintBuilder.buildPKHint(BDUtil.extractToSet(voucherIds, Long.class::cast));
             DataSet dataSet = DB.queryDataSet((String)"getAllAccIds", (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sqlBuilder);){
            for (Row row : dataSet) {
                result.add(row.getLong("faccountid"));
            }
        }
        return result;
    }

    public static Map<Long, List<DynamicObject>> groupVoucherDynsByOrg(DynamicObject[] voucherDyns) {
        if (ArrayUtils.isEmpty((Object[])voucherDyns)) {
            return Collections.emptyMap();
        }
        DynamicProperty orgIdProp = voucherDyns[0].getDynamicObjectType().getProperty("org_id");
        return Arrays.stream(voucherDyns).collect(Collectors.groupingBy(v -> (Long)orgIdProp.getValueFast(v)));
    }

    public static Map<Long, Map<String, Object>> getVoucherStatus(DynamicObject[] vchs) {
        return (Map)ThreadCache.get((Object)"voucherStatus", () -> {
            DynamicObjectCollection collection = QueryServiceHelper.query((String)"gl_voucher", (String)"id,billstatus,period", (QFilter[])new QFilter[]{new QFilter(ID, "in", Arrays.asList(vchs).stream().map(e -> e.getPkValue()).collect(Collectors.toList()))});
            HashMap info = new HashMap();
            collection.forEach(x -> {
                Map map = info.computeIfAbsent(x.getLong(ID), v -> new HashMap());
                map.put("billstatus", x.getString("billstatus"));
                map.put("period", x.getString("period"));
            });
            return info;
        });
    }

    public static Set<Object> getEntryOidSet(DynamicObject vchDyn, DynamicObjectType vchDynType) {
        PkSnapshotSet vchSnapshot = vchDynType.getPkSnapshot((Object)vchDyn);
        if (vchSnapshot == null || vchSnapshot.Snapshots == null) {
            return Collections.emptySet();
        }
        return vchSnapshot.Snapshots.stream().filter(pkSnapshot -> pkSnapshot.TableName.equalsIgnoreCase("t_gl_voucherentry") && pkSnapshot.Oids != null).flatMap(pkSnapshot -> Arrays.stream(pkSnapshot.Oids)).collect(Collectors.toSet());
    }

    public static void clearCashFlowRow(DynamicObject entryRow) {
        entryRow.set("maincfitem", null);
        entryRow.set("maincfamount", (Object)BigDecimal.ZERO);
        entryRow.set("maincfassgrp", null);
        entryRow.set("suppcfitem", null);
        entryRow.set("suppcfamount", (Object)BigDecimal.ZERO);
    }
}

