/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.wrap;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;

public class DynPropertyWrapper {
    private DynamicObject dynamicObject;
    private Map<String, Integer> propertyNameToIndexMap;
    private Map<String, Object> propertyNameToValueMap;

    public DynPropertyWrapper(DynamicObject accountDyn) {
        this.dynamicObject = accountDyn;
        this.propertyNameToIndexMap = new HashMap<String, Integer>(8);
        this.dynamicObject.getDynamicObjectType().getProperties().forEach(property -> this.propertyNameToIndexMap.put(property.getName(), property.getOrdinal()));
        this.propertyNameToValueMap = new HashMap<String, Object>(8);
    }

    public DynamicObject getDynamicObject() {
        return this.dynamicObject;
    }

    public int getPropertyIndex(String propertyName) {
        return this.propertyNameToIndexMap.getOrDefault(propertyName, -1);
    }

    public Object getValueByPropertyName(String propertyName) {
        if (this.propertyNameToValueMap.containsKey(propertyName)) {
            return this.propertyNameToValueMap.get(propertyName);
        }
        int propertyIndex = this.getPropertyIndex(propertyName);
        if (propertyIndex != -1) {
            Object value = this.dynamicObject.get(propertyIndex);
            this.propertyNameToValueMap.put(propertyName, value);
            return value;
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u52a8\u6001\u5bf9\u8c61\u4e0d\u5b58\u5728%s\u5c5e\u6027\u3002", (String)"AccountProperty_0", (String)"fi-gl-common", (Object[])new Object[0]), propertyName));
    }
}

