/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.dataset.AbstractRow;
import kd.bos.algo.util.Tuple2;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.model.Context;
import kd.fi.bd.service.balance.BalanceQueryExecutor;
import kd.fi.bd.service.balance.QueryParam;
import kd.fi.bd.util.BillParamUtil;
import kd.fi.bd.util.PerformanceWatch;
import kd.fi.bd.util.PeriodUtil;
import kd.fi.bd.util.TimerFactory;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.model.schema.VoucherTypeSchema;
import kd.fi.gl.reciprocal.ReciprocalUtils;
import kd.fi.gl.report.ReportUtils;
import kd.fi.gl.report.subsidiary.AssistBalanceQuery;
import kd.fi.gl.util.DataSetHelper;
import kd.fi.gl.util.FlexUtils;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.SubsiDiaryHelper;
import org.apache.commons.lang3.tuple.Triple;

public class ACAccountCheckRightQueryRptOld {
    private static final String startPeriod = "startperiod";
    private static final String endPeriod = "endperiod";
    private static final String account = "account";
    private static final String billStatus = "billstatus";
    private static final String assistDb = "gl_assist_bd";
    private static final String acctKey = "bd_accountview";
    private static final String startDate = "daterange_startdate";
    private static final String endDate = "daterange_enddate";
    private static final String bookeddate = "bookeddate";
    private static final String booktype = "booktype";
    private long currLocal = 0L;
    private boolean isExport = false;
    private List<String> assTypeSel = new ArrayList<String>();
    private Set<Object> currencyid = new HashSet<Object>();
    private ReportQueryParam param;
    private Object obj;
    private Context context;
    private String accountNameField = "name";
    private FilterInfo filterInfo = null;
    private DataSet queryPeriod;
    public final int voucherDisplayLimit = BillParamUtil.getIntegerValue((String)"83bfebc8000017ac", (String)"fi.gl.report.acaccountcheck.voucherlimit", (int)100000);
    private int detailSize;
    private static final Log logger = LogFactory.getLog(ACAccountCheckRightQueryRptOld.class);
    private static final String[] uinitField = new String[]{"currencycolumn", "basecurrency", "enddate", "periodyear", "dc", "voucherid", "entryid", "period", "datefield", "bizdate", "vouchernumber", "desc", "debitfor", "creditfor", "endfor", "debitlocal", "creditlocal", "endlocal", "debitqty", "creditqty", "endqty", "rowtype"};
    private static final String[] uinitvField = new String[]{"currencycolumn", "basecurrency", "enddate", "periodyear", "dc", "voucherid", "entryid", "period", "datefield", "bizdate", "vouchernumber", "desc", "debitfor", "creditfor", "endfor", "debitlocal", "creditlocal", "endlocal", "debitqty", "creditqty", "endqty", "rowtype", "checkstatus"};
    private static final String[] uinit_gperiodField = new String[]{"currencycolumn", "basecurrency", "enddate", "periodyear", "dc", "voucherid", "period", "datefield", "bizdate", "vouchernumber", "desc", "debitfor", "creditfor", "endfor", "debitlocal", "creditlocal", "endlocal", "debitqty", "creditqty", "endqty", "rowtype"};
    private static final String[] gfieldField = new String[]{"currencycolumn"};
    private static final String[] gperiodField = new String[]{"period", "enddate", "periodyear", "currencycolumn"};
    private static final String[] byearbalField = new String[]{"currencycolumn", "yeardebitfor", "yearcreditfor", "yeardebitlocal", "yearcreditlocal", "yeardebitqty", "yearcreditqty"};

    public ACAccountCheckRightQueryRptOld(ReportQueryParam param, Object obj, Context context) {
        this.param = param;
        this.obj = obj;
        this.context = context;
    }

    public DataSet query() {
        try {
            if (this.obj == null) {
                QFilter filter = new QFilter("id", "=", (Object)0L);
                return QueryServiceHelper.queryDataSet((String)(this.getClass() + ".query"), (String)"gl_voucher", (String)"id", (QFilter[])new QFilter[]{filter}, null);
            }
            return this.querySubsiDiaryRight(this.param, this.obj);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new KDBizException(GLUtil.printError((Throwable)e));
        }
    }

    private DataSet querySubsiDiaryRight(ReportQueryParam param, Object obj) {
        int preYear;
        DynamicObject prePeriod;
        PerformanceWatch watch = new PerformanceWatch(ACAccountCheckRightQueryRptOld.class, "ACAccountCheckRightQueryRpt_querySubsiDiaryRight", false);
        watch.start("preInit");
        FilterInfo filterInfo = param.getFilter();
        this.preInit(param, obj);
        Collection assistFilterEntries = ReciprocalUtils.buildAssistFilterInfo((FilterInfo)filterInfo, (Object)obj);
        Triple balanceOrmInfos = FlexUtils.buildDynamicORMAssistOnBalance((Collection)assistFilterEntries, (String)"gl_balance", (boolean)true);
        Tuple2<DataSet, DataSet> balanceAndAsistDS = this.queryBalanceAndAssist((Triple<MainEntityType, List<QFilter>, List<String>>)balanceOrmInfos);
        DataSet balanceData = (DataSet)balanceAndAsistDS.t1;
        DataSet assTypeData = (DataSet)balanceAndAsistDS.t2;
        watch.stop();
        List<Long> assIds = this.collectHgIdSet(balanceData);
        watch.start("queryVoucher_data");
        Triple vchOrmInfo = FlexUtils.buildDynamicORMAssistOnVoucher((Collection)assistFilterEntries, (boolean)true);
        DataSet queryVoucher = this.queryVoucher(filterInfo, (Triple<MainEntityType, List<QFilter>, List<String>>)vchOrmInfo);
        watch.stop();
        if (queryVoucher.copy().isEmpty()) {
            BigDecimal beginlocal = BigDecimal.ZERO;
            for (Row next : balanceData.copy()) {
                beginlocal = beginlocal.add(next.getBigDecimal("beginlocal"));
            }
            if (beginlocal.compareTo(BigDecimal.ZERO) == 0) {
                return DataSetHelper.createEmptyDataSet();
            }
        }
        if ((prePeriod = GLUtil.getPreviousPeriod((Object)filterInfo.getLong(startPeriod))) != null) {
            if (queryVoucher.copy().hasNext()) {
                preYear = prePeriod.getInt("periodyear");
            } else {
                prePeriod = filterInfo.getDynamicObject(startPeriod);
                preYear = prePeriod.getInt("periodyear");
            }
        } else {
            preYear = 0;
        }
        watch.start("queryBalanceAndAssist");
        String beginYearBalSel = "account.number accountnumber,account.dc dc,currency currencycolumn,measureunit,yeardebitfor yeardebitfor, yearcreditfor yearcreditfor, yeardebitlocal, yearcreditlocal, yeardebitqty, yearcreditqty, debitfor,debitlocal,debitqty,creditfor,creditlocal,creditqty, assgrp assgrpid";
        DataSet beginYearBal = SubsiDiaryHelper.getBalance((FilterInfo)filterInfo, (String)beginYearBalSel, assIds, (long)filterInfo.getLong(startPeriod), (long)filterInfo.getLong(startPeriod));
        beginYearBal = beginYearBal.select("accountnumber,dc,currencycolumn,measureunit,yeardebitfor-debitfor yeardebitfor, yearcreditfor-creditfor yearcreditfor, yeardebitlocal-debitlocal yeardebitlocal,yearcreditlocal-creditlocal yearcreditlocal, yeardebitqty-debitqty yeardebitqty, yearcreditqty-creditqty yearcreditqty, assgrpid");
        List beginYearBalCols = GLUtil.getDataSetCols((DataSet)beginYearBal);
        beginYearBalCols.remove("currencycolumn");
        beginYearBalCols.add(this.isBaseCur(this.currLocal, "currencycolumn", filterInfo));
        beginYearBal = beginYearBal.select(beginYearBalCols.toArray(new String[0]));
        watch.stop();
        Date startD = filterInfo.getDate(startDate);
        Date endD = null;
        if (prePeriod != null) {
            endD = prePeriod.getDate("enddate");
        }
        QFilter fperiod = new QFilter(bookeddate, "<", (Object)startD);
        if (endD != null) {
            fperiod.and(new QFilter(bookeddate, ">=", (Object)endD));
        }
        watch.start("voucherData");
        List<QFilter> filterVoucher = this.filterVoucher(filterInfo, fperiod);
        String select = "entries.debitori debitfor,entries.creditori creditfor,entries.debitlocal debitlocal,entries.creditlocal creditlocal, entries.assgrp assgrpid, entries.currency currency, " + String.join((CharSequence)",", (Iterable)vchOrmInfo.getRight());
        filterVoucher.addAll((Collection)vchOrmInfo.getMiddle());
        ORM voucherOrm = ORM.create();
        voucherOrm.setDataEntityType("gl_voucher", (IDataEntityType)vchOrmInfo.getLeft());
        DataSet voucherData = voucherOrm.queryDataSet(ACAccountCheckRightQueryRptOld.class.getName(), "gl_voucher", select, filterVoucher.toArray(new QFilter[0]), null, -1);
        select = "debitfor, creditfor, debitlocal, creditlocal, assgrpid, " + this.isBaseCur(this.currLocal, "currency", filterInfo) + " , " + String.join((CharSequence)",", this.assTypeSel);
        voucherData = voucherData.select(select);
        ArrayList<String> orderBy = new ArrayList<String>(6);
        orderBy.add("currency");
        this.assTypeSel.forEach(s -> orderBy.add((String)s));
        voucherData = voucherData.groupBy(orderBy.toArray(new String[0])).sum("debitlocal").sum("creditlocal").sum("debitfor").sum("creditfor").finish();
        String voucherDataSel = "debitlocal - creditlocal vchendlocal, debitfor - creditfor vchendfor, currency, " + String.join((CharSequence)",", this.assTypeSel);
        voucherData = voucherData.select(voucherDataSel);
        beginYearBal = beginYearBal.addField(preYear + "", "periodyear");
        watch.stop();
        List<DataSet> listDataSet = this.checkBoxFilter(filterInfo, queryVoucher, balanceData, beginYearBal);
        queryVoucher = listDataSet.get(0);
        balanceData = listDataSet.get(1);
        beginYearBal = listDataSet.get(2);
        String balanceSelect = this.isBaseCur(this.currLocal, "currencycolumn", filterInfo) + ", accountnumber, measureunit, debitfor, creditfor, debitlocal, creditlocal, endfor, beginlocal endlocal, endqty, assgrpid, " + String.join((CharSequence)",", this.assTypeSel);
        balanceData = balanceData.select(balanceSelect);
        DataSet periods = this.queryPeriod(filterInfo);
        watch.start("joinassTypeFields");
        List assTypeFields = ReportUtils.getSetField((DataSet)assTypeData);
        assTypeFields.remove("hg");
        beginYearBal = assTypeData.copy().join(beginYearBal, JoinType.RIGHT).on("hg", "assgrpid").select(assTypeFields.toArray(new String[0]), ReportUtils.getSetField((DataSet)beginYearBal).toArray(new String[0])).finish();
        watch.stop();
        watch.start("createBeginBalance");
        DataSet begin = this.createBeginBalance(balanceData, queryVoucher, voucherData, assTypeFields);
        watch.stop();
        if (begin == null) {
            return balanceData;
        }
        watch.start("setGroupData");
        DataSet result = this.setGroupData(queryVoucher, this.currLocal, begin, beginYearBal, periods);
        watch.stop();
        String show = watch.show();
        logger.info("=====ACAccountCheckRightQueryRpt_querySubsiDiaryRight_show:{}=====", (Object)show);
        return result;
    }

    private DataSet queryVoucher(FilterInfo filterInfo, Triple<MainEntityType, List<QFilter>, List<String>> ormInfo) {
        String currencyVal;
        Date startD = filterInfo.getDate(startDate);
        Date endD = filterInfo.getDate(endDate);
        QFilter fperiod = new QFilter(bookeddate, ">=", (Object)startD).and(new QFilter(bookeddate, "<=", (Object)endD));
        List<QFilter> acctFilters = this.filterVoucher(filterInfo, fperiod);
        boolean isBasecurrency = false;
        if (filterInfo.getString("currency") != null && "basecurrency".equals(currencyVal = filterInfo.getString("currency"))) {
            isBasecurrency = true;
        }
        String orderBys = isBasecurrency ? "entries.eorg, entries.eperiod" : "entries.currency,period";
        String voucherSel = "id voucherid,entries.id fentryid,bookeddate datefield,period,entries.currency currencycolumn,entries.localrate localrate,entries.measureunit measureunit,entries.entrydc entrydc,bizdate, vouchertype, billno,entries.edescription desc,entries.debitori debitfor,entries.creditori creditfor,entries.debitlocal debitlocal,entries.creditlocal creditlocal,entries.quantity quantity, entries.assgrp assgrpid, entries.account accountid ,entries.id entryid ";
        voucherSel = voucherSel + " , " + String.join((CharSequence)",", (Iterable)ormInfo.getRight());
        acctFilters.addAll((Collection)ormInfo.getMiddle());
        ORM orm = ORM.create();
        orm.setDataEntityType("gl_voucher", (IDataEntityType)ormInfo.getLeft());
        DataSet queryVoucher = orm.queryDataSet(ACAccountCheckRightQueryRptOld.class.getName(), "gl_voucher", voucherSel, acctFilters.toArray(new QFilter[0]), orderBys, this.voucherDisplayLimit + 1);
        queryVoucher = this.addVchTypeField(queryVoucher);
        queryVoucher = this.addPeriodField(queryVoucher);
        queryVoucher = this.addAccountFields(queryVoucher);
        int voucherCount = queryVoucher.copy().count("voucherid", false);
        this.setDetailSize(voucherCount);
        if (voucherCount > this.voucherDisplayLimit) {
            this.context.registerContext("voucherfilter", (Object)SerializationUtils.serializeToBase64(acctFilters));
            this.context.registerContext("isbasecurrency", (Object)isBasecurrency);
            queryVoucher = queryVoucher.limit(0, this.voucherDisplayLimit);
        }
        List assTypeFields = filterInfo.getFlexFilterItems().stream().map(v -> v.getPropName()).collect(Collectors.toList());
        String vchSelect = this.isBaseCur(this.currLocal, "currencycolumn", filterInfo) + " ,measureunit ," + this.currLocal + " basecurrency, enddate, periodyear ,dc ,voucherid ,accountnumber ,period, datefield, bizdate, typename+' '+billno vouchernumber, desc,debitfor, creditfor, 0.0 endfor, debitlocal, creditlocal, 0.0 endlocal, case when debitlocal!=0 then quantity else 0.0 end as debitqty, case when creditlocal!=0 then quantity else 0.0 end as creditqty, 0.0 endqty, assgrpid, entryid, " + String.join((CharSequence)",", assTypeFields);
        queryVoucher = queryVoucher.select(vchSelect).addField("2", "rowtype");
        queryVoucher = queryVoucher.addNullField("checkstatus");
        return queryVoucher;
    }

    private DataSet createBeginBalance(DataSet balanceData, DataSet queryVoucher, DataSet voucherData, List<String> assTypeFields) {
        DataSet begin = null;
        String[] fileds = new String[]{"currencycolumn", this.currLocal + " basecurrency", "null enddate", "null periodyear", "'0' dc", "0L voucherid", "null period", "null datefield", "null bizdate", "null vouchernumber", String.format(ResManager.loadKDString((String)"%1$s\u671f\u521d\u4f59\u989d%2$s", (String)"ACAccountCheckRightQueryRpt_0", (String)"fi-gl-report", (Object[])new Object[0]), "'", "' desc"), "0.0 debitfor", "0.0 creditfor", "0.0 endfor", "0.0 debitlocal", "0.0 creditlocal", "endlocal", "0.0 debitqty", "0.0 creditqty", "0.0 endqty"};
        String[] resulSel = this.addAssType(fileds);
        String[] unionFiled = new String[]{"currencycolumn", this.currLocal + " basecurrency", "null enddate", "null periodyear", "case when endlocal>0 then '1' when endlocal<0 then '-1' else '0' end as dc", "0L voucherid", "null period", "null datefield", "null bizdate", "null vouchernumber", String.format(ResManager.loadKDString((String)"%1$s\u671f\u521d\u4f59\u989d%2$s", (String)"ACAccountCheckRightQueryRpt_0", (String)"fi-gl-report", (Object[])new Object[0]), "'", "' desc"), "0.0 debitfor", "0.0 creditfor", "endfor", "0.0 debitlocal", "0.0 creditlocal", "endlocal", "0.0 debitqty", "0.0 creditqty", "endqty"};
        String[] unionSel = this.addAssType(unionFiled);
        if (balanceData.copy().count("accountnumber", false) > 0) {
            if (queryVoucher.copy().count("accountnumber", false) > 0) {
                begin = queryVoucher.copy().select(resulSel);
                begin = begin.union(balanceData.copy().select(unionSel));
                begin = begin.groupBy(this.addAssType(new String[]{"currencycolumn"})).sum("endfor").sum("endlocal").sum("endqty").finish().select(unionSel).addField("1", "rowtype");
            } else {
                begin = balanceData.copy().groupBy(this.addAssType(new String[]{"currencycolumn"})).sum("endfor").sum("endlocal").sum("endqty").finish().select(unionSel).addField("1", "rowtype");
            }
        } else if (queryVoucher.copy().count("accountnumber", false) > 0) {
            begin = queryVoucher.copy().groupBy(this.addAssType(new String[]{"currencycolumn"})).finish().select(resulSel).addField("1", "rowtype");
        }
        if (voucherData.hasNext() && begin != null) {
            unionFiled = new String[]{"currencycolumn", this.currLocal + " basecurrency", "null enddate", "null periodyear", "0L voucherid", "null period", "null datefield", "null bizdate", "null vouchernumber", String.format(ResManager.loadKDString((String)"%1$s\u671f\u521d\u4f59\u989d%2$s", (String)"ACAccountCheckRightQueryRpt_0", (String)"fi-gl-report", (Object[])new Object[0]), "'", "' desc"), "0.0 debitfor", "0.0 creditfor", "endfor + vchendfor endfor", "0.0 debitlocal", "0.0 creditlocal", "endlocal + vchendlocal as end", "endlocal + vchendlocal as endlocal", "0.0 debitqty", "0.0 creditqty", "endqty"};
            unionSel = this.addAssType(unionFiled);
            JoinDataSet joinDataSet = begin.join(voucherData, JoinType.LEFT);
            for (String assType : assTypeFields) {
                joinDataSet = joinDataSet.on(assType, assType);
            }
            joinDataSet.on("currencycolumn", "currency");
            begin = joinDataSet.select(unionSel).finish().addField("1", "rowtype").addField("case when endlocal>0 then '1' when endlocal<0 then '-1' else '0' end ", "dc");
        }
        if (begin != null) {
            begin = begin.addNullField("entryid");
        }
        return begin;
    }

    private DataSet queryPeriod(FilterInfo filterInfo) {
        QFilter filter1 = new QFilter("id", ">=", (Object)filterInfo.getLong(startPeriod));
        QFilter filter2 = new QFilter("id", "<=", (Object)filterInfo.getLong(endPeriod));
        QFilter filter3 = new QFilter("periodtype", "=", (Object)filterInfo.getLong("periodtype"));
        DataSet periods = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_period", (String)"id period, enddate, periodyear", (QFilter[])new QFilter[]{filter1, filter2, filter3}, (String)"enddate");
        return periods;
    }

    private List<DataSet> checkBoxFilter(FilterInfo filterInfo, DataSet queryVoucher, DataSet balanceData, DataSet beginYearBal) {
        if (!filterInfo.getBoolean("showqty")) {
            String vchSelect = "currencycolumn, 0L measureunit, basecurrency, enddate, periodyear, dc, voucherid, accountnumber, period, datefield, bizdate, vouchernumber, desc, debitfor, creditfor, endfor, debitlocal, creditlocal, endlocal, debitqty, creditqty, endqty, rowtype, assgrpid, entryid, checkstatus, " + String.join((CharSequence)",", this.assTypeSel);
            String beginYearSel = "accountnumber, dc, currencycolumn, 0L measureunit, periodyear, yeardebitfor, yearcreditfor, yeardebitlocal, yearcreditlocal, yeardebitqty, yearcreditqty, assgrpid";
            String balanceDataSel = "accountnumber, currencycolumn, 0L measureunit, debitfor, creditfor, debitlocal, creditlocal, endfor, beginlocal, endlocal, endqty,assgrpid," + String.join((CharSequence)",", this.assTypeSel);
            queryVoucher = queryVoucher.select(vchSelect);
            beginYearBal = beginYearBal.select(beginYearSel);
            balanceData = balanceData.select(balanceDataSel);
        }
        if (filterInfo.getBoolean("noochide")) {
            List<String> groupFields = Arrays.asList("currencycolumn", "assgrpid");
            DataSet ochideSet = queryVoucher.copy().groupBy(groupFields.toArray(new String[0])).finish();
            List fields = ReportUtils.getSetField((DataSet)balanceData);
            balanceData = ochideSet.join(balanceData, JoinType.INNER).on("accountnumber", "accountnumber").on("currencycolumn", "currencycolumn").on("measureunit", "measureunit").select(fields.toArray(new String[0])).finish();
        }
        if (filterInfo.getBoolean("balancezerohide")) {
            if (!filterInfo.getBoolean("showqty")) {
                balanceData = balanceData.groupBy(new String[]{"accountnumber", "currencycolumn", "measureunit"}).sum("debitfor").sum("creditfor").sum("debitlocal").sum("creditlocal").sum("endfor").sum("beginlocal").sum("endlocal").sum("endqty").finish();
            }
            balanceData = balanceData.filter("endlocal!=0");
            List fields = ReportUtils.getSetField((DataSet)queryVoucher);
            queryVoucher = queryVoucher.join(balanceData, JoinType.INNER).on("accountnumber", "accountnumber").on("currencycolumn", "currencycolumn").on("measureunit", "measureunit").select(fields.toArray(new String[0])).finish();
        }
        ArrayList<DataSet> listDataSet = new ArrayList<DataSet>();
        listDataSet.add(queryVoucher);
        listDataSet.add(balanceData);
        listDataSet.add(beginYearBal);
        return listDataSet;
    }

    private String isBaseCur(long curLocId, String curKey, FilterInfo filterInfo) {
        if ("basecurrency".equals(filterInfo.getString("currency"))) {
            return curLocId + "L " + curKey;
        }
        if (!"allcurrency".equals(filterInfo.getString("currency"))) {
            return filterInfo.getString("currency") + "L " + curKey;
        }
        return curKey;
    }

    public DataSet setGroupData(DataSet queryData, long currLocal, DataSet begin, DataSet beginYearBal, DataSet queryPeriods) {
        queryData = queryData.addField("2", "rowtype").select(this.addAssType(this.getGroupField("uinitv")));
        begin = begin.addField("1", "rowtype").select(this.addAssType(this.getGroupField("uinit"))).addNullField("checkstatus");
        DataSet union = queryData.copy().union(begin);
        DataSet unionCopy = union.copy().select(this.addAssType(this.getGroupField("uinitv")));
        String[] groupField = this.getGroupField("gfield");
        DataSet periodSet = queryPeriods.join(union.groupBy(this.addAssType(groupField)).finish(), JoinType.CROSS).select(new String[]{"period", "enddate", "periodyear"}, this.addAssType(groupField)).finish();
        DataSet periodAcct = union.groupBy(this.addAssType(new String[]{"currencycolumn", "period"})).sum("debitfor").sum("creditfor").sum("debitlocal").sum("creditlocal").sum("debitqty").sum("creditqty").finish().filter("period!=null").orderBy(new String[]{"period"});
        JoinDataSet joinPeriodSet = periodSet.join(periodAcct, JoinType.LEFT).on("currencycolumn", "currencycolumn").on("period", "period");
        for (String assType : this.assTypeSel) {
            joinPeriodSet.on(assType, assType);
        }
        periodSet = joinPeriodSet.select(this.addAssType(new String[]{"period", "enddate datefield", "periodyear", "currencycolumn"}), new String[]{currLocal + " basecurrency", "null voucherid", "null entryid", "null bizdate", "null vouchernumber", String.format(ResManager.loadKDString((String)"%1$s\u672c\u671f\u5408\u8ba1%2$s", (String)"ACAccountCheckRightQueryRpt_1", (String)"fi-gl-report", (Object[])new Object[0]), "'", "' desc"), "debitfor", "creditfor", "0.0  endfor", "debitlocal", "creditlocal", "0.0 endlocal", "debitqty", "creditqty", "0.0 endqty"}).finish().addField("3", "rowtype");
        periodSet = periodSet.select(this.addAssType(new String[]{"currencycolumn", "basecurrency", "periodyear", "voucherid", "entryid", "period", "datefield", "bizdate", "vouchernumber", String.format(ResManager.loadKDString((String)"%1$s\u672c\u671f\u5408\u8ba1%2$s", (String)"ACAccountCheckRightQueryRpt_1", (String)"fi-gl-report", (Object[])new Object[0]), "'", "' desc"), "debitfor", "creditfor", "endfor", "debitlocal", "creditlocal", "endlocal", "debitqty", "creditqty", "endqty", "rowtype"})).addField("'0'", "checkstatus");
        DataSet yearSet = periodSet.copy().removeFields(new String[]{"rowtype", "desc"}).addField("4", "rowtype").addField(String.format(ResManager.loadKDString((String)"%1$s\u672c\u5e74\u7d2f\u8ba1%2$s", (String)"ACAccountCheckRightQueryRpt_2", (String)"fi-gl-report", (Object[])new Object[0]), "'", "'"), "desc");
        beginYearBal = beginYearBal.addField("0", "rowtype");
        beginYearBal = beginYearBal.select(this.addAssType(new String[]{"currencycolumn", "null basecurrency", "periodyear", "null voucherid", "null entryid", "null period", "null datefield", "null bizdate", "null vouchernumber", "null desc", "yeardebitfor debitfor", "yearcreditfor creditfor", "0.0 endfor", "yeardebitlocal debitlocal", "yearcreditlocal creditlocal", "0.0 endlocal", "yeardebitqty debitqty", "yearcreditqty creditqty", "0.0 endqty", "rowtype"}));
        yearSet = yearSet.select(this.addAssType(new String[]{"currencycolumn", "basecurrency", "periodyear", "voucherid", "entryid", "period", "datefield", "bizdate", "vouchernumber", "desc", "debitfor", "creditfor", "endfor", "debitlocal", "creditlocal", "endlocal", "debitqty", "creditqty", "endqty", "rowtype"}));
        yearSet = yearSet.union(beginYearBal).orderBy(this.addAssType(new String[]{"currencycolumn", "rowtype", "period"}));
        String caseWhen = this.addAssTypeCase("case when cast(PreRowValue(currencycolumn) as long)==currencycolumn ");
        String preRowSel = caseWhen + "and cast(PreRowValue(periodyear) as integer)==periodyear then cast(PreRowValue() as decimal)";
        yearSet = yearSet.select(this.addAssType(new String[]{"currencycolumn", "basecurrency", "periodyear", "voucherid", "entryid", "period", "datefield", "bizdate", "vouchernumber", String.format(ResManager.loadKDString((String)"%1$s\u672c\u5e74\u7d2f\u8ba1%2$s", (String)"ACAccountCheckRightQueryRpt_2", (String)"fi-gl-report", (Object[])new Object[0]), "'", "' desc"), preRowSel + "+debitfor else debitfor end as debitfor", preRowSel + "+creditfor else creditfor end as creditfor", "endfor", preRowSel + "+debitlocal else debitlocal end as debitlocal", preRowSel + "+creditlocal else creditlocal end as creditlocal", "endlocal", preRowSel + "+debitqty else debitqty end as debitqty", preRowSel + "+creditqty else creditqty end as creditqty", "endqty", "rowtype"})).filter("rowtype!=0");
        yearSet = yearSet.addField("'0'", "checkstatus");
        union = unionCopy.orderBy(this.addAssType(new String[]{"currencycolumn", "rowtype", "period", "datefield", "vouchernumber"}));
        String group = caseWhen + "then cast(PreRowValue() as decimal) ";
        union = union.select(this.addAssType(new String[]{"currencycolumn", "basecurrency", "periodyear", "voucherid", "entryid", "period", "datefield", "bizdate", "vouchernumber", "desc", "debitfor", "creditfor", group + "+debitfor-creditfor else endfor end as endfor", "debitlocal", "creditlocal", group + "+debitlocal-creditlocal else endlocal end as endlocal", "debitqty", "creditqty", group + "+debitqty-creditqty else endqty end as endqty", "rowtype", "checkstatus"}));
        union = union.union(periodSet).union(yearSet);
        union = union.orderBy(this.addAssType(new String[]{"currencycolumn", "period", "rowtype", "datefield", "vouchernumber"}));
        String preCon = caseWhen + "and rowtype!=1 and rowtype!=2 then cast(PreRowValue() as decimal) ";
        union = union.select(this.addAssType(new String[]{"currencycolumn", currLocal + " basecurrency", "periodyear", "voucherid", "entryid", "period", "datefield", "bizdate", "vouchernumber", "desc", "debitfor", "creditfor", preCon + "else endfor end as endfor", "debitlocal", "creditlocal", preCon + "else endlocal end as endlocal", "debitqty", "creditqty", preCon + "else endqty end as endqty", "rowtype", "checkstatus"}));
        return union;
    }

    private String addAssTypeCase(String sel) {
        StringBuilder selBuilder = new StringBuilder(sel);
        for (String ass : this.assTypeSel) {
            selBuilder.append("and cast(PreRowValue(").append(ass).append(") as long)==").append(ass).append(" ");
        }
        sel = selBuilder.toString();
        return sel;
    }

    private Table<String, Long, List<Row>> getVoucherTable(DataSet queryVoucher, DataSet periods, String[] selectField) {
        HashBasedTable dataTable = HashBasedTable.create();
        queryVoucher = queryVoucher.select(selectField);
        while (queryVoucher.hasNext()) {
            List rows;
            Row row = queryVoucher.next();
            Long periodId = row.getLong("period");
            StringBuilder sb = new StringBuilder(6);
            this.assTypeSel.forEach(asistType -> {
                sb.append(row.getString(asistType));
                sb.append("_");
            });
            sb.append(row.getString("currencycolumn"));
            String dataKey = sb.toString();
            if (!dataTable.containsRow((Object)dataKey)) {
                for (Row periodRow : periods.copy()) {
                    Long period = periodRow.getLong("period");
                    dataTable.put((Object)dataKey, (Object)period, new LinkedList());
                }
            }
            if (null == (rows = (List)dataTable.get((Object)dataKey, (Object)periodId))) continue;
            AbstractRow persist = ((AbstractRow)row).persist();
            rows.add(persist);
        }
        return dataTable;
    }

    private String[] addAssType(String[] sel) {
        List<String> list = Arrays.asList(sel);
        ArrayList<String> assTypeList = new ArrayList<String>();
        assTypeList.addAll(this.assTypeSel);
        assTypeList.addAll(list);
        String[] resultSel = assTypeList.toArray(new String[0]);
        return resultSel;
    }

    private String[] getGroupField(String groupSel) {
        String[] group = null;
        switch (groupSel) {
            case "uinit": {
                group = uinitField;
                break;
            }
            case "uinitv": {
                group = uinitvField;
                break;
            }
            case "uinit_gperiod": {
                group = uinit_gperiodField;
                break;
            }
            case "gfield": {
                group = gfieldField;
                break;
            }
            case "gperiod": {
                group = gperiodField;
                break;
            }
            case "byearbal": {
                group = byearbalField;
            }
        }
        return group;
    }

    private List<QFilter> filterVoucher(FilterInfo filter, QFilter dateFilter) {
        Map deFilterMap;
        String currencyVal;
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        List periodIds = PeriodUtil.getPeriodIds((Long)filter.getLong(startPeriod), (Long)filter.getLong(endPeriod));
        filters.add(new QFilter("period", "in", (Object)periodIds));
        filters.add(dateFilter);
        String[] fBillStatus = "B,C".split(",");
        QFilter billFilter = new QFilter(billStatus, "in", (Object)fBillStatus);
        filters.add(billFilter);
        QFilter orgf = new QFilter("org", "=", (Object)filter.getLong("org"));
        filters.add(orgf);
        filters.add(new QFilter(booktype, "=", (Object)filter.getLong(booktype)));
        filters.add(new QFilter("entries.eorg", "=", (Object)filter.getLong("org")));
        filters.add(new QFilter("entries.eperiod", "in", (Object)periodIds));
        if (filter.getDynamicObjectCollection(account) != null) {
            HashSet<Long> masterIds = new HashSet<Long>();
            for (DynamicObject accDynamic : filter.getDynamicObjectCollection(account)) {
                masterIds.add(accDynamic.getLong("id"));
            }
            HashSet<Long> acctIds = this.acctMasterIDToID(masterIds);
            HashSet ids = new HashSet();
            SubsiDiaryHelper.getLeafIds(acctIds, ids);
            ids.addAll(SubsiDiaryHelper.getLeafAcct(acctIds));
            QFilter faccount = new QFilter("entries.account", "in", (Object)ids.toArray());
            filters.add(faccount);
        }
        if (filter.getBoolean("noverificationvch")) {
            ArrayList<QFilter> noverQFilters = new ArrayList<QFilter>(8);
            noverQFilters.add(new QFilter("period", ">=", (Object)filter.getLong(startPeriod)));
            noverQFilters.add(new QFilter("period", "<=", (Object)filter.getLong(endPeriod)));
            noverQFilters.add(orgf);
            noverQFilters.add(new QFilter(booktype, "=", (Object)filter.getLong(booktype)));
            noverQFilters.add(new QFilter(account, "=", filter.getDynamicObject("account1").get("masterid")));
            noverQFilters.add(new QFilter("status", "!=", (Object)"2"));
            String currencyVal2 = filter.getString("currency");
            if (!"basecurrency".equals(currencyVal2) && !"allcurrency".equals(currencyVal2)) {
                noverQFilters.add(new QFilter("currency", "=", (Object)filter.getLong("currency")));
            }
            Collection assistFilterEntries = ReciprocalUtils.buildAssistFilterInfo((FilterInfo)this.filterInfo, (Object)this.obj);
            Triple ormInfo = FlexUtils.buildDynamicORMAssistOnBalance((Collection)assistFilterEntries, (String)"gl_acccurrent", (boolean)true);
            ORM orm = ORM.create();
            orm.setDataEntityType("gl_acccurrent", (IDataEntityType)ormInfo.getLeft());
            List middle = (List)ormInfo.getMiddle();
            noverQFilters.addAll(middle);
            DataSet acccurrentDataSet = orm.queryDataSet(this.getClass().getName(), "gl_acccurrent", "voucherentry,currency", noverQFilters.toArray(new QFilter[0]));
            HashSet<Object> vchentryIdList = new HashSet<Object>(16);
            for (Row voucherentryId : acccurrentDataSet) {
                vchentryIdList.add(voucherentryId.get("voucherentry"));
                this.currencyid.add(voucherentryId.get("currency"));
            }
            if (!vchentryIdList.isEmpty()) {
                filters.add(new QFilter("entries.id", "in", vchentryIdList));
            } else {
                filters.add(new QFilter("1", "=", (Object)-1));
            }
            if (!this.currencyid.isEmpty()) {
                filters.add(new QFilter("entries.currency", "in", this.currencyid));
            }
        }
        if (filter.getString("currency") != null && !"basecurrency".equals(currencyVal = filter.getString("currency")) && !"allcurrency".equals(currencyVal)) {
            QFilter fcurrency = new QFilter("entries.currency", "=", (Object)Long.parseLong(filter.getString("currency")));
            filters.add(fcurrency);
        }
        if (filter.getDynamicObjectCollection("measureunits") != null) {
            DynamicObjectCollection unitsDynColl = filter.getDynamicObjectCollection("measureunits");
            ArrayList<Long> ids = new ArrayList<Long>();
            for (DynamicObject dyn : unitsDynColl) {
                ids.add(dyn.getLong("id"));
            }
            QFilter funits = new QFilter("entries.measureunit", "in", (Object)ids.toArray());
            filters.add(funits);
        }
        if ((deFilterMap = filter.getCommFilters()).get("gl_voucher") != null) {
            filters.addAll((Collection)deFilterMap.get("gl_voucher"));
        }
        return filters;
    }

    private HashSet<Long> acctMasterIDToID(HashSet<Long> ids) {
        HashSet<Long> masterIds = new HashSet<Long>();
        if (ids == null || ids.isEmpty()) {
            return masterIds;
        }
        QFilter filter = new QFilter("id", "in", ids);
        DataSet masterSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)acctKey, (String)"masterid", (QFilter[])new QFilter[]{filter}, null);
        for (Row row : masterSet) {
            long masterId = row.getLong("masterid");
            masterIds.add(masterId);
        }
        HashSet<Long> acctIds = new HashSet<Long>();
        QFilter mFilter = new QFilter("masterid", "in", masterIds);
        DataSet accSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)acctKey, (String)"id", (QFilter[])new QFilter[]{mFilter}, null);
        for (Row row : accSet) {
            long accId = row.getLong("id");
            acctIds.add(accId);
        }
        return acctIds;
    }

    private Tuple2<DataSet, DataSet> queryBalanceAndAssist(Triple<MainEntityType, List<QFilter>, List<String>> ormInfos) {
        String balanceSel = "account.number accountnumber, currency currencycolumn,measureunit, debitfor debitfor, creditfor creditfor, debitlocal, creditlocal, beginfor endfor, beginlocal, endlocal, beginqty endqty, assgrp assgrpid";
        TimerFactory.Timer timer = TimerFactory.getTimer(this.getClass());
        DataSet balanceDS = this.query(ACAccountCheckRightQueryRptOld.getParam(this.filterInfo), balanceSel, ormInfos, AssistBalanceQuery.CustomFlexProperty.ofNoneDetailAlia((String)"assval"));
        timer.time("=====balance query");
        StringBuilder builder = new StringBuilder("assgrpid");
        this.assTypeSel.forEach(asstype -> builder.append(", ").append((String)asstype));
        String[] groupBy = builder.toString().split(",");
        DataSet assistDS = balanceDS.copy().groupBy(groupBy).finish();
        groupBy[0] = "assgrpid hg";
        assistDS = assistDS.select(groupBy);
        return new Tuple2((Object)balanceDS, (Object)assistDS);
    }

    private static QueryParam getParam(FilterInfo filterInfo) {
        QueryParam param = new QueryParam();
        param.setZeroAmtNoDisplay(filterInfo.getBoolean("nodisplayforzero"));
        param.setZeroBalNoDisplay(filterInfo.getBoolean("balancezero"));
        param.setSubstractPL(filterInfo.getBoolean("issubstractpl"));
        param.setAccountVersionPeriodId(filterInfo.getLong(endPeriod));
        param.setAccountFilter(new QFilter("id", "in", (Object)filterInfo.getDynamicObject("account1").getLong("id")));
        param.setOnlyLeafAcctBal(true);
        String currencyVal = filterInfo.getString("currency");
        if (!"basecurrency".equals(currencyVal) && !"allcurrency".equals(currencyVal)) {
            param.setCurrencyIds(new Long[]{Long.parseLong(filterInfo.getString("currency"))});
        } else if ("basecurrency".equals(currencyVal)) {
            param.setAddAmountFilter(false);
        }
        return param;
    }

    private void preInit(ReportQueryParam param, Object obj) {
        FilterInfo customFilterInfo = param.getFilter().clone();
        List clonedFilterItems = param.getFilter().getFlexFilterItems().stream().filter(Objects::nonNull).map(FilterItemInfo::clone).collect(Collectors.toList());
        customFilterInfo.setFlexFilterItems(clonedFilterItems);
        if (!SubsiDiaryHelper.isExportAll((FilterInfo)customFilterInfo)) {
            Map<String, FilterItemInfo> collect = clonedFilterItems.stream().collect(Collectors.toMap(FilterItemInfo::getPropName, filterItemInfo -> filterItemInfo));
            for (FilterItemInfo itemInfo : param.getFilter().getFlexFilterItems()) {
                String assType = itemInfo.getPropName();
                if (!((DynamicObject)obj).containsProperty(assType)) continue;
                DynamicObject valueDyn = ((DynamicObject)obj).getDynamicObject(assType);
                HashSet<Object> assistValue = new HashSet<Object>(1);
                assistValue.add(valueDyn.get("id"));
                collect.get(assType).setValue(assistValue);
            }
        }
        customFilterInfo.setCommFilter(param.getFilter().getCommFilter());
        customFilterInfo.setFastFilter(param.getFilter().getFastFilter());
        customFilterInfo.setQFilters(param.getFilter().getQFilters());
        customFilterInfo.setOtherEntryFilter(param.getFilter().getOtherEntryFilter());
        customFilterInfo.setTableHeadFilterItems(param.getFilter().getTableHeadFilterItems());
        this.filterInfo = customFilterInfo;
        AccountBookInfo book = AccSysUtil.getBookFromAccSys((long)this.filterInfo.getLong("org"), (long)this.filterInfo.getLong(booktype));
        this.currLocal = book.getBaseCurrencyId();
        this.accountNameField = GLUtil.getAcctNameBySysParam((Long)this.filterInfo.getLong("org"));
        this.queryPeriod = this.queryPeriod(this.filterInfo);
        this.isExport = SubsiDiaryHelper.isExport((FilterInfo)this.filterInfo);
        for (FilterItemInfo itemInfo : this.filterInfo.getFlexFilterItems()) {
            String key = itemInfo.getPropName();
            this.assTypeSel.add(key);
        }
    }

    private List<Long> collectHgIdSet(DataSet balanceDS) {
        ArrayList<Long> hgLists = new ArrayList<Long>(16);
        balanceDS.copy().forEachRemaining(row -> hgLists.add(row.getLong("assgrpid")));
        return hgLists;
    }

    private DataSet addAccountFields(DataSet queryVoucher) {
        Long acctMasterid = (Long)this.filterInfo.getDynamicObject("account1").get("masterid");
        QFilter[] filters = new QFilter[]{new QFilter("masterid", "=", (Object)acctMasterid)};
        DataSet acctNameNumberDs = QueryServiceHelper.queryDataSet((String)(this.getClass() + ".acctQueryWithPeriodF"), (String)acctKey, (String)("id, number, dc," + this.accountNameField), (QFilter[])filters, null);
        return queryVoucher.join(acctNameNumberDs).on("accountid", "id").select(GLUtil.getDataSetCols((DataSet)queryVoucher).toArray(new String[0]), new String[]{"number accountnumber", this.accountNameField + " accountname", "dc"}).finish();
    }

    private DataSet addVchTypeField(DataSet vchDS) {
        DataSet vchTypeDS = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + "#vchTypeName"), (String)VoucherTypeSchema.INSTANCE.entity, (String)"id, name, number", (QFilter[])new QFilter[]{QFilter.of((String)"1=1", (Object[])new Object[0])}, null);
        return vchDS.leftJoin(vchTypeDS).on("vouchertype", "id").select(GLUtil.getDataSetCols((DataSet)vchDS).toArray(new String[0]), new String[]{"name typename", "number typenumber"}).finish();
    }

    private DataSet addPeriodField(DataSet vchDs) {
        return vchDs.leftJoin(this.queryPeriod.copy()).on("period", "period").select(GLUtil.getDataSetCols((DataSet)vchDs).toArray(new String[0]), new String[]{"enddate", "periodyear"}).finish();
    }

    public DataSet query(QueryParam queryParam, String balanceSelect, Triple<MainEntityType, List<QFilter>, List<String>> ormInfos, String ... assistBDSelect) {
        AccountBookInfo defaultBook;
        long orgId = this.filterInfo.getLong("org");
        Set childOrgId = SubsiDiaryHelper.getChildOrgId((FilterInfo)this.filterInfo);
        childOrgId.add(orgId);
        long bookTypeId = this.filterInfo.getLong(booktype);
        if (bookTypeId == 0L && (defaultBook = AccSysUtil.getDefaultBookFromAccSys((Long)((Long)this.filterInfo.getDynamicObject("org").getPkValue()))) != null) {
            bookTypeId = defaultBook.getBookTypeId();
        }
        queryParam.setBalEntityType((MainEntityType)ormInfos.getLeft());
        ArrayList customF = queryParam.getCustomFilter();
        if (customF == null) {
            customF = new ArrayList(4);
        }
        customF.addAll((Collection)ormInfos.getMiddle());
        queryParam.setCustomFilter(customF);
        if (assistBDSelect.length > 0) {
            balanceSelect = balanceSelect + "," + String.join((CharSequence)",", (Iterable)ormInfos.getRight());
        }
        return BalanceQueryExecutor.getInstance().getBalance(balanceSelect, childOrgId.toArray(new Long[0]), bookTypeId, this.filterInfo.getLong("accounttable"), this.filterInfo.getLong(startPeriod), this.filterInfo.getLong(endPeriod), queryParam);
    }

    public boolean isExport() {
        return this.isExport;
    }

    public int getDetailSize() {
        return this.detailSize;
    }

    public void setDetailSize(int detailSize) {
        this.detailSize = detailSize;
    }
}

