/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.flex.FlexEntireData;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.accountref.AccountRefUtils;
import kd.bos.ext.fi.accountref.AccountTableRef;
import kd.bos.ext.fi.accountref.AssGrpDefaultVal;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bd.service.balance.BalanceQueryExecutor;
import kd.fi.bd.service.balance.QueryParam;
import kd.fi.gl.accountref.constant.AccountDetails;
import kd.fi.gl.accountref.utils.BalanceTransferUtils;
import kd.fi.gl.reciprocal.FlexSaveService;
import kd.fi.gl.report.MulOrgQPRpt;
import kd.fi.gl.report.ReportUtils;
import kd.fi.gl.util.GLUtil;

public class AccountRefBalanceRptPlugin
extends AbstractReportListDataPlugin {
    private static final String ROWTYPE = "rowtype";
    private static final String ENABLEDATE = "enabledate";
    private static final String ACCOUNTTABLE = "accounttable";
    private static final String OLDACCTTAB = "oldaccttab";
    private static final int INIT_FIELD_CAPACITY = 8;
    private static final int INIT_CAPACITY = 1024;
    private static final String SUM = "sum";
    private static final String SELECT_FIELDS = "account, account.%s name, currency currencyfor, beginfor, beginlocal, endfor, endlocal";
    private static final String ASSTACTITEM_FLEXFIELD = "asstactitem.flexfield";
    private static final String GL_ASSIST_BD = "gl_assist_bd";
    private static final String GL_ASSIST_TXT = "gl_assist_txt";
    private static final String GL = "gl";
    private static final String T_GL_ASSIST = "T_GL_ASSIST";
    private MulOrgQPRpt qParam;
    private AccountTableRef accountTableRef;
    private Date effectiveDate;

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        for (AbstractReportColumn column : columns) {
            ReportColumn rptColumn;
            String fieldKey;
            if (!(column instanceof ReportColumn) || !"oldassgrpid".equals(fieldKey = (rptColumn = (ReportColumn)column).getFieldKey()) && !"newassgrpid".equals(fieldKey)) continue;
            rptColumn.setHide(!this.qParam.isShowAssist());
        }
        return columns;
    }

    public DataSet query(ReportQueryParam queryParam, Object args) throws Throwable {
        FilterInfo filterInfo = queryParam.getFilter();
        this.init(filterInfo);
        DataSet oldBalanceSet = this.queryBalance(queryParam, true);
        DataSet newBalanceSet = this.queryBalance(queryParam, false);
        return this.buildAccountRefRst(oldBalanceSet, newBalanceSet);
    }

    private void init(FilterInfo filterInfo) {
        this.qParam = new MulOrgQPRpt(filterInfo, "gl_rpt_balance_accountref");
        Long periodId = filterInfo.getLong("effectiveperiod");
        Long orgId = filterInfo.getLong("org");
        DynamicObject bookVersion = BalanceTransferUtils.queryEffectiveVersionInfo((Long)orgId, (Long)this.qParam.getBookType(), (Long)periodId);
        if (null != bookVersion) {
            this.accountTableRef = AccountRefUtils.getAccountTableRef((long)orgId, (long)bookVersion.getLong("oldaccttab.id"), (long)bookVersion.getLong("accounttable.id"));
            this.effectiveDate = bookVersion.getDate(ENABLEDATE);
        }
        if (null == this.accountTableRef) {
            throw new KDBizException(ResManager.loadKDString((String)"\u79d1\u76ee\u5bf9\u7167\u5173\u7cfb\u67e5\u627e\u5931\u8d25\u3002", (String)"AccountRefBalanceRptPlugin_0", (String)"fi-gl-report", (Object[])new Object[0]));
        }
    }

    private DataSet buildAccountRefRst(DataSet oldBalanceSet, DataSet newBalanceSet) {
        DataSet accountRefSet = this.queryAccountRefSet(oldBalanceSet);
        DataSet resultSet = this.joinAccountRefSet(oldBalanceSet, accountRefSet);
        DataSet sumSet = this.sumOldBalByRef(resultSet);
        resultSet = this.joinNewBalanceSet(newBalanceSet, resultSet);
        resultSet = this.diffBalanceSet(resultSet, sumSet);
        return this.sumTotalRow(resultSet);
    }

    private DataSet sumTotalRow(DataSet resultSet) {
        DataSet totalRowSet = MulOrgQPRpt.gainSumSet((DataSet)resultSet.copy(), (String[])new String[0], (String[])new String[]{"olddebitlocal", "oldcreditlocal", "newdebitlocal", "newcreditlocal", "diffamountlocal"});
        List totalCols = GLUtil.getDataSetCols((DataSet)totalRowSet);
        totalCols.remove("newaccountname");
        totalCols.add(String.format("'%s' %s", ResManager.loadKDString((String)"\u5408\u8ba1", (String)"AccountRefBalanceRptPlugin_1", (String)"fi-gl-report", (Object[])new Object[0]), "newaccountname"));
        totalCols.remove(ROWTYPE);
        totalCols.add("'1' rowtype");
        totalCols.remove("currencylocal");
        totalCols.add(this.qParam.getCurLocal() + " " + "currencylocal");
        totalCols.remove("dc");
        totalCols.add(String.format("case when %s>0 then '1' when %s<0 then '-1' else '0' end %s", "diffamountlocal", "diffamountlocal", "dc"));
        totalRowSet = totalRowSet.select(totalCols.toArray(new String[0]));
        List cols = GLUtil.getDataSetCols((DataSet)resultSet);
        resultSet = resultSet.union(totalRowSet.select(cols.toArray(new String[0])));
        ArrayList<String> orderBys = new ArrayList<String>(8);
        orderBys.add(ROWTYPE);
        orderBys.add("number");
        orderBys.add("currencyfor");
        if (this.qParam.isShowAssist()) {
            orderBys.add("newassgrpid");
        }
        return resultSet.orderBy(orderBys.toArray(new String[0]));
    }

    private DataSet queryAccountRefSet(DataSet oldBalanceSet) {
        DataSet accountRefSet = null;
        accountRefSet = this.qParam.isShowAssist() ? this.getAccountAssistRefSet(oldBalanceSet) : this.getAccountRefSet();
        return accountRefSet;
    }

    private DataSet diffBalanceSet(DataSet resultSet, DataSet sumSet) {
        List cols = GLUtil.getDataSetCols((DataSet)resultSet);
        cols.add(String.format("(%s-%s)-(%s-%s) %s", "newdebitfor", "newcreditfor", "olddebitforsum", "oldcreditforsum", "diffamountfor"));
        cols.add(String.format("(%s-%s)-(%s-%s) %s", "newdebitlocal", "newcreditlocal", "olddebitlocalsum", "oldcreditlocalsum", "diffamountlocal"));
        JoinDataSet rJoinDataSet = resultSet.join(sumSet, JoinType.INNER).on("newaccountid", "newaccountid").on("currencyfor", "currencyfor");
        if (this.qParam.isShowAssist()) {
            rJoinDataSet = rJoinDataSet.on("newassgrpid", "newassgrpid");
        }
        DataSet rstSet = rJoinDataSet.select(cols.toArray(new String[0])).finish();
        List rstCols = GLUtil.getDataSetCols((DataSet)rstSet);
        rstCols.add(String.format("%s %s", this.qParam.getCurLocal(), "currencylocal"));
        rstCols.add(String.format("case when %s>0 or %s>0 then '1' when %s<0 or %s<0 then '-1' else '0' end %s", "diffamountfor", "diffamountlocal", "diffamountfor", "diffamountlocal", "dc"));
        rstCols.remove("diffamountfor");
        rstCols.remove("diffamountlocal");
        rstCols.add(String.format("case when %s<0 then -1*%s else %s end %s", "diffamountfor", "diffamountfor", "diffamountfor", "diffamountfor"));
        rstCols.add(String.format("case when %s<0 then -1*%s else %s end %s", "diffamountlocal", "diffamountlocal", "diffamountlocal", "diffamountlocal"));
        rstCols.add("'0' rowtype");
        return rstSet.select(rstCols.toArray(new String[0]));
    }

    private DataSet joinNewBalanceSet(DataSet newBalanceSet, DataSet resultSet) {
        List leftCols = GLUtil.getDataSetCols((DataSet)resultSet);
        ArrayList<String> rightCols = new ArrayList<String>(8);
        rightCols.add("newdebitfor");
        rightCols.add("newcreditfor");
        rightCols.add("newdebitlocal");
        rightCols.add("newcreditlocal");
        JoinDataSet nJoinDataSet = resultSet.join(newBalanceSet, JoinType.LEFT).on("newaccountid", "account").on("currencyfor", "currencyfor");
        if (this.qParam.isShowAssist()) {
            nJoinDataSet = nJoinDataSet.on("newassgrpid", "assgrp");
        }
        DataSet rstSet = nJoinDataSet.select(leftCols.toArray(new String[0]), rightCols.toArray(new String[0])).finish();
        List rstCols = GLUtil.getDataSetCols((DataSet)rstSet);
        this.replaceNullCol(rstCols, "newdebitfor");
        this.replaceNullCol(rstCols, "newcreditfor");
        this.replaceNullCol(rstCols, "newdebitlocal");
        this.replaceNullCol(rstCols, "newcreditlocal");
        DataSet accSet = ReportUtils.getAccountInfos((Long)this.qParam.getPorg(), (Long)this.accountTableRef.getNewAccountTableId(), (Date)this.effectiveDate);
        return rstSet.join(accSet, JoinType.INNER).on("newaccountid", "account").select(rstCols.toArray(new String[0]), new String[]{"name newaccountname", "number"}).finish();
    }

    private void replaceNullCol(List<String> rstCols, String field) {
        rstCols.remove(field);
        rstCols.add(String.format("case when %s is null then 0 else %s end %s", field, field, field));
    }

    private DataSet sumOldBalByRef(DataSet resultSet) {
        ArrayList<String> groupFields = new ArrayList<String>(8);
        groupFields.add("newaccountid");
        groupFields.add("currencyfor");
        if (this.qParam.isShowAssist()) {
            groupFields.add("newassgrpid");
        }
        DataSet sumSet = MulOrgQPRpt.gainSumSet((DataSet)resultSet.copy(), (String[])groupFields.toArray(new String[0]), (String[])new String[]{"olddebitfor", "oldcreditfor", "olddebitlocal", "oldcreditlocal"});
        List cols = GLUtil.getDataSetCols((DataSet)sumSet);
        cols.remove("olddebitfor");
        cols.add("olddebitfor olddebitforsum");
        cols.remove("oldcreditfor");
        cols.add("oldcreditfor oldcreditforsum");
        cols.remove("olddebitlocal");
        cols.add("olddebitlocal olddebitlocalsum");
        cols.remove("oldcreditlocal");
        cols.add("oldcreditlocal oldcreditlocalsum");
        return sumSet.select(cols.toArray(new String[0]));
    }

    private DataSet joinAccountRefSet(DataSet oldBalanceSet, DataSet accountRefSet) {
        List balCols = GLUtil.getDataSetCols((DataSet)oldBalanceSet);
        balCols.remove("account");
        balCols.remove("assgrp");
        ArrayList<String> refCols = new ArrayList<String>(8);
        refCols.add("newaccountid");
        refCols.add("oldaccountid");
        JoinDataSet oJoinDataSet = oldBalanceSet.join(accountRefSet, JoinType.INNER).on("account", "oldaccountid");
        if (this.qParam.isShowAssist()) {
            oJoinDataSet = oJoinDataSet.on("assgrp", "oldassgrpid");
            refCols.add("oldassgrpid");
            refCols.add("newassgrpid");
        }
        return oJoinDataSet.select(balCols.toArray(new String[0]), refCols.toArray(new String[0])).finish();
    }

    private DataSet getAccountAssistRefSet(DataSet oldBalanceSet) {
        HashSet<Long> assgrpIds = new HashSet<Long>(1024);
        List<BalInfo> balInfos = this.buildBalInfos(oldBalanceSet, assgrpIds);
        Map<Long, Map<String, Object>> oldAssgrpAndValMap = this.queryAssgrpAndValMap(assgrpIds);
        Map<Long, AccountDetails> newAccountInfoMap = this.queryNewAccountInfo();
        List<FlexEntireData> flexEntireDatas = this.buildNewFlexEntireDatas(balInfos, newAccountInfoMap, oldAssgrpAndValMap);
        Map<String, Long> valAndAssgrpIdMap = this.queryAssgrpIds(flexEntireDatas);
        ArrayList<Object[]> refDatas = new ArrayList<Object[]>(1024);
        RowMeta meta = new RowMeta(new String[]{"oldaccountid", "newaccountid", "oldassgrpid", "newassgrpid"}, new DataType[]{DataType.LongType, DataType.LongType, DataType.LongType, DataType.LongType});
        HashSet<String> balKeys = new HashSet<String>(balInfos.size());
        for (BalInfo balInfo : balInfos) {
            String key;
            String newAssval = balInfo.getNewAssval();
            Long newAssgrpId = 0L;
            if (!StringUtils.isEmpty((String)newAssval)) {
                newAssgrpId = valAndAssgrpIdMap.get(newAssval);
            }
            if (!balKeys.add(key = balInfo.getOldAcctId() + "-" + balInfo.getNewAcctId() + "-" + balInfo.getOldAssgrpId() + "-" + newAssgrpId)) continue;
            refDatas.add(new Object[]{balInfo.getOldAcctId(), balInfo.getNewAcctId(), balInfo.getOldAssgrpId(), newAssgrpId});
        }
        return Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSet(refDatas.iterator(), meta);
    }

    private List<BalInfo> buildBalInfos(DataSet oldBalanceSet, Set<Long> assgrpIds) {
        ArrayList<BalInfo> balInfos = new ArrayList<BalInfo>(1024);
        try (DataSet tmpSet = oldBalanceSet.copy();){
            for (Row row : tmpSet) {
                Long oldAssgrpId = row.getLong("assgrp");
                assgrpIds.add(oldAssgrpId);
                Long oldAccountId = row.getLong("account");
                Long newAccountId = this.accountTableRef.getNewAccountId(oldAccountId);
                BalInfo balInfo = new BalInfo();
                balInfo.setOldAcctId(oldAccountId);
                balInfo.setOldAssgrpId(oldAssgrpId);
                balInfo.setNewAcctId(newAccountId);
                balInfos.add(balInfo);
            }
        }
        return balInfos;
    }

    private List<FlexEntireData> buildNewFlexEntireDatas(List<BalInfo> balInfos, Map<Long, AccountDetails> newAccountInfoMap, Map<Long, Map<String, Object>> oldAssgrpAndValMap) {
        ArrayList<FlexEntireData> flexEntireDatas = new ArrayList<FlexEntireData>(1024);
        for (BalInfo balInfo : balInfos) {
            FlexEntireData flexEntireData = new FlexEntireData();
            ArrayList<FlexEntireData.FlexData> flexDatas = new ArrayList<FlexEntireData.FlexData>(32);
            Long oldAccountId = balInfo.getOldAcctId();
            Long oldAssgrpId = balInfo.getOldAssgrpId();
            AssGrpDefaultVal newAssgrpVals = this.accountTableRef.getNewDefaultAssgrp(oldAccountId);
            Long newAccountId = this.accountTableRef.getNewAccountId(oldAccountId);
            AccountDetails accountDetails = newAccountInfoMap.get(newAccountId);
            if (accountDetails == null) continue;
            Set newFlexFields = accountDetails.getFlexFields();
            if (oldAssgrpId.equals(0L)) {
                this.buildAssvalWithZeorAssgrp(flexEntireData, newAssgrpVals, newFlexFields, flexDatas);
            } else {
                Map<String, Object> oldAssgrpVals = oldAssgrpAndValMap.get(oldAssgrpId);
                this.buildAssvalWithNoZeorAssgrp(flexEntireData, newAssgrpVals, newFlexFields, oldAssgrpVals, flexDatas);
            }
            if (flexDatas.isEmpty()) continue;
            flexEntireData.setFlexDatas(flexDatas);
            String newAssval = flexEntireData.concatFlexData();
            balInfo.setNewAssval(newAssval);
            flexEntireDatas.add(flexEntireData);
        }
        return flexEntireDatas;
    }

    private Map<String, Long> queryAssgrpIds(List<FlexEntireData> flexEntireDatas) {
        MainEntityType mainEntity = new MainEntityType();
        mainEntity.setAlias(T_GL_ASSIST);
        mainEntity.setDBRouteKey(GL);
        return FlexSaveService.batchSaveFlexData((MainEntityType)mainEntity, flexEntireDatas);
    }

    private Map<Long, Map<String, Object>> queryAssgrpAndValMap(Set<Long> assgrpIds) {
        Map map;
        HashMap<Long, Map<String, Object>> oldAssgrpAndValMap = new HashMap<Long, Map<String, Object>>(1024);
        try (DataSet assistSet = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + ".handle"), (String)GL_ASSIST_BD, (String)"hg, asstype, assval", (QFilter[])new QFilter[]{new QFilter("hg", "in", assgrpIds)}, null);){
            for (Row row : assistSet) {
                map = oldAssgrpAndValMap.computeIfAbsent(row.getLong("hg"), k -> new HashMap(32));
                map.put(row.getString("asstype"), row.get("assval"));
            }
        }
        assistSet = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + ".handle"), (String)GL_ASSIST_TXT, (String)"hg, asstype, assval", (QFilter[])new QFilter[]{new QFilter("hg", "in", assgrpIds)}, null);
        var4_4 = null;
        try {
            for (Row row : assistSet) {
                map = oldAssgrpAndValMap.computeIfAbsent(row.getLong("hg"), k -> new HashMap(32));
                map.put(row.getString("asstype"), row.get("assval"));
            }
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (assistSet != null) {
                if (var4_4 != null) {
                    try {
                        assistSet.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    assistSet.close();
                }
            }
        }
        return oldAssgrpAndValMap;
    }

    private Map<Long, AccountDetails> queryNewAccountInfo() {
        DynamicObject[] accounts;
        HashMap<Long, AccountDetails> idAndDetailsMap = new HashMap<Long, AccountDetails>(1024);
        for (DynamicObject account : accounts = BusinessDataServiceHelper.load((Object[])this.accountTableRef.getNewAccountIdSet().toArray(new Long[0]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_accountview"))) {
            DynamicObjectCollection assistEntry = account.getDynamicObjectCollection("checkitementry");
            HashSet<String> lstFields = new HashSet<String>(16);
            for (DynamicObject assistRow : assistEntry) {
                String fieldName = assistRow.getString(ASSTACTITEM_FLEXFIELD);
                lstFields.add(fieldName);
            }
            AccountDetails accountDetails = new AccountDetails();
            Long masterId = account.getLong("masterid");
            accountDetails.setMasterId(masterId);
            accountDetails.setFlexFields(lstFields);
            Long id = account.getLong("id");
            idAndDetailsMap.put(id, accountDetails);
        }
        return idAndDetailsMap;
    }

    private DataSet getAccountRefSet() {
        RowMeta meta = new RowMeta(new String[]{"oldaccountid", "newaccountid"}, new DataType[]{DataType.LongType, DataType.LongType});
        ArrayList<Object[]> datas = new ArrayList<Object[]>(1024);
        for (Long newAcctId : this.accountTableRef.getNewAccountIdSet()) {
            Set oldAcctIds = this.accountTableRef.getOldAccountIds(newAcctId);
            for (Long oldAcctId : oldAcctIds) {
                datas.add(new Object[]{oldAcctId, newAcctId});
            }
        }
        return Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSet(datas.iterator(), meta);
    }

    private DataSet queryBalance(ReportQueryParam queryParam, boolean isQueryOldBal) {
        FilterInfo filterInfo = queryParam.getFilter();
        QueryParam param = new QueryParam();
        String currencyId = filterInfo.getString("currency");
        if (!"basecurrency".equals(currencyId) && !"allcurrency".equals(currencyId)) {
            param.setCurrencyIds(new Long[]{Long.valueOf(currencyId)});
        }
        param.setOnlyLeafAcctBal(true);
        Long acctTblId = 0L;
        Long periodId = filterInfo.getLong("effectiveperiod");
        if (isQueryOldBal) {
            DynamicObject prePeriod = GLUtil.getPreviousPeriod((Object)periodId);
            if (prePeriod == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u671f\u95f4%s\u7684\u4e0a\u4e00\u4e2a\u671f\u95f4\u4e0d\u5b58\u5728\u3002", (String)"AccountRefBalanceRptPlugin_2", (String)"fi-gl-report", (Object[])new Object[0]), periodId));
            }
            periodId = prePeriod.getLong("id");
            acctTblId = this.accountTableRef.getOldAccountTableId();
            param.setAccountFilter(new QFilter("id", "in", (Object)this.accountTableRef.getOldAccountIdSet()));
        } else {
            acctTblId = this.accountTableRef.getNewAccountTableId();
            param.setAccountFilter(new QFilter("id", "in", (Object)this.accountTableRef.getNewAccountIdSet()));
        }
        String accountNameField = GLUtil.getAcctNameBySysParam((Long)this.qParam.getPorg());
        String selectFields = String.format(SELECT_FIELDS, accountNameField);
        if (this.qParam.isShowAssist()) {
            selectFields = selectFields + ",assgrp";
        }
        DataSet dSet = BalanceQueryExecutor.getInstance().getBalance(selectFields, this.qParam.getFilteredChildOrg().toArray(new Long[0]), this.qParam.getBookType(), acctTblId.longValue(), periodId.longValue(), periodId.longValue(), param);
        List list = GLUtil.getDataSetCols((DataSet)dSet);
        list.remove("name");
        if (isQueryOldBal) {
            list.remove("endfor");
            list.remove("endlocal");
            list.add("case when endfor>0 then endfor else 0.0 end as olddebitfor");
            list.add("case when endfor>0 then 0.0 else -1*endfor end as oldcreditfor");
            list.add("case when endlocal>0 then endlocal else 0.0 end as olddebitlocal");
            list.add("case when endlocal>0 then 0.0 else -1*endlocal end as oldcreditlocal");
            list.add("name oldaccountname");
        } else {
            list.remove("beginfor");
            list.remove("beginlocal");
            list.add("case when beginfor>0 then beginfor else 0.0 end as newdebitfor");
            list.add("case when beginfor>0 then 0.0 else -1*beginfor end as newcreditfor");
            list.add("case when beginlocal>0 then beginlocal else 0.0 end as newdebitlocal");
            list.add("case when beginlocal>0 then 0.0 else -1*beginlocal end as newcreditlocal");
        }
        return dSet.select(list.toArray(new String[0]));
    }

    private void buildAssvalWithZeorAssgrp(FlexEntireData flexEntireData, AssGrpDefaultVal newAssgrpVals, Set<String> newFlexFields, List<FlexEntireData.FlexData> flexDatas) {
        for (String flexField : newFlexFields) {
            FlexEntireData.FlexData flexData = null;
            Object defaultAssval = newAssgrpVals.getDefaultAssgrpId(flexField);
            if (defaultAssval != null) {
                flexData = this.buildFlexData(flexField, defaultAssval, flexEntireData);
            }
            if (flexData == null) continue;
            flexDatas.add(flexData);
        }
    }

    private void buildAssvalWithNoZeorAssgrp(FlexEntireData flexEntireData, AssGrpDefaultVal newAssgrpVals, Set<String> newFlexFields, Map<String, Object> oldAssgrpVals, List<FlexEntireData.FlexData> flexDatas) {
        if (oldAssgrpVals != null) {
            for (String flexField : newFlexFields) {
                FlexEntireData.FlexData flexData = null;
                Object assval = oldAssgrpVals.get(flexField);
                if (assval != null) {
                    flexData = this.buildFlexData(flexField, assval, flexEntireData);
                } else {
                    Object defaultAssval = newAssgrpVals.getDefaultAssgrpId(flexField);
                    if (defaultAssval != null) {
                        flexData = this.buildFlexData(flexField, defaultAssval, flexEntireData);
                    }
                }
                if (flexData == null) continue;
                flexDatas.add(flexData);
            }
        }
    }

    private FlexEntireData.FlexData buildFlexData(String flexField, Object assval, FlexEntireData flexEntireData) {
        FlexEntireData.FlexData flexData = new FlexEntireData.FlexData(flexEntireData);
        if (assval instanceof Long) {
            flexData.setDbType(FlexEntireData.FlexFieldDataType.LONG);
        } else if (assval instanceof String) {
            flexData.setDbType(FlexEntireData.FlexFieldDataType.STRING);
        }
        flexData.setPropId(flexField);
        flexData.setValue(assval);
        return flexData;
    }

    private static class BalInfo {
        private Long oldAcctId;
        private Long oldAssgrpId;
        private Long newAcctId;
        private String newAssval;

        private BalInfo() {
        }

        public Long getOldAcctId() {
            return this.oldAcctId;
        }

        public void setOldAcctId(Long oldAcctId) {
            this.oldAcctId = oldAcctId;
        }

        public Long getOldAssgrpId() {
            return this.oldAssgrpId;
        }

        public void setOldAssgrpId(Long oldAssgrpId) {
            this.oldAssgrpId = oldAssgrpId;
        }

        public Long getNewAcctId() {
            return this.newAcctId;
        }

        public void setNewAcctId(Long newAcctId) {
            this.newAcctId = newAcctId;
        }

        public String getNewAssval() {
            return this.newAssval;
        }

        public void setNewAssval(String newAssval) {
            this.newAssval = newAssval;
        }
    }
}

