/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportTreeDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.entity.tree.TreeNode;
import kd.bos.orm.ORM;
import kd.bos.orm.query.Distinctable;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.WithDistinctable;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.util.AccountUtils;
import kd.fi.gl.accountref.utils.BalanceTransferUtils;
import kd.fi.gl.reciprocal.ReciprocalUtils;
import kd.fi.gl.report.MulOrgQPRpt;
import kd.fi.gl.report.ReportUtils;
import kd.fi.gl.util.GLUtil;
import org.apache.commons.lang3.tuple.Pair;

public class AgingTreeLeftRpt
extends AbstractReportTreeDataPlugin {
    private static final String ACCT_SELECT_FIELD = "id,%s name,number,masterid,accounttype,accounttype.parent parent,accounttype.name typename,accounttype.level level";
    private MulOrgQPRpt qParam;

    public List<TreeNode> query(ReportQueryParam param, String selectedObj) throws Throwable {
        this.qParam = new MulOrgQPRpt(param.getFilter(), "gl_rpt_agingschedule");
        DynamicObjectCollection acctCol = this.getAccountCollection(param);
        return this.createAccountTree(acctCol);
    }

    public DynamicObjectCollection getAccountCollection(ReportQueryParam param) throws Exception {
        FilterInfo filter = param.getFilter();
        Set<Long> acctIdSet = this.filterVaildAcctId(filter, this.qParam);
        Long accountTableId = filter.getLong("accounttable");
        String currencyId = filter.getString("currency");
        QFilter orgFilter = new QFilter("org", "in", (Object)this.qParam.getChildOrg());
        QFilter booktypeFilter = new QFilter("booktype", "=", (Object)filter.getLong("booktype"));
        QFilter accounttableFilter = new QFilter("accounttable", "=", (Object)accountTableId);
        QFilter currencyFilter = null;
        if (!("allcurrency".equals(currencyId) || "basecurrency".equals(currencyId) || "reportcurrency".equals(currencyId))) {
            currencyFilter = new QFilter("currency", "=", (Object)Long.valueOf(currencyId));
        }
        HashSet<Long> acctMasterIdCheckSet = new HashSet<Long>(8);
        QFilter acctCheckFilter = new QFilter("id", "in", acctIdSet);
        acctCheckFilter.and(new QFilter("account.checkitementry.enaccheck", "=", (Object)"1"));
        try (DataSet accds = QueryServiceHelper.queryDataSet((String)"AgingTreeLeftRpt.getAccountCollection", (String)"bd_accountview", (String)"masterid", (QFilter[])acctCheckFilter.toArray(), null);){
            while (accds.hasNext()) {
                acctMasterIdCheckSet.add(accds.next().getLong("masterid"));
            }
        }
        HashSet<Long> existBalAcctMasterId = new HashSet<Long>(acctMasterIdCheckSet.size());
        ArrayList<QFilter> balFilter = new ArrayList<QFilter>(6);
        balFilter.add(orgFilter);
        balFilter.add(booktypeFilter);
        balFilter.add(accounttableFilter);
        balFilter.add(currencyFilter);
        balFilter.add(new QFilter("account", "in", acctMasterIdCheckSet));
        try (DataSet accds = QueryServiceHelper.queryDataSet((String)"AgingTreeLeftRpt.getAccountCollection", (String)"gl_balance", (String)"account.id id", (QFilter[])balFilter.toArray(new QFilter[0]), null);){
            while (accds.hasNext()) {
                Row row = accds.next();
                existBalAcctMasterId.add(row.getLong("id"));
            }
        }
        boolean showLeafAccount = filter.getBoolean("showleafaccount");
        Date bookeddate = filter.getDate("bookeddate");
        QFilter balAcctFilter = new QFilter("masterid", "in", existBalAcctMasterId);
        balAcctFilter.and(BalanceTransferUtils.getAccountRefFilter((Date)bookeddate));
        Pair pair = Pair.of(new HashSet(existBalAcctMasterId.size()), new HashSet(acctMasterIdCheckSet.size()));
        try (DataSet accds = QueryServiceHelper.queryDataSet((String)"AgingTreeLeftRpt.getAccountCollection", (String)"bd_accountview", (String)"id, longnumber", (QFilter[])balAcctFilter.toArray(), null);){
            while (accds.hasNext()) {
                Row row = accds.next();
                ((Set)pair.getLeft()).add(row.getLong("id"));
                if (showLeafAccount) continue;
                ((Set)pair.getRight()).add(row.getString("longnumber"));
            }
        }
        long orgId = Optional.ofNullable(filter.getCommFilter()).map(x -> (QFilter)x.get("parentOrg")).map(x -> Long.parseLong(x.getValue().toString())).orElse(0L);
        QFilter filters = BalanceTransferUtils.getAccountRefFilter((Date)bookeddate);
        if (showLeafAccount) {
            filters.and(new QFilter("id", "in", pair.getLeft()));
        } else {
            HashSet superNumbers = new HashSet(16);
            ((Set)pair.getRight()).forEach(v -> {
                String[] split = v.split("_");
                superNumbers.addAll(Arrays.asList(split));
            });
            filters.and(new QFilter("number", "in", superNumbers));
        }
        Set acctIds = AccountUtils.queryAccountIds((long)orgId, (long)accountTableId, Collections.singletonList(filters));
        QFilter acctF = new QFilter("id", "in", (Object)acctIds);
        if (!showLeafAccount) {
            acctF.and(new QFilter("level", "<=", (Object)filter.getInt("accountlevel")));
        }
        String accountNameField = GLUtil.getAcctNameBySysParam((Long)((Long)this.qParam.getOrgs().get(0)));
        String selectFields = String.format(ACCT_SELECT_FIELD, accountNameField);
        return QueryServiceHelper.query((String)(((Object)((Object)this)).getClass().getName() + ".getAccount"), (String)"bd_accountview", (String)selectFields, (QFilter[])acctF.toArray(), (String)"number");
    }

    private Set<Long> filterVaildAcctId(FilterInfo filter, MulOrgQPRpt qParam) {
        QFilter validAcctFilter = this.setAccountFilter(filter, qParam);
        List items = filter.getFlexFilterItems();
        if (items.size() > 0) {
            HashSet<String> flexFields = new HashSet<String>(items.size());
            for (FilterItemInfo filterItemInfo : items) {
                String propName = filterItemInfo.getPropName();
                flexFields.add(propName);
            }
            validAcctFilter.and("checkitementry.asstactitem.flexfield", "in", flexFields);
            validAcctFilter.and("checkitementry.enaccheck", "=", (Object)"1");
        }
        HashSet<Long> acctIdSet = new HashSet<Long>(8);
        try (DataSet validAcctDs = ORM.create().queryDataSet(((Object)((Object)this)).getClass().getName(), "bd_accountview", "masterid", validAcctFilter.toArray(), "", -1, (Distinctable)WithDistinctable.get());){
            while (validAcctDs.hasNext()) {
                acctIdSet.add(validAcctDs.next().getLong("masterid"));
            }
        }
        return acctIdSet;
    }

    private QFilter setAccountFilter(FilterInfo filter, MulOrgQPRpt qParam) {
        Set idSet;
        DynamicObjectCollection accountColl = filter.getDynamicObjectCollection("account");
        HashSet<Object> accountPkSet = new HashSet<Object>();
        if (accountColl != null && !accountColl.isEmpty()) {
            for (DynamicObject account : accountColl) {
                accountPkSet.add(account.getPkValue());
            }
        }
        if ((idSet = ReportUtils.getAllMasterIdSet((String)"bd_accountview", accountPkSet)).isEmpty()) {
            List recpScheme = ReciprocalUtils.loadRcpSchemes((FilterInfo)filter);
            recpScheme.forEach(x -> idSet.addAll(x.getAccountList()));
            QFilter initActFilter = ReciprocalUtils.queryEndInitActFilter((Set)qParam.getChildOrg(), (Long)qParam.getBookType());
            Set initAcct = (Set)initActFilter.getValue();
            idSet.retainAll(initAcct);
        }
        return new QFilter("masterid", "in", (Object)idSet);
    }

    private List<TreeNode> createAccountTree(DynamicObjectCollection accounts) {
        ArrayList<TreeNode> treeList = new ArrayList<TreeNode>();
        String rootNode = "0";
        TreeNode node = this.createTreeNode(null, rootNode, ResManager.loadKDString((String)"\u79d1\u76ee", (String)"AgingTreeLeftRpt_0", (String)"fi-gl-report", (Object[])new Object[0]), true);
        treeList.add(node);
        boolean i = false;
        boolean isOpen = true;
        HashSet<String> numList = new HashSet<String>();
        for (DynamicObject acct : accounts) {
            String number;
            if (i) {
                isOpen = false;
            }
            if (numList.contains(number = acct.getString("number"))) continue;
            numList.add(number);
            String acctName = acct.getString("name");
            TreeNode acctNode = new TreeNode(rootNode, acct.getString("masterid"), number + " " + acctName);
            acctNode.setIsOpened(isOpen);
            treeList.add(acctNode);
            i = true;
        }
        return treeList;
    }

    private TreeNode createTreeNode(String parentId, String id, String text, boolean isOpen) {
        TreeNode node = new TreeNode(parentId, id, text);
        node.setIsOpened(isOpen);
        return node;
    }
}

