/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.ReduceGroupFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.algo.util.Tuple2;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.service.balance.BalanceQueryExecutor;
import kd.fi.bd.service.balance.QueryParam;
import kd.fi.bd.util.BillParamUtil;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.comassist.model.ComAssistTable;
import kd.fi.gl.comassist.service.ComAssistTableService;
import kd.fi.gl.common.Tuple;
import kd.fi.gl.enums.basedata.AssistValueType;
import kd.fi.gl.report.ReportUtils;
import kd.fi.gl.report.subsidiary.AssistBalanceQuery;
import kd.fi.gl.report.subsidiary.SubsidiaryPeriod;
import kd.fi.gl.report.subsidiary.SubsidiaryReportDatasetBuilder;
import kd.fi.gl.util.BaseDataUtil;
import kd.fi.gl.util.FlexUtils;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.PermissonType;
import kd.fi.gl.vo.NameHistoryVO;
import org.apache.commons.lang3.tuple.Triple;

public class AssistActBalanceReportPlugin
extends AbstractReportListDataPlugin {
    private static final Log logger = LogFactory.getLog(AssistActBalanceReportPlugin.class);
    private boolean iscount = false;
    private boolean isleafaccount = false;
    private boolean iszeroamount = false;
    private boolean iszerobalance = false;
    private boolean issyncur = false;
    private boolean isallcur = false;
    private boolean issubstractpl = false;
    private boolean isShowSum = false;
    private long org;
    private long booktype;
    private long startperiod;
    private long endperiod;
    private long periodType;
    private long currency = -1L;
    private long accounttable;
    private List<Long> accountIdList;
    private int accountlevel;
    private List<Long> measureunitList;
    private long currencyLocal;
    private Map<String, Set<Object>> assistMap = new LinkedHashMap<String, Set<Object>>();
    private static final String ASSIST_DB = "gl_assist_bd";
    private static final String ASSIST_TXT = "gl_assist_txt";
    private static final String ASSIST_TYPE = "bd_asstacttype";
    private static final String acctView = "bd_accountview";
    private static final String SHOW_SUM = "showsum";
    private List<String> assTxtList = new ArrayList<String>();
    private List<String> dataSetCols;
    private List<String> COMASSIST_BAL_LIST = new ArrayList<String>(8);
    private List<String> COMASSIST_LIST = new ArrayList<String>(8);
    List<Tuple2<String, Set<Long>>> COMASSIST_VALUE_LIST = new ArrayList<Tuple2<String, Set<Long>>>(16);
    private Map<String, String> flexFieldEntityIdMap = new HashMap<String, String>(16);
    private Map<String, Tuple<String, String>> flexFieldPropMap = new HashMap<String, Tuple<String, String>>(16);
    private Map<Long, SubsidiaryPeriod> periodMap;
    static final List<String> SUM_GRP = Arrays.asList("flexfield", "asstypename", "assvalname", "assvalnumber", "accountnumber", "currencyid", "measureunit");
    private static final String[] yearbeginField = new String[]{"yearbeginfor", "yearbegindebitlocal", "yearbegincreditlocal", "yearbeginqty"};
    private static final String[] beginField = new String[]{"periodbeginfor", "debitbeginlocal", "creditbeginlocal", "periodbeginqty"};
    private static final String[] periodField = new String[]{"debitfor", "debitlocal", "debitqty", "creditfor", "creditlocal", "creditqty", "count"};
    private static final String[] yearField = new String[]{"yeardebitfor", "yeardebitlocal", "yeardebitqty", "yearcreditfor", "yearcreditlocal", "yearcreditqty"};
    private static final String[] endField = new String[]{"endfor", "debitendlocal", "creditendlocal", "endqty"};
    private static final String[] grpBy = new String[]{"asstypename", "flexfield", "assid", "assvalnumber", "assvalname", "actid", "accountnumber", "accountid", "dc"};

    private void init(ReportQueryParam param) {
        List value;
        List value2;
        FilterInfo filter = param.getFilter();
        this.iscount = filter.getBoolean("showqty");
        this.isleafaccount = filter.getBoolean("showleafaccount");
        this.iszeroamount = filter.getBoolean("nodisplayforzero");
        this.iszerobalance = filter.getBoolean("balancezero");
        this.issubstractpl = filter.getBoolean("issubstractpl");
        this.isShowSum = filter.getBoolean(SHOW_SUM);
        this.org = filter.getLong("org");
        this.booktype = filter.getLong("booktype");
        AccountBookInfo bookdyn = AccSysUtil.getBookFromAccSys((long)this.org, (long)this.booktype);
        this.currencyLocal = bookdyn.getBaseCurrencyId();
        this.startperiod = filter.getLong("startperiod");
        this.endperiod = filter.getLong("endperiod");
        this.periodType = filter.getLong("periodtype");
        String curStr = filter.getString("currency");
        if ("basecurrency".equals(curStr)) {
            this.issyncur = true;
        } else if ("allcurrency".equals(curStr)) {
            this.isallcur = true;
        } else {
            this.currency = Long.parseLong(curStr);
        }
        this.accounttable = filter.getLong("accounttable");
        FilterItemInfo itemInfo = filter.getFilterItem("account");
        if (itemInfo != null && (value2 = (List)itemInfo.getValue()) != null) {
            this.accountIdList = new ArrayList<Long>(2);
            for (Object dyn : value2) {
                this.accountIdList.add(dyn.getLong("id"));
            }
        }
        this.accountlevel = filter.getInt("accountlevel");
        FilterItemInfo unitInfo = filter.getFilterItem("measureunits");
        if (unitInfo != null && (value = (List)unitInfo.getValue()) != null) {
            this.measureunitList = new ArrayList<Long>(1);
            for (DynamicObject dyn : value) {
                this.measureunitList.add(dyn.getLong("id"));
            }
        }
        List items = filter.getFlexFilterItems();
        ArrayList<String> flexFieldList = new ArrayList<String>(4);
        for (FilterItemInfo filterItemInfo : items) {
            String propName = filterItemInfo.getPropName();
            flexFieldList.add(propName);
            this.assistMap.put(propName, new HashSet(64));
        }
        this.fillAssistTxtType(flexFieldList);
        this.accounttable = filter.getLong("accounttable");
        this.periodMap = SubsidiaryReportDatasetBuilder.initPeriodMap((FilterInfo)param.getFilter());
        this.setComassist(param);
    }

    private DataSet queryPeriods(long begin, long end) {
        String selectFields = "id period,periodnumber periodnumber,periodtype,periodyear";
        QFilter filterBegin = new QFilter("id", ">=", (Object)begin);
        QFilter filterEnd = new QFilter("id", "<=", (Object)end);
        QFilter filterType = new QFilter("periodtype", "=", (Object)this.periodType);
        DataSet periodSet = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + ".periodid"), (String)"bd_period", (String)selectFields, (QFilter[])filterBegin.and(filterEnd).and(filterType).toArray(), null);
        return periodSet;
    }

    private void fillAssistTxtType(List<String> propNameList) {
        QFilter qFilter = new QFilter("flexfield", "in", propNameList);
        DataSet assistSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)ASSIST_TYPE, (String)"id, valuetype, flexfield", (QFilter[])new QFilter[]{qFilter}, null);
        for (Row row : assistSet) {
            if (!"3".equals(row.getString("valuetype"))) continue;
            this.assTxtList.add(row.getString("flexfield"));
        }
    }

    public DataSet query(ReportQueryParam param, Object obj) throws Throwable {
        this.org = param.getFilter().getLong("org");
        List permOrgList = AccSysUtil.getAcctOrgPkList((String)"gl_rpt_assistactbalance", (boolean)false, (PermissonType)PermissonType.VIEW);
        if (!permOrgList.contains(this.org)) {
            return GLUtil.getEmptyDS(((Object)((Object)this)).getClass());
        }
        this.init(param);
        DataSet ds = this.queryBase(param);
        if (ds.isEmpty()) {
            return GLUtil.getEmptyDS(((Object)((Object)this)).getClass());
        }
        List flexItems = param.getFilter().getFlexFilterItems();
        StringBuilder orderStr = new StringBuilder(" case ");
        for (int i = 0; i < flexItems.size(); ++i) {
            FilterItemInfo info = (FilterItemInfo)flexItems.get(i);
            orderStr.append(String.format(" when flexfield = '%s' then %d ", info.getPropName(), i));
        }
        orderStr.append(" else 99999 end ");
        ds = ds.addField(orderStr.toString(), "orderflexfield").orderBy(new String[]{"orderflexfield asc", "assvalnumber", "accountnumber asc", "assorder desc"});
        if (this.isleafaccount) {
            ds = ds.filter("accountlevel <= " + this.accountlevel);
        }
        ds = ds.addField(String.valueOf(this.currencyLocal), "currencylocalid");
        return ds;
    }

    private DataSet gainSumSet(DataSet ds, String flag) {
        List<String> cols = AssistActBalanceReportPlugin.getDataSetCols(ds);
        ArrayList<String> groupBy = new ArrayList<String>();
        groupBy.add("flexfield");
        if (this.iscount) {
            groupBy.add("measureunit");
        } else {
            cols.removeIf(x -> x.equals("measureunit"));
        }
        if (!this.issyncur) {
            groupBy.add("currencyid");
        } else {
            cols.removeIf(x -> x.equals("currencyid"));
        }
        if ("sumacct".equals(flag)) {
            List<String> groups = this.getSumGroup();
            groupBy.addAll(groups);
            ds = ds.groupBy(groupBy.toArray(new String[0])).sum("beginfor").sum("beginlocal").sum("beginqty").sum("debitfor").sum("debitlocal").sum("debitqty").sum("creditfor").sum("creditlocal").sum("creditqty").sum("yeardebitfor").sum("yeardebitlocal").sum("yeardebitqty").sum("yearcreditfor").sum("yearcreditlocal").sum("yearcreditqty").sum("endfor").sum("endlocal").sum("endqty").sum("count").finish();
            ds = ds.select(cols.toArray(new String[0]));
        } else {
            List<String> sumGroupList = this.getSumGroup();
            sumGroupList.add("periodyear");
            sumGroupList.add("periodnumber");
            String sumName = ResManager.loadKDString((String)"\u7ef4\u5ea6\u7c7b\u578b\u5c0f\u8ba1", (String)"AssistActBalanceReportPlugin_0", (String)"fi-gl-report", (Object[])new Object[0]);
            int assorderVal = 2;
            if ("sumvalue".equals(flag)) {
                groupBy.add("asstypename");
                groupBy.add("assvalnumber");
                groupBy.add("assvalname");
            } else if ("sumtype".equals(flag)) {
                groupBy.add("asstypename");
                sumName = ResManager.loadKDString((String)"\u7ef4\u5ea6\u7c7b\u578b\u5c0f\u8ba1", (String)"AssistActBalanceReportPlugin_0", (String)"fi-gl-report", (Object[])new Object[0]);
                assorderVal = 3;
            } else if ("total".equals(flag)) {
                sumGroupList.addAll(groupBy);
                groupBy = new ArrayList();
                sumName = ResManager.loadKDString((String)"\u603b\u5408\u8ba1", (String)"AssistActBalanceReportPlugin_1", (String)"fi-gl-report", (Object[])new Object[0]);
                assorderVal = 4;
            }
            sumGroupList.removeAll(groupBy);
            ds = this.sumAssistTotal(ds, groupBy);
            this.clearQtyAndCurrency(sumGroupList, cols);
            ArrayList<String> sumGroups = new ArrayList<String>();
            for (String field : sumGroupList) {
                if ("assvalname".equals(field)) {
                    sumGroups.add("'" + sumName + "'" + field);
                    continue;
                }
                sumGroups.add("null " + field);
            }
            sumGroupList.add("assorder");
            sumGroups.add(assorderVal + " assorder");
            ArrayList<String> allGroupList = new ArrayList<String>();
            allGroupList.addAll(cols);
            allGroupList.removeAll(sumGroupList);
            allGroupList.addAll(sumGroups);
            ds = ds.select(allGroupList.toArray(new String[0]));
            ds = ds.select(cols.toArray(new String[0]));
        }
        return ds;
    }

    private void clearQtyAndCurrency(List<String> sumGroupList, List<String> cols) {
        for (String field : cols) {
            if (this.iscount && field.endsWith("qty") && !sumGroupList.contains(field)) {
                sumGroupList.add(field);
            }
            if (!this.isallcur && !this.issyncur || !field.endsWith("for") || sumGroupList.contains(field)) continue;
            sumGroupList.add(field);
        }
    }

    void sum(int[] periodIdxes, Object[] totalRow, Row curRow) {
        for (int periodIdx : periodIdxes) {
            BigDecimal amt = curRow.getBigDecimal(periodIdx);
            totalRow[periodIdx] = ((BigDecimal)totalRow[periodIdx]).add(amt == null ? BigDecimal.ZERO : amt);
        }
    }

    long getEndPeriod() {
        return this.endperiod;
    }

    Set<String> getDetailGrp() {
        HashSet<String> detailGrp = new HashSet<String>(this.COMASSIST_LIST);
        detailGrp.addAll(SUM_GRP);
        return detailGrp;
    }

    DataSet sumAssistTotal(DataSet balance, List<String> sumGrp) {
        final RowMeta rowMeta = balance.getRowMeta();
        final Set<String> detailGrp = this.getDetailGrp(rowMeta, sumGrp);
        ArrayList sumFields = new ArrayList(16);
        final int[] beginIdxes = Arrays.stream(this.getSumFields("begin")).peek(sumFields::add).mapToInt(arg_0 -> ((RowMeta)rowMeta).getFieldIndex(arg_0)).toArray();
        final int[] periodIdxes = Arrays.stream(this.getSumFields("period")).peek(sumFields::add).mapToInt(arg_0 -> ((RowMeta)rowMeta).getFieldIndex(arg_0)).toArray();
        final int[] yearBeginIdxes = Arrays.stream(this.getSumFields("yearbegin")).peek(sumFields::add).mapToInt(arg_0 -> ((RowMeta)rowMeta).getFieldIndex(arg_0)).toArray();
        final int[] yearIdxes = Arrays.stream(this.getSumFields("year")).peek(sumFields::add).mapToInt(arg_0 -> ((RowMeta)rowMeta).getFieldIndex(arg_0)).toArray();
        final int[] endIdxes = Arrays.stream(this.getSumFields("end")).peek(sumFields::add).mapToInt(arg_0 -> ((RowMeta)rowMeta).getFieldIndex(arg_0)).toArray();
        final int periodFieldIdx = rowMeta.getFieldIndex("period");
        final long periodYear = GLUtil.getYear((long)this.getEndPeriod());
        GroupbyDataSet grpDs = balance.groupBy(detailGrp.toArray(new String[0])).reduceGroup(new ReduceGroupFunction(){
            private static final long serialVersionUID = 2934020726827488534L;

            public Iterator<Object[]> reduce(Iterator<Row> iterator) {
                long year;
                Object[] totalRow = new Object[rowMeta.getFieldCount()];
                Arrays.fill(totalRow, BigDecimal.ZERO);
                boolean firstRow = true;
                boolean firstYearRow = true;
                Row curRow = null;
                while (iterator.hasNext()) {
                    curRow = iterator.next();
                    year = GLUtil.getYear((long)curRow.getLong(periodFieldIdx));
                    if (firstRow) {
                        AssistActBalanceReportPlugin.this.sum(beginIdxes, totalRow, curRow);
                        firstRow = false;
                    }
                    if (year == periodYear && firstYearRow) {
                        AssistActBalanceReportPlugin.this.sum(yearBeginIdxes, totalRow, curRow);
                        firstYearRow = false;
                    }
                    AssistActBalanceReportPlugin.this.sum(periodIdxes, totalRow, curRow);
                }
                if (curRow != null) {
                    year = GLUtil.getYear((long)curRow.getLong(periodFieldIdx));
                    if (year == periodYear) {
                        AssistActBalanceReportPlugin.this.sum(yearIdxes, totalRow, curRow);
                    }
                    AssistActBalanceReportPlugin.this.sum(endIdxes, totalRow, curRow);
                    for (String s : detailGrp) {
                        totalRow[rowMeta.getFieldIndex((String)s)] = curRow.get(s);
                    }
                    return Collections.singletonList(totalRow).iterator();
                }
                return null;
            }

            public RowMeta getResultRowMeta() {
                return rowMeta;
            }
        }).groupBy(sumGrp.toArray(new String[0]));
        sumFields.forEach(arg_0 -> ((GroupbyDataSet)grpDs).sum(arg_0));
        return grpDs.finish();
    }

    Set<String> getDetailGrp(RowMeta rowMeta, List<String> sumGrps) {
        Set<String> detailGrp = this.getDetailGrp();
        detailGrp.addAll(sumGrps);
        detailGrp.removeIf(grp -> rowMeta.getFieldIndex(grp, false) == -1);
        return detailGrp;
    }

    String[] getSumFields(String type) {
        String[] list;
        switch (type) {
            case "yearbegin": {
                list = yearbeginField;
                break;
            }
            case "begin": {
                list = beginField;
                break;
            }
            case "period": {
                list = periodField;
                break;
            }
            case "year": {
                list = yearField;
                break;
            }
            case "end": {
                list = endField;
                break;
            }
            default: {
                list = new String[]{};
            }
        }
        return list;
    }

    private List<String> getSumGroup() {
        ArrayList<String> groups = new ArrayList<String>();
        groups.add("asstypename");
        groups.add("assvalnumber");
        groups.add("assvalname");
        groups.add("actid");
        groups.add("accountnumber");
        groups.add("dc");
        groups.add("accountid");
        groups.add("period");
        groups.add("assid");
        groups.addAll(this.COMASSIST_LIST);
        return groups;
    }

    private DataSet queryBase(ReportQueryParam param) {
        long tick = System.currentTimeMillis();
        DataSet ds = this.queryBalance(param);
        if (Objects.isNull(ds) || ds.isEmpty()) {
            return GLUtil.getEmptyDS(((Object)((Object)this)).getClass());
        }
        logger.info("queryBalance cost:{}ms", (Object)(System.currentTimeMillis() - tick));
        tick = System.currentTimeMillis();
        logger.info("buildFinalBalannceDataSet cost:{}ms", (Object)(System.currentTimeMillis() - tick));
        tick = System.currentTimeMillis();
        ds = this.gainSumSet(ds, "sumacct");
        ds = this.dealSum(ds);
        if (this.dataSetCols == null) {
            this.dataSetCols = AssistActBalanceReportPlugin.getDataSetCols(ds);
        }
        ds = ds.addField("1", "assorder");
        ArrayList<String> orderList = new ArrayList<String>();
        orderList.add("flexfield");
        if (!this.issyncur) {
            orderList.add("currencyid");
        }
        if (this.iscount) {
            orderList.add("measureunit");
        }
        StringBuilder filterBuilder = new StringBuilder();
        if (this.iszeroamount) {
            if (!this.issyncur) {
                filterBuilder.append(" debitfor != 0.0 or creditfor != 0.0 or ");
            }
            filterBuilder.append(" debitlocal != 0.0 or creditlocal != 0.0 or count > 0");
        }
        if (this.iszerobalance) {
            if (filterBuilder.length() > 0) {
                filterBuilder.append(" or ");
            }
            if (!this.issyncur) {
                filterBuilder.append(" endfor != 0.0 or ");
            }
            filterBuilder.append(" debitendlocal != 0.0 or creditendlocal != 0.0 ");
        }
        if (filterBuilder.length() > 0) {
            ds = ds.filter(filterBuilder.toString());
        }
        DataSet totalSet = this.gainSumSet(ds.copy(), "total");
        if (this.isShowSum) {
            DataSet sumValSet = this.gainSumSet(ds.copy(), "sumvalue");
            DataSet sumTypeSet = this.gainSumSet(ds.copy(), "sumtype");
            ds = ds.union(sumValSet);
            ds = ds.addField("1", "typeorder");
            sumTypeSet = sumTypeSet.addField("2", "typeorder");
            ds = ds.union(sumTypeSet);
            orderList.add("typeorder");
        }
        orderList.add("assvalnumber");
        orderList.add("assvalname");
        orderList.add("assorder");
        ds = ds.orderBy(orderList.toArray(new String[0]));
        if (this.isShowSum) {
            ds = ds.removeFields(new String[]{"typeorder"});
        }
        ds = ds.union(totalSet);
        ds = this.replaceHistoryName(ds);
        logger.info("join cost:{}ms", (Object)(System.currentTimeMillis() - tick));
        return ds;
    }

    private DataSet replaceHistoryName(DataSet ds) {
        HashMap<String, NameHistoryVO> flexVOMap = new HashMap<String, NameHistoryVO>(32);
        for (Row row : ds.copy()) {
            if (Objects.isNull(row.getLong("period"))) continue;
            Date nameCtrlDate = this.periodMap.get(row.getLong("period")).getEnddate();
            String flexField = row.getString("flexfield");
            String entityId = this.flexFieldEntityIdMap.get(flexField);
            if (!Objects.nonNull(entityId)) continue;
            String groupKey = String.format("%s_%s", flexField, row.getLong("period"));
            Long assid = row.getLong("assid");
            if (!Objects.nonNull(assid) || assid == 0L) continue;
            NameHistoryVO nameHistoryVO = flexVOMap.computeIfAbsent(groupKey, key -> new NameHistoryVO(entityId, Long.valueOf(this.org), String.format("id,%s name", this.flexFieldPropMap.get((Object)flexField).item1), nameCtrlDate));
            nameHistoryVO.addAssId(assid);
            nameHistoryVO.addProp("period", (Object)row.getLong("period"));
            nameHistoryVO.addProp("flexfield", (Object)row.getString("flexfield"));
        }
        BaseDataUtil.queryBaseDataByDate(flexVOMap.values());
        String[] fieldNames = new String[]{"assistKey", "historyname"};
        DataType[] dataTypes = new DataType[]{DataType.StringType, DataType.StringType};
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])fieldNames, (DataType[])dataTypes);
        DataSetBuilder builder = Algo.create((String)(((Object)((Object)this)).getClass().getName() + "buildAssistDataSet")).createDataSetBuilder(rowMeta);
        flexVOMap.values().stream().forEach(vo -> vo.getAssIdNameMap().entrySet().stream().forEach(entry -> builder.append(new Object[]{String.format("%s_%s_%s", vo.getProp("flexfield"), vo.getProp("period"), entry.getKey()), entry.getValue()})));
        DataSet assistDataSet = builder.build();
        ds = ds.addField("concat(String(flexfield),'_',String(period),'_',String(assid))", "assistKey");
        List<String> finalCols = this.getLeftJoinAssistDataSetCols(ds);
        List cols = GLUtil.getDataSetCols((DataSet)ds);
        ds = ds.join(assistDataSet, JoinType.LEFT).on("assistKey", "assistKey").select(cols.toArray(new String[0]), new String[]{"historyname"}).finish().select(finalCols.toArray(new String[0]));
        return ds;
    }

    private List<String> getLeftJoinAssistDataSetCols(DataSet ds) {
        RowMeta rowMeta = ds.getRowMeta();
        Field[] fields = rowMeta.getFields();
        ArrayList<String> list = new ArrayList<String>(fields.length);
        for (Field field : fields) {
            if ("assvalname".equals(field.getName())) {
                list.add("case when historyname is null then assvalname else historyname end as assvalname");
                continue;
            }
            list.add(field.getName());
        }
        return list;
    }

    private DataSet queryBalance(ReportQueryParam reportQueryParam) {
        ArrayList<String> listFlex = new ArrayList<String>(this.assistMap.keySet());
        QFilter fflex = new QFilter("flexfield", "in", listFlex);
        String algoKey = ((Object)((Object)this)).getClass().getName();
        DataSet assTypeSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)ASSIST_TYPE, (String)"id", (QFilter[])new QFilter[]{fflex}, null);
        ArrayList<Long> assTypeIds = new ArrayList<Long>();
        for (Row row : assTypeSet) {
            assTypeIds.add(row.getLong("id"));
        }
        QFilter faccount = new QFilter("checkitementry.asstactitem.id", "in", assTypeIds);
        DataSet accountSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)acctView, (String)"id", (QFilter[])new QFilter[]{faccount}, null);
        HashSet<Long> accountIds = new HashSet<Long>();
        for (Row acct : accountSet) {
            accountIds.add(acct.getLong("id"));
        }
        if (this.accountIdList != null) {
            accountIds.retainAll(this.accountIdList);
        }
        String selectFields = this.getSelectFields();
        Long[] currencyIds = null;
        if (this.iscount) {
            selectFields = selectFields + ",measureunit";
        }
        if (!this.issyncur && !this.isallcur) {
            currencyIds = new Long[]{this.currency};
        }
        AssistBalanceQuery query = new AssistBalanceQuery(reportQueryParam.getFilter());
        QueryParam param = new QueryParam();
        param.setCurrencyIds(currencyIds);
        param.setOnlyLeafAcctBal(true);
        param.setAccountFilter(new QFilter("id", "in", accountIds));
        if (this.measureunitList != null) {
            param.setMeasureUnitIds(this.measureunitList.toArray(new Long[0]));
        }
        param.setSubstractPL(this.issubstractpl);
        param.setAccountVersionPeriodId(this.endperiod);
        int balancelimit = BillParamUtil.getIntegerValue((String)"83bfebc8000017ac", (String)"fi.gl.report.assistactbal.balancelimit", (int)100000);
        param.setQueryLimit(balancelimit);
        param.getCustomFilter().addAll(this.buildComAssistQfilters());
        selectFields = selectFields + this.comAssistFields();
        Tuple2 customFiltersAndSelectField = query.getCustomFlexPropFilterAndSelectFields(new String[]{AssistBalanceQuery.CustomFlexProperty.ofNoneDetailAlia((String)"assval")});
        ArrayList customF = param.getCustomFilter();
        if (customF == null) {
            customF = new ArrayList(4);
        }
        List flexFilters = (List)customFiltersAndSelectField.t1;
        String[] flexFields = ((String)customFiltersAndSelectField.t2).split(",");
        Map flexMap = FlexUtils.buildFlexValueSourceMap((ReportQueryParam)reportQueryParam);
        ArrayList<DataSet> dsList = new ArrayList<DataSet>(8);
        for (int i = 0; i < flexFilters.size(); ++i) {
            ArrayList<QFilter> singleFlexFilters = new ArrayList<QFilter>(customF);
            singleFlexFilters.add((QFilter)flexFilters.get(i));
            String selectField = flexFields[i + 1];
            String flexField = selectField.split(" ")[2];
            Triple flexTriple = (Triple)flexMap.get(flexField);
            if (flexTriple.getRight() != null) {
                if (!((String)flexTriple.getRight()).equals("bos_assistantdata_detail")) {
                    this.flexFieldEntityIdMap.put(flexField, (String)flexTriple.getRight());
                }
                BasedataEntityType entity = (BasedataEntityType)MetadataServiceHelper.getDataEntityType((String)((String)flexTriple.getRight()));
                this.flexFieldPropMap.put(flexField, (Tuple<String, String>)Tuple.create((Object)entity.getNameProperty(), (Object)entity.getNumberProperty()));
            }
            param.setBalEntityType(query.balEntityType(flexField));
            DataSet singleFlexDataSet = this.getSingleFlexBalanceDataSet(selectFields + "," + selectField, param, singleFlexFilters, (Triple<String, String, String>)flexTriple);
            if (singleFlexDataSet.isEmpty()) continue;
            dsList.add(singleFlexDataSet);
        }
        DataSet ds = null;
        if (CollectionUtils.isNotEmpty(dsList)) {
            ds = (DataSet)dsList.get(0);
            if (dsList.size() >= 2) {
                for (int i = 1; i < dsList.size(); ++i) {
                    ds = ds.union((DataSet)dsList.get(i));
                }
            }
        }
        return ds;
    }

    private DataSet getSingleFlexBalanceDataSet(String selectFields, QueryParam param, List<QFilter> singleFlexFilters, Triple<String, String, String> flexTriple) {
        param.setCustomFilter(singleFlexFilters);
        DataSet amountBegin = BalanceQueryExecutor.getInstance().getBalance(selectFields.replace("period,", ""), new Long[]{this.org}, this.booktype, this.accounttable, this.startperiod, this.startperiod, param);
        amountBegin = amountBegin.addField(this.startperiod + "L", "period");
        if (this.startperiod != this.endperiod) {
            DynamicObject nextStartPeriod = GLUtil.getNextPeriod((Object)this.startperiod);
            DataSet gl_balance = BalanceQueryExecutor.getInstance().getBalance(selectFields, new Long[]{this.org}, this.booktype, this.accounttable, nextStartPeriod != null ? nextStartPeriod.getLong("id") : this.endperiod, this.endperiod, param);
            List<String> sels = AssistActBalanceReportPlugin.getDataSetCols(gl_balance);
            gl_balance = gl_balance.select(sels.toArray(new String[0]));
            amountBegin = amountBegin.select(sels.toArray(new String[0]));
            amountBegin = amountBegin.union(gl_balance);
        }
        return this.appendFlexInfo(amountBegin, flexTriple);
    }

    private DataSet appendFlexInfo(DataSet balanceDataSet, Triple<String, String, String> flexTriple) {
        DataSet copy = balanceDataSet.copy();
        HashSet<Object> assistValues = new HashSet<Object>(64);
        HashSet<Long> accountIdSet = new HashSet<Long>(64);
        for (Row row : copy) {
            assistValues.add(row.get((String)flexTriple.getLeft()));
            accountIdSet.add(row.getLong("actid"));
        }
        HashMap<String, HashSet<Long>> flexAccountIdMap = new HashMap<String, HashSet<Long>>(8);
        try (DataSet accountDataSet = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "queryFlexField"), (String)acctView, (String)"id,checkitementry.asstactitem.flexfield flexfield", (QFilter[])new QFilter[]{new QFilter("id", "in", accountIdSet)}, null);){
            for (Row row : accountDataSet) {
                String flexfield = row.getString("flexfield");
                HashSet<Long> idSet = (HashSet<Long>)flexAccountIdMap.get(flexfield);
                if (Objects.isNull(idSet)) {
                    idSet = new HashSet<Long>(64);
                    flexAccountIdMap.put(flexfield, idSet);
                }
                idSet.add(row.getLong("id"));
            }
        }
        List<String> cols = AssistActBalanceReportPlugin.getDataSetCols(balanceDataSet);
        String flexfield = (String)flexTriple.getLeft();
        if (Objects.isNull(flexAccountIdMap.get(flexfield))) {
            return GLUtil.getEmptyDS(((Object)((Object)this)).getClass());
        }
        String actIdStr = ((Set)flexAccountIdMap.get(flexfield)).toString().replace("[", "(").replace("]", ")");
        balanceDataSet = balanceDataSet.filter("actid in" + actIdStr);
        ArrayList<String> newCols = new ArrayList<String>(cols);
        if (flexTriple.getRight() != null) {
            Tuple<String, String> propTuple = this.flexFieldPropMap.get(flexTriple.getLeft());
            DataSet assistDataSet = QueryServiceHelper.queryDataSet((String)(AssistActBalanceReportPlugin.class.getName() + "#queryAssistInfo"), (String)((String)flexTriple.getRight()), (String)String.format("id,%s assvalname,%s assvalnumber", propTuple.item1, propTuple.item2), (QFilter[])new QFilter("id", "in", assistValues).toArray(), null);
            balanceDataSet = balanceDataSet.join(assistDataSet, JoinType.LEFT).on(flexfield, "id").select(newCols.toArray(new String[0]), new String[]{"id assid", "assvalname", "assvalnumber"}).finish();
        } else {
            newCols.add("0L assid");
            newCols.add(flexfield + " assvalnumber");
            newCols.add(flexfield + " assvalname");
            balanceDataSet = balanceDataSet.select(newCols.toArray(new String[0]));
        }
        balanceDataSet = balanceDataSet.addField("'" + (String)flexTriple.getMiddle() + "'", "asstypename").addField("'" + flexfield + "'", "flexfield");
        balanceDataSet = balanceDataSet.removeFields(new String[]{flexfield});
        return balanceDataSet;
    }

    private String comAssistFields() {
        StringBuilder comAssistBuildStr = new StringBuilder();
        for (String comassistField : this.COMASSIST_BAL_LIST) {
            comAssistBuildStr.append(" ,");
            comAssistBuildStr.append(comassistField);
        }
        return comAssistBuildStr.toString();
    }

    private List<QFilter> buildComAssistQfilters() {
        return ComAssistTableService.getComAssistFilters((ComAssistTable)ComAssistTable.get((Long)this.accounttable), Collections.singletonList(this.org), (FilterInfo)this.getQueryParam().getFilter(), key -> key, (String)"masterid");
    }

    private void setComassist(ReportQueryParam param) {
        FilterInfo filterInfo = param.getFilter();
        DynamicObject acctTableDyn = filterInfo.getDynamicObject("accounttable");
        if (acctTableDyn == null) {
            return;
        }
        DynamicObjectCollection accTableColl = acctTableDyn.getDynamicObjectCollection("comassistentry");
        ArrayList<Object[]> entityList = new ArrayList<Object[]>(8);
        int i = 1;
        for (DynamicObject row : accTableColl) {
            String valType = row.getString("valuesourcetype");
            if (valType == null) continue;
            String entityId = null;
            ILocaleString locaName = row.getLocaleString("comassistname");
            if (AssistValueType.isAssistData((String)valType)) {
                entityId = "bos_assistantdata_detail";
            } else if (row.getDynamicObject("valuesource") != null) {
                DynamicObject valTypeObj = row.getDynamicObject("valuesource");
                entityId = valTypeObj.getString("number");
            }
            String fieldKey = "comassist" + i;
            if (filterInfo.containProp(fieldKey)) {
                DynamicObjectCollection coll = filterInfo.getDynamicObjectCollection(fieldKey);
                String fieldKeyId = fieldKey + "id";
                if (coll != null) {
                    Set ids = coll.stream().map(o -> o.getLong("id")).collect(Collectors.toSet());
                    this.COMASSIST_VALUE_LIST.add((Tuple2<String, Set<Long>>)new Tuple2((Object)fieldKey, ids));
                } else {
                    this.COMASSIST_VALUE_LIST.add((Tuple2<String, Set<Long>>)new Tuple2((Object)fieldKey, new HashSet(8)));
                }
                this.COMASSIST_BAL_LIST.add(fieldKey + " " + fieldKeyId);
                this.COMASSIST_LIST.add(fieldKeyId);
                entityList.add(new Object[]{fieldKeyId, entityId, locaName});
            }
            ++i;
        }
        Map customParam = param.getCustomParam();
        if (!filterInfo.getBoolean("showcomassist")) {
            customParam.put("ComAssistEntityListStr", null);
            this.COMASSIST_LIST.clear();
            this.COMASSIST_BAL_LIST.clear();
            return;
        }
        String entityStr = SerializationUtils.toJsonString(entityList);
        customParam.put("ComAssistEntityListStr", entityStr);
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        super.getColumns(columns);
        this.addComassistColunms(columns);
        return columns;
    }

    private void addComassistColunms(List<AbstractReportColumn> columns) {
        String comAssistValsListStr = (String)this.getQueryParam().getCustomParam().get("ComAssistEntityListStr");
        if (comAssistValsListStr == null) {
            return;
        }
        List comAssistList = (List)SerializationUtils.fromJsonString((String)comAssistValsListStr, List.class);
        if (!comAssistList.isEmpty()) {
            int index = -1;
            for (AbstractReportColumn x : columns) {
                String fieldKey;
                ++index;
                if (!(x instanceof ReportColumn) || !"measureunit".equals(fieldKey = ((ReportColumn)x).getFieldKey())) continue;
                break;
            }
            for (int i = comAssistList.size() - 1; i >= 0; --i) {
                List tuplMap = (List)comAssistList.get(i);
                String comFieldKey = (String)tuplMap.get(0);
                String entityId = (String)tuplMap.get(1);
                LocaleString nameLocal = new LocaleString();
                LinkedHashMap nameMap = (LinkedHashMap)tuplMap.get(2);
                for (Map.Entry map : nameMap.entrySet()) {
                    String key = (String)map.getKey();
                    String val = (String)map.getValue();
                    nameLocal.setItem(key, (Object)val);
                }
                columns.add(index, (AbstractReportColumn)this.createComAssist(comFieldKey, entityId, nameLocal));
            }
        }
    }

    private ReportColumn createComAssist(String fieldKey, String entityId, LocaleString nameLocal) {
        ReportColumn reportColumn = this.createComAssist(nameLocal, fieldKey, "basedata");
        reportColumn.setEntityId(entityId);
        return reportColumn;
    }

    private ReportColumn createComAssist(LocaleString caption, String fieldKey, String fieldType) {
        ReportColumn column = new ReportColumn();
        column.setCaption(caption);
        column.setFieldKey(fieldKey);
        column.setFieldType(fieldType);
        return column;
    }

    private String[] getGroupSelByCur() {
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(grpBy));
        if (!this.issyncur) {
            list.add("currencyid");
        }
        if (this.iscount) {
            list.add("measureunit");
        }
        list.addAll(this.COMASSIST_LIST);
        return list.toArray(new String[0]);
    }

    private DataSet dealSum(DataSet gl_balance) {
        String[] groupBy = this.getGroupSelByCur();
        List<String> cols = AssistActBalanceReportPlugin.getDataSetCols(gl_balance);
        DataSet period = this.queryPeriods(this.startperiod, this.endperiod);
        DataSet assType = gl_balance.copy().groupBy(groupBy).finish();
        DataSet assPeriod = assType.join(period, JoinType.CROSS).select(groupBy, new String[]{"period", "periodyear", "periodnumber"}).finish();
        List<String> assList = AssistActBalanceReportPlugin.getDataSetCols(assPeriod);
        cols.removeIf(x -> x.equalsIgnoreCase("asstypename"));
        cols.removeIf(x -> x.equalsIgnoreCase("flexfield"));
        cols.removeIf(x -> x.equalsIgnoreCase("assid"));
        cols.removeIf(x -> x.equalsIgnoreCase("assvalnumber"));
        cols.removeIf(x -> x.equalsIgnoreCase("assvalname"));
        cols.removeIf(x -> x.equalsIgnoreCase("actid"));
        cols.removeIf(x -> x.equalsIgnoreCase("accountnumber"));
        if (!this.issyncur) {
            cols.removeIf(x -> x.equalsIgnoreCase("currencyid"));
        }
        if (this.iscount) {
            cols.removeIf(x -> x.equalsIgnoreCase("measureunit"));
        }
        cols.removeIf(x -> x.equalsIgnoreCase("accountid"));
        cols.removeIf(x -> x.equalsIgnoreCase("period"));
        cols.removeIf(x -> x.equalsIgnoreCase("dc"));
        JoinDataSet groupData = gl_balance.join(assPeriod, JoinType.RIGHT).on("flexfield", "flexfield").on("assid", "assid").on("assvalnumber", "assvalnumber").on("assvalname", "assvalname").on("actid", "actid").on("period", "period");
        this.COMASSIST_LIST.forEach(x -> {
            groupData.on(x, x);
            cols.removeIf(y -> y.equalsIgnoreCase((String)x));
        });
        if (!this.issyncur) {
            groupData.on("currencyid", "currencyid");
        }
        if (this.iscount) {
            groupData.on("measureunit", "measureunit");
        }
        gl_balance = groupData.select(cols.toArray(new String[0]), assList.toArray(new String[0])).finish().orderBy(assList.toArray(new String[0]));
        List<String> sels = AssistActBalanceReportPlugin.getDataSetCols(gl_balance);
        ArrayList<String> selNullDeal = new ArrayList<String>();
        for (String field : sels) {
            if (field.endsWith("local") || field.endsWith("for") || field.endsWith("qty")) {
                selNullDeal.add("case when " + field + " =null then 0.0 else " + field + " end as " + field);
                continue;
            }
            selNullDeal.add(field);
        }
        gl_balance = gl_balance.select(selNullDeal.toArray(new String[0]));
        ArrayList<String> selList = new ArrayList<String>(16);
        String condition = "PreRowValue(asstypename) = asstypename and PreRowValue(assvalnumber) = assvalnumber and PreRowValue(assid) = assid and PreRowValue(actid) = actid";
        StringBuilder comAssistCond = new StringBuilder(condition);
        this.COMASSIST_LIST.forEach(x -> {
            comAssistCond.append(" and PreRowValue(");
            comAssistCond.append((String)x);
            comAssistCond.append(") = ");
            comAssistCond.append((String)x);
        });
        condition = comAssistCond.toString();
        if (!this.issyncur) {
            condition = condition + " and PreRowValue(currencyid) = currencyid";
        }
        selList.add("asstypename");
        selList.add("assvalnumber");
        selList.add("assvalname");
        selList.add("actid");
        selList.add("accountnumber");
        selList.add("accountid");
        selList.add("period");
        selList.add("periodyear");
        selList.add("periodnumber");
        if (!this.issyncur) {
            selList.add("currencyid");
        }
        selList.addAll(this.COMASSIST_LIST);
        selList.add("dc");
        selList.add("flexfield");
        selList.add("assid");
        selList.add("count");
        if (this.iscount) {
            selList.add("measureunit");
            condition = condition + " and PreRowValue(measureunit) = measureunit";
        }
        selList.add("case when " + condition + " then PreRowValue(endfor) else beginfor end as beginfor");
        selList.add("case when " + condition + " then PreRowValue(endlocal) else beginlocal end as beginlocal");
        selList.add("case when " + condition + " then PreRowValue(endqty) else beginqty end as beginqty");
        selList.add("debitfor");
        selList.add("debitlocal");
        selList.add("debitqty");
        selList.add("creditfor");
        selList.add("creditlocal");
        selList.add("creditqty");
        selList.add("case when " + condition + " then PreRowValue() + debitfor - creditfor else endfor end as endfor");
        selList.add("case when " + condition + " then PreRowValue() + debitlocal - creditlocal else endlocal end as endlocal");
        selList.add("case when " + condition + " then PreRowValue() + debitqty -creditqty else endqty end as endqty");
        String yearCondition = condition + " and PreRowValue(periodyear) = periodyear";
        selList.add("case when " + yearCondition + " then PreRowValue() + debitfor else yeardebitfor end as yeardebitfor");
        selList.add("case when " + yearCondition + " then PreRowValue() + debitlocal else yeardebitlocal end as yeardebitlocal");
        selList.add("case when " + yearCondition + " then PreRowValue() + debitqty else yeardebitqty end as yeardebitqty");
        selList.add("case when " + yearCondition + " then PreRowValue() + creditfor else yearcreditfor end as yearcreditfor");
        selList.add("case when " + yearCondition + " then PreRowValue() + creditlocal else yearcreditlocal end as yearcreditlocal");
        selList.add("case when " + yearCondition + " then PreRowValue() + creditqty else yearcreditqty end as yearcreditqty");
        gl_balance = gl_balance.select(selList.toArray(new String[0]));
        List<String> list = AssistActBalanceReportPlugin.getDataSetCols(gl_balance);
        list.remove("beginfor");
        list.remove("beginlocal");
        list.remove("beginqty");
        list.remove("endfor");
        list.remove("endlocal");
        list.remove("endqty");
        list.add("case when dc='1' then endfor - yeardebitfor + yearcreditfor else -1*(endfor - yeardebitfor + yearcreditfor) end as yearbeginfor");
        list.add("case when dc='1' then beginfor else -1*beginfor end as periodbeginfor");
        list.add("case when dc='1' then endfor else -1*endfor end as endfor");
        Boolean isShowByActDC = ReportUtils.getShowByActDCSysParam((Long)this.org);
        if (isShowByActDC.booleanValue()) {
            list.add("case when dc='1' then (endlocal - yeardebitlocal + yearcreditlocal) else 0 end yearbegindebitlocal");
            list.add("case when dc='-1' then -1*(endlocal - yeardebitlocal + yearcreditlocal) else 0 end yearbegincreditlocal");
            list.add("case when dc='1' then endqty - yeardebitqty + yearcreditqty else -1*(endqty - yeardebitqty + yearcreditqty) end yearbeginqty");
            list.add("case when dc='1' then beginlocal else 0 end debitbeginlocal");
            list.add("case when dc='-1' then -1*beginlocal else 0 end creditbeginlocal");
            list.add("case when dc='1' then beginqty else -1*beginqty end periodbeginqty");
            list.add("case when dc='1' then endlocal else 0 end debitendlocal");
            list.add("case when dc='-1' then -1*endlocal else 0 end creditendlocal");
            list.add("case when dc='1' then endqty else -1*endqty end endqty");
        } else {
            list.add("case when (endlocal - yeardebitlocal + yearcreditlocal)>0 then endlocal - yeardebitlocal + yearcreditlocal else 0.0 end yearbegindebitlocal");
            list.add("case when (endlocal - yeardebitlocal + yearcreditlocal)<0 then -1*(endlocal - yeardebitlocal + yearcreditlocal) else 0.0 end yearbegincreditlocal");
            list.add("case when (endqty - yeardebitqty + yearcreditqty)>0 then (endqty - yeardebitqty + yearcreditqty) else -1*(endqty - yeardebitqty + yearcreditqty) end yearbeginqty");
            list.add("case when beginlocal>0 then beginlocal else 0.0 end debitbeginlocal");
            list.add("case when beginlocal<0 then -1*beginlocal else 0.0 end creditbeginlocal");
            list.add("case when beginqty>0 then beginqty else -1*beginqty end periodbeginqty");
            list.add("case when endlocal>0 then endlocal else 0.0 end debitendlocal");
            list.add("case when endlocal<0 then -1*endlocal else 0.0 end creditendlocal");
            list.add("case when endqty>0 then endqty else -1*endqty end endqty");
        }
        gl_balance = gl_balance.select(list.toArray(new String[0]));
        return gl_balance;
    }

    public String getSelectFields() {
        String accountNameField = GLUtil.getAcctNameBySysParam((Long)this.org);
        String fields = String.format("period,account.id actid,account.number accountnumber,account.%s accountid,account.dc dc,currency currencyid,beginfor,beginlocal,beginqty,debitfor,", accountNameField) + "debitlocal,debitqty,creditfor,creditlocal,creditqty,endfor,endlocal,endqty,yeardebitfor,yeardebitlocal,yeardebitqty,yearcreditfor,yearcreditlocal,yearcreditqty,count";
        return fields;
    }

    private DataSet queryAssistGroupSet() {
        DataSet ds;
        ArrayList<DataSet> dsList = new ArrayList<DataSet>(4);
        for (Map.Entry<String, Set<Object>> entry : this.assistMap.entrySet()) {
            String flexfield = entry.getKey();
            Set<Object> value = entry.getValue();
            ds = this.queryAssistSet(flexfield, value);
            dsList.add(ds);
        }
        ds = (DataSet)dsList.get(0);
        if (dsList.size() >= 2) {
            for (int i = 1; i < dsList.size(); ++i) {
                ds = ds.union((DataSet)dsList.get(i));
            }
        }
        return ds;
    }

    private DataSet queryAssistSet(String ffield, Set<Object> assval) {
        String entityname = ASSIST_DB;
        if (this.assTxtList.contains(ffield)) {
            entityname = ASSIST_TXT;
        }
        String hgFields = "hg assisthg, asstype, assval";
        ArrayList<QFilter> qfList = new ArrayList<QFilter>();
        QFilter qFilter = new QFilter("asstype", "=", (Object)ffield);
        qfList.add(qFilter);
        if (assval != null && assval.size() > 0) {
            qFilter = new QFilter("assval", "in", assval);
            qfList.add(qFilter);
        } else {
            qFilter = this.assTxtList.contains(ffield) ? new QFilter("assval", "!=", (Object)Character.valueOf('0')) : new QFilter("assval", "!=", (Object)0);
            qfList.add(qFilter);
        }
        QFilter[] filters = qfList.toArray(new QFilter[0]);
        DataSet ds = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + entityname), (String)entityname, (String)hgFields, (QFilter[])filters, null);
        String assFields = "name asstypename,valuesource,flexfield,valuetype,assistanttype";
        QFilter assFilter1 = new QFilter("flexfield", "=", (Object)ffield);
        DataSet dSet = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + ".bd_asstacttype"), (String)ASSIST_TYPE, (String)assFields, (QFilter[])new QFilter[]{assFilter1}, null);
        ds = ds.join(dSet, JoinType.LEFT).on("asstype", "flexfield").select(new String[]{"assisthg", "assval"}, new String[]{"flexfield", "asstypename", "valuesource", "valuetype", "assistanttype"}).finish();
        if (this.assTxtList.contains(ffield)) {
            return this.manualAssistSet(ds);
        }
        HashSet<Long> values = new HashSet<Long>();
        String sourceName = null;
        String valuetype = null;
        for (Row row : ds.copy()) {
            valuetype = row.getString("valuetype");
            if ("1".equals(valuetype)) {
                sourceName = row.getString("valuesource");
            } else if ("2".equals(valuetype)) {
                sourceName = row.getString("assistanttype");
            }
            values.add(row.getLong("assval"));
        }
        if (values.size() > 0 && valuetype != null && sourceName != null) {
            DataSet assistSet = null;
            String name = "name";
            String number = "number";
            if ("1".equals(valuetype)) {
                QFilter qFilter2 = new QFilter("id", "in", values);
                BasedataEntityType entityType = (BasedataEntityType)MetadataServiceHelper.getDataEntityType((String)sourceName);
                name = entityType.getNameProperty();
                number = entityType.getNumberProperty();
                assistSet = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + ".assvalname"), (String)sourceName, (String)("id," + name + "," + number), (QFilter[])new QFilter[]{qFilter2}, null);
            } else if ("2".equals(valuetype)) {
                QFilter fDetail = new QFilter("group.id", "=", (Object)Long.parseLong(sourceName));
                assistSet = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + ".assvalname"), (String)"bos_assistantdata_detail", (String)"id,number,name", (QFilter[])new QFilter[]{fDetail}, null);
            }
            ds = ds.join(assistSet, JoinType.LEFT).on("assval", "id").select(new String[]{"assisthg", "flexfield", "asstypename"}, new String[]{"id assid", number + " assvalnumber", name + " assvalname"}).finish();
        } else {
            ds = ds.select(new String[]{"assisthg", "flexfield", "asstypename", "assval assid", "'' assvalnumber", "'' assvalname"}).filter("1=0");
        }
        return ds;
    }

    private DataSet manualAssistSet(DataSet ds) {
        ds = ds.select(new String[]{"assisthg", "flexfield", "asstypename", "0L assid", "assval assvalnumber", "assval assvalname"});
        return ds;
    }

    public static List<String> getDataSetCols(DataSet ds) {
        Field[] fields;
        ArrayList<String> list = new ArrayList<String>(16);
        RowMeta rowMeta = ds.copy().getRowMeta();
        for (Field field : fields = rowMeta.getFields()) {
            list.add(field.getName());
        }
        return list;
    }
}

