/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.algo.util.Tuple2;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.VarcharProp;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.service.balance.BalanceQueryExecutor;
import kd.fi.bd.service.balance.QueryParam;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.common.Tuple;
import kd.fi.gl.report.ReportHelper;
import kd.fi.gl.report.ReportUtils;
import kd.fi.gl.util.GLApp;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.SubsiDiaryHelper;

public class AssistTotalTreeRightQueryRpt
extends AbstractReportListDataPlugin {
    private static final String startPeriod = "startperiod";
    private static final String endPeriod = "endperiod";
    private static final String account = "account";
    private static final String assistTxt = "gl_assist_txt";
    private static final String assistDb = "gl_assist_bd";
    private static final String assistType = "bd_asstacttype";
    private static final String TYPE_TXT = "type_txt";
    private static final String TYPE_BASE_STRING = "type_base_str";
    private static final String TYPE_BASE_LONG = "type_base_long";
    private Map<String, Tuple2<String, Set<Object>>> assistMap = new LinkedHashMap<String, Tuple2<String, Set<Object>>>();
    private List<String> assTypeSel = new ArrayList<String>(4);
    private static final String[] SEL_FIELD = new String[]{"accountid", "basecurrency", "currencyid", "periodid", "measureunitid", "beginqty", "beginfor", "beginlocal", "debitqty", "creditqty", "debitfor", "creditfor", "debitlocal", "creditlocal", "yeardebitqty", "yeardebitfor", "yeardebitlocal", "yearcreditqty", "yearcreditfor", "yearcreditlocal", "endqty", "endfor", "endlocal", "accountparent", "accountlevel", "accountnumber", "accountname"};
    private static final String[] selField_1 = new String[]{"left.beginqty beginqty", "0 beginfor", "left.beginlocal beginlocal", "left.debitqty debitqty", "left.creditqty creditqty", "0 debitfor", "0 creditfor", "left.debitlocal debitlocal", "left.creditlocal creditlocal", "left.yeardebitqty yeardebitqty", "0 yeardebitfor", "left.yeardebitlocal yeardebitlocal", "left.yearcreditqty yearcreditqty", "0 yearcreditfor", "left.yearcreditlocal yearcreditlocal", "left.endqty endqty", "0 endfor", "left.endlocal endlocal", "0L currency", "left.account account", "left.period period", "accountparent", "accountlevel", "accountnumber", "accountname", "assgrpid"};
    private static final String[] selField_2 = new String[]{"left.beginqty beginqty", "0 beginfor", "left.beginlocal beginlocal", "left.debitqty debitqty", "left.creditqty creditqty", "0 debitfor", "0 creditfor", "left.debitlocal debitlocal", "left.creditlocal creditlocal", "left.yeardebitqty yeardebitqty", "0 yeardebitfor", "left.yeardebitlocal yeardebitlocal", "left.yearcreditqty yearcreditqty", "0 yearcreditfor", "left.yearcreditlocal yearcreditlocal", "left.endqty endqty", "0 endfor", "left.endlocal endlocal", "0L currency", "left.account account", "left.period period", "accountparent", "accountlevel", "accountnumber", "accountname", "left.measureunit measureunit", "assgrpid"};

    public DataSet query(ReportQueryParam param, Object obj) throws Throwable {
        FilterInfo filterInfo = param.getFilter();
        if (obj == null) {
            return this.createEmptyData();
        }
        DataSet dataSet = this.getAccountBalanceResult(filterInfo, obj);
        if (dataSet == null) {
            return this.createEmptyData();
        }
        return dataSet;
    }

    private DataSet createEmptyData() {
        RowMeta meta = RowMetaFactory.createRowMeta((String[])new String[]{"accountid"}, (DataType[])new DataType[]{DataType.LongType});
        DataSetBuilder builder = Algo.create((String)"fi.gl.createEmptyData").createDataSetBuilder(meta);
        return builder.build();
    }

    private String buildSelectField(FilterInfo filterInfo) {
        StringBuilder sb = new StringBuilder();
        sb.append("account,currency,account.parent accountparent,account.level accountlevel,account.number accountnumber,");
        String accountNameField = GLUtil.getAcctNameBySysParam((Long)filterInfo.getLong("org"));
        sb.append(String.format("account.%s accountname,", accountNameField));
        sb.append("beginqty,beginfor,beginlocal,debitqty,creditqty,debitfor,creditfor,debitlocal,creditlocal,yeardebitqty,yeardebitfor,yeardebitlocal,yearcreditqty,yearcreditfor,yearcreditlocal,endqty,endfor,endlocal,assgrp assgrpid");
        if (filterInfo.getDynamicObjectCollection("measureunits") != null || filterInfo.getBoolean("showqty")) {
            sb.append(",measureunit");
        }
        return sb.toString();
    }

    private DataSet getAccountBalanceResult(FilterInfo filterInfo, Object obj) {
        this.initAssist(filterInfo);
        for (FilterItemInfo itemInfo : filterInfo.getFlexFilterItems()) {
            String key = itemInfo.getPropName();
            this.assTypeSel.add(key);
        }
        if (!SubsiDiaryHelper.isExportAll((FilterInfo)filterInfo) && AssistTotalTreeRightQueryRpt.isAllNull(obj)) {
            this.assTypeSel.clear();
        }
        ArrayList<Long> hgIds = new ArrayList<Long>(10);
        DataSet assTypeData = SubsiDiaryHelper.assToAssgrp((FilterInfo)filterInfo, (Object)obj, this.assistMap);
        for (Row row : assTypeData.copy()) {
            hgIds.add(row.getLong("hg"));
        }
        boolean assFlag = hgIds.size() == 1 && (Long)hgIds.get(0) == 0L;
        String balanceSel = this.buildSelectField(filterInfo);
        DataSet balanceData = SubsiDiaryHelper.getBalance((FilterInfo)filterInfo, (String)balanceSel, null);
        boolean flag = filterInfo.getBoolean("showleafaccount");
        DataSet endSet = null;
        assTypeData = this.resolveHgIds(filterInfo, hgIds, assTypeData, balanceData);
        if (assFlag) {
            this.resolveNullValHgId((Map)obj, hgIds, assTypeData, balanceData);
        }
        AccountBookInfo book = AccSysUtil.getBookFromAccSys((long)filterInfo.getLong("org"), (long)filterInfo.getLong("booktype"));
        long currLocal = book.getBaseCurrencyId();
        long startPeriodId = filterInfo.getLong(startPeriod);
        long endPeriodId = filterInfo.getLong(endPeriod);
        QFilter f = new QFilter("id", ">=", (Object)startPeriodId);
        QFilter h = new QFilter("id", "<=", (Object)endPeriodId);
        QFilter s = new QFilter("periodtype", "=", (Object)filterInfo.getDynamicObject("periodtype").getLong("id"));
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"bd_period", (String)"id", (QFilter[])new QFilter[]{f, h, s});
        for (DynamicObject db : coll) {
            GroupbyDataSet groupbyDataSet;
            long periodId = db.getLong("id");
            DataSet dataSet = this.getAccountBalance(filterInfo, balanceSel, hgIds, periodId);
            dataSet = filterInfo.getDynamicObjectCollection("measureunits") == null && !filterInfo.getBoolean("showqty") ? dataSet.select(new String[]{"account accountid", currLocal + " basecurrency", "currency currencyid", periodId + " periodid", "beginqty", "beginfor", "beginlocal", "debitqty", "creditqty", "debitfor", "creditfor", "debitlocal", "creditlocal", "yeardebitqty", "yeardebitfor", "yeardebitlocal", "yearcreditqty", "yearcreditfor", "yearcreditlocal", "endqty", "endfor", "endlocal", "accountparent", "accountlevel", "accountnumber", "accountname", "assgrpid"}).addField("0L", "measureunitid") : dataSet.select(new String[]{"account accountid", currLocal + " basecurrency", "currency currencyid", periodId + " periodid", "measureunit measureunitid", "beginqty", "beginfor", "beginlocal", "debitqty", "creditqty", "debitfor", "creditfor", "debitlocal", "creditlocal", "yeardebitqty", "yeardebitfor", "yeardebitlocal", "yearcreditqty", "yearcreditfor", "yearcreditlocal", "endqty", "endfor", "endlocal", "accountparent", "accountlevel", "accountnumber", "accountname", "assgrpid"});
            ArrayList<String> assTypeList = new ArrayList<String>(this.assTypeSel);
            String[] resultSel = assTypeList.toArray(new String[0]);
            List<String> sum = Arrays.asList("beginqty", "beginfor", "beginlocal", "debitqty", "creditqty", "debitfor", "creditfor", "debitlocal", "creditlocal", "yeardebitqty", "yeardebitfor", "yeardebitlocal", "yearcreditqty", "yearcreditfor", "yearcreditlocal", "endqty", "endfor", "endlocal");
            ArrayList<String> groupBy = new ArrayList<String>(Arrays.asList("accountid", "basecurrency", "currencyid", "periodid", "measureunitid", "accountparent", "accountlevel", "accountnumber", "accountname"));
            if (!this.assTypeSel.isEmpty()) {
                groupBy.addAll(this.assTypeSel);
            }
            if (this.assTypeSel.isEmpty()) {
                groupbyDataSet = dataSet.select(SEL_FIELD).groupBy(groupBy.toArray(new String[0]));
                for (String field : sum) {
                    groupbyDataSet = groupbyDataSet.sum(field);
                }
                dataSet = groupbyDataSet.finish().addField("1", "rowtype").orderBy(new String[]{"accountid"}).orderBy(new String[]{"accountnumber"});
            } else {
                groupbyDataSet = dataSet.join(assTypeData.copy(), JoinType.INNER).on("assgrpid", "hg").select(SEL_FIELD, resultSel).finish().groupBy(groupBy.toArray(new String[0]));
                for (String field : sum) {
                    groupbyDataSet = groupbyDataSet.sum(field);
                }
                dataSet = groupbyDataSet.finish().addField("1", "rowtype").orderBy(new String[]{"accountid"}).orderBy(new String[]{"accountnumber"});
            }
            ArrayList<String> selField = new ArrayList<String>(Arrays.asList(SEL_FIELD));
            selField.add("rowtype");
            selField.addAll(this.assTypeSel);
            dataSet = dataSet.select(selField.toArray(new String[0]));
            StringBuilder noZeroFilter = new StringBuilder();
            if (filterInfo.getBoolean("nodisplayforzero")) {
                if (noZeroFilter.length() > 0) {
                    noZeroFilter.append(" or ");
                }
                noZeroFilter.append("debitlocal != 0.0 or creditlocal != 0.0");
            }
            if (filterInfo.getBoolean("balancezero")) {
                if (noZeroFilter.length() > 0) {
                    noZeroFilter.append(" or ");
                }
                noZeroFilter.append("endlocal != 0.0");
            }
            if (noZeroFilter.length() > 0) {
                dataSet = dataSet.filter(noZeroFilter.toString());
            }
            DataSet totalDataSet = flag ? dataSet.copy() : dataSet.copy().filter("accountlevel = 1");
            if ((dataSet = ReportHelper.filterLevel(dataSet, filterInfo, (Tuple<String, String>)Tuple.create((Object)"accountid", (Object)"id"), filterInfo.getLong("org"))).isEmpty()) continue;
            ArrayList<String> sumGroupBy = new ArrayList<String>(assTypeList);
            sumGroupBy.add("periodid");
            DataSet dataset3 = totalDataSet.groupBy(sumGroupBy.toArray(new String[0])).sum("beginlocal").sum("debitlocal").sum("creditlocal").sum("yeardebitlocal").sum("yearcreditlocal").sum("endlocal").finish();
            ArrayList<String> field = new ArrayList<String>(Arrays.asList("0L accountid", currLocal + " basecurrency", "0L currencyid", "periodid", "0L measureunitid", "0 beginqty", "null beginfor", "null beginlocal", "0 debitqty", "0 creditqty", "null debitfor", "null creditfor", "debitlocal", "creditlocal", "0 yeardebitqty", "null yeardebitfor", "yeardebitlocal", "0 yearcreditqty", "null yearcreditfor", "yearcreditlocal", "0 endqty", "null endfor", "null endlocal", "0L accountparent", "0 accountlevel", "null accountnumber", "null accountname"));
            field.add("2 rowtype");
            field.addAll(assTypeList);
            dataset3 = dataset3.select(field.toArray(new String[0]));
            DataSet dataset5 = dataSet.union(dataset3);
            if (endSet == null) {
                endSet = dataset5;
                continue;
            }
            endSet = endSet.union(dataset5);
        }
        if (!this.assTypeSel.isEmpty() && endSet != null) {
            ArrayList<String> list = new ArrayList<String>(this.assTypeSel);
            list.add("periodid");
            list.add("rowtype");
            endSet = endSet.orderBy(list.toArray(new String[0]));
        }
        String level = filterInfo.getString("accountlevel");
        if (!flag && endSet != null) {
            endSet = endSet.filter("accountlevel <=" + Integer.valueOf(level));
        }
        return endSet;
    }

    private static boolean isAllNull(Object obj) {
        boolean isZero = true;
        if (obj instanceof Map) {
            Map param = (Map)obj;
            for (Map.Entry entry : param.entrySet()) {
                if ("0".equalsIgnoreCase(entry.getValue().toString()) || "-1".equalsIgnoreCase(entry.getValue().toString()) || "".equalsIgnoreCase(entry.getValue().toString())) continue;
                isZero = false;
                break;
            }
            if (isZero) {
                return true;
            }
        }
        return false;
    }

    private void resolveNullValHgId(Map<String, Object> obj, List<Long> hgIds, DataSet assTypeData, DataSet balanceData) {
        hgIds.clear();
        DataSet dataAccount = null;
        for (String flex : obj.keySet()) {
            String selectFields = "assval " + flex + ", hg";
            String entityName = assistDb;
            QFilter fnotZero = new QFilter("assval", "!=", (Object)0);
            QFilter filter = new QFilter("asstype", "=", (Object)flex);
            Tuple2<String, Set<Object>> tuple2 = this.assistMap.get(flex);
            if (TYPE_TXT.equals(tuple2.t1)) {
                entityName = assistTxt;
                fnotZero = new QFilter("assval", "!=", (Object)Character.valueOf('0'));
            }
            DataSet assSet = QueryServiceHelper.queryDataSet((String)"SubsiDiaryHelper.assToAssgrp", (String)entityName, (String)selectFields, (QFilter[])new QFilter[]{fnotZero, filter}, null);
            if (dataAccount == null) {
                dataAccount = balanceData.copy().join(assSet, JoinType.LEFT).on("assgrpid", "hg").select(new String[]{"assgrpid", flex}).finish().filter(flex + " is null");
                continue;
            }
            dataAccount = dataAccount.copy().join(assSet, JoinType.LEFT).on("assgrpid", "hg").select(new String[]{"assgrpid", flex}).finish().filter(flex + " is null");
        }
        if (dataAccount == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u7ef4\u5ea6\u7c7b\u578b\uff0c\u4e0d\u652f\u6301\u67e5\u8be2\u3002", (String)"SubsiDiaryRightQueryRpt_4", (String)GLApp.instance.reportModule(), (Object[])new Object[0]));
        }
        List sel = ReportUtils.getSetField((DataSet)assTypeData);
        sel.removeIf(x -> "hg".equalsIgnoreCase((String)x));
        for (Row row : dataAccount) {
            hgIds.add(row.getLong("assgrpid"));
        }
    }

    private DataSet resolveHgIds(FilterInfo filterInfo, List<Long> hgIds, DataSet assTypeData, DataSet balanceData) {
        if (SubsiDiaryHelper.isExportAll((FilterInfo)filterInfo)) {
            List fItemInfos = filterInfo.getFlexFilterItems();
            boolean hasFilter = false;
            for (FilterItemInfo itemInfo : fItemInfos) {
                if (!StringUtils.isNotBlank((Object)itemInfo.getValue()) || !(itemInfo.getValue() instanceof HashSet) || ((HashSet)itemInfo.getValue()).size() <= 0) continue;
                hasFilter = true;
            }
            JoinType type = hasFilter ? JoinType.INNER : JoinType.LEFT;
            List fileds = SubsiDiaryHelper.getSetField((DataSet)assTypeData);
            fileds.removeIf(x -> "hg".equalsIgnoreCase((String)x));
            assTypeData = balanceData.copy().join(assTypeData, type).on("assgrpid", "hg").select(new String[]{"assgrpid hg"}, fileds.toArray(new String[0])).finish();
            hgIds.clear();
            List assList = ReportUtils.getSetField((DataSet)assTypeData);
            assTypeData = assTypeData.groupBy(assList.toArray(new String[0])).finish();
            for (Row row : assTypeData.copy()) {
                hgIds.add(row.getLong("hg"));
            }
        }
        return assTypeData;
    }

    private void initAssist(FilterInfo filter) {
        List items = filter.getFlexFilterItems();
        for (FilterItemInfo filterItemInfo : items) {
            String propName = filterItemInfo.getPropName();
            String entityId = this.fillAssistTypeName(propName);
            HashSet value = (HashSet)filterItemInfo.getValue();
            if (entityId == null) {
                this.assistMap.put(propName, (Tuple2<String, Set<Object>>)new Tuple2((Object)TYPE_TXT, (Object)value));
                continue;
            }
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
            if (dataEntityType.getPrimaryKey() instanceof VarcharProp) {
                this.assistMap.put(propName, (Tuple2<String, Set<Object>>)new Tuple2((Object)TYPE_BASE_STRING, (Object)value));
                continue;
            }
            this.assistMap.put(propName, (Tuple2<String, Set<Object>>)new Tuple2((Object)TYPE_BASE_LONG, (Object)value));
        }
    }

    private String fillAssistTypeName(String propName) {
        QFilter qFilter = new QFilter("flexfield", "=", (Object)propName);
        DynamicObject queryOne = QueryServiceHelper.queryOne((String)assistType, (String)"name,valuesource,valuetype", (QFilter[])new QFilter[]{qFilter});
        String valType = queryOne.getString("valuetype");
        String entityId = null;
        switch (valType) {
            case "1": {
                entityId = queryOne.getString("valuesource");
                break;
            }
            case "2": {
                entityId = "bos_assistantdata_detail";
            }
        }
        return entityId;
    }

    private DataSet getAccountBalance(FilterInfo filterInfo, String balanceSel, List<Long> assrgIds, long periodId) {
        String currencyVal;
        AccountBookInfo defaultBook;
        long orgId = filterInfo.getLong("org");
        long bookTypeId = filterInfo.getLong("booktype");
        if (bookTypeId == 0L && (defaultBook = AccSysUtil.getDefaultBookFromAccSys((Long)((Long)filterInfo.getDynamicObject("org").getPkValue()))) != null) {
            bookTypeId = defaultBook.getBookTypeId();
        }
        QueryParam param = new QueryParam();
        Set<Long> acctIds = filterInfo.getDynamicObjectCollection(account) != null ? filterInfo.getDynamicObjectCollection(account).stream().map(DataEntityBase::getPkValue).map(Long.class::cast).collect(Collectors.toSet()) : this.getAccIds(filterInfo);
        QFilter faccount = new QFilter("id", "in", acctIds);
        param.setAccountFilter(faccount);
        if (assrgIds != null) {
            param.setAssGrpIds(new HashSet<Long>(assrgIds));
        }
        if (filterInfo.getDynamicObjectCollection("measureunits") != null) {
            DynamicObjectCollection unitsDynColl = filterInfo.getDynamicObjectCollection("measureunits");
            ArrayList<Long> uList = new ArrayList<Long>();
            for (DynamicObject dyn : unitsDynColl) {
                uList.add(dyn.getLong("id"));
            }
            param.setMeasureUnitIds(uList.toArray(new Long[0]));
        }
        if (!"basecurrency".equals(currencyVal = filterInfo.getString("currency")) && !"allcurrency".equals(currencyVal)) {
            long currencyId = Long.parseLong(filterInfo.getString("currency"));
            param.setCurrencyIds(new Long[]{currencyId});
        }
        param.setOnlyLeafAcctBal(filterInfo.getBoolean("showleafaccount"));
        param.setZeroAmtNoDisplay(filterInfo.getBoolean("nodisplayforzero"));
        param.setZeroBalNoDisplay(filterInfo.getBoolean("balancezero"));
        param.setSubstractPL(filterInfo.getBoolean("issubstractpl"));
        param.setAccountVersionPeriodId(filterInfo.getLong(endPeriod));
        DataSet balanceData = BalanceQueryExecutor.getInstance().getBalance(balanceSel, new Long[]{orgId}, bookTypeId, filterInfo.getLong("accounttable"), periodId, periodId, param).addField(String.valueOf(periodId), "period");
        boolean isBaseCurrency = "basecurrency".equals(currencyVal);
        if (isBaseCurrency) {
            boolean isHasMeasure = filterInfo.getDynamicObjectCollection("measureunits") != null || filterInfo.getBoolean("showqty");
            ArrayList<String> groupStr = new ArrayList<String>();
            groupStr.add(account);
            groupStr.add("accountparent");
            groupStr.add("accountlevel");
            groupStr.add("accountnumber");
            groupStr.add("accountname");
            groupStr.add("assgrpid");
            groupStr.add("period");
            String[] selectStr = selField_1;
            if (isHasMeasure) {
                groupStr.add("measureunit");
                selectStr = selField_2;
            }
            long accountTable = filterInfo.getLong("accounttable");
            QFilter accountTableFilter = new QFilter("accounttable", "=", (Object)accountTable);
            DataSet accountDataSet = QueryServiceHelper.queryDataSet((String)"gl.AssistTotalRightQueryRpt.groupSumAccount", (String)"bd_accountview", (String)"id,number accountnumber,parent accountparent,level accountlevel", (QFilter[])new QFilter[]{accountTableFilter}, null);
            DataSet balanceData1 = balanceData.copy().groupBy(groupStr.toArray(new String[]{"1"})).sum("beginqty").sum("beginlocal").sum("debitqty").sum("creditqty").sum("debitlocal").sum("creditlocal").sum("yeardebitqty").sum("yeardebitlocal").sum("yearcreditqty").sum("yearcreditlocal").sum("endqty").sum("endlocal").finish();
            DataSet balanceData2 = balanceData1.copy().join(accountDataSet.copy(), JoinType.INNER).on(account, "id").select(selectStr).finish();
            return balanceData2;
        }
        return balanceData;
    }

    private HashSet<Long> acctMasterIDToID(HashSet<Long> ids) {
        HashSet<Long> masterIds = new HashSet<Long>();
        if (null == ids || ids.isEmpty()) {
            return masterIds;
        }
        QFilter filter = new QFilter("id", "in", ids);
        DataSet masterSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_accountview", (String)"masterid", (QFilter[])new QFilter[]{filter}, null);
        for (Row row : masterSet) {
            long masterId = row.getLong("masterid");
            masterIds.add(masterId);
        }
        HashSet<Long> acctIds = new HashSet<Long>();
        QFilter mFilter = new QFilter("masterid", "in", masterIds);
        DataSet accSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_accountview", (String)"id", (QFilter[])new QFilter[]{mFilter}, null);
        for (Row row : accSet) {
            long accId = row.getLong("id");
            acctIds.add(accId);
        }
        return acctIds;
    }

    private Set<Long> getAccIds(FilterInfo filterInfo) {
        List fItemInfos = filterInfo.getFlexFilterItems();
        HashSet<String> flexField = new HashSet<String>(8);
        for (FilterItemInfo info : fItemInfos) {
            flexField.add(info.getPropName());
        }
        long accountTable = filterInfo.getLong("accounttable");
        long orgID = filterInfo.getLong("org");
        return ReportUtils.getAccIdsByFlexFieldsForBalance(Collections.singletonList(orgID), (long)accountTable, flexField, (long)filterInfo.getLong(endPeriod));
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        super.getColumns(columns);
        FilterInfo filterInfo = this.getQueryParam().getFilter();
        if (SubsiDiaryHelper.isExport((FilterInfo)filterInfo)) {
            return this.addLeftColumn(columns, filterInfo);
        }
        return columns;
    }

    private List<AbstractReportColumn> addLeftColumn(List<AbstractReportColumn> columns, FilterInfo filterInfo) {
        ArrayList leftColumns = new ArrayList();
        SubsiDiaryHelper.createAccountancyTypeColumns(leftColumns, (FilterInfo)filterInfo);
        columns.addAll(0, leftColumns);
        return columns;
    }
}

