/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import java.util.List;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.fi.gl.report.MulOrgQPRpt;
import kd.fi.gl.report.ReportHelper;

final class DailyHelper
extends ReportHelper {
    private static final String CREDIT_COUNT = "creditcount";
    private static final String DEBIT_COUNT = "debitcount";
    private static final String PRE = "pre";
    private static final String NOW = "";
    private static final String TO = "to";

    private static LocaleString getPreBalance() {
        return new LocaleString(ResManager.loadKDString((String)"\u4e0a\u65e5\u4f59\u989d", (String)"DailyHelper_0", (String)"fi-gl-report", (Object[])new Object[0]));
    }

    private static LocaleString getToBalance() {
        return new LocaleString(ResManager.loadKDString((String)"\u672c\u65e5\u4f59\u989d", (String)"DailyHelper_1", (String)"fi-gl-report", (Object[])new Object[0]));
    }

    private static LocaleString getAmount() {
        return new LocaleString(ResManager.loadKDString((String)"\u672c\u65e5\u53d1\u751f\u989d", (String)"DailyHelper_2", (String)"fi-gl-report", (Object[])new Object[0]));
    }

    private static LocaleString getDebitCount() {
        return new LocaleString(ResManager.loadKDString((String)"\u501f\u65b9\u7b14\u6570", (String)"DailyHelper_3", (String)"fi-gl-report", (Object[])new Object[0]));
    }

    private static LocaleString getCreditCount() {
        return new LocaleString(ResManager.loadKDString((String)"\u8d37\u65b9\u7b14\u6570", (String)"DailyHelper_4", (String)"fi-gl-report", (Object[])new Object[0]));
    }

    public DailyHelper(MulOrgQPRpt param) {
        super(param);
    }

    @Override
    public List<AbstractReportColumn> getReportColumn(List<AbstractReportColumn> columns) {
        super.getReportColumn(columns);
        columns.add((AbstractReportColumn)this.columnCreateHelper(PRE));
        columns.add((AbstractReportColumn)this.columnCreateHelper(NOW));
        columns.add((AbstractReportColumn)this.columnCreateHelper(TO));
        ReportColumn debitCount = DailyHelper.createColumn(DailyHelper.getDebitCount(), DEBIT_COUNT, "integer");
        columns.add((AbstractReportColumn)debitCount);
        ReportColumn creditCount = DailyHelper.createColumn(DailyHelper.getCreditCount(), CREDIT_COUNT, "integer");
        columns.add((AbstractReportColumn)creditCount);
        columns.add((AbstractReportColumn)DailyHelper.createFlexOrgidColumn());
        return columns;
    }

    private ReportColumnGroup columnCreateHelper(String prefix) {
        ReportColumnGroup group = new ReportColumnGroup();
        group.setCaption((LocaleString)(prefix.equals(PRE) ? DailyHelper.getPreBalance() : (prefix.equals(TO) ? DailyHelper.getToBalance() : (prefix.startsWith(NOW) ? DailyHelper.getAmount() : null))));
        group.setFieldKey(prefix.equals(PRE) ? "previousGroup" : (prefix.equals(TO) ? "endGroup" : (prefix.startsWith(NOW) ? "todayGroup" : null)));
        return this.getColumnGroup(group, prefix);
    }
}

