/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.accbalance;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Row;
import kd.fi.gl.report.MulOrgQPRpt;
import kd.fi.gl.report.accbalance.AccBalBalSelector;
import kd.fi.gl.report.accbalance.AccBalOutPutIndex;
import kd.fi.gl.report.accbalance.AccBalReportQuery;
import kd.fi.gl.report.common.ICollector;
import kd.fi.gl.report.common.OutPutFunction;
import kd.fi.gl.report.common.RptUtil;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.vo.RateBean;

public class AccBalBalFunction
implements OutPutFunction {
    private AccBalBalSelector selector;
    private AccBalOutPutIndex outPutIndex;
    private Map<Long, RateBean> orgRateMap;
    private Map<Long, Long> orgStartPeriodMap;
    private long startPeriod;
    private long endPeriod;
    private Set<Long> periods;
    private boolean isShowPeriod;

    public AccBalBalFunction(AccBalBalSelector accBalSelector) {
        AccBalReportQuery accBalQuery = accBalSelector.getReportQuery();
        this.selector = accBalSelector;
        this.outPutIndex = accBalQuery.getOutPutIndex();
        MulOrgQPRpt qpRpt = accBalQuery.getQueryParam();
        this.startPeriod = qpRpt.getStartPeriod();
        this.endPeriod = qpRpt.getEndPeriod();
        this.orgRateMap = qpRpt.getOrgRateMap();
        this.periods = qpRpt.getPeriods();
        this.isShowPeriod = qpRpt.isShowPeriod();
        this.orgStartPeriodMap = qpRpt.getOrgStartPeriodMap();
    }

    @Override
    public void output(Row row, ICollector collector) {
        if (this.isShowPeriod) {
            long period = row.getLong(this.selector.getPeriodIndex());
            ArrayList<Object[]> results = new ArrayList<Object[]>(this.periods.size());
            for (Long selectPeriod : this.periods) {
                if (selectPeriod < period) continue;
                Object[] result = this.outputData(row, selectPeriod, selectPeriod);
                result[this.selector.getPeriodIndex()] = selectPeriod;
                results.add(result);
            }
            for (Object[] obj : results) {
                collector.collect(obj);
            }
        } else {
            Object[] result = this.outputData(row, this.startPeriod, this.endPeriod);
            collector.collect(result);
        }
    }

    private Object[] outputData(Row row, long startPeriod, long endPeriod) {
        int countIndex;
        Object[] result = new Object[this.outPutIndex.getFieldCount()];
        int[] opGrpIndexes = this.outPutIndex.getGroupIndexes();
        int[] ipGrpIndexes = this.selector.getGroupIndexes();
        for (int i = 0; i < opGrpIndexes.length; ++i) {
            result[opGrpIndexes[i]] = row.get(ipGrpIndexes[i]);
        }
        long period = row.getLong(this.selector.getPeriodIndex());
        long ePeriod = row.getLong(this.selector.getEndPeriodIndex());
        int[] beginIndexes = this.selector.getBeginIndexes();
        int[] debitIndexes = this.selector.getDebitIndexes();
        int[] creditIndexes = this.selector.getCreditIndexes();
        int[] endIndexes = this.selector.getEndIndexes();
        int[] yearDebitIndexes = this.selector.getYearDebitIndexes();
        int[] yearCreditIndexes = this.selector.getYearCreditIndexes();
        int[] opBeginDebitIndexes = this.outPutIndex.getBeginDebitIndexes();
        long orgStartPeriod = this.orgStartPeriodMap.get(row.getLong(this.selector.getOrgIndex()));
        if (period == startPeriod || orgStartPeriod >= startPeriod && orgStartPeriod <= endPeriod && period == orgStartPeriod) {
            this.copyValue(result, row, opBeginDebitIndexes, beginIndexes);
        } else if (period < startPeriod && ePeriod > startPeriod) {
            this.copyValue(result, row, opBeginDebitIndexes, endIndexes);
        }
        int[] opDebitIndexes = this.outPutIndex.getDebitIndexes();
        int[] opCreditIndexes = this.outPutIndex.getCreditIndexes();
        if (period >= startPeriod) {
            this.copyValue(result, row, opDebitIndexes, debitIndexes);
            this.copyValue(result, row, opCreditIndexes, creditIndexes);
        }
        int[] opYearDebitIndexes = this.outPutIndex.getYearDebitIndexes();
        int[] opYearCreditIndexes = this.outPutIndex.getYearCreditIndexes();
        if (ePeriod > endPeriod && period <= endPeriod && period > endPeriod / GLUtil.YEAR_PERIOD_L * GLUtil.YEAR_PERIOD_L) {
            this.copyValue(result, row, opYearDebitIndexes, yearDebitIndexes);
            this.copyValue(result, row, opYearCreditIndexes, yearCreditIndexes);
        }
        int[] opEndDebitIndexes = this.outPutIndex.getEndDebitIndexes();
        if (period <= endPeriod && ePeriod > endPeriod) {
            this.copyValue(result, row, opEndDebitIndexes, endIndexes);
        }
        if ((countIndex = this.outPutIndex.getCountIndex()) != -1 && period >= startPeriod && period <= endPeriod) {
            result[countIndex] = row.get(this.selector.getCountIndex());
        }
        int[] opYearBDebitIndexes = this.outPutIndex.getYearBDebitIndexes();
        for (int i = 0; i < opYearBDebitIndexes.length; ++i) {
            Object yearDebit = RptUtil.subtract(result[opYearDebitIndexes[i]], result[opYearCreditIndexes[i]]);
            result[opYearBDebitIndexes[i]] = RptUtil.subtract(result[opEndDebitIndexes[i]], yearDebit);
        }
        Map<Integer, Integer> rptLocalIndexMap = this.outPutIndex.getRptLocalIndexMap();
        AccBalBalFunction.setRptAmount(row, result, rptLocalIndexMap, this.orgRateMap, this.selector.getOrgIndex());
        return result;
    }

    static void setRptAmount(Row row, Object[] result, Map<Integer, Integer> rptLocalIndexMap, Map<Long, RateBean> orgRateMap, int orgIndex) {
        for (Map.Entry<Integer, Integer> entry : rptLocalIndexMap.entrySet()) {
            RateBean rate = orgRateMap.get(row.getLong(orgIndex));
            if (rate == null) {
                result[entry.getKey().intValue()] = BigDecimal.ZERO;
                continue;
            }
            Object localVal = result[entry.getValue()];
            BigDecimal localB = localVal == null ? BigDecimal.ZERO : (BigDecimal)localVal;
            result[entry.getKey().intValue()] = rate.isDirect() ? localB.multiply(rate.getRateVal()) : localB.divide(rate.getRateVal(), rate.getPrecision(), RoundingMode.HALF_UP);
        }
    }

    private void copyValue(Object[] result, Row row, int[] opIndexes, int[] ipIndexes) {
        for (int i = 0; i < opIndexes.length; ++i) {
            result[opIndexes[i]] = row.get(ipIndexes[i]);
        }
    }
}

