/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.accbalance;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.util.Tuple2;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.util.BillParamUtil;
import kd.fi.bd.util.DebugTrace;
import kd.fi.bd.util.PeriodUtil;
import kd.fi.gl.report.MulOrgQPRpt;
import kd.fi.gl.report.accbalance.AccBalBalFunction;
import kd.fi.gl.report.accbalance.AccBalReportQuery;
import kd.fi.gl.report.common.ISelector;
import kd.fi.gl.report.common.OutPutFunction;
import kd.fi.gl.util.DataSetHelper;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.MulCurReportUtil;

public class AccBalBalSelector
implements ISelector {
    private static String INPUT_AMOUNT_FIELD = "begin#,debit#,credit#,yeardebit#,yearcredit#,end#";
    private static String INPUT_COUNT_FIELD = "count";
    private MulOrgQPRpt qpRpt;
    private AccBalReportQuery accBalQuery;
    private List<String> queryField;
    private String selectField;
    private QFilter[] qFilters;
    private OutPutFunction outPutFunction;
    private int accountIndex;
    private int orgIndex;
    private int periodIndex;
    private int endPeriodIndex;
    private int countIndex;
    private int[] groupIndexes;
    private int[] beginIndexes;
    private int[] debitIndexes;
    private int[] creditIndexes;
    private int[] yearDebitIndexes;
    private int[] yearCreditIndexes;
    private int[] endIndexes;

    public AccBalBalSelector(AccBalReportQuery accBalQuery) {
        this.accBalQuery = accBalQuery;
        this.qpRpt = accBalQuery.getQueryParam();
        this.initQueryField();
        this.initQFilters();
        this.initGroupIndexes();
        this.initIndexes();
        this.outPutFunction = new AccBalBalFunction(this);
    }

    private void initIndexes() {
        this.beginIndexes = this.setIndexes("begin");
        this.debitIndexes = this.setIndexes("debit");
        this.creditIndexes = this.setIndexes("credit");
        this.yearDebitIndexes = this.setIndexes("yeardebit");
        this.yearCreditIndexes = this.setIndexes("yearcredit");
        this.endIndexes = this.setIndexes("end");
        this.accountIndex = this.queryField.indexOf("account");
        this.orgIndex = this.queryField.indexOf("org");
        this.periodIndex = this.queryField.indexOf("period");
        this.endPeriodIndex = this.queryField.indexOf("endperiod");
        this.countIndex = this.queryField.indexOf("count");
    }

    private int[] setIndexes(String flag) {
        ArrayList<Integer> list = new ArrayList<Integer>(18);
        for (String field : this.merge(flag)) {
            list.add(this.queryField.indexOf(field));
        }
        return list.stream().mapToInt(x -> x).toArray();
    }

    private String[] merge(String prefix) {
        ArrayList<String> list = new ArrayList<String>();
        for (String pre : prefix.split(",")) {
            for (String suf : this.accBalQuery.getOutPutIndex().getTypes().split(",")) {
                list.add(pre + suf);
            }
        }
        return list.toArray(new String[0]);
    }

    private void initQFilters() {
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        list.add(new QFilter("org", "in", (Object)this.qpRpt.getFilteredChildOrg()));
        list.add(new QFilter("booktype", "=", (Object)this.qpRpt.getBookType()));
        list.add(new QFilter("accounttable", "=", (Object)this.qpRpt.getAccountTable()));
        list.add(new QFilter("endperiod", "in", (Object)PeriodUtil.getAvailableEndPeriodIds((String)">", (Long)this.qpRpt.getStartPeriod(), (Long[])this.qpRpt.getFilteredChildOrg().toArray(new Long[0]))));
        list.add(new QFilter("period", "<=", (Object)this.qpRpt.getEndPeriod()));
        list.add(new QFilter("period", ">=", (Object)(this.qpRpt.getEndPeriod() / GLUtil.TYPE_PERIOD_L * GLUtil.TYPE_PERIOD_L)));
        if (this.qpRpt.getMasterIdSet() != null) {
            Set mids = this.accBalQuery.getMasterIdMap().keySet().stream().collect(Collectors.toSet());
            if (!this.accBalQuery.getAllMasterIdMap().isEmpty()) {
                this.accBalQuery.getAllMasterIdMap().keySet().stream().forEach(x -> mids.add(x));
            }
            list.add(new QFilter("account", "in", mids));
        }
        if (!this.qpRpt.isSynCurrency() && !this.qpRpt.isAllCurrency()) {
            list.add(new QFilter("currency", "=", (Object)this.qpRpt.getCurrency()));
        }
        list.addAll(this.qpRpt.getComAssistFiltersForBal());
        this.qFilters = list.toArray(new QFilter[0]);
    }

    private static List<QFilter> buildComAssistQFilters(String prefix, List<Tuple2<String, Set<Long>>> comAssistVals) {
        ArrayList<QFilter> comAssistQfilters = new ArrayList<QFilter>(8);
        for (Tuple2<String, Set<Long>> tuple2 : comAssistVals) {
            String fieldKey = (String)tuple2.t1;
            Set vals = (Set)tuple2.t2;
            if (vals.isEmpty()) continue;
            comAssistQfilters.add(new QFilter(prefix + fieldKey, "in", (Object)vals));
        }
        return comAssistQfilters;
    }

    private void initGroupIndexes() {
        ArrayList<Integer> list = new ArrayList<Integer>(5);
        for (String groupByField : this.accBalQuery.getGroupByFields()) {
            list.add(this.queryField.indexOf(groupByField));
        }
        this.groupIndexes = list.stream().mapToInt(x -> x).toArray();
    }

    private void initQueryField() {
        ArrayList<String> selList = new ArrayList<String>();
        Collections.addAll(selList, this.accBalQuery.getGroupByFields());
        if (!selList.contains("org")) {
            selList.add("org");
        }
        selList.add(INPUT_COUNT_FIELD);
        String mulcur = this.qpRpt.getFilterInfo().getString("mulcur");
        MulCurReportUtil.addBalanceAmountFields(selList, (String)INPUT_AMOUNT_FIELD, (String)mulcur);
        if (this.qpRpt.isQueryCurrency()) {
            Collections.addAll(selList, INPUT_AMOUNT_FIELD.replace("#", "for").split(","));
        }
        if (this.qpRpt.isShowQty()) {
            Collections.addAll(selList, INPUT_AMOUNT_FIELD.replace("#", "qty").split(","));
        }
        if (!this.qpRpt.isShowPeriod()) {
            selList.add("period");
        }
        selList.add("endperiod");
        this.selectField = ((Object)selList).toString().replace("[", "").replace("]", "");
        this.queryField = new ArrayList<String>();
        for (String sel : selList) {
            String[] split = sel.split(" ");
            if (split.length == 1) {
                this.queryField.add(split[0]);
                continue;
            }
            this.queryField.add(split[1]);
        }
    }

    @Override
    public List<String> getQueryFields() {
        return this.queryField;
    }

    @Override
    public QFilter[] getQFilters() {
        return this.qFilters;
    }

    @Override
    public AccBalReportQuery getReportQuery() {
        return this.accBalQuery;
    }

    @Override
    public DataSet getDataSet(QFilter[] filters) {
        filters = filters == null ? this.qFilters : filters;
        boolean enableAcctBalQuery = !this.qpRpt.isShowAssist() && BillParamUtil.getBooleanValue((String)"83bfebc8000017ac", (String)"fi.gl.balance.enableacctbalquery", (boolean)false);
        String entity = enableAcctBalQuery ? "gl_acctbalance" : "gl_balance";
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)entity, (String)this.selectField, (QFilter[])filters, null);
        if (DebugTrace.enable()) {
            DataSetHelper.logDataSet((String)this.getClass().getName(), (DataSet)dataSet);
        }
        return dataSet;
    }

    @Override
    public OutPutFunction getOutPutFunction() {
        return this.outPutFunction;
    }

    public int getAccountIndex() {
        return this.accountIndex;
    }

    public int getPeriodIndex() {
        return this.periodIndex;
    }

    public int getEndPeriodIndex() {
        return this.endPeriodIndex;
    }

    public int[] getGroupIndexes() {
        return this.groupIndexes;
    }

    public int[] getBeginIndexes() {
        return this.beginIndexes;
    }

    public int[] getDebitIndexes() {
        return this.debitIndexes;
    }

    public int[] getCreditIndexes() {
        return this.creditIndexes;
    }

    public int[] getYearDebitIndexes() {
        return this.yearDebitIndexes;
    }

    public int[] getYearCreditIndexes() {
        return this.yearCreditIndexes;
    }

    public int[] getEndIndexes() {
        return this.endIndexes;
    }

    public int getCountIndex() {
        return this.countIndex;
    }

    public int getOrgIndex() {
        return this.orgIndex;
    }
}

