/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.accbalance;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.consts.MCT;
import kd.fi.gl.report.MulOrgQPRpt;
import kd.fi.gl.report.accbalance.AccBalInitBalFunction;
import kd.fi.gl.report.accbalance.AccBalReportQuery;
import kd.fi.gl.report.common.ISelector;
import kd.fi.gl.report.common.OutPutFunction;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.MulCurReportUtil;

public class AccBalInitBalSelector
implements ISelector {
    private AccBalReportQuery accBalQuery;
    private List<String> queryField;
    private QFilter[] qFilters;
    private OutPutFunction outPutFunction;
    private String selectField;
    private MulOrgQPRpt qpRpt;
    private String types;
    private int[] groupIndexes;
    private int[] yearProfitDebitIndexes;
    private int[] yearProfitCreditIndexes;
    private int[] yearDebitIndexes;
    private int[] yearCreditIndexes;
    private int orgIndex;
    private int accountIndex;
    private Set<Long> closedInitOrgs;

    public AccBalInitBalSelector(AccBalReportQuery accBalQuery) {
        this.accBalQuery = accBalQuery;
        this.qpRpt = accBalQuery.getQueryParam();
        this.types = accBalQuery.getOutPutIndex().getTypes();
        this.initOrg();
        this.initQueryField();
        this.initQFilters();
        this.initGroupIndexes();
        this.initIndexes();
        this.outPutFunction = new AccBalInitBalFunction(this);
    }

    private void initOrg() {
        QFilter btFilter = new QFilter("bookstype", "=", (Object)this.qpRpt.getBookType());
        long periodYear = this.qpRpt.getStartPeriod() / GLUtil.YEAR_PERIOD_L % 10000L;
        QFilter periodFilter = new QFilter("startperiod.periodyear", "=", (Object)periodYear);
        QFilter endFilter = new QFilter("isendinit", "=", (Object)true);
        DynamicObjectCollection books = QueryServiceHelper.query((String)"gl_accountbook", (String)"org", (QFilter[])new QFilter[]{btFilter, periodFilter, endFilter});
        this.closedInitOrgs = books.stream().mapToLong(x -> x.getLong("org")).boxed().collect(Collectors.toSet());
    }

    private void initIndexes() {
        this.yearProfitDebitIndexes = this.setIndexes("yearprofitdebit");
        this.yearProfitCreditIndexes = this.setIndexes("yearprofitcredit");
        this.yearDebitIndexes = this.setIndexes("yeardebit");
        this.yearCreditIndexes = this.setIndexes("yearcredit");
        this.orgIndex = this.queryField.indexOf("org");
        this.accountIndex = this.queryField.indexOf("account");
    }

    private void initGroupIndexes() {
        ArrayList<Integer> list = new ArrayList<Integer>(5);
        for (String groupByField : this.accBalQuery.getGroupByFields()) {
            list.add(this.queryField.indexOf(groupByField));
        }
        this.groupIndexes = list.stream().mapToInt(x -> x).toArray();
    }

    private void initQFilters() {
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        Set filteredChildOrg = this.qpRpt.getFilteredChildOrg();
        filteredChildOrg.retainAll(this.closedInitOrgs);
        list.add(new QFilter("org", "in", (Object)filteredChildOrg));
        list.add(new QFilter("booktype", "=", (Object)this.qpRpt.getBookType()));
        list.add(new QFilter("accounttable", "=", (Object)this.qpRpt.getAccountTable()));
        if (this.qpRpt.getMasterIdSet() != null) {
            list.add(new QFilter("account.masterid", "in", this.accBalQuery.getMasterIdMap().keySet()));
        }
        list.add(new QFilter("account.pltype", "!=", (Object)"0"));
        if (!this.qpRpt.isSynCurrency() && !this.qpRpt.isAllCurrency()) {
            list.add(new QFilter("currency", "=", (Object)this.qpRpt.getCurrency()));
        }
        list.addAll(this.qpRpt.getComAssistFiltersForBill(key -> key));
        this.qFilters = list.toArray(new QFilter[0]);
    }

    private void initQueryField() {
        ArrayList<String> sels = new ArrayList<String>();
        sels.add("account.masterid account");
        if (this.qpRpt.isQueryCurrency()) {
            sels.add("currency");
        }
        if (!this.qpRpt.getComAssistValsList().isEmpty()) {
            this.qpRpt.getComAssistValsList().stream().forEach(x -> sels.add((String)x.t1));
        }
        sels.add("org");
        if (this.qpRpt.isShowAssist()) {
            sels.add("assgrp");
        }
        if (this.qpRpt.isShowQty()) {
            sels.add("measureunit");
        }
        sels.addAll(this.mergeForSelectFields("yearprofitdebit", MCT.YEAR_PROFIT_DEBIT));
        sels.addAll(this.mergeForSelectFields("yearprofitcredit", MCT.YEAR_PROFIT_CREDIT));
        sels.addAll(this.mergeForSelectFields("yeardebit", MCT.YEAR_DEBIT));
        sels.addAll(this.mergeForSelectFields("yearcredit", MCT.YEAR_CREDIT));
        this.selectField = ((Object)sels).toString().replace("[", "").replace("]", "");
        this.queryField = new ArrayList<String>();
        for (String sel : sels) {
            String[] split = sel.split(" ");
            if (split.length == 1) {
                this.queryField.add(split[0]);
                continue;
            }
            this.queryField.add(split[1]);
        }
    }

    private int[] setIndexes(String flag) {
        ArrayList<Integer> list = new ArrayList<Integer>(12);
        for (String field : this.merge(flag)) {
            list.add(this.queryField.indexOf(field));
        }
        return list.stream().mapToInt(x -> x).toArray();
    }

    private List<String> merge(String prefix) {
        ArrayList<String> list = new ArrayList<String>();
        for (String pre : prefix.split(",")) {
            for (String suf : this.types.split(",")) {
                list.add(pre + suf);
            }
        }
        return list;
    }

    private List<String> mergeForSelectFields(String prefix, MCT mct) {
        ArrayList<String> list = new ArrayList<String>();
        String mulcur = this.qpRpt.getFilterInfo().getString("mulcur");
        for (String pre : prefix.split(",")) {
            for (String suf : this.types.split(",")) {
                if (Objects.equals(suf, "local")) {
                    list.add(MulCurReportUtil.getSingleInitBalanceLocalField((String)mulcur, (MCT)mct, (String)(pre + suf), (String)(pre + suf)));
                    continue;
                }
                list.add(pre + suf);
            }
        }
        return list;
    }

    @Override
    public List<String> getQueryFields() {
        return this.queryField;
    }

    @Override
    public QFilter[] getQFilters() {
        return this.qFilters;
    }

    @Override
    public AccBalReportQuery getReportQuery() {
        return this.accBalQuery;
    }

    @Override
    public DataSet getDataSet(QFilter[] filters) {
        filters = filters == null ? this.qFilters : filters;
        return QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"gl_initbalance", (String)this.selectField, (QFilter[])filters, null);
    }

    @Override
    public OutPutFunction getOutPutFunction() {
        return this.outPutFunction;
    }

    public int[] getGroupIndexes() {
        return this.groupIndexes;
    }

    public int[] getYearProfitDebitIndexes() {
        return this.yearProfitDebitIndexes;
    }

    public int[] getYearProfitCreditIndexes() {
        return this.yearProfitCreditIndexes;
    }

    public int[] getYearDebitIndexes() {
        return this.yearDebitIndexes;
    }

    public int[] getYearCreditIndexes() {
        return this.yearCreditIndexes;
    }

    public int getOrgIndex() {
        return this.orgIndex;
    }

    public int getAccountIndex() {
        return this.accountIndex;
    }
}

