/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.accbalance.v2;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.configuration.ReportConfiguration;
import kd.fi.gl.report.accbalance.v2.collect.AbstractSumTreeNode;
import kd.fi.gl.report.accbalance.v2.collect.BalanceRowList;
import kd.fi.gl.report.accbalance.v2.collect.simplenode.AbstractAccBalNode;
import kd.fi.gl.report.accbalance.v2.model.AccBalBatchRow;
import kd.fi.gl.report.accbalance.v2.model.BalSumGroup;
import kd.fi.gl.report.accbalance.v2.model.BalanceRow;

public class AccBalActionTracer
implements AutoCloseable {
    private static final ThreadLocal<AccBalActionTracer> CURRENT = new ThreadLocal();
    private static final Log log = LogFactory.getLog(AccBalActionTracer.class);
    private Set<Action> traceAction = null;

    public static AccBalActionTracer get() {
        AccBalActionTracer instance = CURRENT.get();
        if (instance == null) {
            instance = new AccBalActionTracer();
            CURRENT.set(instance);
        }
        return instance;
    }

    private AccBalActionTracer() {
        String actionStr;
        if (DebugTrace.enable() && StringUtils.isNotEmpty((String)(actionStr = ReportConfiguration.ACCBAL_TRACE_ACTION.getString()))) {
            try {
                this.traceAction = Arrays.stream(actionStr.replace(" ", "").split(",")).map(Action::valueOf).collect(Collectors.toSet());
                return;
            }
            catch (Throwable e) {
                log.error(e);
            }
        }
        this.traceAction = new HashSet<Action>(4);
    }

    public void logCreatingNode(AbstractSumTreeNode node) {
        if (this.enableTrace(Action.CREATE_NODE)) {
            String nodeVal = Optional.ofNullable(node.getValue()).map(Object::toString).orElse("null");
            log.info(String.format("action:%s, nodeType:%s, nodeValue:%s", new Object[]{Action.CREATE_NODE, node.getClass().getSimpleName(), nodeVal}));
        }
    }

    public void logBuildingMultiLevelData(AbstractAccBalNode node, List<BalanceRowList> leafRows) {
        if (this.enableTrace(Action.BUILD_MULTI_LEVEL_DATA)) {
            String nodeVal = Optional.ofNullable(node.getValue()).map(Object::toString).orElse("null");
            leafRows.forEach(rowList -> Lists.partition(rowList.getAllData(), (int)5).forEach(splitRows -> log.info(String.format("action:%s, nodeType:%s, nodeValue:%s, dataVal:%s, leafRows:%s", new Object[]{Action.BUILD_MULTI_LEVEL_DATA, node.getClass().getSimpleName(), nodeVal, rowList.getValue(), splitRows.toString()}))));
        }
    }

    public void logReturnData(AbstractSumTreeNode node, List<BalanceRow> resultRows) {
        if (this.enableTrace(Action.RETURN_DATA)) {
            String nodeVal = Optional.ofNullable(node.getValue()).map(Object::toString).orElse("null");
            Lists.partition(resultRows, (int)5).forEach(splitRows -> log.info(String.format("action:%s, nodeType:%s, nodeValue:%s, resRows:%s", new Object[]{Action.RETURN_DATA, node.getClass().getSimpleName(), nodeVal, splitRows.toString()})));
        }
    }

    boolean enableTrace(Action action) {
        return DebugTrace.enable() && (this.traceAction == null || this.traceAction.contains((Object)action));
    }

    public void fetchDetailGrpRow(BalSumGroup nextGrp) {
        if (this.enableTrace(Action.FETCH_DETAIL_GRP_ROW)) {
            log.info(String.format("action:%s, grp:%s", new Object[]{Action.RETURN_DATA, nextGrp}));
        }
    }

    public void logFillNoUseAction(TreeMap<String, Long> longNum2MidTreeMap) {
        if (this.enableTrace(Action.NO_USE_ACTION)) {
            log.info(String.format("action:%s, numTree:%s", new Object[]{Action.RETURN_DATA, longNum2MidTreeMap}));
        }
    }

    public void logSplitSingleBatch(List<AccBalBatchRow> batchRows) {
        if (this.enableTrace(Action.SPLIT_SINGLE_BATCH)) {
            log.info(String.format("action:%s, splitBatches:%s", new Object[]{Action.RETURN_DATA, batchRows}));
        }
    }

    public void logTotalData(BigDecimal[] totalData) {
        if (this.enableTrace(Action.TOTAL_BATCH)) {
            log.info(String.format("action:%s, totalData:%s", new Object[]{Action.TOTAL_BATCH, Arrays.toString(totalData)}));
        }
    }

    public Set<Action> getTraceAction() {
        return this.traceAction;
    }

    @Override
    public void close() {
        CURRENT.remove();
    }

    public static enum Action {
        CREATE_NODE,
        RETURN_DATA,
        BUILD_MULTI_LEVEL_DATA,
        FETCH_DETAIL_GRP_ROW,
        NO_USE_ACTION,
        SPLIT_SINGLE_BATCH,
        TOTAL_BATCH;

    }
}

