/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.accbalance.v2;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoContext;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.entity.report.ReportBatchQueryInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.logging.LogFactory;
import kd.fi.gl.common.Tuple;
import kd.fi.gl.exception.GLErrorCode;
import kd.fi.gl.report.CurType;
import kd.fi.gl.report.MulOrgQPRpt;
import kd.fi.gl.report.QueryParamFactory;
import kd.fi.gl.report.accbalance.v2.AccBalActionTracer;
import kd.fi.gl.report.accbalance.v2.AccBalQueryContext;
import kd.fi.gl.report.accbalance.v2.AcctLevelTree;
import kd.fi.gl.report.accbalance.v2.DetailBalanceMerger;
import kd.fi.gl.report.accbalance.v2.PLBalanceCacheHelper;
import kd.fi.gl.report.accbalance.v2.RowIdGenerator;
import kd.fi.gl.report.accbalance.v2.RowLimitManager;
import kd.fi.gl.report.accbalance.v2.collect.AccBalCollectService;
import kd.fi.gl.report.accbalance.v2.collect.CollectUtils;
import kd.fi.gl.report.accbalance.v2.collect.OrgTreeInfo;
import kd.fi.gl.report.accbalance.v2.collect.TotalCollectService;
import kd.fi.gl.report.accbalance.v2.model.AccBalBatchRow;
import kd.fi.gl.report.accbalance.v2.model.BalanceRow;
import kd.fi.gl.report.accbalance.v2.model.StateChart;
import kd.fi.gl.report.batchquery.IQueryService;
import kd.fi.gl.report.subsidiary.v2.core.ResultField;

public class AccBalQueryServiceImpl
implements IQueryService<AccBalBatchRow> {
    private final Algo algo = Algo.create((String)"AccBal#BatchQuery");
    public static final String DETAIL_SUM_ROW = "detailSumRow";
    public static final String ACCT_MID = "acctmid";

    public Algo getAlgo() {
        return this.algo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DataSet queryByBatch(AccBalBatchRow batchRow, ReportQueryParam queryParam, Object selectObj) {
        ReportBatchQueryInfo batchInfo = (ReportBatchQueryInfo)queryParam.byBatchInfo();
        String queryId = batchInfo.getBatchByDataSetCacheId();
        MulOrgQPRpt param = (MulOrgQPRpt)QueryParamFactory.createOrGetWithThreadCache((ReportQueryParam)queryParam, (String)"gl_rpt_accountbalance", (boolean)false);
        try (AccBalActionTracer tracer = AccBalActionTracer.get();){
            DataSet res;
            RowLimitManager rowLimit = new RowLimitManager(queryId);
            RowIdGenerator rowIdGenerator = new RowIdGenerator(queryId);
            TotalCollectService totalCollector = TotalCollectService.create(queryId, new StateChart(param));
            if (!batchRow.isTotalBatch()) {
                res = batchRow.isSingleBatchRow() ? this.doSingleBatchQuery(queryId, param, rowLimit, rowIdGenerator, totalCollector) : this.doBatchQuery(batchRow, queryId, param, rowLimit, rowIdGenerator, totalCollector, null);
                if (res == null) {
                    DataSet dataSet = null;
                    return dataSet;
                }
                totalCollector.cache();
            } else {
                try (AccBalQueryContext context = AccBalQueryContext.open(param, batchRow, rowLimit, rowIdGenerator, totalCollector);){
                    List<ResultField<BalanceRow>> resultFields = AccBalQueryServiceImpl.getResultFields(param, context);
                    res = this.toDataSet(resultFields, Collections.emptyIterator(), context);
                }
                DataSet total = totalCollector.getData(param, res.getRowMeta());
                res = res.union(total);
                if (rowLimit.isOutOfRowLimit()) {
                    this.setOutOfLimit(queryId);
                }
            }
            rowIdGenerator.cacheResult();
            rowLimit.cacheResult();
            DataSet dataSet = res;
            return dataSet;
        }
        catch (Throwable e) {
            LogFactory.getLog(AccBalQueryServiceImpl.class).error(e);
            throw new KDBizException(e, GLErrorCode.SYS_ERR, new Object[0]);
        }
    }

    private void setOutOfLimit(String queryId) {
        CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache().put(queryId + "#outoflimit", (Object)"true");
    }

    private DataSet doSingleBatchQuery(String queryId, MulOrgQPRpt param, RowLimitManager rowLimit, RowIdGenerator rowIdGenerator, TotalCollectService totalCollector) {
        List<AccBalBatchRow> batchRows = this.getSplitBatchs(param);
        ArrayList batchResults = new ArrayList(batchRows.size());
        OrgTreeInfo orgTreeInfo = param.isShowOrgTree() ? new OrgTreeInfo(param.getOrgViewId(), new HashSet<Long>(param.getAllEntityOrgs())) : null;
        RequestContext context = RequestContext.getOrCreate();
        batchRows.forEach(batchRow -> {
            Future oneBatchDs = ThreadService.submit(() -> this.doBatchQuery((AccBalBatchRow)batchRow, queryId, param, rowLimit, rowIdGenerator, totalCollector, orgTreeInfo), (TaskType)TaskType.GL_ACCOUNT_BALANCE_QUERY_DATA, (RequestContext)context);
            batchResults.add(oneBatchDs);
        });
        DataSet res = null;
        try {
            for (Future batchResult : batchResults) {
                DataSet ds = (DataSet)batchResult.get();
                res = res == null ? ds : res.union(ds);
            }
            return res;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private List<AccBalBatchRow> getSplitBatchs(MulOrgQPRpt param) {
        ArrayList<Map.Entry<String, Set<Long>>> firstLevelNum2ChildrenMid = new ArrayList<Map.Entry<String, Set<Long>>>(AcctLevelTree.create(param).getFirstLevelNum2ChildrenMid().entrySet());
        firstLevelNum2ChildrenMid.sort(Map.Entry.comparingByKey());
        ArrayList<AccBalBatchRow> batchRows = new ArrayList<AccBalBatchRow>();
        Lists.partition(firstLevelNum2ChildrenMid, (int)1).forEach(x -> {
            AccBalBatchRow batchRow = new AccBalBatchRow();
            ArrayList<String> nums = new ArrayList<String>(5);
            ArrayList<Long> mids = new ArrayList<Long>(5);
            x.forEach(num2Mids -> {
                nums.add((String)num2Mids.getKey());
                mids.addAll((Collection)num2Mids.getValue());
            });
            batchRow.setAcctNums(nums);
            batchRow.setAcctMids(mids);
            batchRows.add(batchRow);
        });
        AccBalActionTracer.get().logSplitSingleBatch(batchRows);
        return batchRows;
    }

    DataSet doBatchQuery(AccBalBatchRow batchRow, String queryId, MulOrgQPRpt qpRpt, RowLimitManager rowLimit, RowIdGenerator rowIdGenerator, TotalCollectService totalCollector, OrgTreeInfo orgTreeInfo) {
        try (AccBalQueryContext context = AccBalQueryContext.open(qpRpt, batchRow, rowLimit, rowIdGenerator, totalCollector);){
            DataSet res;
            context.setOrgTreeInfo(orgTreeInfo);
            context.setQueryId(queryId);
            List<ResultField<BalanceRow>> resultFields = AccBalQueryServiceImpl.getResultFields(qpRpt, context);
            StateChart stateChart = context.getStateChart();
            if (batchRow.isEnableSubBatch()) {
                res = this.doMultiOrgAndAssistQuery(batchRow, resultFields, queryId, context);
            } else if (context.getRowLimit().isOutOfRowLimit()) {
                res = this.toDataSet(resultFields, new ArrayList<BalanceRow>(), context);
            } else {
                List<BalanceRow> balanceRows;
                try (AlgoContext algoContext = Algo.newContext();){
                    balanceRows = AccBalCollectService.getInstance().collectSummaryData(context, stateChart.isShowAssist());
                }
                context.getTotalCollectService().sumAll(balanceRows);
                res = this.toDataSet(resultFields, balanceRows, context);
            }
            DataSet dataSet = res;
            return dataSet;
        }
    }

    DataSet toDataSet(List<ResultField<BalanceRow>> resultFields, Iterator<BalanceRow> resultRows, AccBalQueryContext context) {
        return ResultField.toDataSet(resultFields, resultRows, row -> row.setAccountDc(context.getAcctDcByMid(row.getAccountMid())), this.getAlgo());
    }

    DataSet toDataSet(List<ResultField<BalanceRow>> resultFields, List<BalanceRow> resultRows, AccBalQueryContext context) {
        return this.toDataSet(resultFields, resultRows.iterator(), context);
    }

    DataSet doMultiOrgAndAssistQuery(AccBalBatchRow batchRow, List<ResultField<BalanceRow>> resultFields, String queryId, AccBalQueryContext context) {
        if (context.getRowLimit().isOutOfRowLimit()) {
            return this.toDataSet(resultFields, new LinkedList<BalanceRow>(), context);
        }
        DetailBalanceMerger merger = null;
        DataSet res = null;
        if (batchRow.isSummaryBatch()) {
            DetailBalanceMerger.close(queryId);
            PLBalanceCacheHelper.clear(queryId);
            AccBalCollectService collectService = AccBalCollectService.getInstance();
            if (batchRow.isNoDataBatch()) {
                List<BalanceRow> balRows = new ArrayList<BalanceRow>();
                MulOrgQPRpt param = context.getQueryParam();
                StateChart stateChart = context.getStateChart();
                if (!(stateChart.isHideUnused() || param.isNoZeroYearBal() || param.isNoZeroBalance() || param.isNoZeroAmount())) {
                    balRows = collectService.fillNotExistedAcctRow(balRows, context);
                }
                res = this.toDataSet(resultFields, balRows, context);
            } else {
                List<BalanceRow> balRows = collectService.collectSummaryData(context, false);
                context.getTotalCollectService().sumAll(balRows);
                DataSet summaryBal = this.toDataSet(resultFields, balRows, context);
                if (context.getRowLimit().isOutOfRowLimit()) {
                    return summaryBal;
                }
                merger = DetailBalanceMerger.create(summaryBal, this.getAlgo());
                res = this.getAlgo().createDataSetBuilder(merger.getRowMeta()).build();
            }
        } else {
            merger = DetailBalanceMerger.create(queryId, this.getAlgo());
            if (merger != null) {
                Tuple<DataSet, Iterator<BalanceRow>> sumAndDetailRows = merger.nextSumAndDetailRows(context);
                if (sumAndDetailRows != null) {
                    DataSet detailBal = this.toDataSet(resultFields, (Iterator)sumAndDetailRows.item2, context);
                    res = ((DataSet)sumAndDetailRows.item1).union(detailBal);
                } else {
                    res = this.getAlgo().createDataSetBuilder(merger.getRowMeta()).build();
                }
                if (context.getRowLimit().isOutOfRowLimit()) {
                    res = res.union(merger.getAllSumRows());
                }
            }
        }
        if (merger != null) {
            merger.cache(queryId);
        }
        if (res == null) {
            res = this.toDataSet(resultFields, new LinkedList<BalanceRow>(), context);
        }
        return res;
    }

    private static List<ResultField<BalanceRow>> getResultFields(MulOrgQPRpt qpRpt, AccBalQueryContext context) {
        boolean isForeignCur = qpRpt.getCurType() == CurType.FOREIGN;
        long currency = qpRpt.getCurrency();
        boolean showByDc = qpRpt.isShowDataByDC();
        long pOrg = qpRpt.getPorg();
        StateChart stateChart = new StateChart(qpRpt);
        LinkedList<ResultField<BalanceRow>> res = new LinkedList<ResultField<BalanceRow>>();
        res.add(new ResultField<BalanceRow>("rowtype", (DataType)DataType.StringType, r -> r.getRowType().name()));
        if (stateChart.isShowOrgTree()) {
            res.add(new ResultField<BalanceRow>("rowid", (DataType)DataType.IntegerType, BalanceRow::getRowId));
            res.add(new ResultField<BalanceRow>("pid", (DataType)DataType.IntegerType, BalanceRow::getPid));
            res.add(new ResultField<BalanceRow>("isgroupnode", (DataType)DataType.BooleanType, BalanceRow::isSumRow));
            res.add(new ResultField<BalanceRow>("orglevel", (DataType)DataType.IntegerType, BalanceRow::getOrgLevel));
            res.add(new ResultField<BalanceRow>("islink", (DataType)DataType.BooleanType, BalanceRow::isLink));
        }
        res.add(new ResultField<BalanceRow>(DETAIL_SUM_ROW, (DataType)DataType.BooleanType, BalanceRow::isDetailSumRow));
        if (stateChart.isShowOrg()) {
            res.add(new ResultField<BalanceRow>("org", (DataType)DataType.LongType, BalanceRow::getOrgId));
        }
        res.add(new ResultField<BalanceRow>("flexorgid", (DataType)DataType.LongType, r -> stateChart.isShowOrg() ? (r.getOrgId() == 0L ? pOrg : r.getOrgId()) : pOrg));
        res.add(new ResultField<BalanceRow>("account", (DataType)DataType.LongType, r -> context.getAcctIdByMid(r.getAccountMid())));
        res.add(new ResultField<BalanceRow>(ACCT_MID, (DataType)DataType.LongType, BalanceRow::getAccountMid));
        res.add(new ResultField<BalanceRow>("assgrp", (DataType)DataType.LongType, r -> r.getAssgrpId() <= 0L ? 0L : r.getAssgrpId()));
        List comAssist = qpRpt.getCommonAssistKeys();
        for (int i = 0; i < comAssist.size(); ++i) {
            int finalI = i;
            res.add(new ResultField<BalanceRow>((String)comAssist.get(i) + "id", (DataType)DataType.LongType, r -> {
                long[] comAssistValues = r.getComAssistIds();
                return finalI < comAssistValues.length ? comAssistValues[finalI] : 0L;
            }));
        }
        res.add(new ResultField<BalanceRow>("yearbdebitlocal", (DataType)DataType.BigDecimalType, row -> CollectUtils.balAdjust(row.getYearBeginLocal(), row.getAccountDc(), showByDc, true)));
        res.add(new ResultField<BalanceRow>("yearbcreditlocal", (DataType)DataType.BigDecimalType, row -> CollectUtils.balAdjust(row.getYearBeginLocal(), row.getAccountDc(), showByDc, false)));
        res.add(new ResultField<BalanceRow>("begindebitlocal", (DataType)DataType.BigDecimalType, row -> CollectUtils.balAdjust(row.getBeginLocal(), row.getAccountDc(), showByDc, true)));
        res.add(new ResultField<BalanceRow>("begincreditlocal", (DataType)DataType.BigDecimalType, row -> CollectUtils.balAdjust(row.getBeginLocal(), row.getAccountDc(), showByDc, false)));
        res.add(new ResultField<BalanceRow>("debitlocal", (DataType)DataType.BigDecimalType, BalanceRow::getDebitLocal));
        res.add(new ResultField<BalanceRow>("creditlocal", (DataType)DataType.BigDecimalType, BalanceRow::getCreditLocal));
        res.add(new ResultField<BalanceRow>("enddebitlocal", (DataType)DataType.BigDecimalType, row -> CollectUtils.balAdjust(row.getEndLocal(), row.getAccountDc(), showByDc, true)));
        res.add(new ResultField<BalanceRow>("endcreditlocal", (DataType)DataType.BigDecimalType, row -> CollectUtils.balAdjust(row.getEndLocal(), row.getAccountDc(), showByDc, false)));
        res.add(new ResultField<BalanceRow>("yeardebitlocal", (DataType)DataType.BigDecimalType, BalanceRow::getYearDebitLocal));
        res.add(new ResultField<BalanceRow>("yearcreditlocal", (DataType)DataType.BigDecimalType, BalanceRow::getYearCreditLocal));
        res.add(new ResultField<BalanceRow>("currency", (DataType)DataType.LongType, r -> isForeignCur ? currency : r.getCurrencyId()));
        if (stateChart.isQueryCurrency()) {
            res.add(new ResultField<BalanceRow>("yearbdebitfor", (DataType)DataType.BigDecimalType, row -> CollectUtils.balAdjust(row.getYearBeginFor(), row.getAccountDc(), showByDc, true)));
            res.add(new ResultField<BalanceRow>("yearbcreditfor", (DataType)DataType.BigDecimalType, row -> CollectUtils.balAdjust(row.getYearBeginFor(), row.getAccountDc(), showByDc, false)));
            res.add(new ResultField<BalanceRow>("begindebitfor", (DataType)DataType.BigDecimalType, row -> CollectUtils.balAdjust(row.getBeginFor(), row.getAccountDc(), showByDc, true)));
            res.add(new ResultField<BalanceRow>("begincreditfor", (DataType)DataType.BigDecimalType, row -> CollectUtils.balAdjust(row.getBeginFor(), row.getAccountDc(), showByDc, false)));
            res.add(new ResultField<BalanceRow>("debitfor", (DataType)DataType.BigDecimalType, BalanceRow::getDebitFor));
            res.add(new ResultField<BalanceRow>("creditfor", (DataType)DataType.BigDecimalType, BalanceRow::getCreditFor));
            res.add(new ResultField<BalanceRow>("enddebitfor", (DataType)DataType.BigDecimalType, row -> CollectUtils.balAdjust(row.getEndFor(), row.getAccountDc(), showByDc, true)));
            res.add(new ResultField<BalanceRow>("endcreditfor", (DataType)DataType.BigDecimalType, row -> CollectUtils.balAdjust(row.getEndFor(), row.getAccountDc(), showByDc, false)));
            res.add(new ResultField<BalanceRow>("yeardebitfor", (DataType)DataType.BigDecimalType, BalanceRow::getYearDebitFor));
            res.add(new ResultField<BalanceRow>("yearcreditfor", (DataType)DataType.BigDecimalType, BalanceRow::getYearCreditFor));
        }
        if (stateChart.isShowQty()) {
            res.add(new ResultField<BalanceRow>("measureunit", (DataType)DataType.LongType, BalanceRow::getMeasureUnit));
            res.add(new ResultField<BalanceRow>("yearbdebitqty", (DataType)DataType.BigDecimalType, row -> CollectUtils.balAdjust(row.getYearBeginQty(), row.getAccountDc(), showByDc, true)));
            res.add(new ResultField<BalanceRow>("yearbcreditqty", (DataType)DataType.BigDecimalType, row -> CollectUtils.balAdjust(row.getYearBeginQty(), row.getAccountDc(), showByDc, false)));
            res.add(new ResultField<BalanceRow>("begindebitqty", (DataType)DataType.BigDecimalType, row -> CollectUtils.balAdjust(row.getBeginQty(), row.getAccountDc(), showByDc, true)));
            res.add(new ResultField<BalanceRow>("begincreditqty", (DataType)DataType.BigDecimalType, row -> CollectUtils.balAdjust(row.getBeginQty(), row.getAccountDc(), showByDc, false)));
            res.add(new ResultField<BalanceRow>("debitqty", (DataType)DataType.BigDecimalType, BalanceRow::getDebitQty));
            res.add(new ResultField<BalanceRow>("creditqty", (DataType)DataType.BigDecimalType, BalanceRow::getCreditQty));
            res.add(new ResultField<BalanceRow>("enddebitqty", (DataType)DataType.BigDecimalType, row -> CollectUtils.balAdjust(row.getEndQty(), row.getAccountDc(), showByDc, true)));
            res.add(new ResultField<BalanceRow>("endcreditqty", (DataType)DataType.BigDecimalType, row -> CollectUtils.balAdjust(row.getEndQty(), row.getAccountDc(), showByDc, false)));
            res.add(new ResultField<BalanceRow>("yeardebitqty", (DataType)DataType.BigDecimalType, BalanceRow::getYearDebitQty));
            res.add(new ResultField<BalanceRow>("yearcreditqty", (DataType)DataType.BigDecimalType, BalanceRow::getYearCreditQty));
        }
        if (qpRpt.isShowRpt()) {
            res.add(new ResultField<BalanceRow>("currencyrptid", (DataType)DataType.LongType, r -> qpRpt.getCurRpt()));
            res.add(new ResultField<BalanceRow>("yearbdebitrpt", (DataType)DataType.BigDecimalType, row -> CollectUtils.balAdjust(row.getYearBeginRpt(), row.getAccountDc(), showByDc, true)));
            res.add(new ResultField<BalanceRow>("yearbcreditrpt", (DataType)DataType.BigDecimalType, row -> CollectUtils.balAdjust(row.getYearBeginRpt(), row.getAccountDc(), showByDc, false)));
            res.add(new ResultField<BalanceRow>("begindebitrpt", (DataType)DataType.BigDecimalType, row -> CollectUtils.balAdjust(row.getBeginRpt(), row.getAccountDc(), showByDc, true)));
            res.add(new ResultField<BalanceRow>("begincreditrpt", (DataType)DataType.BigDecimalType, row -> CollectUtils.balAdjust(row.getBeginRpt(), row.getAccountDc(), showByDc, false)));
            res.add(new ResultField<BalanceRow>("debitrpt", (DataType)DataType.BigDecimalType, BalanceRow::getDebitRpt));
            res.add(new ResultField<BalanceRow>("creditrpt", (DataType)DataType.BigDecimalType, BalanceRow::getCreditRpt));
            res.add(new ResultField<BalanceRow>("enddebitrpt", (DataType)DataType.BigDecimalType, row -> CollectUtils.balAdjust(row.getEndRpt(), row.getAccountDc(), showByDc, true)));
            res.add(new ResultField<BalanceRow>("endcreditrpt", (DataType)DataType.BigDecimalType, row -> CollectUtils.balAdjust(row.getEndRpt(), row.getAccountDc(), showByDc, false)));
            res.add(new ResultField<BalanceRow>("yeardebitrpt", (DataType)DataType.BigDecimalType, BalanceRow::getYearDebitRpt));
            res.add(new ResultField<BalanceRow>("yearcreditrpt", (DataType)DataType.BigDecimalType, BalanceRow::getYearCreditRpt));
        }
        return res;
    }
}

