/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.accbalance.v2.batch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.IntStream;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.ext.fi.util.StringUtils;
import kd.bos.orm.ORM;
import kd.bos.orm.query.Distinctable;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.WithDistinctable;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.gl.configuration.ReportConfiguration;
import kd.fi.gl.report.MulOrgQPRpt;
import kd.fi.gl.report.accbalance.v2.AccBalQueryUtil;
import kd.fi.gl.report.accbalance.v2.AcctLevelTree;
import kd.fi.gl.report.accbalance.v2.batch.IAccBalBatchStrategy;
import kd.fi.gl.report.accbalance.v2.model.AccBalBatchRow;
import kd.fi.gl.report.accbalance.v2.model.BalSumGroup;
import kd.fi.gl.report.accbalance.v2.model.StateChart;

public class AccBalBatchStrategyFactory {
    static final IAccBalBatchStrategy BY_SINGLETON_BATCH = new IAccBalBatchStrategy(){

        @Override
        public List<AccBalBatchRow> getBatches(MulOrgQPRpt param) {
            AccBalBatchRow batchRow = new AccBalBatchRow();
            batchRow.setSingleBatchRow(true);
            return Collections.singletonList(batchRow);
        }

        @Override
        public boolean enable(MulOrgQPRpt param) {
            return !param.isShowOrg() && !param.isShowAssist() || param.isShowOrgTree();
        }
    };
    static final IAccBalBatchStrategy BY_LEAF_ACCOUNT = new IAccBalBatchStrategy(){

        @Override
        public List<AccBalBatchRow> getBatches(MulOrgQPRpt param) {
            Map<String, List<Long>> num2Mid = AcctLevelTree.create(param).getLeafLongNum2Mid();
            ArrayList<AccBalBatchRow> res = new ArrayList<AccBalBatchRow>();
            num2Mid.forEach((num, mids) -> {
                AccBalBatchRow batch = new AccBalBatchRow();
                batch.setAcctNums(Collections.singletonList(num));
                batch.setAcctMids((List<Long>)mids);
                res.add(batch);
            });
            return res;
        }

        @Override
        public boolean enable(MulOrgQPRpt param) {
            return param.isShowLeafAccount() && !param.isShowAssist() && param.getFilteredChildOrg().size() > 10;
        }
    };
    static final IAccBalBatchStrategy BY_FIRST_LEVEL_ACCOUNT = new IAccBalBatchStrategy(){

        @Override
        public List<AccBalBatchRow> getBatches(MulOrgQPRpt param) {
            TreeMap<String, Set<Long>> firstLevelNum2ChildrenMid = AcctLevelTree.create(param).getFirstLevelNum2ChildrenMid();
            ArrayList<AccBalBatchRow> res = new ArrayList<AccBalBatchRow>();
            firstLevelNum2ChildrenMid.forEach((num, mid) -> {
                AccBalBatchRow batch = new AccBalBatchRow();
                batch.setAcctNums(Collections.singletonList(num));
                batch.setAcctMids(new ArrayList<Long>((Collection<Long>)mid));
                res.add(batch);
            });
            return res;
        }

        @Override
        public boolean enable(MulOrgQPRpt param) {
            return param.isShowOrg() && !param.isShowLeafAccount() && !param.isShowAssist();
        }
    };
    static final IAccBalBatchStrategy BY_ACCOUNT_AND_ORG = new IAccBalBatchStrategy(){

        @Override
        public List<AccBalBatchRow> getBatches(MulOrgQPRpt param) {
            AcctLevelTree acctLevelTree = AcctLevelTree.create(param);
            TreeMap<String, Set<Long>> num2Mids = acctLevelTree.getFirstLevelNum2ChildrenMid();
            ArrayList<AccBalBatchRow> res = new ArrayList<AccBalBatchRow>(64);
            DataSet sumGrpDs = this.getSumGrpDs(param, acctLevelTree);
            HashMap acct2Grp = new HashMap(128);
            sumGrpDs.forEach(sumGrp -> {
                Long acct = sumGrp.getLong("account");
                Set grps = acct2Grp.computeIfAbsent(acct, x -> new HashSet());
                grps.add(new BalSumGroup(sumGrp.getLong("org"), acct, sumGrp.getLong("currency")));
            });
            int batchLimit = ReportConfiguration.ACCBAL_BATCHES_LIMIT.getInt();
            num2Mids.forEach((num, mids) -> {
                if (res.size() < batchLimit) {
                    AccBalBatchRow batchRow = new AccBalBatchRow();
                    batchRow.setSummaryBatch(true);
                    batchRow.setAcctMids(new ArrayList<Long>((Collection<Long>)mids));
                    batchRow.setAcctNums(Collections.singletonList(num));
                    res.add(batchRow);
                    boolean hasData = false;
                    for (Long mid : mids) {
                        Set grps = acct2Grp.getOrDefault(mid, new HashSet());
                        for (BalSumGroup grp : grps) {
                            AccBalBatchRow detailRow = new AccBalBatchRow();
                            detailRow.setSummaryBatch(false);
                            detailRow.setOrgIds(Collections.singletonList(grp.getOrgId()));
                            detailRow.setCurrencyIds(Collections.singletonList(grp.getCurrencyId()));
                            detailRow.setAcctMids(Collections.singletonList(grp.getAccountId()));
                            detailRow.setAcctNums(Collections.singletonList(num));
                            res.add(detailRow);
                        }
                        hasData = hasData || !grps.isEmpty();
                    }
                    batchRow.setNoDataBatch(!hasData);
                }
            });
            res.forEach(row -> row.setEnableSubBatch(true));
            return res;
        }

        private DataSet getSumGrpDs(MulOrgQPRpt param, AcctLevelTree acctLevelTree) {
            ArrayList<Long> leafAcctMids = new ArrayList<Long>();
            if (!acctLevelTree.isSelectAllNum()) {
                acctLevelTree.getLeafLongNum2Mid().values().forEach(leafAcctMids::addAll);
            }
            StateChart stateChart = new StateChart(param);
            List<String> orderFields = AccBalQueryUtil.getSumFieldsOrderBys(stateChart, "accountmid.number");
            ArrayList<String> selectFields = new ArrayList<String>(orderFields);
            selectFields.add("account");
            List<QFilter> baseFilters = AccBalQueryUtil.getBalBaseFilters(param, param.getAllEntityOrgSet(), leafAcctMids);
            int batchLimit = ReportConfiguration.ACCBAL_BATCHES_LIMIT.getInt();
            ORM orm = ORM.create();
            orm.setDataEntityType("gl_acctbalance", (IDataEntityType)AccBalQueryUtil.getBalEntity("gl_acctbalance"));
            DataSet sumGrpDs = orm.queryDataSet("AccBalBatchStrategyFactory", "gl_acctbalance", String.join((CharSequence)",", selectFields), baseFilters.toArray(new QFilter[0]), String.join((CharSequence)",", orderFields), batchLimit, (Distinctable)WithDistinctable.get());
            if (sumGrpDs.getRowMeta().getFieldIndex("currency", false) == -1) {
                sumGrpDs = sumGrpDs.addField("0", "currency");
            }
            return sumGrpDs;
        }

        @Override
        public boolean enable(MulOrgQPRpt param) {
            return param.isShowAssist() && param.isShowOrg() && !param.isNoZeroAmount() && !param.isNoZeroBalance() && !param.isNoZeroYearBal();
        }
    };
    static final List<IAccBalBatchStrategy> ALL_BATCH_STRATEGY = Arrays.asList(BY_SINGLETON_BATCH, BY_ACCOUNT_AND_ORG, BY_LEAF_ACCOUNT, BY_FIRST_LEVEL_ACCOUNT);

    public static IAccBalBatchStrategy getStrategy(MulOrgQPRpt param) {
        String disableStrategy = ReportConfiguration.ACCBAL_DISABLE_BATCH_STRATEGY.getString();
        HashSet disableIndex = new HashSet(4);
        if (StringUtils.isNotEmpty((String)disableStrategy)) {
            Arrays.stream(disableStrategy.split(",")).map(Integer::parseInt).forEach(disableIndex::add);
        }
        return IntStream.range(0, ALL_BATCH_STRATEGY.size()).filter(i -> !disableIndex.contains(i)).mapToObj(ALL_BATCH_STRATEGY::get).filter(strategy -> strategy.enable(param)).findFirst().orElse(BY_FIRST_LEVEL_ACCOUNT);
    }

    public static IAccBalBatchStrategy getStrategy2(MulOrgQPRpt param) {
        QFilter acctFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)param.getPorg()).and(new QFilter("accounttable", "=", (Object)param.getAccountTable()));
        if (QueryServiceHelper.exists((String)"bd_accountview", (QFilter[])acctFilter.toArray())) {
            return AccBalBatchStrategyFactory.getStrategy(param);
        }
        return new IAccBalBatchStrategy(){

            @Override
            public List<AccBalBatchRow> getBatches(MulOrgQPRpt param) {
                return new ArrayList<AccBalBatchRow>();
            }

            @Override
            public boolean enable(MulOrgQPRpt param) {
                return true;
            }
        };
    }
}

