/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.accbalance.v2.collect;

import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kd.fi.gl.configuration.ReportConfiguration;
import kd.fi.gl.report.MulOrgQPRpt;
import kd.fi.gl.report.accbalance.v2.AccBalActionTracer;
import kd.fi.gl.report.accbalance.v2.AccBalQueryContext;
import kd.fi.gl.report.accbalance.v2.PLBalanceCacheHelper;
import kd.fi.gl.report.accbalance.v2.RowLimitManager;
import kd.fi.gl.report.accbalance.v2.collect.CollectUtils;
import kd.fi.gl.report.accbalance.v2.collect.DetailBalCollectService;
import kd.fi.gl.report.accbalance.v2.collect.ISumNode;
import kd.fi.gl.report.accbalance.v2.collect.simplenode.AccSumTreeNodeFactory;
import kd.fi.gl.report.accbalance.v2.ds.impl.AccBalanceDs;
import kd.fi.gl.report.accbalance.v2.ds.impl.BalanceLogDS;
import kd.fi.gl.report.accbalance.v2.ds.impl.PLInitBalanceDS;
import kd.fi.gl.report.accbalance.v2.ds.impl.PLProfitInitBalanceDS;
import kd.fi.gl.report.accbalance.v2.ds.impl.PLVoucherDS;
import kd.fi.gl.report.accbalance.v2.model.BalGroup;
import kd.fi.gl.report.accbalance.v2.model.BalSumGroup;
import kd.fi.gl.report.accbalance.v2.model.BalanceRow;
import kd.fi.gl.report.accbalance.v2.model.IBalanceRow;
import kd.fi.gl.report.accbalance.v2.model.RowType;
import kd.fi.gl.report.accbalance.v2.model.StateChart;

public class AccBalCollectService {
    private final AccBalActionTracer tracer = AccBalActionTracer.get();

    public static AccBalCollectService getInstance() {
        return new AccBalCollectService();
    }

    public List<BalanceRow> collectSummaryData(AccBalQueryContext context, boolean loadAssist) {
        StateChart stateChart = context.getStateChart();
        ArrayList<Iterator<IBalanceRow>> dataSources = new ArrayList<Iterator<IBalanceRow>>();
        dataSources.add(AccBalanceDs.getInstance().getData());
        dataSources.add(BalanceLogDS.getInstance().getData());
        HashMap<BalGroup, BalanceRow> plBalMap = new HashMap<BalGroup, BalanceRow>();
        MulOrgQPRpt param = context.getQueryParam();
        if (param.isSubstractPL()) {
            dataSources.add(this.getPlDataSource(context, plBalMap));
        }
        if (stateChart.isShowLeafAccount() && dataSources.stream().noneMatch(Iterator::hasNext)) {
            return new ArrayList<BalanceRow>();
        }
        List<BalanceRow> balanceRows = this.collectSummaryData(dataSources);
        balanceRows.forEach(r -> r.setAccountDc(context.getAcctDcByMid(r.getAccountMid())));
        if (!stateChart.isQueryAssgrp() && stateChart.isShowAssist()) {
            balanceRows = this.handleDetailRows(balanceRows, loadAssist, plBalMap, context);
            if (!loadAssist) {
                PLBalanceCacheHelper.cache(context.getQueryId(), plBalMap);
            }
        }
        MulOrgQPRpt queryParam = context.getQueryParam();
        if (!(stateChart.isHideUnused() || queryParam.isNoZeroYearBal() || queryParam.isNoZeroBalance() || queryParam.isNoZeroAmount())) {
            balanceRows = this.fillNotExistedAcctRow(balanceRows, context);
        }
        return balanceRows;
    }

    public List<BalanceRow> fillNotExistedAcctRow(List<BalanceRow> balanceRows, AccBalQueryContext context) {
        BalanceRow balRow;
        ArrayList<BalanceRow> res = new ArrayList<BalanceRow>(balanceRows.size());
        TreeMap<String, Long> longNum2MidTreeMap = context.getLongNum2MidTreeMap();
        this.tracer.logFillNoUseAction(longNum2MidTreeMap);
        Iterator<BalanceRow> balItr = balanceRows.iterator();
        BalanceRow balanceRow = balRow = balItr.hasNext() ? balItr.next() : null;
        while (!longNum2MidTreeMap.isEmpty()) {
            Map.Entry<String, Long> curLongNum2Mid = longNum2MidTreeMap.pollFirstEntry();
            boolean existRow = false;
            while (balRow != null && balRow.getAcctLongNum().equals(curLongNum2Mid.getKey())) {
                existRow = true;
                res.add(balRow);
                balRow = balItr.hasNext() ? balItr.next() : null;
            }
            if (existRow || !context.needShowAcctNum(curLongNum2Mid.getKey())) continue;
            context.getTotalCollectService().collectEmptyRow();
            res.add(AccBalCollectService.createEmptyRow(context, curLongNum2Mid.getValue()));
        }
        return res;
    }

    private static BalanceRow createEmptyRow(AccBalQueryContext context, Long acctMid) {
        BalanceRow emptyRow = BalanceRow.create(context);
        long org = context.getStateChart().isShowOrgTree() ? context.getQueryParam().getPorg() : 0L;
        emptyRow.setBalSumGroup(new BalSumGroup(org, acctMid, 0L));
        emptyRow.setRowType(RowType.ACCT_SUMMARY);
        emptyRow.setSumRow(false);
        return emptyRow;
    }

    private List<BalanceRow> handleDetailRows(List<BalanceRow> balanceRows, boolean loadAssist, Map<BalGroup, BalanceRow> plBalMap, AccBalQueryContext context) {
        if (context.getRowLimit().isOutOfRowLimit()) {
            return balanceRows;
        }
        balanceRows.removeIf(row -> {
            boolean showAssist = context.needShowAssist(row.getAcctLongNum());
            return RowType.DETAIL_SUMMARY == row.getRowType() && showAssist;
        });
        if (!balanceRows.isEmpty() && loadAssist) {
            balanceRows = this.insertDetailRows(balanceRows, plBalMap, context);
        }
        return balanceRows;
    }

    private List<BalanceRow> insertDetailRows(List<BalanceRow> balanceRows, Map<BalGroup, BalanceRow> plBalMap, AccBalQueryContext context) {
        RowLimitManager rowLimit = context.getRowLimit();
        LinkedList<BalanceRow> res = new LinkedList<BalanceRow>();
        for (BalanceRow balRow : balanceRows) {
            res.add(balRow);
            if (rowLimit.isOutOfRowLimit() || !balRow.isDetailSumRow() || !context.needShowAssist(balRow.getAcctLongNum())) continue;
            Iterator<BalanceRow> data = DetailBalCollectService.getData(balRow.getBalSumGroup(), plBalMap, context);
            balRow.setSumRow(true);
            balRow.setLink(false);
            data.forEachRemaining(row -> {
                row.setPid(balRow.getRowId());
                res.add((BalanceRow)row);
            });
        }
        return res;
    }

    private Iterator<IBalanceRow> getPlDataSource(final AccBalQueryContext context, final Map<BalGroup, BalanceRow> plBalMap) {
        Iterator initBal = PLInitBalanceDS.getInstance().getData();
        final Iterator<IBalanceRow> plVch = PLVoucherDS.getInstance().getData();
        if (context.isQueryProfitAcct()) {
            Iterator<IBalanceRow> profitInitBal = PLProfitInitBalanceDS.getInstance().getData();
            initBal = Iterators.concat(initBal, profitInitBal);
        }
        final int plGroupLimit = ReportConfiguration.ACCBAL_PL_GROUP_LIMIT.getInt();
        final Iterator finalInitBal = initBal;
        return new Iterator<IBalanceRow>(){

            @Override
            public boolean hasNext() {
                return finalInitBal.hasNext() || plVch.hasNext();
            }

            @Override
            public IBalanceRow next() {
                IBalanceRow balRow = null;
                if (finalInitBal.hasNext()) {
                    balRow = (IBalanceRow)finalInitBal.next();
                } else if (plVch.hasNext()) {
                    balRow = (IBalanceRow)plVch.next();
                }
                if (balRow != null) {
                    BalGroup grp = BalGroup.createGrp(context, balRow);
                    BalanceRow plSumRow = (BalanceRow)plBalMap.get(grp);
                    if (plSumRow == null && plBalMap.size() < plGroupLimit) {
                        plSumRow = new BalanceRow();
                        plSumRow.setBalSumGroup(grp.getBalSumGroup());
                        plSumRow.setBalDetailGroup(grp.getBalDetailGroup());
                        plBalMap.put(grp, plSumRow);
                    }
                    if (plSumRow != null) {
                        CollectUtils.sumTo(plSumRow, balRow, context.getStateChart());
                    }
                }
                return balRow;
            }
        };
    }

    private List<BalanceRow> collectSummaryData(List<Iterator<IBalanceRow>> balRowItrs) {
        ISumNode<IBalanceRow, List<BalanceRow>> root = new AccSumTreeNodeFactory(AccBalQueryContext.getCurrent()).createRoot();
        for (Iterator<IBalanceRow> balRowItr : balRowItrs) {
            balRowItr.forEachRemaining(root::addData);
        }
        return root.getAllData();
    }
}

