/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.accbalance.v2.collect;

import com.google.common.collect.Table;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.ThreeTuple;
import kd.fi.gl.report.accbalance.v2.collect.TreeNodeUtil;

public class OrgTreeInfo {
    private final Map<Long, String> id2LongNum;
    private final Table<String, Integer, String> levelTable;
    private final Map<String, Long> longNum2id;
    private final int commonParentLevel;

    public OrgTreeInfo(long viewId, Set<Long> orgs) {
        this.id2LongNum = TreeNodeUtil.getOrgLongNums(viewId, orgs);
        HashSet<String> longNums = new HashSet<String>(this.id2LongNum.values());
        this.levelTable = TreeNodeUtil.getAllSuperLevelTable(longNums, '!');
        this.longNum2id = TreeNodeUtil.getOrgNum2IdMap(viewId, new HashSet<String>(this.levelTable.values()));
        this.commonParentLevel = TreeNodeUtil.getCommonParentLevel(new HashSet<String>(this.id2LongNum.values()));
    }

    public ThreeTuple<Map<Long, String>, Table<String, Integer, String>, Map<String, Long>> getThree() {
        return new ThreeTuple(this.id2LongNum, this.levelTable, this.longNum2id);
    }

    public int getCommonParentLevel() {
        return this.commonParentLevel;
    }
}

