/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.accbalance.v2.collect;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.SettableArrayRow;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.util.StringUtils;
import kd.fi.gl.report.CurType;
import kd.fi.gl.report.MulOrgQPRpt;
import kd.fi.gl.report.accbalance.v2.AccBalActionTracer;
import kd.fi.gl.report.accbalance.v2.collect.CollectUtils;
import kd.fi.gl.report.accbalance.v2.model.BalanceRow;
import kd.fi.gl.report.accbalance.v2.model.RowType;
import kd.fi.gl.report.accbalance.v2.model.StateChart;

public class TotalCollectService {
    private int i = 0;
    private final int yearBeginDebitLocal = this.i++;
    private final int yearBeginCreditLocal = this.i++;
    private final int beginDebitLocal = this.i++;
    private final int beginCreditLocal = this.i++;
    private final int debitLocal = this.i++;
    private final int creditLocal = this.i++;
    private final int yearDebitLocal = this.i++;
    private final int yearCreditLocal = this.i++;
    private final int endDebitLocal = this.i++;
    private final int endCreditLocal = this.i++;
    private final int yearBeginDebitFor = this.i++;
    private final int yearBeginCreditFor = this.i++;
    private final int beginDebitFor = this.i++;
    private final int beginCreditFor = this.i++;
    private final int debitFor = this.i++;
    private final int creditFor = this.i++;
    private final int yearDebitFor = this.i++;
    private final int yearCreditFor = this.i++;
    private final int endDebitFor = this.i++;
    private final int endCreditFor = this.i++;
    private final int yearBeginDebitRpt = this.i++;
    private final int yearBeginCreditRpt = this.i++;
    private final int beginDebitRpt = this.i++;
    private final int beginCreditRpt = this.i++;
    private final int debitRpt = this.i++;
    private final int creditRpt = this.i++;
    private final int yearDebitRpt = this.i++;
    private final int yearCreditRpt = this.i++;
    private final int endDebitRpt = this.i++;
    private final int endCreditRpt = this.i++;
    private final int count = this.i++;
    private final BigDecimal[] totalData;
    private final String cacheKey;
    private final StateChart stateChart;

    static DistributeSessionlessCache getCache() {
        return CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
    }

    public TotalCollectService(BigDecimal[] totalData, StateChart stateChart, String cacheKey) {
        this.totalData = totalData;
        this.cacheKey = cacheKey;
        this.stateChart = stateChart;
    }

    public static TotalCollectService create(String queryId, StateChart stateChart) {
        String cacheKey = queryId + "#TotalSummary";
        return (TotalCollectService)ThreadCache.get((Object)cacheKey, () -> {
            String summaryRowStr = (String)TotalCollectService.getCache().get(cacheKey);
            Object[] totalData = new BigDecimal[31];
            Arrays.fill(totalData, BigDecimal.ZERO);
            if (StringUtils.isNotEmpty((String)summaryRowStr)) {
                totalData = (BigDecimal[])SerializationUtils.deSerializeFromBase64((String)summaryRowStr);
            }
            return new TotalCollectService((BigDecimal[])totalData, stateChart, cacheKey);
        }, (boolean)true);
    }

    public synchronized void sumAll(List<BalanceRow> balRows) {
        balRows.stream().filter(BalanceRow::isDetailSumRow).forEach(this::sum);
    }

    public void sum(BalanceRow balRow) {
        this.sum(this.totalData, balRow);
    }

    public void collectEmptyRow() {
        this.totalData[this.count] = BigDecimal.ONE;
    }

    private void sum(BigDecimal[] totalData, BalanceRow row) {
        totalData[this.count] = BigDecimal.ONE;
        boolean showByDc = this.stateChart.isShowByDc();
        totalData[this.yearBeginDebitLocal] = totalData[this.yearBeginDebitLocal].add(CollectUtils.balAdjust(row.getYearBeginLocal(), row.getAccountDc(), showByDc, true));
        totalData[this.yearBeginCreditLocal] = totalData[this.yearBeginCreditLocal].add(CollectUtils.balAdjust(row.getYearBeginLocal(), row.getAccountDc(), showByDc, false));
        totalData[this.beginDebitLocal] = totalData[this.beginDebitLocal].add(CollectUtils.balAdjust(row.getBeginLocal(), row.getAccountDc(), showByDc, true));
        totalData[this.beginCreditLocal] = totalData[this.beginCreditLocal].add(CollectUtils.balAdjust(row.getBeginLocal(), row.getAccountDc(), showByDc, false));
        totalData[this.debitLocal] = totalData[this.debitLocal].add(row.getDebitLocal());
        totalData[this.creditLocal] = totalData[this.creditLocal].add(row.getCreditLocal());
        totalData[this.yearDebitLocal] = totalData[this.yearDebitLocal].add(row.getYearDebitLocal());
        totalData[this.yearCreditLocal] = totalData[this.yearCreditLocal].add(row.getYearCreditLocal());
        totalData[this.endDebitLocal] = totalData[this.endDebitLocal].add(CollectUtils.balAdjust(row.getEndLocal(), row.getAccountDc(), showByDc, true));
        totalData[this.endCreditLocal] = totalData[this.endCreditLocal].add(CollectUtils.balAdjust(row.getEndLocal(), row.getAccountDc(), showByDc, false));
        if (this.stateChart.isForeignCurr()) {
            totalData[this.yearBeginDebitFor] = totalData[this.yearBeginDebitFor].add(CollectUtils.balAdjust(row.getYearBeginFor(), row.getAccountDc(), showByDc, true));
            totalData[this.yearBeginCreditFor] = totalData[this.yearBeginCreditFor].add(CollectUtils.balAdjust(row.getYearBeginFor(), row.getAccountDc(), showByDc, false));
            totalData[this.beginDebitFor] = totalData[this.beginDebitFor].add(CollectUtils.balAdjust(row.getBeginFor(), row.getAccountDc(), showByDc, true));
            totalData[this.beginCreditFor] = totalData[this.beginCreditFor].add(CollectUtils.balAdjust(row.getBeginFor(), row.getAccountDc(), showByDc, false));
            totalData[this.debitFor] = totalData[this.debitFor].add(row.getDebitFor());
            totalData[this.creditFor] = totalData[this.creditFor].add(row.getCreditFor());
            totalData[this.yearDebitFor] = totalData[this.yearDebitFor].add(row.getYearDebitFor());
            totalData[this.yearCreditFor] = totalData[this.yearCreditFor].add(row.getYearCreditFor());
            totalData[this.endDebitFor] = totalData[this.endDebitFor].add(CollectUtils.balAdjust(row.getEndFor(), row.getAccountDc(), showByDc, true));
            totalData[this.endCreditFor] = totalData[this.endCreditFor].add(CollectUtils.balAdjust(row.getEndFor(), row.getAccountDc(), showByDc, false));
        }
        if (this.stateChart.isShowRptCurr()) {
            totalData[this.yearBeginDebitRpt] = totalData[this.yearBeginDebitRpt].add(CollectUtils.balAdjust(row.getYearBeginRpt(), row.getAccountDc(), showByDc, true));
            totalData[this.yearBeginCreditRpt] = totalData[this.yearBeginCreditRpt].add(CollectUtils.balAdjust(row.getYearBeginRpt(), row.getAccountDc(), showByDc, false));
            totalData[this.beginDebitRpt] = totalData[this.beginDebitRpt].add(CollectUtils.balAdjust(row.getBeginRpt(), row.getAccountDc(), showByDc, true));
            totalData[this.beginCreditRpt] = totalData[this.beginCreditRpt].add(CollectUtils.balAdjust(row.getBeginRpt(), row.getAccountDc(), showByDc, false));
            totalData[this.debitRpt] = totalData[this.debitRpt].add(row.getDebitRpt());
            totalData[this.creditRpt] = totalData[this.creditRpt].add(row.getCreditRpt());
            totalData[this.yearDebitRpt] = totalData[this.yearDebitRpt].add(row.getYearDebitRpt());
            totalData[this.yearCreditRpt] = totalData[this.yearCreditRpt].add(row.getYearCreditRpt());
            totalData[this.endDebitRpt] = totalData[this.endDebitRpt].add(CollectUtils.balAdjust(row.getEndRpt(), row.getAccountDc(), showByDc, true));
            totalData[this.endCreditRpt] = totalData[this.endCreditRpt].add(CollectUtils.balAdjust(row.getEndRpt(), row.getAccountDc(), showByDc, false));
        }
    }

    public void cache() {
        AccBalActionTracer.get().logTotalData(this.totalData);
        TotalCollectService.getCache().put(this.cacheKey, (Object)SerializationUtils.serializeToBase64((Object)this.totalData));
    }

    public DataSet getData(MulOrgQPRpt param, RowMeta rowMeta) {
        AccBalActionTracer.get().logTotalData(this.totalData);
        ThreadCache.remove((Object)this.cacheKey);
        TotalCollectService.getCache().remove(this.cacheKey);
        DataSetBuilder builder = Algo.create((String)"TotalCollectService").createDataSetBuilder(rowMeta);
        if (this.totalData[this.count].signum() == 0) {
            return builder.build();
        }
        SettableArrayRow data = new SettableArrayRow(rowMeta);
        if (param.getCurType() == CurType.FOREIGN) {
            data.setValue(rowMeta.getFieldIndex("currency"), (Object)param.getCurrency());
        }
        data.setValue(rowMeta.getFieldIndex("rowtype"), (Object)RowType.TOTAL.name());
        if (param.isShowOrgTree()) {
            data.setValue(rowMeta.getFieldIndex("isgroupnode"), (Object)false);
            data.setValue(rowMeta.getFieldIndex("rowid"), (Object)Integer.MAX_VALUE);
            data.setValue(rowMeta.getFieldIndex("pid"), (Object)0);
        }
        data.setValue(rowMeta.getFieldIndex("yearbdebitlocal"), (Object)this.totalData[this.yearBeginDebitLocal]);
        data.setValue(rowMeta.getFieldIndex("yearbcreditlocal"), (Object)this.totalData[this.yearBeginCreditLocal]);
        data.setValue(rowMeta.getFieldIndex("begindebitlocal"), (Object)this.totalData[this.beginDebitLocal]);
        data.setValue(rowMeta.getFieldIndex("begincreditlocal"), (Object)this.totalData[this.beginCreditLocal]);
        data.setValue(rowMeta.getFieldIndex("debitlocal"), (Object)this.totalData[this.debitLocal]);
        data.setValue(rowMeta.getFieldIndex("creditlocal"), (Object)this.totalData[this.creditLocal]);
        data.setValue(rowMeta.getFieldIndex("yeardebitlocal"), (Object)this.totalData[this.yearDebitLocal]);
        data.setValue(rowMeta.getFieldIndex("yearcreditlocal"), (Object)this.totalData[this.yearCreditLocal]);
        data.setValue(rowMeta.getFieldIndex("enddebitlocal"), (Object)this.totalData[this.endDebitLocal]);
        data.setValue(rowMeta.getFieldIndex("endcreditlocal"), (Object)this.totalData[this.endCreditLocal]);
        if (this.stateChart.isForeignCurr()) {
            data.setValue(rowMeta.getFieldIndex("yearbdebitfor"), (Object)this.totalData[this.yearBeginDebitFor]);
            data.setValue(rowMeta.getFieldIndex("yearbcreditfor"), (Object)this.totalData[this.yearBeginCreditFor]);
            data.setValue(rowMeta.getFieldIndex("begindebitfor"), (Object)this.totalData[this.beginDebitFor]);
            data.setValue(rowMeta.getFieldIndex("begincreditfor"), (Object)this.totalData[this.beginCreditFor]);
            data.setValue(rowMeta.getFieldIndex("debitfor"), (Object)this.totalData[this.debitFor]);
            data.setValue(rowMeta.getFieldIndex("creditfor"), (Object)this.totalData[this.creditFor]);
            data.setValue(rowMeta.getFieldIndex("yeardebitfor"), (Object)this.totalData[this.yearDebitFor]);
            data.setValue(rowMeta.getFieldIndex("yearcreditfor"), (Object)this.totalData[this.yearCreditFor]);
            data.setValue(rowMeta.getFieldIndex("enddebitfor"), (Object)this.totalData[this.endDebitFor]);
            data.setValue(rowMeta.getFieldIndex("endcreditfor"), (Object)this.totalData[this.endCreditFor]);
        }
        if (this.stateChart.isShowRptCurr()) {
            data.setValue(rowMeta.getFieldIndex("currencyrptid"), (Object)param.getCurRpt());
            data.setValue(rowMeta.getFieldIndex("yearbdebitrpt"), (Object)this.totalData[this.yearBeginDebitRpt]);
            data.setValue(rowMeta.getFieldIndex("yearbcreditrpt"), (Object)this.totalData[this.yearBeginCreditRpt]);
            data.setValue(rowMeta.getFieldIndex("begindebitrpt"), (Object)this.totalData[this.beginDebitRpt]);
            data.setValue(rowMeta.getFieldIndex("begincreditrpt"), (Object)this.totalData[this.beginCreditRpt]);
            data.setValue(rowMeta.getFieldIndex("debitrpt"), (Object)this.totalData[this.debitRpt]);
            data.setValue(rowMeta.getFieldIndex("creditrpt"), (Object)this.totalData[this.creditRpt]);
            data.setValue(rowMeta.getFieldIndex("yeardebitrpt"), (Object)this.totalData[this.yearDebitRpt]);
            data.setValue(rowMeta.getFieldIndex("yearcreditrpt"), (Object)this.totalData[this.yearCreditRpt]);
            data.setValue(rowMeta.getFieldIndex("enddebitrpt"), (Object)this.totalData[this.endDebitRpt]);
            data.setValue(rowMeta.getFieldIndex("endcreditrpt"), (Object)this.totalData[this.endCreditRpt]);
        }
        builder.append((Row)data);
        return builder.build();
    }
}

