/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.accbalance.v2.collect;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.hugein.HugeInConfig;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;

public class TreeNodeUtil {
    public static final char ORG_LONG_NUM_SPLIT = '!';
    public static final char ACCT_LONG_NUM_SPLIT = '_';

    public static Map<Long, String> getOrgLongNums(long viewId, Set<Long> orgs) {
        boolean filterWithOrg;
        HashMap<Long, String> id2LongNum = new HashMap<Long, String>(32);
        QFilter viewF = new QFilter("view", "=", (Object)viewId);
        boolean bl = filterWithOrg = orgs.size() < HugeInConfig.inThreshold();
        if (filterWithOrg) {
            viewF.and("org", "in", orgs);
        }
        QueryServiceHelper.queryDataSet((String)"TreeNodeUtil.getOrgLongNums", (String)"bos_org_structure", (String)"org, longnumber", (QFilter[])viewF.toArray(), null, (int)-1).forEachRemaining(row -> {
            long orgId = row.getLong(0);
            if (filterWithOrg || orgs.contains(orgId)) {
                id2LongNum.put(orgId, row.getString(1));
            }
        });
        return id2LongNum;
    }

    public static ThreeTuple<Map<Long, String>, Table<String, Integer, String>, Map<String, Long>> getAllSuperLevelTable(long viewId, Set<Long> orgs) {
        Map<Long, String> id2LongNum = TreeNodeUtil.getOrgLongNums(viewId, orgs);
        HashSet<String> longNums = new HashSet<String>(id2LongNum.values());
        Table<String, Integer, String> levelTable = TreeNodeUtil.getAllSuperLevelTable(longNums, '!');
        Map<String, Long> longNum2id = TreeNodeUtil.getOrgNum2IdMap(viewId, new HashSet<String>(levelTable.values()));
        return new ThreeTuple(id2LongNum, levelTable, longNum2id);
    }

    public static Map<String, Long> getOrgNum2IdMap(long viewId, Set<String> longNums) {
        HashMap<String, Long> res = new HashMap<String, Long>(32);
        QFilter viewF = new QFilter("view", "=", (Object)viewId);
        if (longNums.size() < HugeInConfig.inThreshold()) {
            viewF.and("longnumber", "in", longNums);
        }
        BusinessDataServiceHelper.loadFromCache((String)"bos_org_structure", (String)"org.id, longnumber", (QFilter[])viewF.toArray()).forEach((key, org) -> {
            String longNum = org.getString("longnumber");
            if (longNums.contains(longNum)) {
                res.put(longNum, org.getLong("org.id"));
            }
        });
        return res;
    }

    public static Table<String, Integer, String> getAllSuperLevelTable(Set<String> fullNums, char splitChar) {
        HashBasedTable longNum2Level2num = HashBasedTable.create((int)fullNums.size(), (int)4);
        for (String fullNum : fullNums) {
            char[] chars = fullNum.toCharArray();
            int level = 0;
            for (int i = 0; i < chars.length; ++i) {
                if (chars[i] != splitChar) continue;
                longNum2Level2num.put((Object)fullNum, (Object)level++, (Object)fullNum.substring(0, i));
            }
            longNum2Level2num.put((Object)fullNum, (Object)level, (Object)fullNum);
        }
        return longNum2Level2num;
    }

    public static String getParentOrgLongNum(String myLongNum) {
        int splitIndex = myLongNum.lastIndexOf(33);
        return splitIndex < 0 ? null : myLongNum.substring(0, splitIndex);
    }

    public static int getLongNumLevel(String longNum, char splitter) {
        int j = 0;
        for (int i = 0; i < longNum.length(); ++i) {
            if (splitter != longNum.charAt(i)) continue;
            ++j;
        }
        return j + 1;
    }

    public static String getSubLongNumByLevel(String longNum, int level, char splitter) {
        int i;
        int j = 0;
        for (i = 0; i < longNum.length() && (splitter != longNum.charAt(i) || ++j < level); ++i) {
        }
        return longNum.substring(0, i);
    }

    public static int getCommonParentLevel(Set<String> childLongNums) {
        if (CollectionUtils.isEmpty(childLongNums)) {
            return -1;
        }
        Iterator<String> longNumItr = childLongNums.iterator();
        ArrayList<Character> prefixChars = new ArrayList<Character>(32);
        String longNum = longNumItr.next();
        for (int i = 0; i < longNum.length(); ++i) {
            prefixChars.add(Character.valueOf(longNum.charAt(i)));
        }
        prefixChars.add(Character.valueOf('!'));
        int prefixEndIndex = prefixChars.size();
        block1: while (longNumItr.hasNext()) {
            longNum = longNumItr.next();
            for (int i = 0; i < prefixEndIndex; ++i) {
                if (i <= longNum.length()) {
                    char c;
                    char c2 = c = i == longNum.length() ? (char)'!' : (char)longNum.charAt(i);
                    if (((Character)prefixChars.get(i)).charValue() == c) continue;
                }
                prefixEndIndex = i;
                continue block1;
            }
        }
        int level = 0;
        for (int i = 0; i < prefixEndIndex; ++i) {
            if (((Character)prefixChars.get(i)).charValue() != '!') continue;
            ++level;
        }
        return level - 1;
    }
}

