/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.accbalance.v2.collect.simplenode;

import java.util.List;
import kd.fi.gl.report.CurType;
import kd.fi.gl.report.MulOrgQPRpt;
import kd.fi.gl.report.accbalance.v2.AccBalQueryContext;
import kd.fi.gl.report.accbalance.v2.collect.BalanceRowList;
import kd.fi.gl.report.accbalance.v2.collect.ISumNode;
import kd.fi.gl.report.accbalance.v2.collect.TreeDataCollectService;
import kd.fi.gl.report.accbalance.v2.collect.simplenode.AbstractAccBalNode;
import kd.fi.gl.report.accbalance.v2.collect.simplenode.AccSumTreeNodeFactory;
import kd.fi.gl.report.accbalance.v2.collect.simplenode.DetailGroupNode;
import kd.fi.gl.report.accbalance.v2.model.BalDetailGroup;
import kd.fi.gl.report.accbalance.v2.model.BalSumGroup;
import kd.fi.gl.report.accbalance.v2.model.BalanceRow;
import kd.fi.gl.report.accbalance.v2.model.IBalanceRow;
import kd.fi.gl.report.accbalance.v2.model.RowType;
import kd.fi.gl.report.accbalance.v2.model.StateChart;

public class LeafAccountNode
extends AbstractAccBalNode {
    private final Long acctMid;
    private final StateChart stateChart;
    private final Long foreignCurrency;

    public LeafAccountNode(Long acctMid, String acctLongNum) {
        super(acctLongNum);
        this.acctMid = acctMid;
        AccBalQueryContext context = AccBalQueryContext.getCurrent();
        MulOrgQPRpt queryParam = context.getQueryParam();
        this.foreignCurrency = queryParam.getCurType() == CurType.FOREIGN ? queryParam.getCurrency() : 0L;
        this.stateChart = context.getStateChart();
    }

    @Override
    protected void setLeafData(IBalanceRow balanceRow) {
        LeafAccountNode.sumTo(this.mySumRow, balanceRow, this.stateChart);
    }

    @Override
    protected void enhanceChildData(BalanceRowList childRows) {
        super.enhanceChildData(childRows);
        if (childRows.getAllData().isEmpty()) {
            return;
        }
        if (this.stateChart.isShowCurrency() && this.stateChart.isShowOrgTree()) {
            childRows.getSumData().setPid(0);
        }
        childRows.getAllData().forEach(r -> {
            BalSumGroup oriGrp = r.getBalSumGroup();
            r.setBalSumGroup(BalSumGroup.createGrp(this.context, oriGrp.getOrgId(), this.acctMid, this.foreignCurrency != 0L ? this.foreignCurrency.longValue() : oriGrp.getCurrencyId()));
            r.setAcctLongNum((String)this.getValue());
        });
        Class<? extends AbstractAccBalNode> childType = ((AccSumTreeNodeFactory)this.getNodeFactory()).getNodeType(this.getLevel() + 1);
        if (childType != null && TreeDataCollectService.showMultiLevelNode(childType, this.context.getStateChart())) {
            childRows.getSumData().setLeafAcctRow(true);
        }
    }

    @Override
    protected BalanceRow enhanceSumData(BalanceRow mySumRow, List<BalanceRow> childRows) {
        if ((mySumRow = super.enhanceSumData(mySumRow, childRows)) != null) {
            BalSumGroup grp;
            if (this.stateChart.isShowCurrency() && this.stateChart.isShowOrgTree()) {
                mySumRow.setSumRow(false);
                long pOrg = AccBalQueryContext.getCurrent().getQueryParam().getPorg();
                grp = BalSumGroup.createGrp(this.context, pOrg, this.acctMid, this.foreignCurrency);
            } else {
                grp = BalSumGroup.createGrp(this.context, 0L, this.acctMid, this.foreignCurrency);
            }
            mySumRow.setBalSumGroup(grp);
            mySumRow.setBalDetailGroup(BalDetailGroup.EMPTY);
            mySumRow.setAcctLongNum((String)this.getValue());
            mySumRow.setLeafAcctRow(true);
            mySumRow.setRowType(RowType.ACCT_SUMMARY);
            Class<ISumNode> childType = this.getChildType();
            mySumRow.setDetailSumRow(childType == null || childType.equals(DetailGroupNode.class));
        }
        return mySumRow;
    }

    @Override
    protected void sumChildData(BalanceRow sumData, BalanceRowList singleChildData) {
        LeafAccountNode.sumTo(sumData, singleChildData.getSumData(), this.stateChart);
    }

    private static void sumTo(BalanceRow sumData, IBalanceRow sourceData, StateChart stateChart) {
        sumData.addCount(sourceData.getCount());
        if (stateChart.isQueryLocalCurrency()) {
            sumData.addBeginLocal(sourceData.getBeginLocal());
            sumData.addCreditLocal(sourceData.getCreditLocal());
            sumData.addDebitLocal(sourceData.getDebitLocal());
            sumData.addYearCreditLocal(sourceData.getYearCreditLocal());
            sumData.addYearDebitLocal(sourceData.getYearDebitLocal());
            sumData.addEndLocal(sourceData.getEndLocal());
        }
        if (stateChart.isForeignCurr()) {
            sumData.addBeginFor(sourceData.getBeginFor());
            sumData.addCreditFor(sourceData.getCreditFor());
            sumData.addDebitFor(sourceData.getDebitFor());
            sumData.addYearCreditFor(sourceData.getYearCreditFor());
            sumData.addYearDebitFor(sourceData.getYearDebitFor());
            sumData.addEndFor(sourceData.getEndFor());
        }
        if (stateChart.isShowRptCurr() && sourceData instanceof BalanceRow) {
            sumData.addBeginRpt(((BalanceRow)sourceData).getBeginRpt());
            sumData.addCreditRpt(((BalanceRow)sourceData).getCreditRpt());
            sumData.addDebitRpt(((BalanceRow)sourceData).getDebitRpt());
            sumData.addYearCreditRpt(((BalanceRow)sourceData).getYearCreditRpt());
            sumData.addYearDebitRpt(((BalanceRow)sourceData).getYearDebitRpt());
            sumData.addEndRpt(((BalanceRow)sourceData).getEndRpt());
        }
    }
}

