/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.accbalance.v2.collect.treenode;

import java.util.List;
import kd.fi.gl.report.accbalance.v2.AccBalQueryContext;
import kd.fi.gl.report.accbalance.v2.collect.BalanceRowList;
import kd.fi.gl.report.accbalance.v2.collect.INodeFactory;
import kd.fi.gl.report.accbalance.v2.collect.ISumNode;
import kd.fi.gl.report.accbalance.v2.collect.TreeNodeUtil;
import kd.fi.gl.report.accbalance.v2.collect.treenode.AccountSumTreeNode;
import kd.fi.gl.report.accbalance.v2.model.BalanceRow;

public class AccountTreeFactory
implements INodeFactory<String, BalanceRowList, List<BalanceRow>> {
    private final AccBalQueryContext context;
    private final int showLevel;

    public AccountTreeFactory(AccBalQueryContext context) {
        this.context = context;
        this.showLevel = context.getQueryParam().getAccountLevel();
    }

    @Override
    public ISumNode<BalanceRowList, List<BalanceRow>> createRoot() {
        AccountSumTreeNode root = new AccountSumTreeNode("", -1L, 0, false);
        root.setNodeFactory(this);
        return root;
    }

    @Override
    public String extractChildValue(ISumNode<BalanceRowList, List<BalanceRow>> parentNode, BalanceRowList sourceRow) {
        int childLevel = parentNode.getLevel() + 1;
        if (childLevel > this.showLevel) {
            return null;
        }
        BalanceRow detailAcctSumRow = sourceRow.getSumData();
        String longNum = detailAcctSumRow.getAcctLongNum();
        if (longNum.length() == 0) {
            longNum = this.context.getAcctLongNumByEntityOrgMid(detailAcctSumRow.getAccountMid());
            detailAcctSumRow.setAcctLongNum(longNum);
        }
        String pLongNum = AccountTreeFactory.getParentLongNum(longNum, childLevel, '_');
        while (pLongNum != null && !this.context.needShowAcctNum(pLongNum)) {
            pLongNum = AccountTreeFactory.getParentLongNum(longNum, ++childLevel, '_');
        }
        return pLongNum;
    }

    private static String getParentLongNum(String fullLongNum, int curLevel, char splitChar) {
        int count = 1;
        for (int i = 0; i < fullLongNum.length(); ++i) {
            if (fullLongNum.charAt(i) != splitChar || count++ != curLevel) continue;
            return fullLongNum.substring(0, i);
        }
        return count == curLevel ? fullLongNum : null;
    }

    @Override
    public ISumNode<BalanceRowList, List<BalanceRow>> createChildNode(ISumNode<BalanceRowList, List<BalanceRow>> parentNode, BalanceRowList sourceRow) {
        String leafAcctLongNum = sourceRow.getSumData().getAcctLongNum();
        String acctLongNum = this.extractChildValue(parentNode, sourceRow);
        int longNumLevel = TreeNodeUtil.getLongNumLevel(acctLongNum, '_');
        Long acctMid = this.context.getAcctMidByLongNum(acctLongNum);
        boolean isLeafAcct = acctLongNum.equals(leafAcctLongNum);
        AccountSumTreeNode child = new AccountSumTreeNode(acctLongNum, acctMid, longNumLevel, isLeafAcct);
        child.setNodeFactory(this);
        return child;
    }
}

