/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.accbalance.v2.ds.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.report.MulOrgQPRpt;
import kd.fi.gl.report.accbalance.v2.AccBalQueryContext;
import kd.fi.gl.report.accbalance.v2.AccBalQueryUtil;
import kd.fi.gl.report.accbalance.v2.ds.IDataSource;
import kd.fi.gl.report.accbalance.v2.model.IBalanceRow;
import kd.fi.gl.report.accbalance.v2.model.StateChart;
import kd.fi.gl.report.accbalance.v2.model.StreamBalRow;
import kd.fi.gl.util.MulCurReportUtil;

public class AccBalanceDs
implements IDataSource {
    public static AccBalanceDs getInstance() {
        return new AccBalanceDs();
    }

    @Override
    public Iterator<IBalanceRow> getData() {
        AccBalQueryContext context = AccBalQueryContext.getCurrent();
        boolean queryAssgrp = context.getStateChart().isQueryAssgrp();
        return AccBalQueryUtil.createItr(AccBalanceDs.getDs(context), row -> new StreamBalRow((Row)row, context, queryAssgrp));
    }

    static DataSet getDs(AccBalQueryContext context) {
        MulOrgQPRpt queryParam = context.getQueryParam();
        StateChart stateChart = context.getStateChart();
        String fields = String.join((CharSequence)", ", AccBalanceDs.getSelectFields(queryParam, stateChart));
        List<QFilter> filters = AccBalQueryUtil.getBalBaseFilters(queryParam, context);
        String balEntity = stateChart.isQueryAssgrp() ? "gl_balance" : "gl_acctbalance";
        return QueryServiceHelper.queryDataSet((String)"AccBalanceDS#getDs", (String)balEntity, (String)fields, (QFilter[])filters.toArray(new QFilter[0]), null);
    }

    protected static List<String> getSelectFields(MulOrgQPRpt queryParam, StateChart stateChart) {
        ArrayList<String> fields = new ArrayList<String>(16);
        fields.add("org");
        fields.add("account");
        fields.add("count");
        fields.addAll(queryParam.getCommonAssistKeys());
        fields.add("period");
        fields.add("endperiod");
        if (stateChart.isQueryAssgrp()) {
            fields.add("assgrp");
        }
        MulCurReportUtil.addBalanceAmountFields(fields, (String)queryParam.getLocaleCurType());
        if (stateChart.isQueryCurrency()) {
            fields.add("currency");
            fields.add("beginfor");
            fields.add("debitfor");
            fields.add("creditfor");
            fields.add("endfor");
            fields.add("yeardebitfor");
            fields.add("yearcreditfor");
        }
        if (stateChart.isShowQty()) {
            fields.add("measureunit");
            fields.add("beginqty");
            fields.add("debitqty");
            fields.add("creditqty");
            fields.add("endqty");
            fields.add("yeardebitqty");
            fields.add("yearcreditqty");
        }
        return fields;
    }
}

