/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.accbalance.v2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import kd.fi.gl.report.accbalance.v2.AccBalQueryContext;
import kd.fi.gl.util.GLUtil;

public class BalDetailGroup
implements Serializable,
Comparable<Object> {
    private static final transient long serialVersionUID = -674577851532789368L;
    public static final transient long[] NO_COM_ASSIST = new long[10];
    public static final transient BalDetailGroup EMPTY = new BalDetailGroup(0L, 0L, NO_COM_ASSIST);
    private long assgrpId;
    private long measureUnit;
    private long[] comAssistIds;
    private transient int hashCode;
    private static final transient Comparator<BalDetailGroup> COMPARATOR = Comparator.comparing(BalDetailGroup::getMeasureUnit).thenComparing(BalDetailGroup::getAssgrpId).thenComparing((g1, g2) -> GLUtil.compareLongArr((long[])g1.getComAssistIds(), (long[])g2.getComAssistIds()));

    public static BalDetailGroup createGrp(AccBalQueryContext context, long measureUnit, long assgrpId, long[] comAssistIds) {
        return (BalDetailGroup)context.getFromCache(Objects.hash(2, measureUnit, assgrpId, Arrays.hashCode(comAssistIds)), () -> new BalDetailGroup(measureUnit, assgrpId, comAssistIds));
    }

    private BalDetailGroup(long measureUnit, long assgrpId, long[] comAssistIds) {
        this.measureUnit = measureUnit;
        this.assgrpId = assgrpId;
        this.comAssistIds = comAssistIds;
        this.hashCode = Objects.hash(measureUnit, assgrpId, Arrays.hashCode(comAssistIds));
    }

    public BalDetailGroup() {
    }

    public long getMeasureUnit() {
        return this.measureUnit;
    }

    public long getAssgrpId() {
        return this.assgrpId;
    }

    public long[] getComAssistIds() {
        return this.comAssistIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BalDetailGroup that = (BalDetailGroup)o;
        return this.measureUnit == that.measureUnit && this.assgrpId == that.assgrpId && Arrays.equals(this.comAssistIds, that.comAssistIds);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Objects.hash(this.measureUnit, this.assgrpId, Arrays.hashCode(this.comAssistIds));
        }
        return this.hashCode;
    }

    public String toString() {
        return GLUtil.toJsonStr((Object)this);
    }

    @Override
    public int compareTo(Object o) {
        return COMPARATOR.compare(this, (BalDetailGroup)o);
    }
}

