/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.accbalance.v2.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.fi.gl.report.accbalance.v2.AccBalQueryContext;
import kd.fi.gl.report.accbalance.v2.model.BalDetailGroup;
import kd.fi.gl.report.accbalance.v2.model.BalSumGroup;
import kd.fi.gl.report.accbalance.v2.model.IBalanceRow;
import kd.fi.gl.report.accbalance.v2.model.RowType;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.vo.RateBean;

public class BalanceRow
implements IBalanceRow,
Serializable {
    private static final long serialVersionUID = 8028656156612308683L;
    private int rowId = 0;
    private int pid = 0;
    private boolean sumRow = false;
    private RowType rowType = RowType.DEFAULT;
    private BalSumGroup balSumGroup = BalSumGroup.EMPTY;
    private BalDetailGroup balDetailGroup = BalDetailGroup.EMPTY;
    private String orgLongNum = "";
    private String acctLongNum = "";
    private int count = 0;
    private int orgLevel = 0;
    private BigDecimal beginLocal = BigDecimal.ZERO;
    private BigDecimal debitLocal = BigDecimal.ZERO;
    private BigDecimal creditLocal = BigDecimal.ZERO;
    private BigDecimal yearDebitLocal = BigDecimal.ZERO;
    private BigDecimal yearCreditLocal = BigDecimal.ZERO;
    private BigDecimal endLocal = BigDecimal.ZERO;
    private BigDecimal beginFor = BigDecimal.ZERO;
    private BigDecimal debitFor = BigDecimal.ZERO;
    private BigDecimal creditFor = BigDecimal.ZERO;
    private BigDecimal yearDebitFor = BigDecimal.ZERO;
    private BigDecimal yearCreditFor = BigDecimal.ZERO;
    private BigDecimal endFor = BigDecimal.ZERO;
    private BigDecimal beginQty = BigDecimal.ZERO;
    private BigDecimal debitQty = BigDecimal.ZERO;
    private BigDecimal creditQty = BigDecimal.ZERO;
    private BigDecimal yearDebitQty = BigDecimal.ZERO;
    private BigDecimal yearCreditQty = BigDecimal.ZERO;
    private BigDecimal endQty = BigDecimal.ZERO;
    private BigDecimal beginRpt = BigDecimal.ZERO;
    private BigDecimal debitRpt = BigDecimal.ZERO;
    private BigDecimal creditRpt = BigDecimal.ZERO;
    private BigDecimal yearDebitRpt = BigDecimal.ZERO;
    private BigDecimal yearCreditRpt = BigDecimal.ZERO;
    private BigDecimal endRpt = BigDecimal.ZERO;
    private BigDecimal yearBeginQty = null;
    private BigDecimal yearBeginFor = null;
    private BigDecimal yearBeginLocal = null;
    private BigDecimal yearBeginRpt = null;
    private String accountDc = "0";
    private int accountLevel = Integer.MAX_VALUE;
    private boolean detailOrg = false;
    private boolean detailSumRow = false;
    private boolean leafAcctRow = false;
    private boolean link = true;

    public static BalanceRow create(AccBalQueryContext context) {
        BalanceRow newRow = new BalanceRow();
        newRow.setRowId(context.nextRowId());
        return newRow;
    }

    public BalSumGroup getBalSumGroup() {
        return this.balSumGroup;
    }

    public void setBalSumGroup(BalSumGroup balSumGroup) {
        this.balSumGroup = balSumGroup;
    }

    public BalDetailGroup getBalDetailGroup() {
        return this.balDetailGroup;
    }

    public void setBalDetailGroup(BalDetailGroup balDetailGroup) {
        this.balDetailGroup = balDetailGroup;
    }

    @Override
    @JsonIgnore
    public long getOrgId() {
        return this.balSumGroup.getOrgId();
    }

    @Override
    @JsonIgnore
    public long getAccountMid() {
        return this.balSumGroup.getAccountId();
    }

    @Override
    @JsonIgnore
    public long getCurrencyId() {
        return this.balSumGroup.getCurrencyId();
    }

    @Override
    @JsonIgnore
    public long getMeasureUnit() {
        return this.balDetailGroup.getMeasureUnit();
    }

    @Override
    @JsonIgnore
    public long getAssgrpId() {
        return this.balDetailGroup.getAssgrpId();
    }

    @Override
    @JsonIgnore
    public long[] getComAssistIds() {
        return this.balDetailGroup.getComAssistIds();
    }

    @Override
    public BigDecimal getBeginQty() {
        return this.beginQty;
    }

    public void addBeginQty(BigDecimal beginQty) {
        this.beginQty = this.beginQty.add(beginQty);
    }

    @Override
    public BigDecimal getBeginFor() {
        return this.beginFor;
    }

    public void addBeginFor(BigDecimal beginFor) {
        this.beginFor = this.beginFor.add(beginFor);
    }

    @Override
    public BigDecimal getBeginLocal() {
        return this.beginLocal;
    }

    public void addBeginLocal(BigDecimal beginLocal) {
        this.beginLocal = this.beginLocal.add(beginLocal);
    }

    @Override
    public BigDecimal getDebitQty() {
        return this.debitQty;
    }

    public void addDebitQty(BigDecimal debitQty) {
        this.debitQty = this.debitQty.add(debitQty);
    }

    @Override
    public BigDecimal getDebitFor() {
        return this.debitFor;
    }

    public void addDebitFor(BigDecimal debitFor) {
        this.debitFor = this.debitFor.add(debitFor);
    }

    @Override
    public BigDecimal getDebitLocal() {
        return this.debitLocal;
    }

    public void addDebitLocal(BigDecimal debitLocal) {
        this.debitLocal = this.debitLocal.add(debitLocal);
    }

    @Override
    public BigDecimal getCreditQty() {
        return this.creditQty;
    }

    public void addCreditQty(BigDecimal creditQty) {
        this.creditQty = this.creditQty.add(creditQty);
    }

    @Override
    public BigDecimal getCreditFor() {
        return this.creditFor;
    }

    public void addCreditFor(BigDecimal creditFor) {
        this.creditFor = this.creditFor.add(creditFor);
    }

    @Override
    public BigDecimal getCreditLocal() {
        return this.creditLocal;
    }

    public void addCreditLocal(BigDecimal creditLocal) {
        this.creditLocal = this.creditLocal.add(creditLocal);
    }

    @Override
    public BigDecimal getEndQty() {
        return this.endQty;
    }

    public void addEndQty(BigDecimal endQty) {
        this.endQty = this.endQty.add(endQty);
    }

    @Override
    public BigDecimal getEndFor() {
        return this.endFor;
    }

    public void addEndFor(BigDecimal endFor) {
        this.endFor = this.endFor.add(endFor);
    }

    @Override
    public BigDecimal getEndLocal() {
        return this.endLocal;
    }

    public void addEndLocal(BigDecimal endLocal) {
        this.endLocal = this.endLocal.add(endLocal);
    }

    @Override
    public BigDecimal getYearDebitQty() {
        return this.yearDebitQty;
    }

    public void addYearDebitQty(BigDecimal yearDebitQty) {
        this.yearDebitQty = this.yearDebitQty.add(yearDebitQty);
    }

    @Override
    public BigDecimal getYearDebitFor() {
        return this.yearDebitFor;
    }

    public void addYearDebitFor(BigDecimal yearDebitFor) {
        this.yearDebitFor = this.yearDebitFor.add(yearDebitFor);
    }

    @Override
    public BigDecimal getYearDebitLocal() {
        return this.yearDebitLocal;
    }

    public void addYearDebitLocal(BigDecimal yearDebitLocal) {
        this.yearDebitLocal = this.yearDebitLocal.add(yearDebitLocal);
    }

    @Override
    public BigDecimal getYearCreditQty() {
        return this.yearCreditQty;
    }

    public void addYearCreditQty(BigDecimal yearCreditQty) {
        this.yearCreditQty = this.yearCreditQty.add(yearCreditQty);
    }

    @Override
    public BigDecimal getYearCreditFor() {
        return this.yearCreditFor;
    }

    public void addYearCreditFor(BigDecimal yearCreditFor) {
        this.yearCreditFor = this.yearCreditFor.add(yearCreditFor);
    }

    @Override
    public BigDecimal getYearCreditLocal() {
        return this.yearCreditLocal;
    }

    public void addYearCreditLocal(BigDecimal yearCreditLocal) {
        this.yearCreditLocal = this.yearCreditLocal.add(yearCreditLocal);
    }

    public String toString() {
        return GLUtil.toJsonStr((Object)this);
    }

    public String getOrgLongNum() {
        return this.orgLongNum;
    }

    public void setOrgLongNum(String orgLongNum) {
        this.orgLongNum = orgLongNum;
    }

    public String getAcctLongNum() {
        return this.acctLongNum;
    }

    public void setAcctLongNum(String acctLongNum) {
        this.acctLongNum = acctLongNum;
    }

    public int getRowId() {
        return this.rowId;
    }

    public void setRowId(int rowId) {
        this.rowId = rowId;
    }

    public int getPid() {
        return this.pid;
    }

    public void setPid(int pid) {
        this.pid = pid;
    }

    public boolean isSumRow() {
        return this.sumRow;
    }

    public void setSumRow(boolean sumRow) {
        this.sumRow = sumRow;
    }

    public boolean isDetailOrg() {
        return this.detailOrg;
    }

    public void setDetailOrg(boolean detailOrg) {
        this.detailOrg = detailOrg;
    }

    public boolean isDetailSumRow() {
        return this.detailSumRow;
    }

    public void setDetailSumRow(boolean detailSumRow) {
        this.detailSumRow = detailSumRow;
    }

    public boolean isLeafAcctRow() {
        return this.leafAcctRow;
    }

    public void setLeafAcctRow(boolean leafAcctRow) {
        this.leafAcctRow = leafAcctRow;
    }

    public BigDecimal getYearBeginQty() {
        if (this.yearBeginQty == null) {
            this.yearBeginQty = this.getEndQty().subtract(this.getYearDebitQty().subtract(this.getYearCreditQty()));
        }
        return this.yearBeginQty;
    }

    public BigDecimal getYearBeginFor() {
        if (this.yearBeginFor == null) {
            this.yearBeginFor = this.getEndFor().subtract(this.getYearDebitFor().subtract(this.getYearCreditFor()));
        }
        return this.yearBeginFor;
    }

    public BigDecimal getYearBeginLocal() {
        if (this.yearBeginLocal == null) {
            this.yearBeginLocal = this.getEndLocal().subtract(this.getYearDebitLocal().subtract(this.getYearCreditLocal()));
        }
        return this.yearBeginLocal;
    }

    public BigDecimal getYearBeginRpt() {
        if (this.yearBeginRpt == null) {
            this.yearBeginRpt = this.getEndRpt().subtract(this.getYearDebitRpt().subtract(this.getYearCreditRpt()));
        }
        return this.yearBeginRpt;
    }

    public String getAccountDc() {
        return this.accountDc;
    }

    public void setAccountDc(String accountDc) {
        this.accountDc = accountDc;
    }

    public RowType getRowType() {
        return this.rowType;
    }

    public void setRowType(RowType rowType) {
        this.rowType = rowType;
    }

    public BigDecimal getBeginRpt() {
        return this.beginRpt;
    }

    public void addBeginRpt(BigDecimal beginRpt) {
        this.beginRpt = this.beginRpt.add(beginRpt);
    }

    public void setBeginRpt(RateBean rate) {
        BigDecimal localB = this.getBeginLocal();
        this.beginRpt = rate.isDirect() ? localB.multiply(rate.getRateVal()) : localB.divide(rate.getRateVal(), rate.getPrecision(), RoundingMode.HALF_UP);
    }

    public BigDecimal getDebitRpt() {
        return this.debitRpt;
    }

    public void addDebitRpt(BigDecimal debitRpt) {
        this.debitRpt = this.debitRpt.add(debitRpt);
    }

    public void setDebitRpt(RateBean rate) {
        BigDecimal localB = this.getDebitLocal();
        this.debitRpt = rate.isDirect() ? localB.multiply(rate.getRateVal()) : localB.divide(rate.getRateVal(), rate.getPrecision(), RoundingMode.HALF_UP);
    }

    public BigDecimal getCreditRpt() {
        return this.creditRpt;
    }

    public void addCreditRpt(BigDecimal creditRpt) {
        this.creditRpt = this.creditRpt.add(creditRpt);
    }

    public void setCreditRpt(RateBean rate) {
        BigDecimal localB = this.getCreditLocal();
        this.creditRpt = rate.isDirect() ? localB.multiply(rate.getRateVal()) : localB.divide(rate.getRateVal(), rate.getPrecision(), RoundingMode.HALF_UP);
    }

    public BigDecimal getYearDebitRpt() {
        return this.yearDebitRpt;
    }

    public void addYearDebitRpt(BigDecimal yearDebitRpt) {
        this.yearDebitRpt = this.yearDebitRpt.add(yearDebitRpt);
    }

    public void setYearDebitRpt(RateBean rate) {
        BigDecimal localB = this.getYearDebitLocal();
        this.yearDebitRpt = rate.isDirect() ? localB.multiply(rate.getRateVal()) : localB.divide(rate.getRateVal(), rate.getPrecision(), RoundingMode.HALF_UP);
    }

    public BigDecimal getYearCreditRpt() {
        return this.yearCreditRpt;
    }

    public void addYearCreditRpt(BigDecimal yearCreditRpt) {
        this.yearCreditRpt = this.yearCreditRpt.add(yearCreditRpt);
    }

    public void setYearCreditRpt(RateBean rate) {
        BigDecimal localB = this.getYearCreditLocal();
        this.yearCreditRpt = rate.isDirect() ? localB.multiply(rate.getRateVal()) : localB.divide(rate.getRateVal(), rate.getPrecision(), RoundingMode.HALF_UP);
    }

    public BigDecimal getEndRpt() {
        return this.endRpt;
    }

    public void addEndRpt(BigDecimal endRpt) {
        this.endRpt = this.endRpt.add(endRpt);
    }

    public void setEndRpt(RateBean rate) {
        BigDecimal localB = this.getEndLocal();
        this.endRpt = rate.isDirect() ? localB.multiply(rate.getRateVal()) : localB.divide(rate.getRateVal(), rate.getPrecision(), RoundingMode.HALF_UP);
    }

    public int getAccountLevel() {
        return this.accountLevel;
    }

    public void setAccountLevel(int accountLevel) {
        this.accountLevel = accountLevel;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    public void addCount(int count) {
        this.count += count;
    }

    public int getOrgLevel() {
        return this.orgLevel;
    }

    public void setOrgLevel(int orgLevel) {
        this.orgLevel = orgLevel;
    }

    public boolean isLink() {
        return this.link;
    }

    public void setLink(boolean link) {
        this.link = link;
    }
}

