/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.accbalance.v2.model;

import kd.fi.gl.report.CurType;
import kd.fi.gl.report.MulOrgQPRpt;

public class StateChart {
    private final boolean showOrg;
    private final boolean showOrgTree;
    private final boolean showLeafAccount;
    private final boolean showCurrency;
    private final boolean queryCurrency;
    private final boolean foreignCurr;
    private final boolean showRptCurr;
    private final boolean showQty;
    private final boolean showAssist;
    private final boolean showComAssist;
    private final boolean queryAssgrp;
    private final boolean showByDc;
    private final boolean queryLocalCurrency;
    private final boolean queryMulLocalCur;
    private final boolean hideUnused;

    public StateChart(MulOrgQPRpt qpRpt) {
        this.showOrgTree = qpRpt.isShowOrgTree();
        this.showOrg = qpRpt.isShowOrg() || this.showOrgTree;
        this.showCurrency = qpRpt.isShowCurrency();
        this.queryCurrency = qpRpt.isQueryCurrency();
        this.foreignCurr = qpRpt.getCurType() == CurType.FOREIGN;
        this.showQty = qpRpt.isShowQty();
        this.showAssist = qpRpt.isShowAssist();
        this.showComAssist = qpRpt.isShowComassist();
        this.showLeafAccount = qpRpt.isShowLeafAccount();
        this.queryAssgrp = qpRpt.isShowAssist() && (qpRpt.isNoZeroAmount() || qpRpt.isNoZeroBalance() || qpRpt.isNoZeroYearBal());
        this.showByDc = qpRpt.isShowDataByDC();
        this.showRptCurr = qpRpt.isShowRpt();
        this.queryLocalCurrency = qpRpt.getCurLocal() > 0L;
        String localeCurType = qpRpt.getLocaleCurType();
        this.queryMulLocalCur = localeCurType != null && !"LocalCurrency".equals(localeCurType);
        this.hideUnused = qpRpt.isHideUnused() || qpRpt.isShowLeafAccount();
    }

    public boolean isShowOrg() {
        return this.showOrg;
    }

    public boolean isShowOrgTree() {
        return this.showOrgTree;
    }

    public boolean isShowCurrency() {
        return this.showCurrency;
    }

    public boolean isShowQty() {
        return this.showQty;
    }

    public boolean isShowAssist() {
        return this.showAssist;
    }

    public boolean isShowComAssist() {
        return this.showComAssist;
    }

    public boolean isShowLeafAccount() {
        return this.showLeafAccount;
    }

    public boolean isQueryCurrency() {
        return this.queryCurrency;
    }

    public boolean isQueryAssgrp() {
        return this.queryAssgrp;
    }

    public boolean isShowByDc() {
        return this.showByDc;
    }

    public boolean isForeignCurr() {
        return this.foreignCurr;
    }

    public boolean isShowRptCurr() {
        return this.showRptCurr;
    }

    public boolean isQueryLocalCurrency() {
        return this.queryLocalCurrency;
    }

    public boolean isQueryMulLocalCur() {
        return this.queryMulLocalCur;
    }

    public boolean isHideUnused() {
        return this.hideUnused;
    }
}

