/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.accbalance.v2.model;

import java.math.BigDecimal;
import kd.bos.algo.Row;
import kd.fi.gl.report.accbalance.v2.AccBalQueryContext;
import kd.fi.gl.report.accbalance.v2.model.AbstractStreamBalRow;

public class StreamPLInitBalRow
extends AbstractStreamBalRow {
    private final boolean queryYearAmount;

    public StreamPLInitBalRow(Row streamRow, AccBalQueryContext context) {
        super(streamRow, context);
        this.queryYearAmount = context.isQueryInitYearAmount();
    }

    @Override
    public BigDecimal getEndQty() {
        return this.getOriYearDebitQty().subtract(this.getOriYearCreditQty()).negate();
    }

    @Override
    public BigDecimal getEndFor() {
        return this.getOriYearDebitFor().subtract(this.getOriYearCreditFor()).negate();
    }

    @Override
    public BigDecimal getEndLocal() {
        return this.getOriYearDebitLocal().subtract(this.getOriYearCreditLocal()).negate();
    }

    @Override
    public int getCount() {
        return 0;
    }

    @Override
    public BigDecimal getBeginQty() {
        return this.getEndQty();
    }

    @Override
    public BigDecimal getBeginFor() {
        return this.getEndFor();
    }

    @Override
    public BigDecimal getBeginLocal() {
        return this.getEndLocal();
    }

    @Override
    public BigDecimal getDebitQty() {
        return BigDecimal.ZERO;
    }

    @Override
    public BigDecimal getDebitFor() {
        return BigDecimal.ZERO;
    }

    @Override
    public BigDecimal getDebitLocal() {
        return BigDecimal.ZERO;
    }

    @Override
    public BigDecimal getCreditQty() {
        return BigDecimal.ZERO;
    }

    @Override
    public BigDecimal getCreditFor() {
        return BigDecimal.ZERO;
    }

    @Override
    public BigDecimal getCreditLocal() {
        return BigDecimal.ZERO;
    }

    @Override
    public BigDecimal getYearDebitQty() {
        return !this.queryYearAmount ? BigDecimal.ZERO : this.getOriYearDebitQty().negate();
    }

    private BigDecimal getOriYearDebitQty() {
        return this.streamRow.getBigDecimal("yeardebitqty").subtract(this.streamRow.getBigDecimal("yearprofitdebitqty"));
    }

    @Override
    public BigDecimal getYearDebitFor() {
        return !this.queryYearAmount ? BigDecimal.ZERO : this.getOriYearDebitFor().negate();
    }

    private BigDecimal getOriYearDebitFor() {
        return this.streamRow.getBigDecimal("yeardebitfor").subtract(this.streamRow.getBigDecimal("yearprofitdebitfor"));
    }

    @Override
    public BigDecimal getYearDebitLocal() {
        return !this.queryYearAmount ? BigDecimal.ZERO : this.getOriYearDebitLocal().negate();
    }

    private BigDecimal getOriYearDebitLocal() {
        return this.streamRow.getBigDecimal("yeardebitlocal").subtract(this.streamRow.getBigDecimal("yearprofitdebitlocal"));
    }

    @Override
    public BigDecimal getYearCreditQty() {
        return !this.queryYearAmount ? BigDecimal.ZERO : this.getOriYearCreditQty().negate();
    }

    private BigDecimal getOriYearCreditQty() {
        return this.streamRow.getBigDecimal("yearcreditqty").subtract(this.streamRow.getBigDecimal("yearprofitcreditqty"));
    }

    @Override
    public BigDecimal getYearCreditFor() {
        return !this.queryYearAmount ? BigDecimal.ZERO : this.getOriYearCreditFor().negate();
    }

    private BigDecimal getOriYearCreditFor() {
        return this.streamRow.getBigDecimal("yearcreditfor").subtract(this.streamRow.getBigDecimal("yearprofitcreditfor"));
    }

    @Override
    public BigDecimal getYearCreditLocal() {
        return !this.queryYearAmount ? BigDecimal.ZERO : this.getOriYearCreditLocal().negate();
    }

    private BigDecimal getOriYearCreditLocal() {
        return this.streamRow.getBigDecimal("yearcreditlocal").subtract(this.streamRow.getBigDecimal("yearprofitcreditlocal"));
    }
}

