/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.assistbalance;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.service.balance.account.AccountTreeModel;
import kd.fi.bd.service.balance.account.IAccountTreeModel;
import kd.fi.bd.util.BiTreeNode;
import kd.fi.gl.report.MulOrgQPRpt;
import kd.fi.gl.report.assistbalance.AssistBalQueryRpt;
import kd.fi.gl.report.assistbalance.BalanceSumUpService;
import kd.fi.gl.report.assistbalance.model.AccountVO;
import kd.fi.gl.util.AccountUtils;

public class AccountIndex {
    private static final Log LOG = LogFactory.getLog(AccountIndex.class);
    private static final long MOCK_ACC_ROOT = -999L;
    private final Map<Long, AccountVO> accIdMap;
    private Map<String, AccountVO> accNumberMap = new HashMap<String, AccountVO>(1024);
    private final Table<Long, Long, Long> orgAccMidIndex;
    private final BalanceSumUpService sumUpService;

    public AccountIndex(IAccountTreeModel accountTreeModel, boolean isShowAccountFullName, BalanceSumUpService sumUpService) {
        this.sumUpService = sumUpService;
        Set<Long> accIds = accountTreeModel.getAccountTreeData().stream().map(x -> (Long)x[0]).collect(Collectors.toSet());
        String selectFields = String.format("id,number,longnumber,masterid,%s mname,level,dc,isleaf,isqty,isassist", isShowAccountFullName ? "fullname" : "name");
        this.accIdMap = new HashMap<Long, AccountVO>(8);
        DataSet accountDS = QueryServiceHelper.queryDataSet((String)(AssistBalQueryRpt.class.getName() + "/loadAccountInfo"), (String)"bd_accountview", (String)selectFields, (QFilter[])new QFilter("id", "in", (Object)accIds.toArray(new Long[0])).toArray(), null);
        while (accountDS.hasNext()) {
            Row row = accountDS.next();
            long id = row.getLong("id");
            AccountVO vo = AccountIndex.buildAccountVO(row);
            this.accIdMap.put(id, vo);
        }
        this.orgAccMidIndex = HashBasedTable.create();
        for (Map.Entry entry : accountTreeModel.toMap().entrySet()) {
            long orgId = ((AccountTreeModel.OrgAccMidKey)entry.getKey()).getOrgId();
            long accMid = ((AccountTreeModel.OrgAccMidKey)entry.getKey()).getAccMasterId();
            long accId = (Long)((BiTreeNode.TreeNodeRelation)entry.getValue()).getSelf();
            this.orgAccMidIndex.put((Object)orgId, (Object)accMid, (Object)accId);
        }
    }

    public AccountIndex(IAccountTreeModel accountTreeModel, MulOrgQPRpt qParam, BalanceSumUpService sumUpService, AccountIndex accountIndex) {
        this.sumUpService = sumUpService;
        this.orgAccMidIndex = HashBasedTable.create();
        this.accIdMap = new HashMap<Long, AccountVO>(8);
        boolean isShowAccountFullName = qParam.isShowAccountFullName();
        String selectFields = String.format("id,number,longnumber,masterid,%s mname,level,dc,isleaf,isqty,isassist", isShowAccountFullName ? "fullname" : "name");
        DynamicObject period = BusinessDataServiceHelper.loadSingleFromCache((Object)qParam.getEndPeriod(), (String)"bd_period");
        Date endDate = period.getDate("enddate");
        QFilter accFilter = new QFilter("level", "<=", (Object)qParam.getAccountLevel());
        if (qParam.isShowLeafAccount()) {
            accFilter = new QFilter("isleaf", "=", (Object)true);
        }
        if (qParam.getAccountList() != null) {
            accFilter.and(new QFilter("masterid", "in", (Object)accountTreeModel.getFilterAccountIds()));
        }
        Map<Long, AccountVO> childOrgAccMap = accountIndex.getAccIdMap();
        try (DataSet accountDataSet = AccountUtils.getAccountDataSet((long)qParam.getPorg(), (long)qParam.getAccountTable(), (Date)endDate, (boolean)false, (QFilter)accFilter, (String[])new String[]{selectFields});){
            accountDataSet.forEachRemaining(row -> {
                AccountVO accountVO = (AccountVO)childOrgAccMap.get(row.getLong("id"));
                if (Objects.isNull(accountVO)) {
                    accountVO = AccountIndex.buildAccountVO(row);
                    accountIndex.addAccountVO(accountVO);
                }
                this.accNumberMap.put(accountVO.getNumber(), accountVO);
            });
        }
    }

    private static AccountVO buildAccountVO(Row row) {
        AccountVO vo = new AccountVO(row.getLong("id"));
        vo.setMasterId(row.getLong("masterid"));
        vo.setNumber(row.getString("number"));
        vo.setLongNumber(row.getString("longnumber"));
        vo.setName(row.getString("mname"));
        vo.setIsQty(row.getBoolean("isqty"));
        vo.setDc(row.getInteger("dc"));
        vo.setIsAssist(row.getBoolean("isassist"));
        vo.setIsLeaf(row.getBoolean("isleaf"));
        vo.setLevel(row.getInteger("level"));
        return vo;
    }

    public Map<Long, AccountVO> getAccIdMap() {
        return Collections.unmodifiableMap(this.accIdMap);
    }

    public Long getAccountVOByOrgAndMid(long orgId, long accMasterId) {
        Long accId = (Long)this.orgAccMidIndex.get((Object)orgId, (Object)accMasterId);
        if (null == accId) {
            throw new KDBizException("can't find the AccID by orgid: " + orgId + ", accMasterId:" + accMasterId);
        }
        return accId;
    }

    public void addAccountVOByOrgAndMid(long orgId, long accMasterId, long accId) {
        this.orgAccMidIndex.put((Object)orgId, (Object)accMasterId, (Object)accId);
    }

    public AccountVO getAccountVO(long accId) {
        AccountVO vo = this.accIdMap.get(accId);
        if (null == vo) {
            throw new KDBizException("logic error: not found the Account VO by account id:" + accId);
        }
        return vo;
    }

    public void addAccountVO(AccountVO vo) {
        this.accIdMap.put(vo.getId(), vo);
    }

    public AccountVO getAccountVO(String number) {
        return this.accNumberMap.get(number);
    }

    public long getTopAccountId(long orgId, long accountId) {
        return this.sumUpService.getTopAccountId(orgId, accountId);
    }
}

