/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.assistbalance;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.report.assistbalance.model.RawBalanceRow;
import kd.fi.gl.util.MultiIndexTreeCache;

public class AssistBalanceAggregateCache {
    private static final Log LOG = LogFactory.getLog(AssistBalanceAggregateCache.class);
    private static final int CAPCITY = 100000;
    private List<RawBalanceRow> _data = new ArrayList<RawBalanceRow>(100000);
    private MultiIndexTreeCache<RawBalanceRow> indexCache = new MultiIndexTreeCache("AssistBalanceAggregateCache", Integer.MAX_VALUE);
    private int _mergeTimes = 0;
    private int _outLimitTimes = 0;

    public boolean push(RawBalanceRow rawBalanceRow) {
        int realDC = rawBalanceRow.debitlocal.subtract(rawBalanceRow.creditlocal).compareTo(BigDecimal.ZERO) > 0 ? 1 : 0;
        Object[] indexParams = new Object[]{rawBalanceRow.assistValues, rawBalanceRow.comAssistVals, rawBalanceRow.orgId, rawBalanceRow.accMid, rawBalanceRow.currencyId, rawBalanceRow.measureUnitId, rawBalanceRow.period, rawBalanceRow.endPeriod, realDC};
        RawBalanceRow existRow = (RawBalanceRow)this.indexCache.retrieval(indexParams);
        if (null != existRow) {
            existRow.merge(rawBalanceRow);
            ++this._mergeTimes;
            return true;
        }
        if (this.indexCache.getSize() >= 100000) {
            ++this._outLimitTimes;
            return false;
        }
        this.indexCache.addData((Object)rawBalanceRow, indexParams);
        this._data.add(rawBalanceRow);
        return true;
    }

    public Collection<RawBalanceRow> listRowsAndClear() {
        try {
            if (DebugTrace.enable()) {
                for (RawBalanceRow rawRow : this._data) {
                    LOG.info("AssistBalanceAggregateCache aggregated row: {}", (Object)rawRow);
                }
            }
            List<RawBalanceRow> list = this._data;
            return list;
        }
        finally {
            this.indexCache.clearAll();
        }
    }

    public int getMergeTimes() {
        return this._mergeTimes;
    }

    public int getOutLimitTimes() {
        return this._outLimitTimes;
    }
}

