/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.assistbalance;

import com.google.common.base.Preconditions;
import kd.bos.cache.ThreadCache;
import kd.fi.gl.report.CurType;
import kd.fi.gl.report.assistbalance.AccountIndex;
import kd.fi.gl.report.assistbalance.model.AccountVO;

public class AssistBalanceContext {
    private static final String CACHE_KEY = "fi.gl.report.assistbalance.AssistBalanceContext";
    private AccountIndex accountIndex;
    private Boolean isEnableCurrencyGroup;
    private boolean isReachLimit = false;

    public AccountIndex getAccountIndex() {
        return this.accountIndex;
    }

    public void setAccountIndex(AccountIndex accountIndex) {
        this.accountIndex = accountIndex;
    }

    public Boolean getIsEnableCurrencyGroup() {
        return this.isEnableCurrencyGroup;
    }

    public void setIsEnableCurrencyGroup(CurType currencyType) {
        Preconditions.checkArgument((null != currencyType ? 1 : 0) != 0);
        this.isEnableCurrencyGroup = CurType.FOREIGN == currencyType;
    }

    public boolean isReachLimit() {
        return this.isReachLimit;
    }

    public void setIsReachLimit(boolean reachLimit) {
        this.isReachLimit = reachLimit;
    }

    public static AssistBalanceContext get() {
        Object value = ThreadCache.get((Object)CACHE_KEY);
        if (null == value) {
            AssistBalanceContext result = new AssistBalanceContext();
            ThreadCache.put((Object)CACHE_KEY, (Object)result);
            return result;
        }
        return (AssistBalanceContext)value;
    }

    public static AccountVO getAccountVOById(long accId) {
        return ((AssistBalanceContext)ThreadCache.get((Object)CACHE_KEY)).getAccountIndex().getAccountVO(accId);
    }
}

